within Simulator.UsersGuide.ReleaseNotes;

class VersionManagement
  extends Modelica.Icons.ReleaseNotes;
  annotation(
    Documentation(info = "<html><head></head><body><!--StartFragment--><h4 style=\"font-size: 12px;\">Development branches</h4><p style=\"font-size: 12px;\">Further development and maintenance of the OMChemSim Library is performed with the master branch on the public&nbsp;<a href=\"https://github.com/FOSSEE/OMChemSim.git\">GitHub repository</a>&nbsp;of the FOSSEE.</p><h4 style=\"font-size: 12px;\">Contribution workflow</h4><p style=\"font-size: 12px;\">The general&nbsp;<a href=\"https://guides.github.com/activities/forking/\">contribution workflow</a>&nbsp;is usually as follows:</p><ol style=\"font-size: 12px;\"><li>Fork the repository to your account by&nbsp;<a href=\"https://help.github.com/articles/fork-a-repo/\">using the Fork button</a>&nbsp;of the GitHub repository site.</li><li>Clone the forked repository to your computer. Make sure to checkout the maintenance branch if the bug fix is going to get merged to the maintenance branch.</li><li>Create a new topic branch and give it a meaningful name, like, e.g., \"issue22-fix-formula\".</li><li>Do your code changes and commit them, one change per commit. Single commits can be copied to other branches. Multiple commits can be squashed into one, but splitting is difficult.</li><li>Once you are done, push your topic branch to your forked repository.</li><li>Go to the upstream&nbsp;<a href=\"https://github.com/FOSSEE/OMChemSim.git\">https://github.com/FOSSEE/OMChemSim.git</a>&nbsp;repository and submit a<a href=\"https://help.github.com/articles/about-pull-requests/\">Pull Request</a>&nbsp;(PR). If the PR is related to a certain issue, reference it by its number like this: #22. Once a pull request is opened, you can discuss and&nbsp;<a href=\"https://help.github.com/articles/about-pull-request-reviews/\">review</a>&nbsp;the potential changes with collaborators and add follow-up commits before the changes are merged into the repository.</li><li>Update your branch with the requested changes. If necessary, merge the latest \"master\" branch into your topic branch and solve all merge conflicts in your topic branch.</li></ol><p style=\"font-size: 12px;\">As a recommendation, a valid bug fix may contain one or more of the following changes.</p><ul style=\"font-size: 12px;\"><li>Correcting an equation.</li><li>Correcting attributes quantity/unit/defaultUnit in a declaration.</li><li>Improving/fixing the documentation.</li><li>Introducing a new name in the public section of a class (model, package, ...) or in any section of a partial class is&nbsp;<strong>not</strong>&nbsp;allowed. Since otherwise, a user might use this new name and when storing its model and loading it with an older build-version, an error would occur.</li><li>Introducing a new name in the protected section of a non-partial class should only be done if absolutely necessary to fix a bug. The problem is that this might be non-backward compatible, because a user might already extend from this class and already using the same name.</li></ul><!--EndFragment--></body></html>"));

end VersionManagement;
