within Simulator.Files;

package Chemsep_Database
  model General_Properties
    parameter Integer SN;
    parameter String name;
    parameter String CAS;
    parameter Real Tc;
    parameter Real Pc;
    parameter Real Vc;
    parameter Real Cc;
    parameter Real Tb;
    parameter Real Tm;
    parameter Real TT;
    parameter Real TP;
    parameter Real MW;
    parameter Real LVB;
    parameter Real AF;
    parameter Real SP;
    parameter Real DM;
    parameter Real SH;
    parameter Real IGHF;
    parameter Real GEF;
    parameter Real AS;
    parameter Real HFMP;
    parameter Real HOC;
    parameter Real UniquacR;
    parameter Real UniquacQ;
    parameter Real LiqDen[6];
    parameter Real VP[6];
    parameter Real LiqCp[6];
    parameter Real HOV[6];
    parameter Real VapCp[6];
    parameter Real LiqVis[6];
    parameter Real VapVis[6];
    parameter Real LiqK[6];
    parameter Real VapK[6];
    parameter Real Racketparam;
    parameter Real ChaoSeadAF;
    parameter Real ChaoSeadSP;
    parameter Real ChaoSeadLV;
  end General_Properties;

  model Air
  extends General_Properties(
    SN = 1, name = "Air", CAS = "132259-10-0", Tc = 132.45, Pc = 3774000,  Vc = 0.09147, Cc = 0.313, Tb = 78.67, Tm = 59.15, TT = 59.15, TP = 5642.15, MW = 28.96, LVB = 0.0329147, AF = 0, SP = 12750, DM = 0, SH = 0.0, IGHF = 0, GEF = 0, AS = 199000, HFMP = 0, HOC = 0, LiqDen = {105,2.6731,0.25637,132.51,0.26788,0}, VP = {101,14.794,-599.85,1.0009,-3.9938E-07,2}, LiqCp = {16,53628,4511.1,-143.29,1.582,-0.0051332}, HOV = {106,7385651,0.276676,0.211253,-0.836764,0.722737}, VapCp = {100,29562.29,-7.164949,0.0216294,-0.0000139748,2.89195E-09}, LiqVis = {101,-72.336,813.48,12.687,-0.00033062,2}, VapVis = {102,0.000001592,0.48975,123.45,-829.58,0}, LiqK = {16,-0.21199,-16.311,-0.23057,-0.0076197,0.0000025018}, VapK = {102,0.0003511,0.76492,16.071,1084.4,0}, Racketparam = 0.29056, UniquacR = 0, UniquacQ = 0, ChaoSeadAF = -0.00787976, ChaoSeadSP = 12749.8, ChaoSeadLV = 0.0329147);
  end Air;
  
  model Argon
  extends General_Properties(
    SN = 2, name = "Argon", CAS = "7440-37-1", Tc = 150.86, Pc = 4898000,  Vc = 0.07457, Cc = 0.291, Tb = 87.27, Tm = 83.8039, TT = 83.8, TP = 68906.1, MW = 39.948, LVB = 0.0291, AF = -0.002, SP = 14138.3, DM = 0, SH = 0.0, IGHF = 0, GEF = 0, AS = 154732, HFMP = 1184900, HOC = 0, LiqDen = {105,3.803,0.286,150.86,0.2984,0}, VP = {101,44.369,-1126.1,-4.5688,0.000062339,2}, LiqCp = {16,46085,-1304.5,21.195,-0.015382,0.000033063}, HOV = {106,7981000,0.099752,0.32009,-0.11898,0.031141}, VapCp = {16,20786,0,0,0,0}, LiqVis = {101,-99.903,1347.5,17.615,-0.00032893,2}, VapVis = {102,0.0000010023,0.5922,85.563,238.26,0}, LiqK = {16,-0.30397,-0.82999,-0.71462,-0.00039294,-0.000012209}, VapK = {102,0.00013095,0.81923,-122.33,13993,0}, Racketparam = 0, UniquacR = 1.1074, UniquacQ = 1.068, ChaoSeadAF = -0.002, ChaoSeadSP = 14138.3, ChaoSeadLV = 0.0285865);
  end Argon;
  
  model Bromine
  extends General_Properties(
    SN = 3, name = "Bromine", CAS = "7726-95-6", Tc = 584.15, Pc = 1.03E+07,  Vc = 0.135, Cc = 0.286, Tb = 331.9, Tm = 265.9, TT = 265.85, TP = 5853.37, MW = 159.808, LVB = 0.0514795, AF = 0.128997, SP = 23590, DM = 0, SH = 0.0, IGHF = 3.091E+07, GEF = 3140000, AS = 245350, HFMP = 1.057E+07, HOC = 0, LiqDen = {105,2.0603,0.28982,584.15,0.28948,0}, VP = {101,63.657,-5321.6,-6.3199,0.0000054412,2}, LiqCp = {16,75351,-4.87E+07,54033,102.73,0.43775}, HOV = {106,3.8419E+07,-0.26282,2.1808,-2.7529,1.1823}, VapCp = {16,35000,-410,8.5,-0.00016,-0.00000001}, LiqVis = {101,-5.9813,410.55,-0.30036,-0.000006936,2}, VapVis = {102,1.1438E-07,0.88111,59.595,-6723.3,0}, LiqK = {16,-0.69183,27.775,-0.38966,0.00057103,-8.8462E-07}, VapK = {102,0.0000065648,1.4785,4505.6,-870500,0}, Racketparam = 0.279241, UniquacR = 1.8985, UniquacQ = 1.672, ChaoSeadAF = 0.108, ChaoSeadSP = 23591.8, ChaoSeadLV = 0.0514795);
  end Bromine;
  
  model Carbontetrachloride
  extends General_Properties(
    SN = 4, name = "Carbontetrachloride", CAS = "56-23-5", Tc = 556.3, Pc = 4557000,  Vc = 0.276, Cc = 0.271, Tb = 349.79, Tm = 250.33, TT = 250.33, TP = 1122.46, MW = 153.822, LVB = 0.09707, AF = 0.187, SP = 17550, DM = 0, SH = 0.0, IGHF = -9.581E+07, GEF = -5.354E+07, AS = 309910, HFMP = 2535000, HOC = -2.653E+08, LiqDen = {105,1.0721,0.28328,556.3,0.30092,0}, VP = {101,82.671,-6304.2,-9.2247,0.0000074352,2}, LiqCp = {16,129390,1959.2,-18.833,0.080834,-0.000047491}, HOV = {106,3.1764E+07,-1.5729,5.2158,-5.5259,2.1931}, VapCp = {16,37588.04,-242.5309,11.66726,-0.000446049,1.391101E-07}, LiqVis = {101,-22.297,1645,1.7588,-0.0000028163,2}, VapVis = {102,0.0000029947,0.37756,454.35,5708.3,0}, LiqK = {16,0.034432,-227.95,-0.38117,-0.0048371,-0.0000011782}, VapK = {102,0.0001208,0.98541,1411.1,-36584,0}, Racketparam = 0, UniquacR = 3.33, UniquacQ = 2.82, ChaoSeadAF = 1.695, ChaoSeadSP = 17546.4, ChaoSeadLV = 0.0971395);
  end Carbontetrachloride;
  
  model Carbonmonoxide
  extends General_Properties(
    SN = 5, name = "Carbonmonoxide", CAS = "630-08-0", Tc = 132.85, Pc = 3494000,  Vc = 0.0931, Cc = 0.292, Tb = 81.66, Tm = 68.15, TT = 68.15, TP = 15400, MW = 28.01, LVB = 0.03488, AF = 0.045, SP = 6402, DM = 3.74E-31, SH = -110530000.0, IGHF = -1.1053E+08, GEF = -1.3715E+08, AS = 197556, HFMP = 840984, HOC = -2.83E+08, LiqDen = {105,2.2423,0.2437,132.93,0.24196,0}, VP = {101,42.283,-1035.1,-4.2012,0.000062546,2}, LiqCp = {16,63364,-10524,359.6,-3.9494,0.014624}, HOV = {106,8585000,0.4921,-0.326,0.2231,0}, VapCp = {16,29100,-1979.753,10.58274,-0.0000790406,-1.99685E-07}, LiqVis = {101,-82.158,1037.8,14.229,-0.00028204,2}, VapVis = {102,0.0000012713,0.51494,105.97,-231.11,0}, LiqK = {16,-0.23621,-3.5251,-0.55788,-0.0039362,-0.0000082725}, VapK = {102,0.00061581,0.6828,61.287,221.32,0}, Racketparam = 0.2918, UniquacR = 1.0679, UniquacQ = 1.112, ChaoSeadAF = 0.093, ChaoSeadSP = 6402.36, ChaoSeadLV = 0.0354426);
  end Carbonmonoxide;
  
  model Carbondioxide
  extends General_Properties(
    SN = 6, name = "Carbondioxide", CAS = "124-38-9", Tc = 304.21, Pc = 7383000,  Vc = 0.094, Cc = 0.274, Tb = 0, Tm = 216.58, TT = 216.58, TP = 518672, MW = 44.0095, LVB = 0.0616782, AF = 0.223621, SP = 14560, DM = 0, SH = -393510000.0, IGHF = -3.9351E+08, GEF = -3.9437E+08, AS = 213677, HFMP = 9019000, HOC = 0, LiqDen = {105,2.768,0.26212,304.21,0.2908,0}, VP = {101,95.478,-4070,-12.07,0.000029505,2}, LiqCp = {16,80592,108.83,-6.9126,0.059647,0.0000069922}, HOV = {106,2.1092E+07,0.35366,-0.46134,0.43554,0.037671}, VapCp = {16,28933,-494.28,10.658,-0.000027375,3.3268E-09}, LiqVis = {101,-7.7022,-166.34,0.38094,-0.00004018,2}, VapVis = {102,0.0000022464,0.45495,292.64,1669.1,0}, LiqK = {16,-0.24975,-55.106,0.41735,-0.0051067,0.0000020157}, VapK = {102,5.804,-0.44522,794.13,2139600,0}, Racketparam = 0.270937, UniquacR = 1.2986, UniquacQ = 1.292, ChaoSeadAF = 0.231, ChaoSeadSP = 14563.8, ChaoSeadLV = 0.0372744);
  end Carbondioxide;
  
  model Carbondisulfide
  extends General_Properties(
    SN = 7, name = "Carbondisulfide", CAS = "75-15-0", Tc = 552, Pc = 7900000,  Vc = 0.16, Cc = 0.275, Tb = 319.375, Tm = 161.58, TT = 161.11, TP = 1.4944, MW = 76.1407, LVB = 0.0606387, AF = 0.110697, SP = 20400, DM = 0, SH = -393510000.0, IGHF = 1.169E+08, GEF = 6.68E+07, AS = 237900, HFMP = 4393000, HOC = -1.0769E+09, LiqDen = {105,1.7976,0.28757,552,0.32269,0}, VP = {101,52.62041,-4546.02,-4.744246,4.881551E-06,2}, LiqCp = {16,69032,671.75,2.3423,0.015972,-0.0000043479}, HOV = {106,3.9758E+07,0.68679,0.18227,-1.7985,1.3658}, VapCp = {16,26779,-222.87,10.557,0.00011062,-5.3772E-08}, LiqVis = {101,-9.8702,691.26,-0.072299,1.6489E-07,2}, VapVis = {102,5.9681E-08,0.92304,48.01,-162.47,0}, LiqK = {16,0.12378,-150.01,-0.453,-0.0078739,-0.0000032002}, VapK = {102,0.00033762,0.73827,483.3,-4769.2,0}, Racketparam = 0, UniquacR = 2.057, UniquacQ = 1.65, ChaoSeadAF = 0.107865, ChaoSeadSP = 20410.7, ChaoSeadLV = 0.0606387);
  end Carbondisulfide;
  
  model Phosgene
  extends General_Properties(
    SN = 8, name = "Phosgene", CAS = "75-44-5", Tc = 455, Pc = 5674200,  Vc = 0.19, Cc = 0.285, Tb = 280.71, Tm = 145.37, TT = 145.37, TP = 0.920651, MW = 98.9161, LVB = 0.0597955, AF = 0.201309, SP = 17140, DM = 3.9E-30, SH = -218900000.0, IGHF = -2.189E+08, GEF = -2.0479E+08, AS = 283740, HFMP = 5738400, HOC = -1.746E+08, LiqDen = {105,1.4691,0.2768,455,0.27965,0}, VP = {101,81.03568,-5112.106,-9.267047,0.0000119936,2}, LiqCp = {16,101240,-202030,196.31,2.1704,-0.0015512}, HOV = {106,4.367252E+07,1.081822,-0.773774,-0.1937,0.317951}, VapCp = {16,32506,-282.16,11.124,-0.00017636,4.5651E-08}, LiqVis = {101,-789.51,22474,129.1,-0.00032789,2}, VapVis = {102,6.2229E-07,0.58405,277.35,-6111.6,0}, LiqK = {16,0.0025061,3.5674,-1.6592,-0.0007952,-0.0000018088}, VapK = {102,0.000024368,1.1423,246.56,4296.5,0}, Racketparam = 0, UniquacR = 2.300593, UniquacQ = 2.08, ChaoSeadAF = 0.1918, ChaoSeadSP = 17837.2, ChaoSeadLV = 0.0705389);
  end Phosgene;
  
  model Trichloroacetylchloride
  extends General_Properties(
    SN = 9, name = "Trichloroacetylchloride", CAS = "76-02-8", Tc = 604, Pc = 4320000,  Vc = 0.3408, Cc = 0.293, Tb = 391.15, Tm = 216.2, TT = 216.2, TP = 5.18177, MW = 181.833, LVB = 0.112961, AF = 0.282386, SP = 18010, DM = 4.0E-30, SH = -218900000.0, IGHF = -2.398E+08, GEF = -1.8E+08, AS = 360000, HFMP = 9040000, HOC = -5.062E+08, LiqDen = {105,0.76674,0.26122,604,0.28678,0}, VP = {101,174.9617,-10592.68,-23.45621,0.0000238342,2}, LiqCp = {16,177260,-1933.8,48.92,-0.20004,0.00024097}, HOV = {106,1.449329E+08,7.45895,-20.20511,23.04844,-9.793955}, VapCp = {16,91870,-696.64,12.555,-0.0015691,6.1156E-07}, LiqVis = {101,-12.095,1867,-0.00010079,1.1286E-09,2}, VapVis = {102,0.0000001265,0.7796,98.46,0.0024692,0}, LiqK = {16,0.043702,-153.3,-0.62199,-0.0058162,0.0000023649}, VapK = {102,0.0006898,0.5929,623.5,0.0039481,0}, Racketparam = 0, UniquacR = 4.177323, UniquacQ = 3.544, ChaoSeadAF = 0.347734, ChaoSeadSP = 18501.6, ChaoSeadLV = 0.112737);
  end Trichloroacetylchloride;
  
  model Hydrogenchloride
  extends General_Properties(
    SN = 10, name = "Hydrogenchloride", CAS = "7647-01-0", Tc = 324.69, Pc = 8310000,  Vc = 0.081, Cc = 0.249, Tb = 188.15, Tm = 158.97, TT = 158.97, TP = 13521.9, MW = 36.461, LVB = 0.03028, AF = 0.126, SP = 12190, DM = 3.6E-30, SH = -92310000.0, IGHF = -9.231E+07, GEF = -9.53E+07, AS = 186786, HFMP = 2000000, HOC = -2.86E+07, LiqDen = {105,2.3619,0.23301,324.69,0.25076,0}, VP = {101,138.2562,-4825.245,-19.73669,0.0000650759,2}, LiqCp = {16,-53340,265.92,4.243,0.058092,-0.00013923}, HOV = {106,1.9563E+07,-0.79988,3.8907,-4.9768,2.2266}, VapCp = {16,29096.99,-1271.123,6.610209,0.00378635,-0.0000013094}, LiqVis = {101,-196.43,5474.4,31.068,-0.000094243,2}, VapVis = {102,5.1969E-07,0.66444,177.83,-3965.9,0}, LiqK = {16,-0.4993,-113.3,0.99185,-0.0023549,-0.0000033612}, VapK = {102,0.0017816,0.5013,331.03,3750.8,0}, Racketparam = 0, UniquacR = 1.056032, UniquacQ = 1.1, ChaoSeadAF = 0.121, ChaoSeadSP = 22003.8, ChaoSeadLV = 0.030563);
  end Hydrogenchloride;
  
  model Chlorine
  extends General_Properties(
    SN = 11, name = "Chlorine", CAS = "7782-50-5", Tc = 417, Pc = 7700000,  Vc = 0.124, Cc = 0.275, Tb = 239.12, Tm = 172.12, TT = 172.12, TP = 1366.04, MW = 70.905, LVB = 0.04536, AF = 0.073, SP = 17360, DM = 0, SH = 0.0, IGHF = 0, GEF = 0, AS = 222972, HFMP = 6406000, HOC = 0, LiqDen = {105,1.8293,0.25,417.16,0.26753,0}, VP = {101,45.776,-3292.7,-3.7926,0.0000049863,2}, LiqCp = {16,66547,12488,-246.3,-2.7266,-0.021518}, HOV = {106,2.9601E+07,0.77334,-1.0279,0.93368,-0.2926}, VapCp = {16,28958,-398.03,10.125,-0.0010681,3.8414E-07}, LiqVis = {101,-11.351,502.6,0.30506,-9.5237E-07,2}, VapVis = {102,2.5899E-07,0.74273,97.463,-22.488,0}, LiqK = {16,-0.48743,13.229,-0.49371,0.00052989,-0.0000020491}, VapK = {102,0.00096588,0.54995,434.26,3605.9,0}, Racketparam = 0, UniquacR = 1.5887, UniquacQ = 1.524, ChaoSeadAF = 0.0547, ChaoSeadSP = 20120, ChaoSeadLV = 0.0455063);
  end Chlorine;
  
  model Hydrogeniodide
  extends General_Properties(
    SN = 12, name = "Hydrogeniodide", CAS = "10034-85-2", Tc = 423.85, Pc = 8310000,  Vc = 0.1219, Cc = 0.287, Tb = 237.55, Tm = 222.38, TT = 222.38, TP = 49326.4, MW = 127.912, LVB = 0.0507575, AF = 0.0380703, SP = 17120, DM = 1.5E-30, SH = 26500000.0, IGHF = 2.65E+07, GEF = 1716000, AS = 206481, HFMP = 2872100, HOC = -1.162E+08, LiqDen = {105,0.29008,0.10272,423.85,0.12802,0}, VP = {101,48.208,-3309.5,-4.2202,0.0000058868,2}, LiqCp = {16,47228,657.18,2.2493,0.031778,-0.000056365}, HOV = {106,4.5057E+07,2.4036,-3.4166,1.5877,-0.0027034}, VapCp = {16,29070.86,-1600.955,9.445762,0.000914155,-4.506661E-07}, LiqVis = {101,-20.449,-959.41,4.2445,-0.000095025,2}, VapVis = {102,1.6146E-07,0.8587,45.387,-1595.3,0}, LiqK = {16,-0.2841,21.17,-1.299,0.00096857,-0.0000020056}, VapK = {102,0.000042343,0.89806,44.783,-39.662,0}, Racketparam = 0, UniquacR = 1.6724, UniquacQ = 1.5928, ChaoSeadAF = 0.0380703, ChaoSeadSP = 19866.7, ChaoSeadLV = 0.0457176);
  end Hydrogeniodide;
  
  model Hydrogen
  extends General_Properties(
    SN = 13, name = "Hydrogen", CAS = "1333-74-0", Tc = 33.19, Pc = 1313000,  Vc = 0.064147, Cc = 0.305, Tb = 20.39, Tm = 13.95, TT = 13.95, TP = 7220, MW = 2.01588, LVB = 0.0285681, AF = -0.215993, SP = 6648, DM = 0, SH = 0.0, IGHF = 0, GEF = 0, AS = 130571, HFMP = 117100, HOC = -2.4182E+08, LiqDen = {105,2.9613,0.25981,33.19,0.19104,0}, VP = {101,13.05,-97.534,1.0355,0.00031816,2}, LiqCp = {16,14510,-1191.1,156.51,-6.1773,0.087907}, HOV = {106,1534700,3.214,-8.4567,8.4646,-2.8057}, VapCp = {16,3994.325,-48.69006,10.36209,-0.000340144,1.960333E-07}, LiqVis = {101,-32.531,97.304,5.9178,-0.0031563,2}, VapVis = {102,1.7916E-07,0.68557,-0.51413,132.61,0}, LiqK = {16,-0.34238,-4.3002,-0.53814,0.0011639,-0.00021792}, VapK = {102,0.0026851,0.74366,13.289,-31.305,0}, Racketparam = 0.3139, UniquacR = 0.4092, UniquacQ = 0.5516, ChaoSeadAF = 0, ChaoSeadSP = 6647.875, ChaoSeadLV = 0.031);
  end Hydrogen;
  
  model Water
  extends General_Properties(
    SN = 14, name = "Water", CAS = "7732-18-5", Tc = 647.14, Pc = 2.2064E+07,  Vc = 0.05595, Cc = 0.229, Tb = 373.15, Tm = 273.15, TT = 273.16, TP = 611.73, MW = 18.015, LVB = 0.01807, AF = 0.344, SP = 47860, DM = 6.17E-30, SH = 0.0, IGHF = -2.41814E+08, GEF = -2.2859E+08, AS = 188724, HFMP = 6001740, HOC = 0, LiqDen = {106,32.51621,-3.213004,7.92411,-7.359898,2.703522}, VP = {101,74.55502,-7295.586,-7.442448,0.0000042881,2}, LiqCp = {16,75539,-22297,136.02,-0.25622,0.00018273}, HOV = {106,5.964E+07,0.86515,-1.1134,0.67764,-0.026925}, VapCp = {16,33200,-878.9001,8.436956,0.00207627,-6.467085E-07}, LiqVis = {101,-133.7,6785.7,18.47,-0.000014736,2}, VapVis = {102,7.002327E-08,0.934576,195.6338,-13045.99,0}, LiqK = {16,-1.5697,-55.141,0.7832,0.0011484,-0.0000018151}, VapK = {102,0.0000065986,1.3947,59.478,-15484,0}, Racketparam = 0.2338, UniquacR = 0.92, UniquacQ = 1.4, ChaoSeadAF = 0.328, ChaoSeadSP = 47812.7, ChaoSeadLV = 0.0180674);
  end Water;
  
  model Hydrogensulfide
  extends General_Properties(
    SN = 15, name = "Hydrogensulfide", CAS = "7783-06-4", Tc = 373.53, Pc = 8962910,  Vc = 0.0985, Cc = 0.284, Tb = 212.8, Tm = 187.68, TT = 187.68, TP = 23200, MW = 34.0809, LVB = 0.0438045, AF = 0.0941677, SP = 18000, DM = 3.23E-30, SH = -20630000.0, IGHF = -2.063E+07, GEF = -3.344E+07, AS = 205600, HFMP = 2376500, HOC = -5.18E+08, LiqDen = {105,2.3565,0.25354,373.53,0.26514,0}, VP = {101,48.34868,-3078.428,-4.229632,6.844234E-06,2}, LiqCp = {16,68743,-100800,1016.4,-3.3645,0.0037533}, HOV = {106,2.7198E+07,0.69517,-0.69951,0.51422,-0.11694}, VapCp = {16,33121.9,-869.6079,9.605736,0.00110059,-3.859399E-07}, LiqVis = {101,7.527,261.77,-3.1833,0.0000078743,2}, VapVis = {102,3.4328E-08,1.0455,58.912,-13329,0}, LiqK = {16,-0.078369,-33.634,-0.24641,-0.0025463,-0.0000049089}, VapK = {102,1.0611E-07,1.8773,-355.78,45782,0}, Racketparam = 0.285, UniquacR = 1.234, UniquacQ = 1.241, ChaoSeadAF = 0.0941677, ChaoSeadSP = 18000.2, ChaoSeadLV = 0.0358604);
  end Hydrogensulfide;
  
  model Ammonia
  extends General_Properties(
    SN = 16, name = "Ammonia", CAS = "7664-41-7", Tc = 405.4, Pc = 1.1353E+07,  Vc = 0.07247, Cc = 0.255, Tb = 239.82, Tm = 195.41, TT = 195.41, TP = 6111.09, MW = 17.031, LVB = 0.02496, AF = 0.256, SP = 24790, DM = 4.9E-30, SH = -45898000.0, IGHF = -4.5898E+07, GEF = -1.64E+07, AS = 192660, HFMP = 5657000, HOC = -3.1683E+08, LiqDen = {105,4.0518,0.27129,405.4,0.31349,0}, VP = {101,62.8849,-4136.862,-6.320663,9.203947E-06,2}, LiqCp = {16,77659,-45330,445.74,-1.4197,0.0015508}, HOV = {106,2.4542E+07,-1.3178,4.7194,-5.4808,2.4196}, VapCp = {16,33239,-913.64,10.802,0.00021047,-4.1739E-08}, LiqVis = {101,-39.742,1486.5,4.7749,-0.000015796,2}, VapVis = {102,0.0000000459,0.96936,48.366,-2671.4,0}, LiqK = {16,-0.95309,14.684,0.56768,-0.00028968,-0.0000019238}, VapK = {102,0.000016165,1.3146,75.168,-8202.1,0}, Racketparam = 0, UniquacR = 0.9097, UniquacQ = 0.98, ChaoSeadAF = 0.2517, ChaoSeadSP = 29224.9, ChaoSeadLV = 0.0249801);
  end Ammonia;
  
  model Neon
  extends General_Properties(
    SN = 17, name = "Neon", CAS = "7440-01-9", Tc = 44.4, Pc = 2653000,  Vc = 0.0417, Cc = 0.3, Tb = 27.09, Tm = 24.55, TT = 24.56, TP = 43300, MW = 20.1797, LVB = 0.0167622, AF = -0.0395988, SP = 9440, DM = 0, SH = 0.0, IGHF = 0, GEF = 0, AS = 146219, HFMP = 328100, HOC = 0, LiqDen = {105,7.3718,0.3067,44.4,0.2786,0}, VP = {101,29.459,-269.41,-2.5349,0.00051726,2}, LiqCp = {16,29948,-243.96,32.083,-0.79445,0.01023}, HOV = {106,1420900,-0.63029,-0.0022325,1.6268,-0.7611}, VapCp = {16,20786,-1728.5,-21.855,0.0020512,2.1139E-07}, LiqVis = {101,-83.002,434.94,18.35,-0.0034996,2}, VapVis = {102,7.6731E-07,0.65634,5.8941,175.84,0}, LiqK = {16,-0.49811,-1.8025,-0.49257,0.0090166,-0.00024023}, VapK = {102,0.0011717,0.66099,12.109,-70.155,0}, Racketparam = 0, UniquacR = 0.680949, UniquacQ = 0.776, ChaoSeadAF = -0.0413762, ChaoSeadSP = 9417.34, ChaoSeadLV = 0.0167622);
  end Neon;
  
  model Nitricacid
  extends General_Properties(
    SN = 18, name = "Nitricacid", CAS = "7697-37-2", Tc = 520, Pc = 6890100,  Vc = 0.145, Cc = 0.231, Tb = 356.15, Tm = 231.55, TT = 231.55, TP = 60.7682, MW = 63.0128, LVB = 0.041734, AF = 0.714406, SP = 29610, DM = 7.24E-30, SH = 0.0, IGHF = -1.343E+08, GEF = -7.401E+07, AS = 266370, HFMP = 1.047E+07, HOC = 1.34E+07, LiqDen = {105,6.9293,0.47274,520,0.49837,0}, VP = {101,26.654,-5017.1,-0.036699,-0.0000064771,2}, LiqCp = {16,111110,-611.57,-2.7202,0.014286,-0.000033905}, HOV = {106,7.01E+07,0.68707,-0.0019914,0.0028792,-0.0014403}, VapCp = {16,32639,-463.06,11.547,-0.00011018,4.1801E-09}, LiqVis = {101,264.29,-7985,-44.099,0.000074947,2}, VapVis = {102,2.2234E-07,0.72283,140.72,-0.0025913,0}, LiqK = {16,0.15591,-186.43,-2.2714,0.0033214,-0.0000018932}, VapK = {102,0.00063365,0.72057,645.24,0.005306,0}, Racketparam = 0, UniquacR = 1.638761, UniquacQ = 1.564, ChaoSeadAF = 0.714406, ChaoSeadSP = 29605.6, ChaoSeadLV = 0.041734);
  end Nitricacid;
  
  model Nitricoxide
  extends General_Properties(
    SN = 19, name = "Nitricoxide", CAS = "10102-43-9", Tc = 180, Pc = 6480000,  Vc = 0.058, Cc = 0.251, Tb = 121.38, Tm = 112.15, TT = 109.5, TP = 21890, MW = 30.006, LVB = 0.02344, AF = 0.582, SP = 23120, DM = 5.1E-31, SH = 90250000.0, IGHF = 9.025E+07, GEF = 8.657E+07, AS = 210600, HFMP = 2301000, HOC = -9.02489E+07, LiqDen = {105,2.1354,0.19686,180.16,0.15443,0}, VP = {101,98.67523,-3011.477,-13.21121,0.000072078,2}, LiqCp = {16,38756,-323.94,15.685,-0.060412,0.00033434}, HOV = {106,2.4721E+07,2.2365,-5.8672,6.8169,-2.7529}, VapCp = {16,29831.89,-2622.96,12.94433,-0.00260975,6.261468E-07}, LiqVis = {101,-50.098,734.63,8.0267,-0.00017996,2}, VapVis = {102,0.0000010289,0.55954,89.353,515.43,0}, LiqK = {16,-0.85384,4.7868,-0.010049,0.0010454,-0.0000086044}, VapK = {102,0.00046657,0.73353,58.917,-625.75,0}, Racketparam = 0, UniquacR = 0.9163, UniquacQ = 0.9859, ChaoSeadAF = 0.582944, ChaoSeadSP = 23117.6, ChaoSeadLV = 0.0234267);
  end Nitricoxide;
  
  model Nitrogendioxide
  extends General_Properties(
    SN = 20, name = "Nitrogendioxide", CAS = "10102-44-0", Tc = 431.15, Pc = 1.01325E+07,  Vc = 0.08249, Cc = 0.233, Tb = 294.15, Tm = 261.9, TT = 261.9, TP = 18728.3, MW = 46.0055, LVB = 0.031997, AF = 0.851088, SP = 33390, DM = 1.05E-30, SH = 33180000.0, IGHF = 3.318E+07, GEF = 5.1328E+07, AS = 239920, HFMP = 1.465E+07, HOC = -3.30954E+07, LiqDen = {105,2.2179,0.22994,431.38,0.19006,0}, VP = {101,18.404,-3508.6,0.81255,0.0000049983,2}, LiqCp = {16,77435,432.69,5.3737,0.020804,-0.000021695}, HOV = {106,5.37E+07,0.3,0,0,0}, VapCp = {16,32962.96,-578.7755,10.44921,0.0000793322,-5.181036E-08}, LiqVis = {101,-311.49,10041,49.027,-0.00010518,2}, VapVis = {102,1.2078E-08,1.1399,-382.56,78187,0}, LiqK = {16,0.11611,127610,-1409.1,5.1777,-0.0063738}, VapK = {102,0.070851,-0.2143,-1258,429500,0}, Racketparam = 0, UniquacR = 1.053395, UniquacQ = 1.1308, ChaoSeadAF = 0.851088, ChaoSeadSP = 33494.8, ChaoSeadLV = 0.0317854);
  end Nitrogendioxide;
  
  model Nitrogen
  extends General_Properties(
    SN = 21, name = "Nitrogen", CAS = "7727-37-9", Tc = 126.2, Pc = 3398000,  Vc = 0.0901, Cc = 0.289, Tb = 77.35, Tm = 63.149, TT = 63.149, TP = 12520, MW = 28.014, LVB = 0.03484, AF = 0.037, SP = 9082, DM = 0, SH = 0.0, IGHF = 0, GEF = 0, AS = 191500, HFMP = 720000, HOC = 0, LiqDen = {105,2.435,0.25137,126.27,0.249,0}, VP = {101,42.32946,-965.9771,-4.321774,0.0000797271,2}, LiqCp = {16,55135,217.45,-0.9071,0.05327,0.00024166}, HOV = {106,2.7284E+07,7.8021,-19.125,19.518,-7.5428}, VapCp = {16,29103.63,-2305.946,11.31935,-0.00100557,1.706099E-07}, LiqVis = {101,3.4358,-24.706,-2.6748,-0.000041603,2}, VapVis = {102,4.6051E-07,0.65049,5.8019,2822.7,0}, LiqK = {16,-0.21743,10.383,-1.0631,0.00036245,-0.000023265}, VapK = {102,0.0003395,0.76921,19.592,293.93,0}, Racketparam = 0.2906, UniquacR = 1.0415, UniquacQ = 1.088, ChaoSeadAF = 0.045, ChaoSeadSP = 9081.94, ChaoSeadLV = 0.0346723);
  end Nitrogen;
  
  model Nitrousoxide
  extends General_Properties(
    SN = 22, name = "Nitrousoxide", CAS = "10024-97-2", Tc = 309.6, Pc = 7255000,  Vc = 0.097, Cc = 0.273, Tb = 184.67, Tm = 182.33, TT = 182.3, TP = 87850, MW = 44.013, LVB = 0.0359, AF = 0.162, SP = 8275, DM = 5.57E-31, SH = 82050000.0, IGHF = 8.205E+07, GEF = 1.0416E+08, AS = 219850, HFMP = 6539000, HOC = -8.20482E+07, LiqDen = {105,2.0978,0.2338,309.6,0.25899,0}, VP = {101,50.69662,-2836.473,-4.609937,7.237315E-06,2}, LiqCp = {16,72525,232.93,2.2666,0.037329,-0.000055304}, HOV = {106,2.585559E+07,0.982629,-2.292314,3.369827,-1.65657}, VapCp = {16,28650,-400.03,10.5,0.00014292,-6.728E-08}, LiqVis = {101,-10.876,472.99,0.14659,-0.000013815,2}, VapVis = {102,0.0000020512,0.47044,305.02,-521.81,0}, LiqK = {16,0.10112,-5274.1,16.778,-0.037729,-0.000048678}, VapK = {102,0.001121,0.66298,524.68,7332.7,0}, Racketparam = 0, UniquacR = 1.238, UniquacQ = 1.2442, ChaoSeadAF = 0.140894, ChaoSeadSP = 20308, ChaoSeadLV = 0.036002);
  end Nitrousoxide;
  
  model Oxygen
  extends General_Properties(
    SN = 23, name = "Oxygen", CAS = "7782-44-7", Tc = 154.58, Pc = 5043000,  Vc = 0.07337, Cc = 0.288, Tb = 90.17, Tm = 54.361, TT = 54.361, TP = 150, MW = 31.999, LVB = 0.02785, AF = 0.022, SP = 8182, DM = 0, SH = 0.0, IGHF = 0, GEF = 0, AS = 205043, HFMP = 444000, HOC = 0, LiqDen = {105,2.6097,0.23614,154.78,0.23695,0}, VP = {101,40.55487,-1120.543,-3.776114,0.0000485344,2}, LiqCp = {16,53393,-1966.4,48.21,-0.31631,0.0010466}, HOV = {106,1.0672E+07,1.5661,-3.4356,3.5416,-1.2718}, VapCp = {16,29061.62,-1470.897,11.10778,-0.00128484,3.183122E-07}, LiqVis = {101,-5.2319,116.13,-1.0315,0.0000034376,2}, VapVis = {102,8.0134E-07,0.60321,56.09,1584.9,0}, LiqK = {16,-0.19654,-10.535,-0.46717,-0.0052064,-3.3418E-07}, VapK = {102,0.0004508,0.74544,58.278,-562.62,0}, Racketparam = 0.2908, UniquacR = 0.857, UniquacQ = 0.94, ChaoSeadAF = 0.019, ChaoSeadSP = 8181.93, ChaoSeadLV = 0.0280225);
  end Oxygen;
  
  model Sulfurdioxide
  extends General_Properties(
    SN = 24, name = "Sulfurdioxide", CAS = "7446-09-5", Tc = 430.75, Pc = 7884100,  Vc = 0.122, Cc = 0.269, Tb = 263.13, Tm = 200, TT = 197.67, TP = 1674.39, MW = 64.0638, LVB = 0.04688, AF = 0.245381, SP = 12270, DM = 5.44E-30, SH = -296840000.0, IGHF = -2.9684E+08, GEF = -3.0012E+08, AS = 248100, HFMP = 7401000, HOC = 0, LiqDen = {105,1.8477,0.24254,430.75,0.27051,0}, VP = {101,53.52766,-4260.124,-4.670429,0.0000030272,2}, LiqCp = {16,86911,53691,-599.94,2.2025,-0.0025885}, HOV = {106,4.8914E+07,1.8091,-2.9053,2.2271,-0.64793}, VapCp = {16,33406,-516.38,10.524,0.000013143,-6.1535E-08}, LiqVis = {101,50.887,-1574,-9.4517,1.5898E-07,2}, VapVis = {102,0.0000012144,0.53923,315.41,-2659.7,0}, LiqK = {16,-0.21664,-2.2484,-0.50659,-0.0009424,-0.0000010218}, VapK = {102,23.316,-0.95324,-1567.4,1330100,0}, Racketparam = 0, UniquacR = 1.6961, UniquacQ = 1.612, ChaoSeadAF = 0.2462, ChaoSeadSP = 12272.9, ChaoSeadLV = 0.0438228);
  end Sulfurdioxide;
  
  model Sulfurtrioxide
  extends General_Properties(
    SN = 25, name = "Sulfurtrioxide", CAS = "7446-11-9", Tc = 490.85, Pc = 8210000,  Vc = 0.127, Cc = 0.255, Tb = 317.9, Tm = 289.95, TT = 289.95, TP = 21130, MW = 80.0632, LVB = 0.0420954, AF = 0.42396, SP = 31130, DM = 0, SH = -296840000.0, IGHF = -3.9572E+08, GEF = -3.7095E+08, AS = 256510, HFMP = 7532000, HOC = 1.422E+08, LiqDen = {105,1.6186,0.20129,490.85,0.42123,0}, VP = {101,351.6001,-18247.39,-49.77065,0.0000409297,2}, LiqCp = {16,258090,-3271.8,-8.4929,0.0035868,-0.000028801}, HOV = {106,8.1339E+07,0.77728,-0.42427,0.68287,-0.4608}, VapCp = {16,32986,-404.97,11.171,-0.000087925,-8.9809E-09}, LiqVis = {101,-260.71,11505,38.839,-0.000061621,2}, VapVis = {102,0.0000010033,0.54515,135.63,19402,0}, LiqK = {16,0.021077,585.52,-5.8227,0.016099,-0.000027318}, VapK = {102,1.1717,-0.2465,2002.7,1327100,0}, Racketparam = 0, UniquacR = 2.145023, UniquacQ = 1.972376, ChaoSeadAF = 0.42396, ChaoSeadSP = 31130, ChaoSeadLV = 0.0420954);
  end Sulfurtrioxide;
  
  model Chloroform
  extends General_Properties(
    SN = 26, name = "Chloroform", CAS = "67-66-3", Tc = 536.5, Pc = 5500000,  Vc = 0.24, Cc = 0.296, Tb = 334.33, Tm = 209.63, TT = 209.63, TP = 68.1479, MW = 119.377, LVB = 0.08068, AF = 0.226, SP = 18920, DM = 3.37E-30, SH = -296840000.0, IGHF = -1.029E+08, GEF = -7.01E+07, AS = 295600, HFMP = 9540000, HOC = -3.8E+08, LiqDen = {105,0.53556,0.18404,536.5,0.18541,0}, VP = {101,99.91512,-6781.559,-11.93873,0.0000115883,2}, LiqCp = {16,93132,645.44,2.3739,0.024457,-0.000021097}, HOV = {106,5.1382E+07,0.7027,0.36748,-1.351,0.69236}, VapCp = {16,36659,-308.1,11.299,0.00003137,-3.3538E-08}, LiqVis = {101,-20.923,1248.9,1.655,-0.0000024787,2}, VapVis = {102,1.8024E-07,0.76204,109.36,-1373.9,0}, LiqK = {16,0.061417,-66.692,-1.6802,-0.001962,-0.0000044192}, VapK = {102,0.00041167,0.84476,1870.6,-7829.5,0}, Racketparam = 0, UniquacR = 2.7, UniquacQ = 2.34, ChaoSeadAF = 0.2059, ChaoSeadSP = 18919.5, ChaoSeadLV = 0.0805048);
  end Chloroform;
  
  model Hydrogencyanide
  extends General_Properties(
    SN = 27, name = "Hydrogencyanide", CAS = "74-90-8", Tc = 456.65, Pc = 5390000,  Vc = 0.139, Cc = 0.197, Tb = 298.85, Tm = 259.91, TT = 259.833, TP = 18625, MW = 27.0253, LVB = 0.0397695, AF = 0.409913, SP = 24810, DM = 9.94E-30, SH = -296840000.0, IGHF = 1.35143E+08, GEF = 1.24725E+08, AS = 201719, HFMP = 8405700, HOC = -6.2329E+08, LiqDen = {105,1.3163,0.18425,456.65,0.2794,0}, VP = {101,42.70101,-4001.496,-3.208729,5.620619E-06,2}, LiqCp = {16,70227,-10279,42.028,0.069085,-0.00024154}, HOV = {106,4.5225E+07,2.0549,-4.7432,4.7996,-1.8366}, VapCp = {16,29289,-482.84,10.404,-0.000041659,6.8553E-08}, LiqVis = {101,-12.545,843.5,0.21344,-0.0000012673,2}, VapVis = {102,1.2749E-08,1.0633,338.59,155.3,0}, LiqK = {16,0.06901,-183.38,0.87895,-0.0078031,0.000002353}, VapK = {102,0.000015837,1.2055,-98.566,53091,0}, Racketparam = 0, UniquacR = 1.1951, UniquacQ = 1.2098, ChaoSeadAF = 0.409913, ChaoSeadSP = 24806, ChaoSeadLV = 0.0397695);
  end Hydrogencyanide;
  
  model Formaldehyde
  extends General_Properties(
    SN = 28, name = "Formaldehyde", CAS = "50-00-0", Tc = 408, Pc = 6590000,  Vc = 0.115, Cc = 0.223, Tb = 254.05, Tm = 181.15, TT = 181.15, TP = 887, MW = 30.026, LVB = 0.04097, AF = 0.281846, SP = 21190, DM = 7.77E-30, SH = -108600000.0, IGHF = -1.086E+08, GEF = -1.026E+08, AS = 218660, HFMP = 7050000, HOC = -5.268E+08, LiqDen = {105,1.9413,0.22308,408,0.28569,0}, VP = {101,62.07923,-4207.675,-6.202287,5.521233E-06,2}, LiqCp = {16,62716,-69.453,3.2871,0.047782,-0.0001008}, HOV = {106,3.0902E+07,0.29722,-0.051281,0.13234,-0.080686}, VapCp = {16,33216.06,-1212.62,11.96032,-0.000635943,1.549232E-07}, LiqVis = {101,-11.303,753.06,-0.013733,-4.6837E-08,2}, VapVis = {102,8.1997E-07,0.57256,258.17,-5091,0}, LiqK = {16,0.10999,-161.62,0.83463,-0.01142,0.0000060772}, VapK = {102,44.841,-0.71285,-3466.2,5262100,0}, Racketparam = 0, UniquacR = 0.9183, UniquacQ = 0.78, ChaoSeadAF = 0.253, ChaoSeadSP = 23824.8, ChaoSeadLV = 0.0369129);
  end Formaldehyde;
  
  model Methylchloride
  extends General_Properties(
    SN = 29, name = "Methylchloride", CAS = "74-87-3", Tc = 416.2, Pc = 6680000,  Vc = 0.143, Cc = 0.276, Tb = 248.95, Tm = 175.45, TT = 175.43, TP = 867.6, MW = 50.488, LVB = 0.05059, AF = 0.151, SP = 17320, DM = 6.24E-30, SH = -81960000.0, IGHF = -8.196E+07, GEF = -5.844E+07, AS = 234180, HFMP = 6548000, HOC = -6.7538E+08, LiqDen = {105,1.6672,0.24865,416.26,0.26843,0}, VP = {101,73.95113,-4332.347,-8.308415,0.0000132119,2}, LiqCp = {16,72914,778.6,-9.5627,0.081286,-0.000092921}, HOV = {106,3.0406E+07,0.41721,-0.045158,-0.067629,0.055437}, VapCp = {16,32790.34,-743.4513,11.51178,-0.0000302967,1.138778E-09}, LiqVis = {101,-60.189,2252.1,8.022,-0.000019477,2}, VapVis = {102,8.5916E-08,0.87071,35.619,35.603,0}, LiqK = {16,-0.22503,12.649,-0.64685,-0.0003032,-0.0000029812}, VapK = {102,-22144,0.7661,-4.8548E+10,-3.7839E+10,0}, Racketparam = 0, UniquacR = 1.667106, UniquacQ = 1.568, ChaoSeadAF = 0.153068, ChaoSeadSP = 19719.7, ChaoSeadLV = 0.0501264);
  end Methylchloride;
  
  model Methyliodide
  extends General_Properties(
    SN = 30, name = "Methyliodide", CAS = "74-88-4", Tc = 528, Pc = 7370000,  Vc = 0.185, Cc = 0.311, Tb = 315.58, Tm = 206.7, TT = 206.7, TP = 254.555, MW = 141.939, LVB = 0.062667, AF = 0.19716, SP = 20180, DM = 5.4E-30, SH = -81960000.0, IGHF = 1.3E+07, GEF = 1.47E+07, AS = 254000, HFMP = 0, HOC = -7.096E+08, LiqDen = {105,1.3975,0.25854,528,0.2679,0}, VP = {101,56.57754,-4804.529,-5.238128,3.097144E-06,2}, LiqCp = {16,81227,-510450,4831.2,-15.234,0.016088}, HOV = {106,3.3737E+07,-0.25822,1.7219,-2.0034,0.83642}, VapCp = {16,33243,-588.89,11.23,0.00016737,-5.0885E-08}, LiqVis = {101,-8.0691,650.82,-0.30881,-1.1201E-07,2}, VapVis = {102,7.1469E-07,0.6322,292.39,-1664.7,0}, LiqK = {16,0.025022,-2.7147,-2.1673,-0.0005511,-0.000004231}, VapK = {102,0.15913,0.010769,1577.4,2109400,0}, Racketparam = 0, UniquacR = 2.1651, UniquacQ = 1.84, ChaoSeadAF = 0.192721, ChaoSeadSP = 20172.3, ChaoSeadLV = 0.062667);
  end Methyliodide;
  
  model Methane
  extends General_Properties(
    SN = 31, name = "Methane", CAS = "74-82-8", Tc = 190.56, Pc = 4599000,  Vc = 0.0986, Cc = 0.286, Tb = 111.66, Tm = 90.694, TT = 90.694, TP = 11696, MW = 16.043, LVB = 0.03554, AF = 0.011, SP = 11600, DM = 0, SH = -74520000.0, IGHF = -7.452E+07, GEF = -5.049E+07, AS = 186270, HFMP = 941400, HOC = -8.0262E+08, LiqDen = {105,1.894,0.23603,191.05,0.21974,0}, VP = {101,39.98844,-1337.308,-3.580049,0.0000320698,2}, LiqCp = {16,61157,5034.1,-48.913,-0.22998,0.0022243}, HOV = {106,1.4418E+07,2.3055,-5.4199,5.658,-2.1286}, VapCp = {16,33151.9,-1220.001,12.0907,-0.000384791,9.896403E-08}, LiqVis = {101,-45.328,724.39,6.5917,-0.00010373,2}, VapVis = {102,5.3432E-07,0.58831,114.58,-1338.5,0}, LiqK = {16,0.011567,-46.041,0.10435,-0.012133,-0.0000051716}, VapK = {102,0.0000074705,1.4432,-57.569,587.82,0}, Racketparam = 0.2876, UniquacR = 1.1239, UniquacQ = 1.152, ChaoSeadAF = 0, ChaoSeadSP = 11618.44, ChaoSeadLV = 0.0378392);
  end Methane;
  
  model Methanol
  extends General_Properties(
    SN = 32, name = "Methanol", CAS = "67-56-1", Tc = 512.64, Pc = 8097000,  Vc = 0.118, Cc = 0.224, Tb = 337.69, Tm = 175.47, TT = 175.47, TP = 0.111264, MW = 32.042, LVB = 0.04073, AF = 0.565, SP = 29440, DM = 5.67E-30, SH = -74520000.0, IGHF = -2.0094E+08, GEF = -1.6232E+08, AS = 239880, HFMP = 3215000, HOC = -6.382E+08, LiqDen = {105,1.7918,0.23929,512.64,0.21078,0}, VP = {101,73.40342,-6548.076,-7.409987,5.72492E-06,2}, LiqCp = {16,62799,1254.2,-5.9906,0.052937,-0.00004711}, HOV = {106,5.8058E+07,0.87168,-0.81501,0.1695,0.17846}, VapCp = {16,36313.16,-680.4577,11.10203,0.000756766,-2.902645E-07}, LiqVis = {101,-32.996,1981.4,3.3666,-0.0000039246,2}, VapVis = {102,3.0654E-07,0.69658,204.87,24.304,0}, LiqK = {16,-0.056817,13.156,-1.2214,-0.00028282,-0.0000010129}, VapK = {102,7.8368E-07,1.7569,108.12,-21101,0}, Racketparam = 0, UniquacR = 1.43, UniquacQ = 1.43, ChaoSeadAF = 0.5589, ChaoSeadSP = 29546.4, ChaoSeadLV = 0.0407027);
  end Methanol;
  
  model Methylamine
  extends General_Properties(
    SN = 33, name = "Methylamine", CAS = "74-89-5", Tc = 430, Pc = 7420000,  Vc = 0.125, Cc = 0.259, Tb = 266.82, Tm = 179.69, TT = 179.69, TP = 176.712, MW = 31.057, LVB = 0.04734, AF = 0.284, SP = 21270, DM = 4.37E-30, SH = -22970000.0, IGHF = -2.297E+07, GEF = 3.207E+07, AS = 243300, HFMP = 6134000, HOC = -9.7508E+08, LiqDen = {105,1.39,0.21405,430.05,0.2275,0}, VP = {101,74.79969,-5067.174,-8.028002,7.988835E-06,2}, LiqCp = {16,90815,374.96,2.7431,0.031527,-0.000044978}, HOV = {106,4.6499E+07,1.6058,-3.2311,3.4082,-1.3345}, VapCp = {16,40540,-902.15,12.495,-0.00072761,0.0000002382}, LiqVis = {101,9.645,448.12,-3.737,0.000017508,2}, VapVis = {102,5.4475E-07,0.58715,230.63,-2982.2,0}, LiqK = {16,0.19876,9592,-137.2,0.62482,-0.00097954}, VapK = {102,-51.979,1.0721,-4.4966E+08,4.2697E+09,0}, Racketparam = 0, UniquacR = 1.5959, UniquacQ = 1.544, ChaoSeadAF = 0.281272, ChaoSeadSP = 23116, ChaoSeadLV = 0.0447131);
  end Methylamine;
  
  model Trichloroethylene
  extends General_Properties(
    SN = 34, name = "Trichloroethylene", CAS = "79-01-6", Tc = 571, Pc = 4910000,  Vc = 0.256, Cc = 0.265, Tb = 360.1, Tm = 188.4, TT = 188.4, TP = 1.97868, MW = 131.388, LVB = 0.0901371, AF = 0.21662, SP = 18800, DM = 2.57E-30, SH = -22970000.0, IGHF = -9620000, GEF = 1.606E+07, AS = 325090, HFMP = 0, HOC = -8.6411E+08, LiqDen = {105,1.0632,0.27217,571,0.2986,0}, VP = {101,46.56173,-5021.974,-3.675161,4.330407E-06,2}, LiqCp = {16,111110,1042.6,-3.1013,0.043029,-0.000040867}, HOV = {106,4.571591E+07,0.581727,-0.122707,-0.842037,0.831632}, VapCp = {16,56305,-500.68,11.893,-0.00053611,1.6998E-07}, LiqVis = {101,-16.947,1157.4,0.95533,0.0000012051,2}, VapVis = {102,1.5903E-07,0.76088,56.852,7589.2,0}, LiqK = {16,0.079767,522.46,-9.4979,0.032021,-0.00005769}, VapK = {102,0.00050539,0.6741,584.61,3177.4,0}, Racketparam = 0, UniquacR = 3.31, UniquacQ = 2.86, ChaoSeadAF = 0.2456, ChaoSeadSP = 18796.4, ChaoSeadLV = 0.0901371);
  end Trichloroethylene;
  
  model Dichloroacetylchloride
  extends General_Properties(
    SN = 35, name = "Dichloroacetylchloride", CAS = "79-36-7", Tc = 585, Pc = 4610000,  Vc = 0.283, Cc = 0.268, Tb = 380.45, Tm = 230, TT = 230, TP = 27.15, MW = 147.388, LVB = 0.0969971, AF = 0.308927, SP = 19510, DM = 5.27E-30, SH = -22970000.0, IGHF = -2.4033E+08, GEF = -1.915E+08, AS = 350000, HFMP = 0, HOC = -6.2647E+08, LiqDen = {105,0.94766,0.26857,585,0.28586,0}, VP = {101,74.72886,-6808.875,-7.735182,4.475716E-06,2}, LiqCp = {16,140380,-122.15,7.1438,0.0089927,-3.0698E-07}, HOV = {106,1.182114E+08,5.662305,-14.25375,15.19267,-6.032208}, VapCp = {16,54272,-346.01,11.744,-0.00014147,6.1056E-08}, LiqVis = {101,-11.762,1691.3,-0.020172,2.8483E-09,2}, VapVis = {102,1.4668E-07,0.7617,110.57,-0.0060267,0}, LiqK = {16,0.045516,-168.82,-0.6335,-0.0052944,0.0000014358}, VapK = {102,0.00049754,0.6638,622.43,-0.0085753,0}, Racketparam = 0, UniquacR = 3.597891, UniquacQ = 3.044, ChaoSeadAF = 0.370509, ChaoSeadSP = 19942.4, ChaoSeadLV = 0.097018);
  end Dichloroacetylchloride;
  
  model Trichloroacetaldehyde
  extends General_Properties(
    SN = 36, name = "Trichloroacetaldehyde", CAS = "75-87-6", Tc = 565, Pc = 4410000,  Vc = 0.288, Cc = 0.27, Tb = 370.85, Tm = 216, TT = 216, TP = 10.133, MW = 147.388, LVB = 0.0983111, AF = 0.332334, SP = 19150, DM = 6.54E-30, SH = -22970000.0, IGHF = -1.97E+08, GEF = -1.48E+08, AS = 348000, HFMP = 0, HOC = -6.72E+08, LiqDen = {105,0.92352,0.2658,565,0.27915,0}, VP = {101,104.1738,-7649.009,-12.42192,0.0000106892,2}, LiqCp = {16,141170,-5.956,6.555,0.014383,-0.000012896}, HOV = {106,6.2611E+07,1.7765,-3.981,4.442,-1.8138}, VapCp = {16,75534,-497.17,11.711,-0.00021306,5.7567E-08}, LiqVis = {101,-15.452,1500.4,0.62119,1.0267E-07,2}, VapVis = {102,1.9624E-07,0.76217,181.59,-7289.4,0}, LiqK = {16,-0.0058147,-49.103,-1.1431,-0.0024848,-2.7456E-08}, VapK = {102,0.00037396,0.73494,540.31,2896.6,0}, Racketparam = 0.261398, UniquacR = 3.638102, UniquacQ = 3.132, ChaoSeadAF = 0.332283, ChaoSeadSP = 19153.3, ChaoSeadLV = 0.0983111);
  end Trichloroacetaldehyde;
  
  model Acetylene
  extends General_Properties(
    SN = 37, name = "Acetylene", CAS = "74-86-2", Tc = 308.3, Pc = 6114000,  Vc = 0.1122, Cc = 0.268, Tb = 188.4, Tm = 192.4, TT = 192.4, TP = 127445, MW = 26.038, LVB = 0.04347, AF = 0.189, SP = 7921, DM = 0, SH = 228200000.0, IGHF = 2.282E+08, GEF = 2.1068E+08, AS = 200810, HFMP = 3770000, HOC = -1.257E+09, LiqDen = {105,2.8265,0.29316,308.3,0.31711,0}, VP = {101,82.22155,-3603.253,-10.0271,0.0000269397,2}, LiqCp = {16,79227,3177.2,-44.249,0.23814,-0.00030171}, HOV = {106,3.8817E+07,1.497,-1.0261,0.037348,-0.024401}, VapCp = {16,28271.69,-404.2493,11.05572,-0.000229636,1.424209E-07}, LiqVis = {101,-10.822,283.23,0.22007,-0.0000091126,2}, VapVis = {102,0.0000010997,0.50414,259.72,2787.3,0}, LiqK = {16,-0.060328,-110.3,0.44567,-0.0073832,0.0000024581}, VapK = {102,0.000078096,1.0286,-36.515,33144,0}, Racketparam = 0.2712, UniquacR = 1.52, UniquacQ = 1.39, ChaoSeadAF = 0.1841, ChaoSeadSP = 18813, ChaoSeadLV = 0.0421382);
  end Acetylene;
  
  model Dichloroacetaldehyde
  extends General_Properties(
    SN = 38, name = "Dichloroacetaldehyde", CAS = "79-02-7", Tc = 555, Pc = 4950000,  Vc = 0.239, Cc = 0.256, Tb = 362, Tm = 223, TT = 223, TP = 30.4712, MW = 112.943, LVB = 0.0800261, AF = 0.343679, SP = 21090, DM = 7.87E-30, SH = 228200000.0, IGHF = -1.8E+08, GEF = -1.387E+08, AS = 329000, HFMP = 1.4E+07, HOC = -8.11E+08, LiqDen = {105,1.0695,0.25535,555,0.28663,0}, VP = {101,90.61988,-7239.82,-10.19237,7.278159E-06,2}, LiqCp = {16,79819,-93.388,10.443,0.0030492,-0.0000015371}, HOV = {106,5.4311E+07,0.74287,-0.97767,1.092,-0.46681}, VapCp = {16,68025,-873.5,12.537,-0.00086712,2.2298E-07}, LiqVis = {101,-19.012,2548.4,0.73092,-0.0000016452,2}, VapVis = {102,3.0229E-07,0.67781,216.84,-7478.9,0}, LiqK = {16,-0.006509,-45.732,-1.1121,-0.0023494,-2.6574E-07}, VapK = {102,0.00042346,0.72759,609.27,10645,0}, Racketparam = 0.260402, UniquacR = 3.058668, UniquacQ = 2.632, ChaoSeadAF = 0.343679, ChaoSeadSP = 21250.9, ChaoSeadLV = 0.0788193);
  end Dichloroacetaldehyde;
  
  model Vinylchloride
  extends General_Properties(
    SN = 39, name = "Vinylchloride", CAS = "75-01-4", Tc = 432, Pc = 5670000,  Vc = 0.179, Cc = 0.283, Tb = 259.25, Tm = 119.36, TT = 119.36, TP = 0.0191781, MW = 62.4982, LVB = 0.0692236, AF = 0.100107, SP = 15960, DM = 4.84E-30, SH = 28450000.0, IGHF = 2.845E+07, GEF = 4.195E+07, AS = 273540, HFMP = 4744000, HOC = -1.178E+09, LiqDen = {105,1.4882,0.26866,432,0.2693,0}, VP = {101,30.50309,-3204.111,-1.15716,-3.151817E-06,2}, LiqCp = {16,29928,167.46,5.6386,0.023319,-0.000024747}, HOV = {106,2.6581E+07,-2.1189,8.303,-9.8551,4.0685}, VapCp = {16,39013,-667.91,11.935,-0.00030895,9.1245E-08}, LiqVis = {101,-3.586,386.19,-1.1014,-9.1164E-07,2}, VapVis = {102,4.1288E-07,0.63726,118.97,5390.5,0}, LiqK = {16,0.060341,155.36,-4.6785,0.015523,-0.000038165}, VapK = {102,-260.51,0.58623,-1.7838E+08,-1.6691E+09,0}, Racketparam = 0.281776, UniquacR = 1.9124, UniquacQ = 1.492, ChaoSeadAF = 0.100107, ChaoSeadSP = 17766.2, ChaoSeadLV = 0.0646597);
  end Vinylchloride;
  
  model Acetylchloride
  extends General_Properties(
    SN = 40, name = "Acetylchloride", CAS = "75-36-5", Tc = 508, Pc = 5740000,  Vc = 0.196, Cc = 0.266, Tb = 323.9, Tm = 160.3, TT = 160.3, TP = 0.0945737, MW = 78.4976, LVB = 0.0713449, AF = 0.334018, SP = 19730, DM = 9.07E-30, SH = 28450000.0, IGHF = -2.4351E+08, GEF = -2.058E+08, AS = 295000, HFMP = 2.75307E+08, HOC = -8.7599E+08, LiqDen = {105,1.4254,0.27938,508,0.26304,0}, VP = {101,99.17638,-7177.914,-11.22425,-0.0000057394,2}, LiqCp = {16,42690,1356.4,-2.0032,0.038796,-0.000032805}, HOV = {106,4.0E+07,0.3,0,0,0}, VapCp = {16,55490,-733.46,11.97,-0.00022853,6.1958E-08}, LiqVis = {101,4.4371,130.26,-2.2299,-8.5166E-07,2}, VapVis = {102,5.0377E-08,0.94052,79.768,-9041.6,0}, LiqK = {16,0.11965,1957.5,-32.911,0.1548,-0.00027429}, VapK = {102,-27944,0.34599,-4.878E+09,-7.8546E+10,0}, Racketparam = 0.26125, UniquacR = 2.438365, UniquacQ = 2.208, ChaoSeadAF = 0.334018, ChaoSeadSP = 20189.2, ChaoSeadLV = 0.0712327);
  end Acetylchloride;
  
  model OneOneTwotrichloroethane
  extends General_Properties(
    SN = 41, name = "OneOneTwotrichloroethane", CAS = "79-00-5", Tc = 602, Pc = 4480000,  Vc = 0.281, Cc = 0.252, Tb = 387, Tm = 236.5, TT = 236.5, TP = 44.7475, MW = 133.404, LVB = 0.0929898, AF = 0.259135, SP = 19890, DM = 4.17E-30, SH = 28450000.0, IGHF = -1.42E+08, GEF = -8.097E+07, AS = 337100, HFMP = 1.13E+07, HOC = -9.685E+08, LiqDen = {105,0.9055,0.25465,602,0.30987,0}, VP = {101,66.05096,-6428.165,-6.44717,3.27127E-06,2}, LiqCp = {16,121000,433.16,2.2235,0.034423,-0.000040901}, HOV = {106,5.0503E+07,0.64021,-1.1382,1.5379,-0.66031}, VapCp = {16,56506,-535.36,12.166,-0.00021958,4.8605E-08}, LiqVis = {101,-26.218,1571.3,2.5992,-0.0000081378,2}, VapVis = {102,2.8974E-07,0.68713,200.47,-854.38,0}, LiqK = {16,-0.027258,-78.724,-0.73941,-0.0030401,8.8565E-07}, VapK = {102,0.000095455,1.0427,1258.3,-2960.2,0}, Racketparam = 0.267821, UniquacR = 3.526, UniquacQ = 2.948, ChaoSeadAF = 0.259768, ChaoSeadSP = 19818.9, ChaoSeadLV = 0.0929898);
  end OneOneTwotrichloroethane;
  
  model Acetonitrile
  extends General_Properties(
    SN = 42, name = "Acetonitrile", CAS = "75-05-8", Tc = 545.5, Pc = 4830000,  Vc = 0.173, Cc = 0.184, Tb = 354.75, Tm = 229.32, TT = 229.32, TP = 186.945, MW = 41.0519, LVB = 0.0528577, AF = 0.337886, SP = 24050, DM = 1.31E-29, SH = 28450000.0, IGHF = 7.404E+07, GEF = 9.1868E+07, AS = 243290, HFMP = 8167000, HOC = -1.19043E+09, LiqDen = {105,1.3064,0.22597,545.5,0.28678,0}, VP = {101,63.90188,-5635.018,-6.338065,5.801644E-06,2}, LiqCp = {16,78687,635.92,1.7473,0.02389,-0.000017421}, HOV = {106,4.416703E+07,0.0989791,1.817987,-3.443548,1.854664}, VapCp = {16,41003,-679.99,11.578,0.00010104,-4.1014E-08}, LiqVis = {101,-31.531,1522.1,3.3306,-0.0000059061,2}, VapVis = {102,5.1905E-08,0.88581,38.325,87.034,0}, LiqK = {16,0.18265,8401.9,-103.1,0.40559,-0.00056286}, VapK = {102,4.7622E-08,2.1156,30.88,-14671,0}, Racketparam = 0.260911, UniquacR = 1.87, UniquacQ = 1.72, ChaoSeadAF = 0.338174, ChaoSeadSP = 24093.5, ChaoSeadLV = 0.0526772);
  end Acetonitrile;
  
  model Ethylene
  extends General_Properties(
    SN = 43, name = "Ethylene", CAS = "74-85-1", Tc = 282.34, Pc = 5041000,  Vc = 0.1311, Cc = 0.282, Tb = 169.42, Tm = 104, TT = 104, TP = 125.988, MW = 28.054, LVB = 0.05107, AF = 0.087, SP = 12440, DM = 0, SH = 52510000.0, IGHF = 5.251E+07, GEF = 6.844E+07, AS = 219200, HFMP = 3351000, HOC = -1.323E+09, LiqDen = {105,2.3782,0.29542,282.36,0.32456,0}, VP = {101,54.53229,-2458.42,-5.660037,0.0000194185,2}, LiqCp = {16,68016,-22414,286.75,-1.1802,0.0017304}, HOV = {106,2.1658E+07,1.2164,-2.1538,2.0768,-0.73096}, VapCp = {16,33071.93,-860.0281,12.22807,-0.000509703,1.628387E-07}, LiqVis = {101,-8.9556,288.21,-0.21985,-0.000010831,2}, VapVis = {102,0.0000021134,0.41436,359.51,-2291.7,0}, LiqK = {16,-0.19499,-11.178,-0.31182,-0.0034844,3.5873E-07}, VapK = {102,0.0000093247,1.4607,410.48,-44405,0}, Racketparam = 0.281, UniquacR = 1.57, UniquacQ = 1.49, ChaoSeadAF = 0.0949, ChaoSeadSP = 12436.64, ChaoSeadLV = 0.061);
  end Ethylene;
  
  model OneOnedichloroethane
  extends General_Properties(
    SN = 44, name = "OneOnedichloroethane", CAS = "75-34-3", Tc = 523, Pc = 5100000,  Vc = 0.236, Cc = 0.277, Tb = 330.45, Tm = 176.19, TT = 176.19, TP = 2.21455, MW = 98.959, LVB = 0.08473, AF = 0.244, SP = 18300, DM = 6.87E-30, SH = 52510000.0, IGHF = -1.2941E+08, GEF = -7.259E+07, AS = 305010, HFMP = 7870000, HOC = -1.1104E+09, LiqDen = {105,1.1057,0.26536,523,0.28703,0}, VP = {101,66.53401,-5492.415,-6.715993,5.298782E-06,2}, LiqCp = {16,115470,479.34,1.2009,0.029511,-0.000025794}, HOV = {106,4.458773E+07,0.555838,0.0209485,-0.722234,0.56963}, VapCp = {16,45661,-449.92,11.802,0.00015496,-5.3829E-08}, LiqVis = {101,-9.7803,891.16,-0.14866,-3.5884E-07,2}, VapVis = {102,0.0000001814,0.74706,93.461,1513.7,0}, LiqK = {16,0.011357,-64.086,-0.98127,-0.0039469,6.6106E-07}, VapK = {102,0.00013381,1.01,1042.5,-2442,0}, Racketparam = 0, UniquacR = 2.9617, UniquacQ = 2.532, ChaoSeadAF = 0.244612, ChaoSeadSP = 18299.2, ChaoSeadLV = 0.0847207);
  end OneOnedichloroethane;
  
  model OneTwodichloroethane
  extends General_Properties(
    SN = 45, name = "OneTwodichloroethane", CAS = "107-06-2", Tc = 561, Pc = 5400000,  Vc = 0.22, Cc = 0.255, Tb = 356.66, Tm = 237.49, TT = 237.49, TP = 237.127, MW = 98.959, LVB = 0.07945, AF = 0.286, SP = 20260, DM = 4.8E-30, SH = 52510000.0, IGHF = -1.2979E+08, GEF = -7.3945E+07, AS = 308280, HFMP = 8830000, HOC = -1.105E+09, LiqDen = {105,1.1942,0.27053,561.61,0.29157,0}, VP = {101,81.47902,-6503.169,-8.960273,7.32894E-06,2}, LiqCp = {16,92757,224.15,8.5223,0.0025656,0.000005106}, HOV = {106,5.072427E+07,0.517321,0.205828,-0.637156,0.265499}, VapCp = {16,62073,-758.84,12.345,-0.0004196,0.0000001146}, LiqVis = {101,25.747,-385.45,-5.5912,0.0000027937,2}, VapVis = {102,1.1983E-07,0.79504,20.791,14003,0}, LiqK = {16,0.015945,-110.67,-0.74013,-0.0032664,-5.0786E-07}, VapK = {102,0.00023592,0.93945,1368.6,23794,0}, Racketparam = 0, UniquacR = 2.88, UniquacQ = 2.52, ChaoSeadAF = 0.2876, ChaoSeadSP = 20249.5, ChaoSeadLV = 0.0794424);
  end OneTwodichloroethane;
  
  model Acetaldehyde
  extends General_Properties(
    SN = 46, name = "Acetaldehyde", CAS = "75-07-0", Tc = 466, Pc = 5550000,  Vc = 0.154, Cc = 0.221, Tb = 294, Tm = 150.15, TT = 150.15, TP = 0.323203, MW = 44.0526, LVB = 0.0568878, AF = 0.290734, SP = 20110, DM = 8.97E-30, SH = -166400000.0, IGHF = -1.664E+08, GEF = -1.333E+08, AS = 264200, HFMP = 3220000, HOC = -1.1045E+09, LiqDen = {105,1.2346,0.22392,466,0.25025,0}, VP = {101,132.6058,-7086.883,-17.42481,0.0000237457,2}, LiqCp = {16,72077,1068.4,-6.4275,0.06878,-0.000079154}, HOV = {106,1.4565E+07,-6.1925,18.559,-20.707,8.5605}, VapCp = {16,42578,-730.39,11.883,0.000033485,-3.0296E-08}, LiqVis = {101,-4.0316,623.05,-1.1589,8.4583E-07,2}, VapVis = {102,1.1933E-07,0.78879,65.293,1023.3,0}, LiqK = {16,0.014392,-40.45,-0.67323,-0.0036191,0.0000011083}, VapK = {102,3.2627E-07,1.8293,-23.073,3397.7,0}, Racketparam = 0, UniquacR = 1.9, UniquacQ = 1.8, ChaoSeadAF = 0.316685, ChaoSeadSP = 19818.5, ChaoSeadLV = 0.0564965);
  end Acetaldehyde;
  
  model Ethyleneoxide
  extends General_Properties(
    SN = 47, name = "Ethyleneoxide", CAS = "75-21-8", Tc = 469.15, Pc = 7190000,  Vc = 0.140296, Cc = 0.25876, Tb = 283.6, Tm = 160.65, TT = 160.65, TP = 7.78791, MW = 44.0526, LVB = 0.0508328, AF = 0.197447, SP = 21050, DM = 6.3E-30, SH = -52630000.0, IGHF = -5.263E+07, GEF = -1.323E+07, AS = 242990, HFMP = 5171400, HOC = -1.218E+09, LiqDen = {105,0.99773,0.19368,469.15,0.19965,0}, VP = {101,69.60869,-4890.744,-7.346771,8.198478E-06,2}, LiqCp = {16,81911,-50003,534.49,-1.8654,0.00223}, HOV = {106,5.9285E+07,3.2175,-7.404,7.8553,-3.1858}, VapCp = {16,31884.09,-715.0886,12.13937,-0.0000867837,-5.187264E-09}, LiqVis = {101,-8.5785,634.7,-0.32031,-8.1095E-08,2}, VapVis = {102,0.0000010777,0.52994,452.12,-16957,0}, LiqK = {16,-0.2748,8.1093,-0.70065,-0.00041054,-6.2588E-07}, VapK = {102,-0.00032904,1.1711,-7027.1,89001,0}, Racketparam = 0, UniquacR = 1.5927, UniquacQ = 1.32, ChaoSeadAF = 0.202, ChaoSeadSP = 21584, ChaoSeadLV = 0.0497046);
  end Ethyleneoxide;
  
  model Aceticacid
  extends General_Properties(
    SN = 48, name = "Aceticacid", CAS = "64-19-7", Tc = 594.45, Pc = 5790000,  Vc = 0.171, Cc = 0.2, Tb = 391.04, Tm = 289.81, TT = 289.81, TP = 1280, MW = 60.053, LVB = 0.05753, AF = 0.46, SP = 19060, DM = 5.8E-30, SH = -52630000.0, IGHF = -4.328E+08, GEF = -3.745E+08, AS = 282500, HFMP = 1.173E+07, HOC = -7.866E+08, LiqDen = {105,1.0627,0.22174,594.76,0.22566,0}, VP = {101,87.50607,-7603.906,-9.655308,7.168835E-06,2}, LiqCp = {16,49034,1051.1,0.77564,0.031667,-0.000028344}, HOV = {106,6.6203E+07,6.7121,-17.45,17.2,-6.0038}, VapCp = {16,40110,-588.24,12.017,0.00016249,-8.6918E-08}, LiqVis = {101,-58.528,2990.9,7.4911,-0.000011028,2}, VapVis = {102,4.3395E-09,1.24,-175.09,25013,0}, LiqK = {16,0.11159,-531.13,1.6359,-0.009369,-7.1996E-07}, VapK = {102,0.34137,-0.80579,-824.3,175840,0}, Racketparam = 0, UniquacR = 2.23, UniquacQ = 2.04, ChaoSeadAF = 0.4566, ChaoSeadSP = 18501.7, ChaoSeadLV = 0.0575804);
  end Aceticacid;
  
  model Methylformate
  extends General_Properties(
    SN = 49, name = "Methylformate", CAS = "107-31-3", Tc = 487.2, Pc = 6000000,  Vc = 0.172, Cc = 0.255, Tb = 304.9, Tm = 174.15, TT = 174.15, TP = 6.88085, MW = 60.053, LVB = 0.06214, AF = 0.253, SP = 20500, DM = 5.9E-30, SH = -52630000.0, IGHF = -3.524E+08, GEF = -2.95E+08, AS = 285200, HFMP = 7531000, HOC = -8.924E+08, LiqDen = {105,1.213,0.23619,487.2,0.24621,0}, VP = {101,70.6458,-5401.751,-7.334787,5.934343E-06,2}, LiqCp = {16,97064,3377.4,-42.373,0.22648,-0.00029763}, HOV = {106,7.0578E+07,3.7855,-9.0874,9.6043,-3.7868}, VapCp = {16,41319,-570.15,12.038,-0.000034216,-2.7109E-11}, LiqVis = {101,-9.949,1214.4,-0.53562,0.000010346,2}, VapVis = {102,0.0000069776,0.31537,1034.6,13.293,0}, LiqK = {16,0.0090363,23.594,-1.5627,0.00089283,-0.0000058101}, VapK = {102,-817050,-0.23016,2.5314E+08,-1.5205E+12,0}, Racketparam = 0, UniquacR = 2.1431, UniquacQ = 2.036, ChaoSeadAF = 0.257, ChaoSeadSP = 20503.4, ChaoSeadLV = 0.0620841);
  end Methylformate;
  
  model Ethylchloride
  extends General_Properties(
    SN = 50, name = "Ethylchloride", CAS = "75-00-3", Tc = 460.3, Pc = 5300000,  Vc = 0.199, Cc = 0.276, Tb = 285.42, Tm = 136.75, TT = 134.8, TP = 0.1249, MW = 64.514, LVB = 0.07258, AF = 0.194, SP = 17250, DM = 6.84E-30, SH = -112260000.0, IGHF = -1.1226E+08, GEF = -6.0499E+07, AS = 275780, HFMP = 4451800, HOC = -1.2849E+09, LiqDen = {105,1.3553,0.26895,460.36,0.24994,0}, VP = {101,51.28342,-4206.393,-4.478839,3.812824E-06,2}, LiqCp = {16,95946,-7247,67.469,-0.16696,0.00017795}, HOV = {106,3.61548E+07,0.981924,-2.026046,2.205811,-0.774155}, VapCp = {16,12765.96,-117.0948,11.04141,0.00111696,-3.565557E-07}, LiqVis = {101,-10.065,698.32,-0.097691,8.0018E-08,2}, VapVis = {102,3.2572E-07,0.66869,165.43,-2726.9,0}, LiqK = {16,0.062544,150.84,-4.3182,0.012599,-0.000031799}, VapK = {102,-19.83,0.20145,-728060,-2.7917E+08,0}, Racketparam = 0, UniquacR = 2.3665, UniquacQ = 2.112, ChaoSeadAF = 0.190636, ChaoSeadSP = 17772.6, ChaoSeadLV = 0.0708426);
  end Ethylchloride;
  
  model Ethane
  extends General_Properties(
    SN = 51, name = "Ethane", CAS = "74-84-0", Tc = 305.32, Pc = 4872000,  Vc = 0.1455, Cc = 0.279, Tb = 184.55, Tm = 90.352, TT = 90.352, TP = 1.13, MW = 30.07, LVB = 0.04615, AF = 0.099, SP = 12400, DM = 0, SH = -83820000.0, IGHF = -8.382E+07, GEF = -3.192E+07, AS = 229120, HFMP = 2859000, HOC = -1.42864E+09, LiqDen = {105,1.3749,0.23949,305.43,0.22875,0}, VP = {101,61.43744,-2814.319,-6.778053,0.0000210827,2}, LiqCp = {16,68726,-1953.6,31.772,-0.10571,0.00019673}, HOV = {106,2.3996E+07,1.4625,-2.8991,2.8421,-0.99532}, VapCp = {16,35666.22,-616.5198,11.69914,0.000444525,-1.541942E-07}, LiqVis = {101,-33.92204,743.404,4.302492,-0.0000364469,2}, VapVis = {102,5.2452E-07,0.58906,188.8,-2953.8,0}, LiqK = {16,-0.073876,-9.6787,-0.67405,-0.003407,-0.0000022023}, VapK = {102,0.000074549,1.168,506.4,-881.74,0}, Racketparam = 0.2793, UniquacR = 1.8022, UniquacQ = 1.696, ChaoSeadAF = 0.0908, ChaoSeadSP = 12375.2, ChaoSeadLV = 0.0551979);
  end Ethane;
  
  model Ethanol
  extends General_Properties(
    SN = 52, name = "Ethanol", CAS = "64-17-5", Tc = 513.92, Pc = 6148000,  Vc = 0.167, Cc = 0.24, Tb = 351.8, Tm = 159.05, TT = 159.05, TP = 0.000495642, MW = 46.069, LVB = 0.05868, AF = 0.649, SP = 26140, DM = 5.64E-30, SH = -83820000.0, IGHF = -2.3495E+08, GEF = -1.6785E+08, AS = 280640, HFMP = 4931000, HOC = -1.235E+09, LiqDen = {105,1.3539,0.24957,515.66,0.22099,0}, VP = {101,88.0754,-7652.06,-9.471507,5.928087E-06,2}, LiqCp = {16,76684,675.72,-0.093875,0.037153,-0.000031214}, HOV = {106,6.3899E+07,1.2782,-2.673,2.7973,-1.0209}, VapCp = {16,44530,-660.89,12.153,0.000019532,-1.5636E-08}, LiqVis = {101,8.061,774.76,-3.0701,-4.3408E-09,2}, VapVis = {102,1.2467E-07,0.7862,76.034,-2017.3,0}, LiqK = {16,0.10247,-120.39,-0.48487,-0.0071706,0.000003461}, VapK = {102,-0.01001,0.64925,-7360.5,-255250,0}, Racketparam = 0, UniquacR = 2.11, UniquacQ = 1.97, ChaoSeadAF = 0.634, ChaoSeadSP = 26133.3, ChaoSeadLV = 0.0586177);
  end Ethanol;
  
  model Dimethylether
  extends General_Properties(
    SN = 53, name = "Dimethylether", CAS = "115-10-6", Tc = 400.1, Pc = 5400000,  Vc = 0.17, Cc = 0.276, Tb = 248.31, Tm = 131.66, TT = 131.65, TP = 3.04959, MW = 46.069, LVB = 0.06907, AF = 0.191, SP = 15120, DM = 4.34E-30, SH = -184100000.0, IGHF = -1.841E+08, GEF = -1.128E+08, AS = 266700, HFMP = 4937000, HOC = -1.3284E+09, LiqDen = {105,1.4889,0.26123,400.1,0.27948,0}, VP = {101,50.32175,-3631.453,-4.444735,5.290757E-06,2}, LiqCp = {16,97754,353.35,-1.896,0.040999,-0.000017816}, HOV = {106,3.8521E+07,2.2845,-5.7518,6.5695,-2.6976}, VapCp = {16,37573.94,-346.059,11.12596,0.00118434,-4.086847E-07}, LiqVis = {101,-10.661,449.83,0.0072727,-3.6906E-08,2}, VapVis = {102,0.0000027281,0.3952,534.12,2319,0}, LiqK = {16,-0.15344,-11.847,-0.56462,-0.0022104,5.6048E-07}, VapK = {102,0.059968,0.26671,1018.3,1098900,0}, Racketparam = 0, UniquacR = 2.0461, UniquacQ = 1.936, ChaoSeadAF = 0.2, ChaoSeadSP = 15212.1, ChaoSeadLV = 0.0703107);
  end Dimethylether;
  
  model Ethyleneglycol
  extends General_Properties(
    SN = 54, name = "Ethyleneglycol", CAS = "107-21-1", Tc = 719, Pc = 8200000,  Vc = 0.191, Cc = 0.262, Tb = 470.45, Tm = 260.15, TT = 260.15, TP = 0.21922, MW = 62.0678, LVB = 0.055908, AF = 0.506776, SP = 33840, DM = 8.04E-30, SH = -184100000.0, IGHF = -3.922E+08, GEF = -3.018E+08, AS = 304891, HFMP = 9958000, HOC = -1.0527E+09, LiqDen = {105,1.3106,0.25084,720,0.21838,0}, VP = {101,68.11797,-9617.267,-5.83171,-1.13705E-06,2}, LiqCp = {16,86990,-72.326,9.7466,0.0065456,-0.0000047}, HOV = {106,7.414E+07,0.16807,-0.19694,1.0417,-0.61488}, VapCp = {16,52948,-604.61,12.115,0.00010607,-4.9352E-08}, LiqVis = {101,-309.38,14928,45.49,-0.000044405,2}, VapVis = {102,1.2284E-07,0.79557,132.87,-5540.3,0}, LiqK = {16,0.1684,-313.75,-1.072,-0.000058054,-0.0000032443}, VapK = {102,-8962900,-0.31257,2.5313E+09,-1.2955E+13,0}, Racketparam = 0, UniquacR = 2.41, UniquacQ = 2.25, ChaoSeadAF = 0.48683, ChaoSeadSP = 33703.3, ChaoSeadLV = 0.0559089);
  end Ethyleneglycol;
  
  model Dimethylsulfide
  extends General_Properties(
    SN = 55, name = "Dimethylsulfide", CAS = "75-18-3", Tc = 503, Pc = 5530000,  Vc = 0.201, Cc = 0.266, Tb = 310.48, Tm = 174.88, TT = 174.88, TP = 7.86415, MW = 62.136, LVB = 0.07377, AF = 0.19, SP = 18530, DM = 5.0E-30, SH = -184100000.0, IGHF = -3.724E+07, GEF = 7302000, AS = 285850, HFMP = 7984700, HOC = -1.7443E+09, LiqDen = {105,1.1867,0.25844,503.06,0.24773,0}, VP = {101,14.07567,-3435.088,1.598135,-0.0000069451,2}, LiqCp = {16,112410,-20036,201.07,-0.63397,0.0007177}, HOV = {106,5.490637E+07,1.721854,-2.161256,0.932609,-0.0179494}, VapCp = {16,56893,-682.39,12.01,0.00013748,-5.7442E-08}, LiqVis = {101,-15.044,992.97,0.60378,0.0000010306,2}, VapVis = {102,4.8631E-07,0.62748,355.22,-11800,0}, LiqK = {16,0.10006,-155.98,-0.57159,-0.0045066,-0.0000087305}, VapK = {102,0.00026184,0.91507,780.75,-32167,0}, Racketparam = 0.273888, UniquacR = 2.5141, UniquacQ = 2.216, ChaoSeadAF = 0.189279, ChaoSeadSP = 18513.3, ChaoSeadLV = 0.0730914);
  end Dimethylsulfide;
  
  model Ethylmercaptan
  extends General_Properties(
    SN = 56, name = "Ethylmercaptan", CAS = "75-08-1", Tc = 499, Pc = 5490000,  Vc = 0.207, Cc = 0.274, Tb = 308.15, Tm = 125.26, TT = 125.26, TP = 0.00113837, MW = 62.136, LVB = 0.07458, AF = 0.189, SP = 18250, DM = 5.27E-30, SH = -184100000.0, IGHF = -4.63E+07, GEF = -4814000, AS = 296100, HFMP = 4975000, HOC = -1.7366E+09, LiqDen = {105,1.203,0.25909,499.16,0.26567,0}, VP = {101,65.4773,-5020.82,-6.678317,6.449817E-06,2}, LiqCp = {16,112430,-35384,348.44,-1.1065,0.0012231}, HOV = {106,4.1777E+07,0.6898,-0.36317,-0.097723,0.16958}, VapCp = {16,39403.72,-328.0582,11.29594,0.000950986,-3.249647E-07}, LiqVis = {101,-10.854,753.55,0.040849,-7.5884E-07,2}, VapVis = {102,0.0000001695,0.75553,151.56,-5377.8,0}, LiqK = {16,-0.021257,2.7237,-1.42,-0.0008779,-0.0000018277}, VapK = {102,0.0014607,0.7033,1243.2,53588,0}, Racketparam = 0, UniquacR = 2.551747, UniquacQ = 2.3, ChaoSeadAF = 0.192074, ChaoSeadSP = 18270.4, ChaoSeadLV = 0.0746133);
  end Ethylmercaptan;
  
  model Ethylamine
  extends General_Properties(
    SN = 57, name = "Ethylamine", CAS = "75-04-7", Tc = 456.4, Pc = 5630000,  Vc = 0.1818, Cc = 0.267, Tb = 289.75, Tm = 192.15, TT = 192.15, TP = 151.827, MW = 45.084, LVB = 0.06659, AF = 0.276, SP = 19100, DM = 4.07E-30, SH = -47150000.0, IGHF = -4.715E+07, GEF = 3.616E+07, AS = 284800, HFMP = 9350000, HOC = -1.5874E+09, LiqDen = {105,1.3663,0.25297,456.4,0.27948,0}, VP = {101,115.5255,-6764.221,-14.43912,0.0000155603,2}, LiqCp = {16,129790,-12366,-31.003,0.53709,-0.00091494}, HOV = {106,4.2765E+07,0.58718,-0.33502,0.17251,-0.0015134}, VapCp = {16,55762,-832.71,12.632,-0.00036845,1.1147E-07}, LiqVis = {101,-41.853,1619.5,5.3649,-0.000030563,2}, VapVis = {102,5.0871E-07,0.59417,255.23,-186.42,0}, LiqK = {16,0.17744,585.82,-11.165,0.043182,-0.000095024}, VapK = {102,0.40679,0.005162,1280.6,1721800,0}, Racketparam = 0, UniquacR = 2.2703, UniquacQ = 2.084, ChaoSeadAF = 0.285061, ChaoSeadSP = 19493.4, ChaoSeadLV = 0.0656335);
  end Ethylamine;
  
  model Acrylonitrile
  extends General_Properties(
    SN = 58, name = "Acrylonitrile", CAS = "107-13-1", Tc = 535, Pc = 4480000,  Vc = 0.212, Cc = 0.214, Tb = 350.5, Tm = 189.63, TT = 189.63, TP = 3.68289, MW = 53.0626, LVB = 0.0662367, AF = 0.349801, SP = 21560, DM = 1.29E-29, SH = -47150000.0, IGHF = 1.837E+08, GEF = 1.937E+08, AS = 275300, HFMP = 6230000, HOC = -1.69E+09, LiqDen = {105,1.0816,0.2293,535,0.28939,0}, VP = {101,74.54771,-6259.727,-7.785577,4.08032E-06,2}, LiqCp = {16,83847,240.59,6.8887,0.0095277,-0.0000046046}, HOV = {106,5.224752E+07,0.877802,-0.432396,-0.672186,0.607598}, VapCp = {16,42651,-533.04,11.728,0.00013096,-6.2176E-08}, LiqVis = {101,-0.5429,318.29,-1.481,-8.3759E-07,2}, VapVis = {102,4.616E-08,0.90278,67.424,-1672.6,0}, LiqK = {16,-0.15669,19.22,-1.0721,0.00025871,-0.0000022582}, VapK = {102,0.0012317,1.2472,60863,-1968600,0}, Racketparam = 0.259865, UniquacR = 2.31, UniquacQ = 2.05, ChaoSeadAF = 0.349801, ChaoSeadSP = 21555.4, ChaoSeadLV = 0.0662367);
  end Acrylonitrile;
  
  model Methylacetylene
  extends General_Properties(
    SN = 59, name = "Methylacetylene", CAS = "74-99-7", Tc = 402.4, Pc = 5630000,  Vc = 0.1635, Cc = 0.275, Tb = 250.12, Tm = 170.45, TT = 170.45, TP = 414.934, MW = 40.065, LVB = 0.06231, AF = 0.214, SP = 15870, DM = 2.61E-30, SH = 184900000.0, IGHF = 1.849E+08, GEF = 1.9384E+08, AS = 248360, HFMP = 5350000, HOC = -1.8487E+09, LiqDen = {105,1.5983,0.26361,402.4,0.27835,0}, VP = {101,68.97649,-4285.953,-7.418705,0.000010515,2}, LiqCp = {16,85291,38.538,6.7428,0.016885,-0.000022161}, HOV = {106,3.4954E+07,0.52948,0.26449,-0.89434,0.5174}, VapCp = {16,34169.26,-350.7621,11.18743,0.000684714,-2.185041E-07}, LiqVis = {101,-0.91891,242.44,-1.5439,5.0147E-07,2}, VapVis = {102,0.0000010586,0.48791,277.58,3995.6,0}, LiqK = {16,0.065025,-121.87,-0.025752,-0.0097723,0.0000047452}, VapK = {102,0.00029245,0.88088,248.57,78809,0}, Racketparam = 0.2703, UniquacR = 2.1931, UniquacQ = 1.936, ChaoSeadAF = 0.2176, ChaoSeadSP = 18393.2, ChaoSeadLV = 0.0596157);
  end Methylacetylene;
  
  model Propadiene
  extends General_Properties(
    SN = 60, name = "Propadiene", CAS = "463-49-0", Tc = 394, Pc = 5250000,  Vc = 0.1739, Cc = 0.279, Tb = 238.77, Tm = 136.87, TT = 136.87, TP = 18.2497, MW = 40.065, LVB = 0.06095, AF = 0.122, SP = 14010, DM = 0, SH = 190500000.0, IGHF = 1.905E+08, GEF = 2.008E+08, AS = 243900, HFMP = 4400000, HOC = -1.8563E+09, LiqDen = {105,0.86549,0.19732,394,0.21029,0}, VP = {101,59.80183,-3745.303,-6.036523,8.205156E-06,2}, LiqCp = {16,78665,-12422,151.08,-0.53356,0.00065986}, HOV = {106,1.54657E+07,-3.722436,11.45729,-12.9266,5.522823}, VapCp = {16,34671.52,-447.4983,11.46556,0.000444481,-1.470826E-07}, LiqVis = {101,-9.5153,310.76,-0.034725,-0.0000021543,2}, VapVis = {102,6.3119E-07,0.52792,129.92,8459.5,0}, LiqK = {16,0.06063,169.42,-4.6941,0.014436,-0.000036249}, VapK = {102,0.000059663,1.0782,9.0271,65666,0}, Racketparam = 0, UniquacR = 1.7917, UniquacQ = 1.528, ChaoSeadAF = 0.3125, ChaoSeadSP = 17551, ChaoSeadLV = 0.0604292);
  end Propadiene;
  
  model Propylene
  extends General_Properties(
    SN = 61, name = "Propylene", CAS = "115-07-1", Tc = 364.85, Pc = 4600000,  Vc = 0.185, Cc = 0.281, Tb = 225.45, Tm = 87.9, TT = 87.89, TP = 0.00117, MW = 42.0797, LVB = 0.0832412, AF = 0.137588, SP = 11890, DM = 1.22E-30, SH = 20230000.0, IGHF = 2.023E+07, GEF = 6.264E+07, AS = 267000, HFMP = 2936000, HOC = -1.9262E+09, LiqDen = {105,0.98129,0.22226,365.58,0.24039,0}, VP = {101,55.10362,-3330.452,-5.40588,0.0000093641,2}, LiqCp = {16,79790,300.8,5.1342,0.0095615,0.000012777}, HOV = {106,2.7525E+07,0.61217,-0.41646,0.083772,0.12092}, VapCp = {16,38965.36,-516.3838,11.75322,0.000509119,-1.771348E-07}, LiqVis = {101,-54.05485,1437.773,7.536247,-0.0000342733,2}, VapVis = {102,7.3873E-07,0.54213,262.33,-108.51,0}, LiqK = {16,-0.044587,22.061,-1.744,0.0015214,-0.0000078162}, VapK = {102,0.000045373,1.2,415.83,2757.2,0}, Racketparam = 0.2785, UniquacR = 2.25, UniquacQ = 2.02, ChaoSeadAF = 0.1477, ChaoSeadSP = 13152.4, ChaoSeadLV = 0.068956);
  end Propylene;
  
  model Acetone
  extends General_Properties(
    SN = 62, name = "Acetone", CAS = "67-64-1", Tc = 508.1, Pc = 4700000,  Vc = 0.209, Cc = 0.233, Tb = 329.22, Tm = 178.45, TT = 178.45, TP = 2.78509, MW = 58.08, LVB = 0.07394, AF = 0.307, SP = 19730, DM = 9.61E-30, SH = 20230000.0, IGHF = -2.157E+08, GEF = -1.513E+08, AS = 295400, HFMP = 5774000, HOC = -1.659E+09, LiqDen = {105,1.1051,0.24556,508.21,0.27409,0}, VP = {101,72.77713,-5752.936,-7.680083,6.83076E-06,2}, LiqCp = {16,107130,725.57,0.95296,0.025981,-0.00001439}, HOV = {106,6.6943E+07,3.4736,-8.9271,10.062,-4.1656}, VapCp = {16,52915,-669.27,12.201,0.00012839,-5.8844E-08}, LiqVis = {101,-14.064,1000.7,0.45349,3.9456E-07,2}, VapVis = {102,3.1012E-08,0.97616,23.042,14.834,0}, LiqK = {16,0.01013,-95.32,-0.21151,-0.0052616,0.0000023043}, VapK = {102,-26.882,0.9036,-1.2095E+08,-6.0879E+08,0}, Racketparam = 0, UniquacR = 2.5735, UniquacQ = 2.336, ChaoSeadAF = 0.3099, ChaoSeadSP = 19729.7, ChaoSeadLV = 0.0738386);
  end Acetone;
  
  model Ethylformate
  extends General_Properties(
    SN = 63, name = "Ethylformate", CAS = "109-94-4", Tc = 508.5, Pc = 4740000,  Vc = 0.229, Cc = 0.257, Tb = 327.47, Tm = 193.55, TT = 193.55, TP = 18.1186, MW = 74.079, LVB = 0.08093, AF = 0.282, SP = 19070, DM = 6.44E-30, SH = 20230000.0, IGHF = -3.883E+08, GEF = -3.031E+08, AS = 328200, HFMP = 9204800, HOC = -1.50696E+09, LiqDen = {105,0.85568,0.22882,508.5,0.23792,0}, VP = {101,69.04518,-5678.642,-7.031396,0.0000050057,2}, LiqCp = {16,115910,228.3,4.0783,0.027366,-0.000029781}, HOV = {106,5.9813E+07,2.1931,-4.6587,4.7089,-1.7696}, VapCp = {16,52378,-459.08,11.875,0.00065506,-2.4832E-07}, LiqVis = {101,-8.9483,848.56,-0.31567,2.8582E-07,2}, VapVis = {102,6.0691E-07,0.60378,450.04,-20466,0}, LiqK = {16,-0.030927,19.999,-1.4911,-0.000052048,-0.0000024111}, VapK = {102,381.39,0.9159,1.8E+09,-1.1462E+10,0}, Racketparam = 0, UniquacR = 2.8175, UniquacQ = 2.576, ChaoSeadAF = 0.285, ChaoSeadSP = 18938.7, ChaoSeadLV = 0.0808277);
  end Ethylformate;
  
  model Methylacetate
  extends General_Properties(
    SN = 64, name = "Methylacetate", CAS = "79-20-9", Tc = 506.8, Pc = 4690000,  Vc = 0.228, Cc = 0.254, Tb = 330.09, Tm = 175.15, TT = 175.15, TP = 1.01703, MW = 74.079, LVB = 0.07989, AF = 0.323, SP = 19350, DM = 5.6E-30, SH = 20230000.0, IGHF = -4.119E+08, GEF = -3.242E+08, AS = 319800, HFMP = 7970000, HOC = -1.461E+09, LiqDen = {105,0.98331,0.2428,506.86,0.2549,0}, VP = {101,83.01817,-6288.581,-9.185862,7.595367E-06,2}, LiqCp = {16,6314.4,680.3,4.1767,0.026148,-0.000027341}, HOV = {106,4.9929E+07,0.79197,-0.73136,0.37429,-0.019974}, VapCp = {16,62235,-685.05,12.348,0.00012363,-8.5641E-08}, LiqVis = {101,11.12,-100.13,-3.2745,-5.3051E-07,2}, VapVis = {102,0.0000013226,0.48849,504.21,4.2341,0}, LiqK = {16,-0.28416,27.186,-0.94457,0.00083974,-0.0000024412}, VapK = {102,-23257,-0.1738,1.0287E+07,-6.9243E+10,0}, Racketparam = 0, UniquacR = 2.8, UniquacQ = 2.58, ChaoSeadAF = 0.326, ChaoSeadSP = 19435.1, ChaoSeadLV = 0.0798903);
  end Methylacetate;
  
  model Propionicacid
  extends General_Properties(
    SN = 65, name = "Propionicacid", CAS = "79-09-4", Tc = 604, Pc = 4530000,  Vc = 0.233, Cc = 0.207, Tb = 414.31, Tm = 252.45, TT = 252.45, TP = 13.1, MW = 74.079, LVB = 0.07497, AF = 0.544, SP = 19490, DM = 5.84E-30, SH = 20230000.0, IGHF = -4.535E+08, GEF = -3.568E+08, AS = 294900, HFMP = 1.066E+07, HOC = -1.395E+09, LiqDen = {105,0.88103,0.22848,612.66,0.25898,0}, VP = {101,58.42,-7261.2,-4.9024,0.0000010406,2}, LiqCp = {16,120710,704.7,1.1886,0.028883,-0.000020278}, HOV = {106,4.8878E+07,3.7167,-10.822,11.498,-4.1176}, VapCp = {16,47961,-474.81,12.167,0.00020648,-6.6213E-08}, LiqVis = {101,-53.41646,2724.985,6.7143,-9.670276E-06,2}, VapVis = {102,1.6155E-08,1.0459,-115.32,27680,0}, LiqK = {16,0.067757,-235.87,-0.022659,-0.0065033,0.0000026666}, VapK = {102,0.004145,0.70902,13255,-4962900,0}, Racketparam = 0, UniquacR = 2.9, UniquacQ = 2.58, ChaoSeadAF = 0.52, ChaoSeadSP = 19130.1, ChaoSeadLV = 0.0749523);
  end Propionicacid;
  
  model Nndimethylformamide
  extends General_Properties(
    SN = 66, name = "Nndimethylformamide", CAS = "68-12-2", Tc = 649.6, Pc = 4420000,  Vc = 0.26199, Cc = 0.214, Tb = 425.15, Tm = 212.72, TT = 212.72, TP = 0.195325, MW = 73.0938, LVB = 0.0773903, AF = 0.31771, SP = 23960, DM = 1.27E-29, SH = 20230000.0, IGHF = -1.917E+08, GEF = -8.84E+07, AS = 326000, HFMP = 1.615E+07, HOC = -1.78871E+09, LiqDen = {105,0.65216,0.20032,649.6,0.24418,0}, VP = {101,68.99879,-7311.388,-6.749791,3.063845E-06,2}, LiqCp = {16,141440,162.91,4.0696,0.019381,-0.000013063}, HOV = {106,5.7496E+07,0.2466,0.21619,-0.11587,0.026126}, VapCp = {16,68728,-846.07,13.139,-0.00064688,1.6133E-07}, LiqVis = {101,-9.089031,826.091,-0.0843389,-3.479212E-06,2}, VapVis = {102,0.0000034602,0.37991,1156.9,8715.8,0}, LiqK = {16,0.14084,-2496,20.244,-0.064914,0.000049356}, VapK = {102,0.015205,0.35461,594.92,741220,0}, Racketparam = 0, UniquacR = 3.0856, UniquacQ = 2.736, ChaoSeadAF = 0.375516, ChaoSeadSP = 23964.9, ChaoSeadLV = 0.0773743);
  end Nndimethylformamide;
  
  model Propane
  extends General_Properties(
    SN = 67, name = "Propane", CAS = "74-98-6", Tc = 369.83, Pc = 4248000,  Vc = 0.2, Cc = 0.276, Tb = 231.02, Tm = 85.47, TT = 85.47, TP = 0.0001685, MW = 44.097, LVB = 0.07487, AF = 0.152, SP = 13100, DM = 0, SH = -104680000.0, IGHF = -1.0468E+08, GEF = -2.439E+07, AS = 270200, HFMP = 3524000, HOC = -2.04311E+09, LiqDen = {105,1.3186,0.27005,369.86,0.27852,0}, VP = {101,55.2725,-3396.946,-5.423393,8.953731E-06,2}, LiqCp = {16,87486,-13371,156.92,-0.5459,0.00068504}, HOV = {106,3.0459E+07,1.2001,-2.1107,1.9732,-0.65316}, VapCp = {16,37840.4,-445.5789,11.83871,0.000653764,-2.200137E-07}, LiqVis = {101,-35.23159,966.1472,4.395026,-0.0000255079,2}, VapVis = {102,4.7422E-08,0.90416,-4.7484,478.57,0}, LiqK = {16,0.02937,-16.323,-1.3313,-0.0012596,-0.000011206}, VapK = {102,-1.139,0.10904,-9898.6,-7669600,0}, Racketparam = 0.2763, UniquacR = 2.4766, UniquacQ = 2.236, ChaoSeadAF = 0.1538, ChaoSeadSP = 13091.2, ChaoSeadLV = 0.084);
  end Propane;
  
  model Isopropanol
  extends General_Properties(
    SN = 68, name = "Isopropanol", CAS = "67-63-0", Tc = 508.3, Pc = 4762000,  Vc = 0.22, Cc = 0.248, Tb = 355.39, Tm = 185.28, TT = 185.28, TP = 0.0363946, MW = 60.096, LVB = 0.07692, AF = 0.665, SP = 23420, DM = 5.54E-30, SH = -104680000.0, IGHF = -2.727E+08, GEF = -1.7347E+08, AS = 309200, HFMP = 5410000, HOC = -1.83E+09, LiqDen = {105,1.1898,0.26648,508.3,0.23986,0}, VP = {101,77.70856,-7630.115,-7.63517,9.965114E-07,2}, LiqCp = {16,-188260,277.99,9.4459,0.010702,-0.0000091964}, HOV = {106,1.100995E+08,4.1961,-10.70959,11.69444,-4.625499}, VapCp = {16,52738,-555.28,12.347,0.000094247,-4.5945E-08}, LiqVis = {101,-7.4407,2259.7,-1.1149,0.0000002963,2}, VapVis = {102,1.9931E-07,0.72329,178.01,-15.318,0}, LiqK = {16,-0.15761,49.41,-1.6579,0.0019566,-0.0000034939}, VapK = {102,0.0028843,0.91609,11082,-222500,0}, Racketparam = 0.2493, UniquacR = 2.78, UniquacQ = 2.51, ChaoSeadAF = 0.7238, ChaoSeadSP = 23408.3, ChaoSeadLV = 0.0768988);
  end Isopropanol;
  
  model Onepropanol
  extends General_Properties(
    SN = 69, name = "Onepropanol", CAS = "71-23-8", Tc = 536.78, Pc = 5175000,  Vc = 0.219, Cc = 0.254, Tb = 370.93, Tm = 146.95, TT = 146.95, TP = 3.69121E-07, MW = 60.096, LVB = 0.07514, AF = 0.629, SP = 24450, DM = 5.6E-30, SH = -104680000.0, IGHF = -2.552E+08, GEF = -1.599E+08, AS = 322470, HFMP = 5372000, HOC = -1.84381E+09, LiqDen = {105,1.1537,0.26188,536.78,0.23549,0}, VP = {101,141.3971,-10434.27,-17.45829,0.0000113246,2}, LiqCp = {16,100520,125.3,4.7194,0.024513,-0.000019669}, HOV = {106,8.36461E+07,3.338812,-9.831137,11.8901,-4.905709}, VapCp = {16,56681,-627.22,12.379,0.00012228,-5.0293E-08}, LiqVis = {101,-98.08798,4904.749,13.57131,-0.0000219968,2}, VapVis = {102,7.9322E-07,0.54936,416.77,-100.81,0}, LiqK = {16,0.076645,-189.91,-0.13475,-0.0069283,0.0000033645}, VapK = {102,-453.4,0.64532,-2.843E+08,-2.8865E+10,0}, Racketparam = 0.2451, UniquacR = 2.78, UniquacQ = 2.51, ChaoSeadAF = 0.623, ChaoSeadSP = 24557.3, ChaoSeadLV = 0.0749393);
  end Onepropanol;
  
  model Trimethylamine
  extends General_Properties(
    SN = 70, name = "Trimethylamine", CAS = "75-50-3", Tc = 433.3, Pc = 4075000,  Vc = 0.254, Cc = 0.266, Tb = 276.02, Tm = 156.08, TT = 156.08, TP = 9.92058, MW = 59.111, LVB = 0.09428, AF = 0.206243, SP = 14360, DM = 2.04E-30, SH = -24310000.0, IGHF = -2.431E+07, GEF = 9.899E+07, AS = 287000, HFMP = 6544000, HOC = -2.2449E+09, LiqDen = {105,0.67928,0.21649,433.3,0.20925,0}, VP = {101,110.254,-5770.536,-14.1719,0.0000238614,2}, LiqCp = {16,112140,1253.3,-12.905,0.10424,-0.00013798}, HOV = {106,4.743116E+07,0.966273,0.752593,-2.762744,1.513109}, VapCp = {16,65203,-794.87,12.953,-0.00031634,6.4426E-08}, LiqVis = {101,9.9961,-126.46,-3.1956,-6.7828E-08,2}, VapVis = {102,0.000001161,0.48519,364.43,10928,0}, LiqK = {16,-0.0043132,-14.875,-1.2529,-0.0019969,-0.0000017575}, VapK = {102,0.00027205,0.90104,140.75,139110,0}, Racketparam = 0, UniquacR = 2.99, UniquacQ = 2.64, ChaoSeadAF = 0.205, ChaoSeadSP = 15311.1, ChaoSeadLV = 0.0902163);
  end Trimethylamine;
  
  model Vinylacetylene
  extends General_Properties(
    SN = 71, name = "Vinylacetylene", CAS = "689-97-4", Tc = 454, Pc = 4860000,  Vc = 0.205, Cc = 0.264, Tb = 278.25, Tm = 0, TT = 0, TP = 0, MW = 52.0746, LVB = 0.0769826, AF = 0.106852, SP = 16360, DM = 1.3E-30, SH = 304600000.0, IGHF = 3.046E+08, GEF = 3.06E+08, AS = 279400, HFMP = 0, HOC = -2.362E+09, LiqDen = {105,1.2594,0.25931,454,0.29553,0}, VP = {101,79.0442,-5001.865,-8.984128,0.0000129415,2}, LiqCp = {16,68382,-63.514,9.912,0.0031404,-1.0307E-07}, HOV = {106,3.313507E+07,-0.0105563,0.71867,-0.291074,0.0215152}, VapCp = {16,49981,-581.7,12.052,-0.00010825,3.173E-08}, LiqVis = {101,-2.2453,320.68,-1.2895,-5.6512E-09,2}, VapVis = {102,6.7484E-07,0.5304,230.17,-0.0024795,0}, LiqK = {16,-0.05887,-27.718,-0.92317,-0.0023581,1.5773E-07}, VapK = {102,0.000054197,1.0632,-70.589,90617,0}, Racketparam = 0.281184, UniquacR = 3.526, UniquacQ = 2.94, ChaoSeadAF = 0.11815, ChaoSeadSP = 17035, ChaoSeadLV = 0.0740148);
  end Vinylacetylene;
  
  model Thiophene
  extends General_Properties(
    SN = 72, name = "Thiophene", CAS = "110-02-1", Tc = 580, Pc = 5660000,  Vc = 0.219, Cc = 0.252, Tb = 357.31, Tm = 234.94, TT = 234.94, TP = 185.638, MW = 84.142, LVB = 0.07947, AF = 0.186, SP = 20120, DM = 1.8E-30, SH = 304600000.0, IGHF = 1.1544E+08, GEF = 1.267E+08, AS = 278400, HFMP = 5085600, HOC = -2.4352E+09, LiqDen = {105,0.73395,0.21494,580,0.2288,0}, VP = {101,88.26733,-6809.188,-9.975872,0.0000074967,2}, LiqCp = {16,84631,-77.085,9.4174,0.0060386,-0.0000042543}, HOV = {106,4.87E+07,0.35468,0.57965,-0.92941,0.39593}, VapCp = {16,31580,-546.03,12.548,-0.00032144,9.6227E-08}, LiqVis = {101,-15.561,1306.6,0.66009,3.2071E-07,2}, VapVis = {102,0.0000010722,0.54275,557.27,2874.5,0}, LiqK = {16,0.024119,-20.319,-1.5338,-0.0014869,-6.6677E-07}, VapK = {102,0.00013168,0.98328,649.4,-5290.1,0}, Racketparam = 0.274238, UniquacR = 2.8569, UniquacQ = 2.14, ChaoSeadAF = 0.192846, ChaoSeadSP = 20219.8, ChaoSeadLV = 0.0794773);
  end Thiophene;
  
  model Methacrylonitrile
  extends General_Properties(
    SN = 73, name = "Methacrylonitrile", CAS = "126-98-7", Tc = 554, Pc = 3880000,  Vc = 0.265, Cc = 0.223, Tb = 363.45, Tm = 237.35, TT = 237.35, TP = 268.868, MW = 67.0892, LVB = 0.0844058, AF = 0.301271, SP = 19090, DM = 1.23E-29, SH = 304600000.0, IGHF = 9.803E+07, GEF = 1.64E+08, AS = 223800, HFMP = 0, HOC = -2.243E+09, LiqDen = {105,0.89537,0.23729,554,0.29629,0}, VP = {101,56.07917,-5342.951,-5.152858,4.011012E-06,2}, LiqCp = {16,125060,169.88,6.1441,0.015707,-0.000014502}, HOV = {106,4.4103E+07,0.56334,-0.51577,0.31852,-0.072403}, VapCp = {16,68640,-664.02,12.252,0.000039427,-4.9098E-08}, LiqVis = {101,-14.973,1174.5,0.57272,-0.0000017357,2}, VapVis = {102,3.3003E-07,0.64938,329.57,-240,0}, LiqK = {16,0.095479,1984.5,-23.334,0.076497,-0.000098215}, VapK = {102,0.0010085,1.2282,49915,0.89214,0}, Racketparam = 0, UniquacR = 2.987475, UniquacQ = 2.712, ChaoSeadAF = 0.301271, ChaoSeadSP = 19094, ChaoSeadLV = 0.0844058);
  end Methacrylonitrile;
  
  model Dimethylacetylene
  extends General_Properties(
    SN = 74, name = "Dimethylacetylene", CAS = "503-17-3", Tc = 473.2, Pc = 4870000,  Vc = 0.221, Cc = 0.274, Tb = 300.13, Tm = 240.91, TT = 240.91, TP = 6121.21, MW = 54.0904, LVB = 0.0788997, AF = 0.238542, SP = 17480, DM = 1.32E-29, SH = 304600000.0, IGHF = 1.457E+08, GEF = 1.849E+08, AS = 283300, HFMP = 9234000, HOC = -2.4189E+09, LiqDen = {105,1.1717,0.25895,473.2,0.27289,0}, VP = {101,66.56107,-4998.053,-6.834282,6.682052E-06,2}, LiqCp = {16,116500,35.116,5.8634,0.0049877,0.000013087}, HOV = {106,4761730,-11.5565,30.6629,-31.89366,12.67797}, VapCp = {16,62226,-826.04,12.513,-0.0002013,4.9424E-08}, LiqVis = {101,-0.045622,305.04,-1.6582,-4.749E-08,2}, VapVis = {102,0.0000021802,0.39407,508.41,3758,0}, LiqK = {16,0.0074431,-154.13,-0.25098,-0.0046292,-7.3662E-08}, VapK = {102,0.00021497,0.91998,214.54,130500,0}, Racketparam = 0, UniquacR = 2.8635, UniquacQ = 2.48, ChaoSeadAF = 0.1301, ChaoSeadSP = 17463.7, ChaoSeadLV = 0.0789036);
  end Dimethylacetylene;
  
  model Ethylacetylene
  extends General_Properties(
    SN = 75, name = "Ethylacetylene", CAS = "107-00-6", Tc = 440, Pc = 4600000,  Vc = 0.208, Cc = 0.262, Tb = 281.21, Tm = 147.429, TT = 147.43, TP = 1.17966, MW = 54.092, LVB = 0.08322, AF = 0.245, SP = 15950, DM = 2.7E-30, SH = 165200000.0, IGHF = 1.652E+08, GEF = 2.0225E+08, AS = 290390, HFMP = 6029270, HOC = -2.4647E+09, LiqDen = {105,1.3447,0.27928,440,0.29778,0}, VP = {101,76.044,-5031.59,-8.40406,9.681824E-06,2}, LiqCp = {16,109820,1148.7,-9.607,0.084548,-0.00010384}, HOV = {106,3.604722E+07,0.546439,-0.26185,0,0}, VapCp = {16,44709,-441.89,11.889,0.00039371,-1.2645E-07}, LiqVis = {101,-4.3451,354.46,-0.92921,-0.0000006027,2}, VapVis = {102,0.0000027867,0.37696,663.32,30.832,0}, LiqK = {16,-0.032845,13.956,-1.5811,-0.00025138,-0.0000029965}, VapK = {102,0.000036868,1.1429,-57.854,83816,0}, Racketparam = 0, UniquacR = 2.8675, UniquacQ = 2.476, ChaoSeadAF = 0.246864, ChaoSeadSP = 16554, ChaoSeadLV = 0.0809511);
  end Ethylacetylene;
  
  model OneTwobutadiene
  extends General_Properties(
    SN = 76, name = "OneTwobutadiene", CAS = "590-19-2", Tc = 452, Pc = 4360000,  Vc = 0.22, Cc = 0.255, Tb = 284, Tm = 136.95, TT = 136.95, TP = 0.4472, MW = 54.0904, LVB = 0.0838169, AF = 0.165877, SP = 15650, DM = 1.34E-30, SH = 162300000.0, IGHF = 1.623E+08, GEF = 1.986E+08, AS = 293000, HFMP = 6962000, HOC = -2.4617E+09, LiqDen = {105,0.86492,0.22148,452,0.28373,0}, VP = {101,53.27585,-4559.624,-4.46417,-6.771964E-06,2}, LiqCp = {16,109750,-2425.1,12.655,0.059068,-0.00014415}, HOV = {106,3.715905E+07,0.824251,0.000387028,-2.253417,2.024613}, VapCp = {16,39504.04,-354.1475,11.62099,0.00074321,-2.513775E-07}, LiqVis = {101,-9.9134,468.65,-0.069814,2.8031E-07,2}, VapVis = {102,6.4328E-07,0.52378,170.73,9690.7,0}, LiqK = {16,-0.29344,3.1314,-0.70701,-0.00052702,-3.6665E-07}, VapK = {102,0.000085434,1.0359,127.53,78342,0}, Racketparam = 0, UniquacR = 2.466, UniquacQ = 2.024, ChaoSeadAF = 0.3394, ChaoSeadSP = 16360.6, ChaoSeadLV = 0.0816506);
  end OneTwobutadiene;
  
  model OneThreebutadiene
  extends General_Properties(
    SN = 77, name = "OneThreebutadiene", CAS = "106-99-0", Tc = 425, Pc = 4320000,  Vc = 0.221, Cc = 0.27, Tb = 268.62, Tm = 164.25, TT = 164.25, TP = 69.1989, MW = 54.092, LVB = 0.08804, AF = 0.195, SP = 14460, DM = 0, SH = 109240000.0, IGHF = 1.0924E+08, GEF = 1.4972E+08, AS = 278890, HFMP = 7984000, HOC = -2.409E+09, LiqDen = {105,1.3314,0.28213,425,0.30137,0}, VP = {101,64.81816,-4314.788,-6.766483,8.589719E-06,2}, LiqCp = {16,88166,583.44,1.8231,0.030118,-0.000025695}, HOV = {106,3.4211E+07,0.45981,0.016247,-0.15407,0.054476}, VapCp = {16,38238.49,-511.235,12.39338,-0.000121482,4.39211E-08}, LiqVis = {101,12.653,-139.12,-3.6735,-0.0000014093,2}, VapVis = {102,3.4426E-07,0.6407,174.17,-2393.4,0}, LiqK = {16,-0.096853,19.016,-1.4201,0.00020099,-0.0000029536}, VapK = {102,-18588,0.94195,-7.31E+10,-9.6975E+11,0}, Racketparam = 0.2713, UniquacR = 2.6908, UniquacQ = 2.352, ChaoSeadAF = 0.2028, ChaoSeadSP = 14195.77, ChaoSeadLV = 0.088);
  end OneThreebutadiene;
  
  model Onebutene
  extends General_Properties(
    SN = 78, name = "Onebutene", CAS = "106-98-9", Tc = 419.5, Pc = 4020000,  Vc = 0.2408, Cc = 0.278, Tb = 266.92, Tm = 87.8, TT = 87.8, TP = 0.000000694, MW = 56.108, LVB = 0.09534, AF = 0.194, SP = 13630, DM = 1.13E-30, SH = -500000.0, IGHF = -500000, GEF = 7.041E+07, AS = 307400, HFMP = 3848000, HOC = -2.5408E+09, LiqDen = {105,0.98,0.25169,419.54,0.26645,0}, VP = {101,41.66588,-3605.004,-2.983562,6.665773E-07,2}, LiqCp = {16,100270,86.345,7.7333,0.00096546,0.000020281}, HOV = {106,3.5338E+07,0.68186,-0.28099,-0.25369,0.26017}, VapCp = {16,53529,-619.26,12.431,0.000096632,-3.9013E-08}, LiqVis = {101,-10.764,591.51,-0.0017307,2.5723E-08,2}, VapVis = {102,7.0347E-07,0.54535,308.83,-232.73,0}, LiqK = {16,0.071267,99.471,-4.2011,0.014325,-0.000041157}, VapK = {102,0.000092115,1.1181,717.19,13037,0}, Racketparam = 0.2736, UniquacR = 2.92, UniquacQ = 2.56, ChaoSeadAF = 0.2085, ChaoSeadSP = 13827.58, ChaoSeadLV = 0.0953);
  end Onebutene;
  
  model CisTwobutene
  extends General_Properties(
    SN = 79, name = "CisTwobutene", CAS = "590-18-1", Tc = 435.5, Pc = 4210000,  Vc = 0.2338, Cc = 0.269, Tb = 276.87, Tm = 134.26, TT = 134.26, TP = 0.272, MW = 56.108, LVB = 0.09101, AF = 0.203, SP = 14720, DM = 1.0E-30, SH = -7400000.0, IGHF = -7400000, GEF = 6.536E+07, AS = 301200, HFMP = 7309400, HOC = -2.5339E+09, LiqDen = {105,1.1591,0.27085,435.5,0.28116,0}, VP = {101,82.92441,-5022.628,-9.652369,0.0000133961,2}, LiqCp = {16,79532,110.96,9.7654,-0.0036798,0.000019578}, HOV = {106,3.4358E+07,0.38004,0,0,0}, VapCp = {16,53149,-719.47,12.619,-0.000047815,4.5198E-10}, LiqVis = {101,-17.96838,892.0637,1.159883,-2.883463E-06,2}, VapVis = {102,4.0697E-08,0.91942,-12.143,1343.2,0}, LiqK = {16,-0.032373,19.125,-1.716,0.00030408,-0.0000042934}, VapK = {102,0.000075196,1.0578,-53.701,131760,0}, Racketparam = 0.2705, UniquacR = 2.9189, UniquacQ = 2.563, ChaoSeadAF = 0.2575, ChaoSeadSP = 13827.58, ChaoSeadLV = 0.0912);
  end CisTwobutene;
  
  model TransTwobutene
  extends General_Properties(
    SN = 80, name = "TransTwobutene", CAS = "624-64-6", Tc = 428.6, Pc = 4100000,  Vc = 0.2377, Cc = 0.276, Tb = 274.03, Tm = 167.62, TT = 167.62, TP = 74.5, MW = 56.108, LVB = 0.09365, AF = 0.218, SP = 14210, DM = 0, SH = -11000000.0, IGHF = -1.1E+07, GEF = 6.32E+07, AS = 296500, HFMP = 9757500, HOC = -2.53E+09, LiqDen = {105,1.1523,0.27235,428.6,0.28543,0}, VP = {101,56.602,-4026.7,-5.5178,0.0000079176,2}, LiqCp = {16,98730,549.96,0.83133,0.038607,-0.000044392}, HOV = {106,3.3476E+07,0.31355,0.41478,-0.75555,0.40695}, VapCp = {16,60006,-649.72,12.368,0.00014661,-5.1566E-08}, LiqVis = {101,-16.05639,833.2986,0.849646,-2.292227E-06,2}, VapVis = {102,0.0000010493,0.48674,358.01,137.53,0}, LiqK = {16,0.060004,368.81,-7.3737,0.025078,-0.000049526}, VapK = {102,0.000078563,1.0565,14.753,105810,0}, Racketparam = 0.2721, UniquacR = 2.9189, UniquacQ = 2.563, ChaoSeadAF = 0.2138, ChaoSeadSP = 14207.7, ChaoSeadLV = 0.0893483);
  end TransTwobutene;
  
  model Isobutene
  extends General_Properties(
    SN = 81, name = "Isobutene", CAS = "115-11-7", Tc = 417.9, Pc = 4000000,  Vc = 0.2388, Cc = 0.275, Tb = 266.24, Tm = 132.81, TT = 132.81, TP = 0.644929, MW = 56.108, LVB = 0.09524, AF = 0.2, SP = 13660, DM = 1.67E-30, SH = -17100000.0, IGHF = -1.71E+07, GEF = 5.808E+07, AS = 293090, HFMP = 5931200, HOC = -2.5242E+09, LiqDen = {105,1.01,0.25611,417.9,0.2642,0}, VP = {101,47.13879,-3682.162,-3.952514,4.044185E-06,2}, LiqCp = {16,95317,-68.58,9.3268,0.0023434,0.0000076824}, HOV = {106,3.916E+07,1.1638,-1.4033,0.81203,-0.13521}, VapCp = {16,49784,-472.84,12.012,0.00052863,-1.7772E-07}, LiqVis = {101,-12.717,644.93,0.3696,-0.0000023983,2}, VapVis = {102,0.0000028839,0.33897,365.04,17752,0}, LiqK = {16,0.061493,33.335,-2.4686,0.0041425,-0.000023609}, VapK = {102,-418.21,0.91306,-1.5105E+09,3.1789E+10,0}, Racketparam = 0.2727, UniquacR = 2.9195, UniquacQ = 2.684, ChaoSeadAF = 0.1951, ChaoSeadSP = 13659.3, ChaoSeadLV = 0.0953727);
  end Isobutene;
  
  model Twomethylpropanal
  extends General_Properties(
    SN = 82, name = "Twomethylpropanal", CAS = "78-84-2", Tc = 507, Pc = 4100000,  Vc = 0.263, Cc = 0.256, Tb = 337.25, Tm = 208.15, TT = 208.15, TP = 34.8247, MW = 72.1057, LVB = 0.0920264, AF = 0.36218, SP = 18450, DM = 9.0E-30, SH = -17100000.0, IGHF = -2.158E+08, GEF = -1.214E+08, AS = 331200, HFMP = 1.2E+07, HOC = -2.2913E+09, LiqDen = {105,0.97266,0.25698,507,0.28571,0}, VP = {101,102.1731,-7116.016,-12.16592,0.0000111612,2}, LiqCp = {16,143330,110.87,5.2999,0.018869,-0.000016131}, HOV = {106,4.95108E+07,0.263532,1.209662,-2.271572,1.223299}, VapCp = {16,68500,-741.45,12.977,-0.00061649,3.0243E-07}, LiqVis = {101,-10.535,970.52,-0.049339,1.1673E-08,2}, VapVis = {102,1.9586E-07,0.71384,159.71,-212.67,0}, LiqK = {16,0.10024,-223.61,-0.25771,-0.00474,-0.000011884}, VapK = {102,-2151.4,-0.21039,974960,-5.0943E+09,0}, Racketparam = 0, UniquacR = 3.2471, UniquacQ = 2.872, ChaoSeadAF = 0.37009, ChaoSeadSP = 18234.6, ChaoSeadLV = 0.0920137);
  end Twomethylpropanal;
  
  model Methylethylketone
  extends General_Properties(
    SN = 83, name = "Methylethylketone", CAS = "78-93-3", Tc = 536.8, Pc = 4210000,  Vc = 0.267, Cc = 0.252, Tb = 352.71, Tm = 186.48, TT = 186.48, TP = 1.3904, MW = 72.107, LVB = 0.09013, AF = 0.322, SP = 18880, DM = 9.21E-30, SH = -17100000.0, IGHF = -2.39E+08, GEF = -1.47E+08, AS = 339400, HFMP = 8385000, HOC = -2.268E+09, LiqDen = {105,0.16518,0.10716,536.8,0.15066,0}, VP = {101,84.00012,-6498.964,-9.389584,8.32043E-06,2}, LiqCp = {16,137210,245.98,6.3249,0.009404,3.3143E-07}, HOV = {106,4.7221E+07,0.30759,0.48591,-0.8645,0.45018}, VapCp = {16,69404,-545.04,12.139,0.00045578,-1.6351E-07}, LiqVis = {101,-0.60519,503.02,-1.5659,5.5782E-08,2}, VapVis = {102,2.8817E-08,0.96765,-28.58,7703,0}, LiqK = {16,-0.17871,4.3086,-1.0343,0.00010801,-0.0000015411}, VapK = {102,-4970700,-0.23106,2.2577E+09,-1.0834E+13,0}, Racketparam = 0, UniquacR = 3.25, UniquacQ = 2.88, ChaoSeadAF = 0.3241, ChaoSeadSP = 18878.7, ChaoSeadLV = 0.0901936);
  end Methylethylketone;
  
  model Tetrahydrofuran
  extends General_Properties(
    SN = 84, name = "Tetrahydrofuran", CAS = "109-99-9", Tc = 540.2, Pc = 5190000,  Vc = 0.224, Cc = 0.259, Tb = 339.12, Tm = 164.65, TT = 164.65, TP = 0.195542, MW = 72.107, LVB = 0.08171, AF = 0.225, SP = 18970, DM = 5.44E-30, SH = -17100000.0, IGHF = -1.8418E+08, GEF = -7.969E+07, AS = 297290, HFMP = 8540000, HOC = -2.325E+09, LiqDen = {105,1.054,0.25754,540.2,0.26776,0}, VP = {101,82.74347,-6236.553,-9.221137,0.0000078089,2}, LiqCp = {16,83351,774.14,0.38273,0.036255,-0.00003559}, HOV = {106,4.770629E+07,0.8303,-0.617577,-0.253996,0.501899}, VapCp = {16,41616,-744.85,13.048,-0.00029616,7.4486E-08}, LiqVis = {101,-10.047,896.61,-0.11864,2.5625E-07,2}, VapVis = {102,3.3286E-07,0.67758,342.35,-15667,0}, LiqK = {16,-0.22085,9.5971,-0.99496,-0.00017415,-6.4958E-07}, VapK = {102,0.000010439,1.4482,729.36,-9829.3,0}, Racketparam = 0.259, UniquacR = 2.94, UniquacQ = 2.4, ChaoSeadAF = 0.225, ChaoSeadSP = 19042.3, ChaoSeadLV = 0.0819417);
  end Tetrahydrofuran;
  
  model OneFourdioxane
  extends General_Properties(
    SN = 85, name = "OneFourdioxane", CAS = "123-91-1", Tc = 587, Pc = 5170000,  Vc = 0.238, Cc = 0.255, Tb = 374.5, Tm = 284.95, TT = 284.95, TP = 2532.46, MW = 88.106, LVB = 0.08529, AF = 0.279262, SP = 20540, DM = 0, SH = -17100000.0, IGHF = -3.158E+08, GEF = -1.816E+08, AS = 300120, HFMP = 1.284E+07, HOC = -2.1863E+09, LiqDen = {105,1.0039,0.25926,587,0.28278,0}, VP = {101,50.11504,-5577.21,-4.046854,2.080567E-06,2}, LiqCp = {16,151550,-65314,519.35,-1.3402,0.0011989}, HOV = {106,2.1367E+08,9.1812,-22.992,23.854,-9.34}, VapCp = {16,46250,-613.41,12.822,0.000004782,-2.2238E-08}, LiqVis = {101,-79.28,4198.4,10.393,-0.0000085568,2}, VapVis = {102,2.7334E-07,0.7393,129.93,-0.0004206,0}, LiqK = {16,0.089834,46.421,-1.1898,-0.0037338,-0.0000061358}, VapK = {102,2.3873E-07,1.8505,-94.575,7804.2,0}, Racketparam = 0.254, UniquacR = 3.07, UniquacQ = 2.28, ChaoSeadAF = 0.280373, ChaoSeadSP = 20163.3, ChaoSeadLV = 0.0856635);
  end OneFourdioxane;
  
  model Nbutyricacid
  extends General_Properties(
    SN = 86, name = "Nbutyricacid", CAS = "107-92-6", Tc = 624, Pc = 4030000,  Vc = 0.292, Cc = 0.227, Tb = 436.87, Tm = 267.95, TT = 267.95, TP = 10.3, MW = 88.106, LVB = 0.09246, AF = 0.72, SP = 20180, DM = 5.5E-30, SH = -17100000.0, IGHF = -4.758E+08, GEF = -3.6E+08, AS = 360100, HFMP = 1.159E+07, HOC = -2.008E+09, LiqDen = {105,0.702,0.22902,628.16,0.24275,0}, VP = {101,54.31047,-7692.649,-4.148708,2.624319E-07,2}, LiqCp = {16,135560,664.7,1.9592,0.027685,-0.000020111}, HOV = {106,5.1387E+07,1.1517,-2.7656,2.6617,-0.66983}, VapCp = {16,75565,-613.25,12.671,-0.000058773,-2.4845E-08}, LiqVis = {101,14.241,534.99,-4.0411,0.0000053437,2}, VapVis = {102,2.2745E-08,1.0055,13.097,182.58,0}, LiqK = {16,-0.043955,57.698,-1.8847,0.00050649,-0.0000013441}, VapK = {102,0.00010747,1.3444,19634,-7296600,0}, Racketparam = 0, UniquacR = 3.5512, UniquacQ = 3.152, ChaoSeadAF = 0.683, ChaoSeadSP = 20262.7, ChaoSeadLV = 0.0924567);
  end Nbutyricacid;
  
  model Ethylacetate
  extends General_Properties(
    SN = 87, name = "Ethylacetate", CAS = "141-78-6", Tc = 523.2, Pc = 3830000,  Vc = 0.286, Cc = 0.252, Tb = 350.21, Tm = 189.6, TT = 189.6, TP = 1.43179, MW = 88.106, LVB = 0.09855, AF = 0.361, SP = 18350, DM = 5.94E-30, SH = -17100000.0, IGHF = -4.445E+08, GEF = -3.28E+08, AS = 359700, HFMP = 1.048E+07, HOC = -2.061E+09, LiqDen = {105,0.78926,0.24295,523.26,0.25762,0}, VP = {101,93.16862,-7073.291,-10.65983,8.16528E-06,2}, LiqCp = {16,129430,961.92,-0.12694,0.034745,-0.000031346}, HOV = {106,4.9527E+07,0.37029,0.072685,-0.077493,0.017381}, VapCp = {16,97183,-1121.4,13.827,-0.0012343,3.6158E-07}, LiqVis = {101,16.428,-219.29,-4.124,6.0568E-07,2}, VapVis = {102,0.0000034514,0.35236,732.29,-3982.4,0}, LiqK = {16,0.040771,-127.25,-0.26995,-0.0055753,9.9363E-07}, VapK = {102,2.3264E-07,1.902,102.58,-17015,0}, Racketparam = 0, UniquacR = 3.48, UniquacQ = 3.12, ChaoSeadAF = 0.362, ChaoSeadSP = 18345.6, ChaoSeadLV = 0.0985939);
  end Ethylacetate;
  
  model Methylpropionate
  extends General_Properties(
    SN = 88, name = "Methylpropionate", CAS = "554-12-1", Tc = 530.6, Pc = 4000000,  Vc = 0.282, Cc = 0.256, Tb = 352.6, Tm = 185.65, TT = 185.65, TP = 0.634091, MW = 88.106, LVB = 0.09693, AF = 0.349, SP = 18630, DM = 5.681E-30, SH = -17100000.0, IGHF = -4.275E+08, GEF = -3.11E+08, AS = 359600, HFMP = 1.01E+07, HOC = -2.078E+09, LiqDen = {105,0.72945,0.23284,530.6,0.24422,0}, VP = {101,91.97365,-7071.987,-10.4626,7.767427E-06,2}, LiqCp = {16,140380,1173.7,0.81056,0.020863,-0.000005642}, HOV = {106,7.6303E+07,2.9196,-6.5593,6.8235,-2.6926}, VapCp = {16,11365,-258.45,12.315,0.00033508,-7.4281E-08}, LiqVis = {101,-8.2868,807.93,-0.36444,-0.0000010038,2}, VapVis = {102,3.2912E-07,0.63237,126.55,15669,0}, LiqK = {16,0.034599,27.577,-2.1207,0.00098891,-0.0000051703}, VapK = {102,-197.62,-0.13413,101740,-8.2156E+08,0}, Racketparam = 0, UniquacR = 3.4786, UniquacQ = 3.116, ChaoSeadAF = 0.391, ChaoSeadSP = 18626.5, ChaoSeadLV = 0.0969396);
  end Methylpropionate;
  
  model Npropylformate
  extends General_Properties(
    SN = 89, name = "Npropylformate", CAS = "110-74-7", Tc = 538, Pc = 4060000,  Vc = 0.285, Cc = 0.259, Tb = 354.69, Tm = 180.25, TT = 180.25, TP = 0.211011, MW = 88.106, LVB = 0.09794, AF = 0.32, SP = 18470, DM = 6.37E-30, SH = -17100000.0, IGHF = -4.076E+08, GEF = -2.936E+08, AS = 367800, HFMP = 1.32E+07, HOC = -2.041E+09, LiqDen = {105,0.915,0.26134,538,0.28,0}, VP = {101,71.35267,-6244.56,-7.280094,4.220422E-06,2}, LiqCp = {16,76453,-41.853,10.797,0.0021776,0.0000016375}, HOV = {106,5.414398E+07,0.597341,-0.589234,1.004533,-0.602007}, VapCp = {16,48655,-455.54,12.53,0.000075917,-4.246E-09}, LiqVis = {101,-51.649,2317.7,6.5556,-0.000012396,2}, VapVis = {102,6.0899E-07,0.58607,368.57,-171.06,0}, LiqK = {16,0.017242,-22.474,-1.4478,-0.0011278,-0.0000020716}, VapK = {102,661.08,0.99232,5.8449E+09,-9.0597E+10,0}, Racketparam = 0, UniquacR = 3.4919, UniquacQ = 3.116, ChaoSeadAF = 0.314, ChaoSeadSP = 18339.9, ChaoSeadLV = 0.0979424);
  end Npropylformate;
  
  model Sulfolane
  extends General_Properties(
    SN = 90, name = "Sulfolane", CAS = "126-33-0", Tc = 855, Pc = 7290000,  Vc = 0.3365, Cc = 0.345074, Tb = 560.45, Tm = 300.55, TT = 300.55, TP = 0.704459, MW = 120.17, LVB = 0.0952677, AF = 0.5234, SP = 26110, DM = 1.56E-29, SH = -17100000.0, IGHF = -3.727E+08, GEF = -2.431E+08, AS = 347500, HFMP = 1373000, HOC = -2.397E+09, LiqDen = {105,0.89997,0.26972,853,0.30746,0}, VP = {101,112.0995,-12237.47,-12.64533,4.157394E-06,2}, LiqCp = {16,122690,-336.31,11.614,0.0017011,-5.0866E-07}, HOV = {106,1.605659E+08,3.828131,-7.67047,6.739132,-2.353929}, VapCp = {16,92921,-999.97,13.757,-0.00093192,0.0000002258}, LiqVis = {101,-56.251,4046.1,6.7894,-0.0000052803,2}, VapVis = {102,2.9074E-08,0.97453,81.209,-9361.1,0}, LiqK = {16,0.079581,-84.501,-1.1134,-0.0025206,2.9748E-07}, VapK = {102,0.000077821,1.0313,528.38,54551,0}, Racketparam = 0.257009, UniquacR = 4.0357, UniquacQ = 3.2, ChaoSeadAF = 0.377998, ChaoSeadSP = 26335.8, ChaoSeadLV = 0.0952677);
  end Sulfolane;
  
  model Nndimethylacetamide
  extends General_Properties(
    SN = 91, name = "Nndimethylacetamide", CAS = "127-19-5", Tc = 658, Pc = 4030000,  Vc = 0.321, Cc = 0.236, Tb = 439.25, Tm = 253.15, TT = 253.15, TP = 7.64072, MW = 87.1204, LVB = 0.0930285, AF = 0.363509, SP = 22350, DM = 1.27088E-29, SH = -17100000.0, IGHF = -2.25E+08, GEF = -8.85E+07, AS = 351000, HFMP = 1.04182E+07, HOC = -2.38E+09, LiqDen = {105,0.72553,0.2328,658,0.27034,0}, VP = {101,67.333,-7592.9,-6.3978,0.0000021543,2}, LiqCp = {16,175450,252.77,11.249,-0.052983,0.00011812}, HOV = {106,5.8939E+07,0.34564,-0.28415,0.52832,-0.2171}, VapCp = {16,41899,-423.52,12.444,0.00039958,-1.2339E-07}, LiqVis = {101,16.727,-219.71,-4.0135,-0.0000013942,2}, VapVis = {102,3.4592E-07,0.64442,412.29,-8784,0}, LiqK = {16,0.06447,-206.75,-0.7204,0.00031649,-0.000010441}, VapK = {102,0.0011762,0.72055,943.06,275760,0}, Racketparam = 0.258662, UniquacR = 3.760053, UniquacQ = 3.276, ChaoSeadAF = 0.363509, ChaoSeadSP = 22352.7, ChaoSeadLV = 0.0930285);
  end Nndimethylacetamide;
  
  model Nbutane
  extends General_Properties(
    SN = 92, name = "Nbutane", CAS = "106-97-8", Tc = 425.12, Pc = 3796000,  Vc = 0.255, Cc = 0.274, Tb = 272.66, Tm = 134.86, TT = 134.86, TP = 0.67358, MW = 58.123, LVB = 0.10048, AF = 0.199, SP = 13510, DM = 0, SH = -125790000.0, IGHF = -1.2579E+08, GEF = -1.67E+07, AS = 309910, HFMP = 4661000, HOC = -2.65732E+09, LiqDen = {105,1.0023,0.26457,425.17,0.27138,0}, VP = {101,68.5773,-4444.916,-7.395837,9.857432E-06,2}, LiqCp = {16,115150,-3564.7,41.067,-0.098803,0.0001183}, HOV = {106,3.6258E+07,0.83741,-0.83676,0.41526,-0.007606}, VapCp = {16,44749.95,-338.1412,11.81452,0.00097744,-3.359129E-07}, LiqVis = {101,-46.56549,1439.945,6.168131,-0.000023917,2}, VapVis = {102,2.7078E-08,0.97147,-51.16,6431,0}, LiqK = {16,0.00024966,-43.155,-0.78129,-0.0043776,-4.136E-08}, VapK = {102,0.042635,0.45147,4234,1756600,0}, Racketparam = 0.2728, UniquacR = 3.151, UniquacQ = 2.776, ChaoSeadAF = 0.1953, ChaoSeadSP = 13766.21, ChaoSeadLV = 0.1014);
  end Nbutane;
  
  model Isobutane
  extends General_Properties(
    SN = 93, name = "Isobutane", CAS = "75-28-5", Tc = 407.85, Pc = 3640000,  Vc = 0.2627, Cc = 0.278, Tb = 261.34, Tm = 113.54, TT = 113.54, TP = 0.0120622, MW = 58.123, LVB = 0.10436, AF = 0.186, SP = 12560, DM = 4.4E-31, SH = -134990000.0, IGHF = -1.3499E+08, GEF = -2.144E+07, AS = 295500, HFMP = 4540000, HOC = -2.64812E+09, LiqDen = {105,0.89934,0.25371,407.85,0.25125,0}, VP = {101,70.58866,-4298.161,-7.798635,0.0000116,2}, LiqCp = {16,89466,-323.61,12.827,-0.010476,0.000025037}, HOV = {106,3.4869E+07,0.64449,-0.15424,-0.28822,0.20982}, VapCp = {16,39746.03,-371.573,12.02593,0.000755039,-2.59608E-07}, LiqVis = {101,-39.10125,1315.145,4.876982,-0.0000203993,2}, VapVis = {102,3.951E-08,0.90975,-52.076,8625.4,0}, LiqK = {16,0.029586,56.323,-2.8746,0.0051627,-0.000017826}, VapK = {102,0.091178,0.18264,626.56,1124600,0}, Racketparam = 0.275, UniquacR = 3.1502, UniquacQ = 2.772, ChaoSeadAF = 0.1825, ChaoSeadSP = 13766.21, ChaoSeadLV = 0.1055);
  end Isobutane;
  
  model Onebutanol
  extends General_Properties(
    SN = 94, name = "Onebutanol", CAS = "71-36-3", Tc = 563.05, Pc = 4423000,  Vc = 0.275, Cc = 0.26, Tb = 390.88, Tm = 183.85, TT = 184.51, TP = 0.000320123, MW = 74.123, LVB = 0.09196, AF = 0.591, SP = 23510, DM = 5.83737E-30, SH = -134990000.0, IGHF = -2.746E+08, GEF = -1.503E+08, AS = 361480, HFMP = 9372000, HOC = -2.45601E+09, LiqDen = {105,0.7931,0.24201,563.05,0.22263,0}, VP = {101,94.3424,-9140.942,-10.0038,1.706963E-06,2}, LiqCp = {16,118540,928.1,-3.4067,0.053827,-0.000053611}, HOV = {106,1.03317E+08,2.061287,-3.612692,3.240107,-1.125287}, VapCp = {16,63521,-568.25,12.587,0.0001566,-5.9966E-08}, LiqVis = {101,-44.688,3409.1,4.8758,-0.0000057302,2}, VapVis = {102,0.0000014735,0.46162,554.37,6760.2,0}, LiqK = {16,0.019408,-19.063,-1.4625,-0.0014843,-4.7683E-07}, VapK = {102,0.00022746,1.1142,3597.3,-411420,0}, Racketparam = 0.2538, UniquacR = 3.4543, UniquacQ = 3.052, ChaoSeadAF = 0.593, ChaoSeadSP = 23289.2, ChaoSeadLV = 0.0919432);
  end Onebutanol;
  
  model TwomethylOnepropanol
  extends General_Properties(
    SN = 95, name = "TwomethylOnepropanol", CAS = "78-83-1", Tc = 547.78, Pc = 4300000,  Vc = 0.273, Cc = 0.258, Tb = 381.04, Tm = 165.15, TT = 165.15, TP = 2.46096E-06, MW = 74.123, LVB = 0.09291, AF = 0.59, SP = 22900, DM = 5.47E-30, SH = -134990000.0, IGHF = -2.832E+08, GEF = -1.549E+08, AS = 348000, HFMP = 6322000, HOC = -2.449E+09, LiqDen = {105,0.80194,0.24515,547.81,0.21175,0}, VP = {101,174.0368,-12288.81,-22.23928,0.0000131856,2}, LiqCp = {16,114500,844.65,-3.6753,0.058766,-0.000062464}, HOV = {106,6.1411E+07,-0.67703,2.6884,-2.3416,0.75942}, VapCp = {16,20857,-275.26,12.137,0.00070478,-0.0000002462}, LiqVis = {101,-107.9662,6199.736,14.5721,-0.000017552,2}, VapVis = {102,7.9881E-07,0.52424,295.54,17281,0}, LiqK = {16,-0.27685,36.722,-1.0689,0.00066056,-0.0000014048}, VapK = {102,2189.9,0.91222,1.1244E+10,-5.1003E+11,0}, Racketparam = 0, UniquacR = 3.4535, UniquacQ = 3.048, ChaoSeadAF = 0.592, ChaoSeadSP = 23750.6, ChaoSeadLV = 0.0930277);
  end TwomethylOnepropanol;
  
  model Twobutanol
  extends General_Properties(
    SN = 96, name = "Twobutanol", CAS = "78-92-2", Tc = 536.05, Pc = 4179000,  Vc = 0.269, Cc = 0.252, Tb = 372.66, Tm = 158.45, TT = 158.45, TP = 3.16526E-06, MW = 74.123, LVB = 0.09235, AF = 0.574, SP = 22620, DM = 5.54E-30, SH = -134990000.0, IGHF = -2.929E+08, GEF = -1.696E+08, AS = 364690, HFMP = 5971000, HOC = -2.4408E+09, LiqDen = {105,0.65041,0.21558,536.05,0.22084,0}, VP = {101,145.55,-10811,-17.957,0.0000094132,2}, LiqCp = {16,68513,631.42,2.7425,0.03164,-0.000028572}, HOV = {106,9.123771E+07,1.779726,-3.389854,3.546493,-1.385264}, VapCp = {16,70319,-564.51,12.517,0.00018661,-6.3166E-08}, LiqVis = {101,19.329,3026.9,-6.6532,0.000029986,2}, VapVis = {102,1.3231E-07,0.76798,139.73,-4888.6,0}, LiqK = {16,0.031711,-158.34,-0.24491,-0.0057475,0.000002591}, VapK = {102,0.0000011661,1.7056,340.33,-60553,0}, Racketparam = 0, UniquacR = 3.4535, UniquacQ = 3.048, ChaoSeadAF = 0.571133, ChaoSeadSP = 22629.5, ChaoSeadLV = 0.0921178);
  end Twobutanol;
  
  model TwomethylTwopropanol
  extends General_Properties(
    SN = 97, name = "TwomethylTwopropanol", CAS = "75-65-0", Tc = 506.21, Pc = 3973000,  Vc = 0.275, Cc = 0.26, Tb = 355.49, Tm = 298.97, TT = 298.97, TP = 5884.28, MW = 74.123, LVB = 0.09488, AF = 0.613, SP = 21620, DM = 5.57E-30, SH = -134990000.0, IGHF = -3.124E+08, GEF = -1.776E+08, AS = 326300, HFMP = 6703000, HOC = -2.4239E+09, LiqDen = {105,0.40838,0.17034,508.88,0.1974,0}, VP = {101,196.8976,-12439.78,-26.03107,0.0000198743,2}, LiqCp = {16,-158220,-166.8,13.168,0.0013959,-0.0000019876}, HOV = {106,9.49928E+07,1.077392,-0.185452,-0.822732,0.535399}, VapCp = {16,65560,-540.88,12.558,0.00014695,-5.2324E-08}, LiqVis = {101,-933.24,39184,142.25,-0.0001583,2}, VapVis = {102,2.5934E-07,0.64853,136.6,9124.5,0}, LiqK = {16,0.0056947,358.71,-5.5774,0.012913,-0.000018273}, VapK = {102,4.2365E-07,1.7929,-130.93,17989,0}, Racketparam = 0, UniquacR = 3.4528, UniquacQ = 3.128, ChaoSeadAF = 0.612, ChaoSeadSP = 21491.8, ChaoSeadLV = 0.0948614);
  end TwomethylTwopropanol;
  
  model Diethylether
  extends General_Properties(
    SN = 98, name = "Diethylether", CAS = "60-29-7", Tc = 466.7, Pc = 3640000,  Vc = 0.28, Cc = 0.263, Tb = 307.59, Tm = 156.85, TT = 156.85, TP = 0.395447, MW = 74.123, LVB = 0.10475, AF = 0.281, SP = 15420, DM = 3.84E-30, SH = -134990000.0, IGHF = -2.521E+08, GEF = -1.221E+08, AS = 342300, HFMP = 7190000, HOC = -2.5035E+09, LiqDen = {105,0.97479,0.27114,466.7,0.28433,0}, VP = {101,75.39748,-5436.852,-8.193869,7.812562E-06,2}, LiqCp = {16,145290,-2.8208,5.9722,0.017041,-0.0000078238}, HOV = {106,5.331574E+07,0.876213,0.475413,-1.944676,1.061631}, VapCp = {16,81727,-660.7,12.61,0.00016979,-7.4028E-08}, LiqVis = {101,10.139,-61.707,-3.2168,-9.5022E-09,2}, VapVis = {102,0.0000019481,0.40997,495.46,85.073,0}, LiqK = {16,-0.14221,30.008,-1.3139,0.00048013,-0.0000026572}, VapK = {102,-0.0044909,0.61494,-3258.3,85.806,0}, Racketparam = 0, UniquacR = 3.39, UniquacQ = 3.02, ChaoSeadAF = 0.284607, ChaoSeadSP = 15530.3, ChaoSeadLV = 0.104692);
  end Diethylether;
  
  model Diethyleneglycol
  extends General_Properties(
    SN = 99, name = "Diethyleneglycol", CAS = "111-46-6", Tc = 744.6, Pc = 4600000,  Vc = 0.312, Cc = 0.232, Tb = 517.95, Tm = 262.7, TT = 262.7, TP = 0.00319709, MW = 106.12, LVB = 0.0952681, AF = 0.622105, SP = 28920, DM = 8.41E-30, SH = -134990000.0, IGHF = -5.464E+08, GEF = -3.84E+08, AS = 440000, HFMP = 1.3481E+07, HOC = -2.155E+09, LiqDen = {105,0.81894,0.25823,744.6,0.23979,0}, VP = {101,46.26595,-10205.15,-2.102723,-7.036466E-06,2}, LiqCp = {16,188290,227.63,5.7157,0.020545,-0.000018798}, HOV = {106,1.0853E+08,-0.00876655,1.770951,-1.359893,-0.0210292}, VapCp = {16,82107,-687.16,13.353,-0.00070647,2.4155E-07}, LiqVis = {101,-374.29,18192,55.132,-0.000049166,2}, VapVis = {102,6.4523E-08,0.8468,24.322,7352.9,0}, LiqK = {16,-0.11579,8.2246,-1.6466,0.002673,-0.0000035412}, VapK = {102,500.16,1.0276,7.9617E+09,-7.5258E+11,0}, Racketparam = 0, UniquacR = 4.9415, UniquacQ = 4.8, ChaoSeadAF = 0.621104, ChaoSeadSP = 27775.2, ChaoSeadLV = 0.0952681);
  end Diethyleneglycol;
  
  model Diethylamine
  extends General_Properties(
    SN = 100, name = "Diethylamine", CAS = "109-89-7", Tc = 496.6, Pc = 3710000,  Vc = 0.301, Cc = 0.27, Tb = 328.6, Tm = 223.35, TT = 223.35, TP = 374.108, MW = 73.138, LVB = 0.10424, AF = 0.303856, SP = 16610, DM = 3.07E-30, SH = -134990000.0, IGHF = -7.142E+07, GEF = 7.308E+07, AS = 352200, HFMP = 1.14E+07, HOC = -2.8003E+09, LiqDen = {105,0.73036,0.23814,496.66,0.24991,0}, VP = {101,64.68388,-5484.939,-6.37255,4.185124E-06,2}, LiqCp = {16,107090,694.46,2.8508,0.027204,-0.000024864}, HOV = {106,3.911798E+07,0.292165,-0.28266,0.355094,0.0257197}, VapCp = {16,85298,-793.64,13.085,-0.00026826,6.6572E-08}, LiqVis = {101,-21.138,1492,1.4401,-0.0000012994,2}, VapVis = {102,4.3797E-07,0.60244,253.34,-614.36,0}, LiqK = {16,0.066644,-97.786,-0.73312,-0.0054502,-7.5663E-08}, VapK = {102,0.000016939,1.2488,-114.17,77881,0}, Racketparam = 0.27, UniquacR = 3.68, UniquacQ = 3.17, ChaoSeadAF = 0.303733, ChaoSeadSP = 16543.3, ChaoSeadLV = 0.104234);
  end Diethylamine;
  
  model Furfural
  extends General_Properties(
    SN = 101, name = "Furfural", CAS = "98-01-1", Tc = 670.15, Pc = 5660000,  Vc = 0.252, Cc = 0.256, Tb = 434.85, Tm = 236.65, TT = 236.65, TP = 1.54565, MW = 96.0841, LVB = 0.0832248, AF = 0.367784, SP = 23610, DM = 1.2E-29, SH = -134990000.0, IGHF = -1.51E+08, GEF = -1.028E+08, AS = 333300, HFMP = 1.44E+07, HOC = -2.2564E+09, LiqDen = {105,1.0614,0.26706,670.15,0.30028,0}, VP = {101,25.656,-5514,-0.19573,-0.0000013402,2}, LiqCp = {16,122630,404.51,3.0587,0.029945,-0.000031496}, HOV = {106,6.3009E+07,0.4784,0.066802,-0.59102,0.42453}, VapCp = {16,45855,-497.61,12.549,-0.000033724,-2.8785E-08}, LiqVis = {101,2.6487,910.16,-2.1754,0.0000028413,2}, VapVis = {102,5.1928E-08,0.91224,70.285,-5476.4,0}, LiqK = {16,0.13228,19058,-182.25,0.56426,-0.00059782}, VapK = {102,0.00022183,0.91119,617.18,55137,0}, Racketparam = 0.258287, UniquacR = 3.168, UniquacQ = 2.484, ChaoSeadAF = 0.383, ChaoSeadSP = 23643.5, ChaoSeadLV = 0.0831649);
  end Furfural;
  
  model Pyridine
  extends General_Properties(
    SN = 102, name = "Pyridine", CAS = "110-86-1", Tc = 620, Pc = 5670000,  Vc = 0.254, Cc = 0.267, Tb = 388.37, Tm = 231.53, TT = 231.51, TP = 20.5354, MW = 79.101, LVB = 0.08088, AF = 0.242, SP = 21570, DM = 7.31E-30, SH = -134990000.0, IGHF = 1.4037E+08, GEF = 1.9049E+08, AS = 282780, HFMP = 8280000, HOC = -2.6721E+09, LiqDen = {105,0.67102,0.2057,620,0.26001,0}, VP = {101,82.05373,-7269.578,-8.810082,4.816564E-06,2}, LiqCp = {16,101830,209.77,5.3544,0.019802,-0.000018129}, HOV = {106,8.4421E+07,2.7457,-5.3078,4.8654,-1.7952}, VapCp = {16,36223,-620.9,12.812,-0.00029215,7.7524E-08}, LiqVis = {101,-82.798,4102.8,11.028,-0.0000093419,2}, VapVis = {102,5.339E-08,0.90066,85.55,-5060.2,0}, LiqK = {16,0.018788,-54.761,-1.2916,-0.00062226,-0.0000029942}, VapK = {102,-7052.4,0.17223,-5.768E+07,-1.624E+11,0}, Racketparam = 0.269325, UniquacR = 3, UniquacQ = 2.16, ChaoSeadAF = 0.238898, ChaoSeadSP = 21804.1, ChaoSeadLV = 0.0808341);
  end Pyridine;
  
  model Isoprene
  extends General_Properties(
    SN = 103, name = "Isoprene", CAS = "78-79-5", Tc = 484, Pc = 3850030,  Vc = 0.276, Cc = 0.264, Tb = 307.205, Tm = 127.27, TT = 127.27, TP = 0.00247682, MW = 68.117, LVB = 0.100775, AF = 0.158323, SP = 15330, DM = 8.3391E-31, SH = -134990000.0, IGHF = 7.57304E+07, GEF = 1.45896E+08, AS = 315641, HFMP = 4924570, HOC = -2.98424E+09, LiqDen = {105,0.95762,0.265,484,0.28587,0}, VP = {101,59.64382,-4808.579,-5.723014,3.325462E-06,2}, LiqCp = {16,111430,579.88,0.11179,0.042713,-0.000046991}, HOV = {106,4.7482E+07,1.7472,-3.7153,4.0508,-1.6134}, VapCp = {16,46067,-400.72,12.189,0.00043981,-1.4681E-07}, LiqVis = {101,-8.3004,457.06,-0.22583,-0.0000048674,2}, VapVis = {102,5.2484E-07,0.58768,291.05,-6176.5,0}, LiqK = {16,-0.0093138,-47.475,-0.82654,-0.0037828,8.2245E-07}, VapK = {102,0.0010775,0.73105,657.17,112780,0}, Racketparam = 0, UniquacR = 3.36, UniquacQ = 3.01, ChaoSeadAF = 0.1642, ChaoSeadSP = 15333.3, ChaoSeadLV = 0.100775);
  end Isoprene;
  
  model Cyclopentane
  extends General_Properties(
    SN = 104, name = "Cyclopentane", CAS = "287-92-3", Tc = 511.6, Pc = 4508000,  Vc = 0.26, Cc = 0.276, Tb = 322.38, Tm = 179.311, TT = 179.28, TP = 9.07217, MW = 70.134, LVB = 0.09473, AF = 0.194, SP = 16550, DM = 0, SH = -134990000.0, IGHF = -7.703E+07, GEF = 3.885E+07, AS = 292900, HFMP = 608800, HOC = -3.0709E+09, LiqDen = {105,0.92461,0.26305,511.77,0.22002,0}, VP = {101,-74.77148,-401.0576,15.6271,-0.0000260872,2}, LiqCp = {16,84725,368.5,3.0559,0.030633,-0.000031124}, HOV = {106,4.513618E+07,1.248318,-2.311302,2.401073,-0.943348}, VapCp = {16,39785,-704.2,13.082,-0.00014913,2.4491E-08}, LiqVis = {101,-5.1843,670.87,-0.84082,-7.0656E-07,2}, VapVis = {102,2.1433E-07,0.68815,135.42,-1597.6,0}, LiqK = {16,0.10961,-598.59,3.5098,-0.016258,-0.0000091635}, VapK = {102,0.0000098408,1.4611,639.53,7396.1,0}, Racketparam = 0.2687, UniquacR = 3.3, UniquacQ = 2.47, ChaoSeadAF = 0.2051, ChaoSeadSP = 16589.01, ChaoSeadLV = 0.0947);
  end Cyclopentane;
  
  model TwomethylOnebutene
  extends General_Properties(
    SN = 105, name = "TwomethylOnebutene", CAS = "563-46-2", Tc = 465, Pc = 3447000,  Vc = 0.292, Cc = 0.26, Tb = 304.305, Tm = 135.578, TT = 135.578, TP = 0.0205382, MW = 70.1329, LVB = 0.10872, AF = 0.234056, SP = 14700, DM = 1.7E-30, SH = -134990000.0, IGHF = -3.53E+07, GEF = 6.668E+07, AS = 339500, HFMP = 7910700, HOC = -3.1159E+09, LiqDen = {105,0.91622,0.26752,465,0.28165,0}, VP = {101,77.29304,-5304.146,-8.607604,9.513458E-06,2}, LiqCp = {16,121560,527.31,1.2291,0.036295,-0.000037525}, HOV = {106,4.6374E+07,1.4214,-2.5789,2.5516,-0.95454}, VapCp = {16,81218,-803.24,13.077,-0.00034159,9.7536E-08}, LiqVis = {101,-10.065,690.04,-0.13044,0.0000004745,2}, VapVis = {102,5.0873E-07,0.55006,197.77,-68.455,0}, LiqK = {16,-0.024046,2.4654,-1.5931,-0.00074325,-0.0000024745}, VapK = {102,0.00018088,0.94101,77.857,153680,0}, Racketparam = 0.270022, UniquacR = 3.5939, UniquacQ = 3.224, ChaoSeadAF = 0.228663, ChaoSeadSP = 14695.4, ChaoSeadLV = 0.10868);
  end TwomethylOnebutene;
  
  model ThreemethylOnebutene
  extends General_Properties(
    SN = 106, name = "ThreemethylOnebutene", CAS = "563-45-1", Tc = 452.7, Pc = 3550000,  Vc = 0.3049, Cc = 0.288, Tb = 293.21, Tm = 104.66, TT = 104.66, TP = 0.0000144678, MW = 70.134, LVB = 0.11277, AF = 0.211, SP = 13780, DM = 1.07E-30, SH = -27600000.0, IGHF = -2.76E+07, GEF = 7.605E+07, AS = 333900, HFMP = 5359700, HOC = -3.1253E+09, LiqDen = {105,0.85968,0.26229,452.7,0.27579,0}, VP = {101,74.66163,-4956.256,-8.290047,0.0000100425,2}, LiqCp = {16,94996,92.422,8.4061,0.009093,-0.0000045826}, HOV = {106,3.9174E+07,0.58094,0.12579,-0.78785,0.49354}, VapCp = {16,82557,-671.08,12.784,-0.00012458,4.234E-08}, LiqVis = {101,-11.214,821.55,-0.010133,9.4673E-08,2}, VapVis = {102,0.0000016555,0.42535,455.3,876.91,0}, LiqK = {16,-0.017622,5.9209,-1.694,-0.00045405,-0.0000033564}, VapK = {102,0.00014816,0.97375,75.281,116540,0}, Racketparam = 0.272045, UniquacR = 3.5945, UniquacQ = 3.1, ChaoSeadAF = 0.2285, ChaoSeadSP = 14010.2, ChaoSeadLV = 0.111819);
  end ThreemethylOnebutene;
  
  model TwomethylTwobutene
  extends General_Properties(
    SN = 107, name = "TwomethylTwobutene", CAS = "513-35-9", Tc = 470, Pc = 3860000,  Vc = 0.292, Cc = 0.288, Tb = 311.7, Tm = 139.39, TT = 139.39, TP = 0.01937, MW = 70.134, LVB = 0.10757, AF = 0.339, SP = 15210, DM = 1.13E-30, SH = -27600000.0, IGHF = -4.18E+07, GEF = 6.045E+07, AS = 338600, HFMP = 7597700, HOC = -3.1088E+09, LiqDen = {105,0.93623,0.2731,470,0.25849,0}, VP = {101,82.2327,-5590.502,-9.366663,0.0000104545,2}, LiqCp = {16,127040,1071.7,-7.883,0.075072,-0.000089164}, HOV = {106,4.3456E+07,0.64226,-0.070051,-0.5395,0.35656}, VapCp = {16,75343,-774.17,12.975,-0.00022009,6.0763E-08}, LiqVis = {101,-11.234,703.42,0.094871,-0.0000017625,2}, VapVis = {102,8.6256E-07,0.47637,263.56,-2475.7,0}, LiqK = {16,-0.050847,3.0532,-1.4724,-0.00063704,-0.0000020121}, VapK = {102,0.00020806,0.92265,107.34,175680,0}, Racketparam = 0.260813, UniquacR = 3.5919, UniquacQ = 3.22, ChaoSeadAF = 0.27667, ChaoSeadSP = 15247.2, ChaoSeadLV = 0.106707);
  end TwomethylTwobutene;
  
  model Onepentene
  extends General_Properties(
    SN = 108, name = "Onepentene", CAS = "109-67-1", Tc = 464.8, Pc = 3560000,  Vc = 0.2984, Cc = 0.275, Tb = 303.11, Tm = 108.016, TT = 108.016, TP = 0.000037, MW = 70.134, LVB = 0.1104, AF = 0.237, SP = 14410, DM = 1.7E-30, SH = -27600000.0, IGHF = -2.162E+07, GEF = 7.837E+07, AS = 346200, HFMP = 5937400, HOC = -3.13037E+09, LiqDen = {105,0.44335,0.18566,473.43,0.23587,0}, VP = {101,39.52954,-3893.399,-2.686504,1.952359E-06,2}, LiqCp = {16,92753,117.21,8.6537,0.007447,-0.0000026759}, HOV = {106,3.077277E+07,-0.570706,2.243398,-2.258065,0.928488}, VapCp = {16,66520,-609.44,12.683,0.000062395,-2.5354E-08}, LiqVis = {101,-10.79591,682.8004,0.00564316,-9.176806E-07,2}, VapVis = {102,0.0000017549,0.42295,561.21,-17046,0}, LiqK = {16,-0.010825,-30.065,-1.1172,-0.0023327,-0.0000015541}, VapK = {102,0.0000026412,1.549,-2.5891,24389,0}, Racketparam = 0.2944, UniquacR = 3.5953, UniquacQ = 3.104, ChaoSeadAF = 0.2198, ChaoSeadSP = 14420.78, ChaoSeadLV = 0.1104);
  end Onepentene;
  
  model CisTwopentene
  extends General_Properties(
    SN = 109, name = "CisTwopentene", CAS = "627-20-3", Tc = 475, Pc = 3690000,  Vc = 0.3021, Cc = 0.273, Tb = 310.07, Tm = 121.75, TT = 121.75, TP = 0.000554, MW = 70.134, LVB = 0.10785, AF = 0.253, SP = 15060, DM = 1.008E-30, SH = -27600000.0, IGHF = -2.63E+07, GEF = 7.37E+07, AS = 346300, HFMP = 7112000, HOC = -3.123E+09, LiqDen = {105,0.90921,0.26313,475,0.30422,0}, VP = {101,87.54937,-5782.462,-10.18969,0.00001126,2}, LiqCp = {16,132080,-10569,112.64,-0.34846,0.00041161}, HOV = {106,3.808893E+07,0.541071,-0.876512,1.300916,-0.612383}, VapCp = {16,68358,-741.07,12.923,-0.00013529,3.1324E-08}, LiqVis = {101,-10.01,644.41,-0.11124,1.3682E-07,2}, VapVis = {102,7.0321E-08,0.83123,33.115,-394.35,0}, LiqK = {16,-0.06994,-6.3331,-1.1883,-0.0013351,-7.8623E-07}, VapK = {102,0.00017973,0.95148,124.65,170420,0}, Racketparam = 0, UniquacR = 3.5933, UniquacQ = 3.103, ChaoSeadAF = 0.206, ChaoSeadSP = 14420.78, ChaoSeadLV = 0.1078);
  end CisTwopentene;
  
  model TransTwopentene
  extends General_Properties(
    SN = 110, name = "TransTwopentene", CAS = "646-04-8", Tc = 474.2, Pc = 3660000,  Vc = 0.293, Cc = 0.272, Tb = 309.49, Tm = 132.89, TT = 132.89, TP = 0.00574, MW = 70.1329, LVB = 0.1091, AF = 0.248372, SP = 14970, DM = 0, SH = -27600000.0, IGHF = -3.11E+07, GEF = 6.98E+07, AS = 343100, HFMP = 8351700, HOC = -3.119E+09, LiqDen = {105,0.9122,0.26869,474.2,0.28253,0}, VP = {101,77.717,-5422.6,-8.6403,0.0000092035,2}, LiqCp = {16,117170,204.39,5.1039,0.022516,-0.00002152}, HOV = {106,4.3712E+07,0.84137,-0.81266,0.47134,-0.094225}, VapCp = {16,79715,-780.23,12.979,-0.00024552,0.0000000696}, LiqVis = {101,-10.52,657.15,-0.02693,1.6882E-07,2}, VapVis = {102,1.2614E-07,0.75299,74.21,1685.7,0}, LiqK = {16,-0.074338,-10.004,-1.1218,-0.0016085,-2.2796E-07}, VapK = {102,0.000026669,1.1894,-123.11,111540,0}, Racketparam = 0.268765, UniquacR = 3.5933, UniquacQ = 3.103, ChaoSeadAF = 0.209, ChaoSeadSP = 14420.78, ChaoSeadLV = 0.109);
  end TransTwopentene;
  
  model Threepentanone
  extends General_Properties(
    SN = 111, name = "Threepentanone", CAS = "96-22-0", Tc = 561.5, Pc = 3730000,  Vc = 0.336, Cc = 0.268, Tb = 375.14, Tm = 234.18, TT = 234.18, TP = 73.4224, MW = 86.134, LVB = 0.10641, AF = 0.342, SP = 18410, DM = 9.41E-30, SH = -27600000.0, IGHF = -2.579E+08, GEF = -1.344E+08, AS = 370000, HFMP = 1.159E+07, HOC = -2.8804E+09, LiqDen = {105,0.68664,0.23603,561.5,0.27471,0}, VP = {101,58.885,-6044.5,-5.3259,0.0000023057,2}, LiqCp = {16,169130,405.25,3.0239,0.024087,-0.000018434}, HOV = {106,5.083729E+07,0.764461,-0.828447,-0.00277131,0.530942}, VapCp = {16,93124,-637.87,12.577,0.00022827,-1.0612E-07}, LiqVis = {101,-1.367,550.49,-1.4469,4.9148E-07,2}, VapVis = {102,0.0000002611,0.65778,216.39,-3537.8,0}, LiqK = {16,0.0080662,16.294,-1.6509,-0.0010676,-9.5001E-07}, VapK = {102,22.162,1.0028,1.8597E+08,9.2842E+08,0}, Racketparam = 0, UniquacR = 3.9223, UniquacQ = 3.416, ChaoSeadAF = 0.344, ChaoSeadSP = 18259.5, ChaoSeadLV = 0.106401);
  end Threepentanone;
  
  model Methylisopropylketone
  extends General_Properties(
    SN = 112, name = "Methylisopropylketone", CAS = "563-80-4", Tc = 567.7, Pc = 3620000,  Vc = 0.31, Cc = 0.238, Tb = 367.55, Tm = 180.15, TT = 180.15, TP = 0.295357, MW = 86.134, LVB = 0.10791, AF = 0.216, SP = 17710, DM = 9.21E-30, SH = -27600000.0, IGHF = -2.626E+08, GEF = -1.393E+08, AS = 369900, HFMP = 9343000, HOC = -2.877E+09, LiqDen = {105,0.22922,0.13849,567.7,0.18207,0}, VP = {101,57.033,-5794.3,-5.09,0.0000023975,2}, LiqCp = {16,142840,463.87,4.1439,0.020347,-0.000013989}, HOV = {106,1.3282E+07,-7.596951,21.963,-24.77369,10.66731}, VapCp = {16,65899,-628.39,12.858,0.000023331,-5.0246E-08}, LiqVis = {101,-11.042,1043.1,-0.038423,1.1535E-07,2}, VapVis = {102,1.5484E-07,0.72865,149.15,-3826.1,0}, LiqK = {16,-0.11038,18.412,-1.2824,-0.000057222,-0.000001541}, VapK = {102,-6058400,-0.090573,3.176E+09,-2.84E+13,0}, Racketparam = 0.259, UniquacR = 3.9215, UniquacQ = 3.412, ChaoSeadAF = 0.350039, ChaoSeadSP = 18253.3, ChaoSeadLV = 0.106975);
  end Methylisopropylketone;
  
  model Npropylacetate
  extends General_Properties(
    SN = 113, name = "Npropylacetate", CAS = "109-60-4", Tc = 549.4, Pc = 3330000,  Vc = 0.345, Cc = 0.252, Tb = 374.65, Tm = 178.15, TT = 178.15, TP = 0.0171129, MW = 102.133, LVB = 0.11572, AF = 0.389, SP = 17890, DM = 5.97E-30, SH = -27600000.0, IGHF = -4.648E+08, GEF = -3.204E+08, AS = 402300, HFMP = 1.12E+07, HOC = -2.672E+09, LiqDen = {105,0.57751,0.2255,549.4,0.25884,0}, VP = {101,106.6613,-8095.022,-12.62161,8.999471E-06,2}, LiqCp = {16,124410,36.932,8.3883,0.012662,-0.000012028}, HOV = {106,8.047503E+07,1.798019,-2.259874,1.293466,-0.333711}, VapCp = {16,108820,-937.38,13.511,-0.00062962,1.4249E-07}, LiqVis = {101,15.453,-157.9,-3.9304,-3.2102E-07,2}, VapVis = {102,1.9633E-07,0.69295,104.27,10438,0}, LiqK = {16,0.045513,-31.328,-1.5572,-0.00066538,-0.0000053334}, VapK = {102,1128.5,1.014,1.1605E+10,-1.2869E+11,0}, Racketparam = 0, UniquacR = 4.153, UniquacQ = 3.656, ChaoSeadAF = 0.391, ChaoSeadSP = 18004.7, ChaoSeadLV = 0.115712);
  end Npropylacetate;
  
  model Isopentane
  extends General_Properties(
    SN = 114, name = "Isopentane", CAS = "78-78-4", Tc = 460.39, Pc = 3381000,  Vc = 0.3083, Cc = 0.272, Tb = 300.99, Tm = 113.25, TT = 113.25, TP = 0.00012144, MW = 72.15, LVB = 0.11646, AF = 0.229, SP = 13870, DM = 4.34E-31, SH = -27600000.0, IGHF = -1.537E+08, GEF = -1.405E+07, AS = 343740, HFMP = 5150000, HOC = -3.23954E+09, LiqDen = {105,0.73194,0.24835,460.99,0.25733,0}, VP = {101,71.04288,-4967.235,-7.674379,8.659929E-06,2}, LiqCp = {16,112460,-54.259,8.8747,0.0083911,-0.0000034773}, HOV = {106,4.14248E+07,0.799342,-0.581969,0.0834724,0.117826}, VapCp = {16,59843,-493.27,12.516,0.00046099,-1.5305E-07}, LiqVis = {101,-12.596,889.14,0.20472,4.0592E-09,2}, VapVis = {102,6.6346E-08,0.82828,-68.082,25303,0}, LiqK = {16,0.061061,89.857,-3.522,0.0075154,-0.000023032}, VapK = {102,0.00090019,0.7738,456.82,231390,0}, Racketparam = 0.2716, UniquacR = 3.82, UniquacQ = 3.31, ChaoSeadAF = 0.2104, ChaoSeadSP = 14359.41, ChaoSeadLV = 0.1174);
  end Isopentane;
  
  model Npentane
  extends General_Properties(
    SN = 115, name = "Npentane", CAS = "109-66-0", Tc = 469.7, Pc = 3370000,  Vc = 0.311, Cc = 0.268, Tb = 309.22, Tm = 143.42, TT = 143.42, TP = 0.0686418, MW = 72.15, LVB = 0.11522, AF = 0.251, SP = 14380, DM = 0, SH = -27600000.0, IGHF = -1.4676E+08, GEF = -8813000, AS = 349450, HFMP = 8401500, HOC = -3.24494E+09, LiqDen = {105,0.77386,0.25574,469.7,0.26319,0}, VP = {101,72.14242,-5265.589,-7.720709,7.151866E-06,2}, LiqCp = {16,122980,401.5,3.9651,0.024056,-0.000020161}, HOV = {106,4.0854E+07,0.25483,0.96045,-1.5349,0.72504}, VapCp = {16,81062,-706.86,12.962,-0.000049298,2.8357E-09}, LiqVis = {101,-28.93847,1176.355,3.050544,-9.721368E-06,2}, VapVis = {102,5.9173E-08,0.85109,8.4138,3723.2,0}, LiqK = {16,0.023649,-75.089,-0.64229,-0.005078,-2.7196E-07}, VapK = {102,-603.2,0.74698,-8.1823E+08,-8.7865E+09,0}, Racketparam = 0.2685, UniquacR = 3.8254, UniquacQ = 3.316, ChaoSeadAF = 0.2387, ChaoSeadSP = 14359.41, ChaoSeadLV = 0.1161);
  end Npentane;
  
  model Neopentane
  extends General_Properties(
    SN = 116, name = "Neopentane", CAS = "463-82-1", Tc = 433.75, Pc = 3199000,  Vc = 0.3032, Cc = 0.269, Tb = 282.65, Tm = 256.6, TT = 256.6, TP = 35745.2, MW = 72.15, LVB = 0.12216, AF = 0.197, SP = 12510, DM = 0, SH = -168070000.0, IGHF = -1.6807E+08, GEF = -1.714E+07, AS = 305890, HFMP = 3146000, HOC = -3.25039E+09, LiqDen = {105,0.90246,0.2775,433.8,0.29085,0}, VP = {101,85.887,-5169,-10.119,0.000013061,2}, LiqCp = {16,116590,146.32,1.9197,0.044936,-0.000054657}, HOV = {106,3.3957E+07,0.38208,0,0,0}, VapCp = {16,31525,-309.56,12.21,0.00085791,-2.6395E-07}, LiqVis = {101,-36.861,2459.5,3.4416,0.0000070474,2}, VapVis = {102,8.1019E-07,0.5294,468.47,-22580,0}, LiqK = {16,0.027667,-243.53,0.83395,-0.010754,0.0000058849}, VapK = {102,0.0000044729,1.4644,-142.95,66180,0}, Racketparam = 0.2762, UniquacR = 3.8239, UniquacQ = 3.392, ChaoSeadAF = 0.195, ChaoSeadSP = 14359.41, ChaoSeadLV = 0.1233);
  end Neopentane;
  
  model OneTwoFourtrichlorobenzene
  extends General_Properties(
    SN = 117, name = "OneTwoFourtrichlorobenzene", CAS = "120-82-1", Tc = 725, Pc = 3720000,  Vc = 0.395, Cc = 0.244, Tb = 486.15, Tm = 290.15, TT = 290.15, TP = 33.0937, MW = 181.447, LVB = 0.12525, AF = 0.358106, SP = 20620, DM = 4.20291E-30, SH = -168070000.0, IGHF = -1.1757E+07, GEF = 4.30523E+07, AS = 380911, HFMP = 1.55647E+07, HOC = -2.65632E+09, LiqDen = {105,0.61713,0.2524,725,0.2857,0}, VP = {101,47.20405,-7460.647,-3.164866,-3.316432E-06,2}, LiqCp = {16,145370,234.69,6.2789,0.017012,-0.000015675}, HOV = {106,6.897E+07,0.4026,0,0,0}, VapCp = {16,63130,-426.63,12.569,-0.000095696,1.4713E-08}, LiqVis = {101,-241,9893.2,36.115,-0.000047458,2}, VapVis = {102,9.2097E-08,0.80621,99.511,1477.5,0}, LiqK = {16,0.070105,-290.72,-0.20366,-0.0074415,0.0000024779}, VapK = {102,-743.07,0.74159,-2.1746E+09,-6.4502E+10,0}, Racketparam = 0.259136, UniquacR = 5.0625, UniquacQ = 3.732, ChaoSeadAF = 0.358106, ChaoSeadSP = 20618.1, ChaoSeadLV = 0.12525);
  end OneTwoFourtrichlorobenzene;
  
  model Mdichlorobenzene
  extends General_Properties(
    SN = 118, name = "Mdichlorobenzene", CAS = "541-73-1", Tc = 683.95, Pc = 4070000,  Vc = 0.351, Cc = 0.251, Tb = 446.23, Tm = 248.39, TT = 248.39, TP = 6.40787, MW = 147.002, LVB = 0.114533, AF = 0.27898, SP = 19570, DM = 5.74E-30, SH = -168070000.0, IGHF = 2.57E+07, GEF = 7.79E+07, AS = 343530, HFMP = 1.259E+07, HOC = -2.825E+09, LiqDen = {105,0.74132,0.26094,683.95,0.31392,0}, VP = {101,100.37,-9087,-11.404,0.0000055122,2}, LiqCp = {16,89111,785.31,3.6098,0.022491,-0.00001896}, HOV = {106,5.2076E+07,0.15554,-0.20298,0.94291,-0.55524}, VapCp = {16,56066,-490.93,12.649,-0.00012726,2.3703E-08}, LiqVis = {101,-114.79,4907.5,16.374,-0.000020623,2}, VapVis = {102,2.3524E-07,0.71383,257.29,1880.2,0}, LiqK = {16,0.042347,-224.09,-0.2096,-0.006185,0.0000024486}, VapK = {102,-1552.3,0.68852,-2.6293E+09,-1.7751E+11,0}, Racketparam = 0, UniquacR = 4.4376, UniquacQ = 3.288, ChaoSeadAF = 0.215834, ChaoSeadSP = 19575.7, ChaoSeadLV = 0.114641);
  end Mdichlorobenzene;
  
  model Odichlorobenzene
  extends General_Properties(
    SN = 119, name = "Odichlorobenzene", CAS = "95-50-1", Tc = 705, Pc = 4070000,  Vc = 0.351, Cc = 0.244, Tb = 453.57, Tm = 256.15, TT = 256.15, TP = 6.48939, MW = 147.002, LVB = 0.112969, AF = 0.219189, SP = 20310, DM = 8.34E-30, SH = -168070000.0, IGHF = 3.02E+07, GEF = 8.29E+07, AS = 341850, HFMP = 1.266E+07, HOC = -2.826E+09, LiqDen = {105,0.74261,0.26108,705,0.30655,0}, VP = {101,75.75983,-8226.762,-7.552754,6.191298E-07,2}, LiqCp = {16,127840,-59.156,8.3728,0.0093569,-0.0000051714}, HOV = {106,8.774E+07,2.8227,-6.8433,7.6547,-3.1275}, VapCp = {16,55560,-490.51,12.648,-0.00012186,2.1792E-08}, LiqVis = {101,-37.699,2377,4.0848,-0.0000020768,2}, VapVis = {102,1.6041E-07,0.76289,205.1,-39.728,0}, LiqK = {16,0.06919,-379.09,0.89948,-0.0099037,0.0000041677}, VapK = {102,-1200.2,0.7235,-2.8422E+09,-8.8684E+10,0}, Racketparam = 0.271326, UniquacR = 4.4376, UniquacQ = 3.288, ChaoSeadAF = 0.214215, ChaoSeadSP = 20271.3, ChaoSeadLV = 0.11318);
  end Odichlorobenzene;
  
  model Pdichlorobenzene
  extends General_Properties(
    SN = 120, name = "Pdichlorobenzene", CAS = "106-46-7", Tc = 684.75, Pc = 4070000,  Vc = 0.351, Cc = 0.251, Tb = 447.21, Tm = 326.14, TT = 326.14, TP = 1225.03, MW = 147.002, LVB = 0.117406, AF = 0.284638, SP = 19330, DM = 0, SH = -168070000.0, IGHF = 2.25E+07, GEF = 7.67E+07, AS = 336740, HFMP = 1.82E+07, HOC = -2.802E+09, LiqDen = {105,0.74861,0.26271,684.75,0.30815,0}, VP = {101,40.63688,-6607.72,-2.221184,-3.90747E-06,2}, LiqCp = {16,155200,855.07,0.88585,0.024843,-0.000014582}, HOV = {106,6.112633E+07,0.426201,-0.0366365,0.00811781,-0.00754654}, VapCp = {16,55695,-489.46,12.649,-0.00012524,2.3115E-08}, LiqVis = {101,-131.86,5312.8,19.284,-0.000029085,2}, VapVis = {102,1.5946E-07,0.76369,193.94,-148.97,0}, LiqK = {16,0.02927,-28.287,-2.0319,0.000077764,-0.0000037797}, VapK = {102,-2269.7,0.68598,-3.774E+09,-2.6655E+11,0}, Racketparam = 0.265583, UniquacR = 4.4376, UniquacQ = 3.288, ChaoSeadAF = 0.234279, ChaoSeadSP = 19187.2, ChaoSeadLV = 0.117341);
  end Pdichlorobenzene;
  
  model Bromobenzene
  extends General_Properties(
    SN = 121, name = "Bromobenzene", CAS = "108-86-1", Tc = 670.15, Pc = 4519100,  Vc = 0.324, Cc = 0.263, Tb = 429.236, Tm = 242.43, TT = 242.43, TP = 7.8364, MW = 157.008, LVB = 0.105567, AF = 0.250575, SP = 19940, DM = 5.67059E-30, SH = -168070000.0, IGHF = 1.05018E+08, GEF = 1.38532E+08, AS = 324386, HFMP = 1.06274E+07, HOC = -3.01917E+09, LiqDen = {105,0.8226,0.26632,670.15,0.2821,0}, VP = {101,146.6319,-10375.07,-18.74897,0.0000147083,2}, LiqCp = {16,97487,953.8,2.1839,0.023716,-0.000017458}, HOV = {106,5.656362E+07,0.347537,0.135082,0.0123621,-0.140849}, VapCp = {16,65656,-767.67,13.165,-0.00063667,1.8215E-07}, LiqVis = {101,-54.93,2754.4,6.973,-0.000009784,2}, VapVis = {102,2.2327E-07,0.71456,185.02,-22.393,0}, LiqK = {16,0.032562,-180.04,-0.56464,-0.0046562,1.7973E-07}, VapK = {102,0.00025787,0.79923,269.79,163730,0}, Racketparam = 0, UniquacR = 3.9709, UniquacQ = 2.952, ChaoSeadAF = 0.250575, ChaoSeadSP = 19944.7, ChaoSeadLV = 0.105567);
  end Bromobenzene;
  
  model Monochlorobenzene
  extends General_Properties(
    SN = 122, name = "Monochlorobenzene", CAS = "108-90-7", Tc = 632.4, Pc = 4520000,  Vc = 0.308, Cc = 0.265, Tb = 404.91, Tm = 227.95, TT = 227.95, TP = 8.4456, MW = 112.558, LVB = 0.10222, AF = 0.251, SP = 19350, DM = 5.64E-30, SH = -168070000.0, IGHF = 5.109E+07, GEF = 9.829E+07, AS = 314030, HFMP = 9556000, HOC = -2.976E+09, LiqDen = {105,0.78287,0.25464,632.4,0.26342,0}, VP = {101,51.41334,-6020.539,-4.204143,1.293848E-06,2}, LiqCp = {16,139150,-333.42,10.906,-0.018036,0.000054846}, HOV = {106,4.9039E+07,0.24473,-0.048652,0.40537,-0.25012}, VapCp = {16,74680,-1001.5,13.827,-0.0014014,4.6413E-07}, LiqVis = {101,0.029483,556.49,-1.5963,1.2171E-07,2}, VapVis = {102,1.1217E-07,0.79382,109.37,1134.4,0}, LiqK = {16,0.083427,-157.94,-0.89724,-0.0049259,-0.0000027589}, VapK = {102,0.0004167,0.92033,1902.9,123750,0}, Racketparam = 0, UniquacR = 3.79, UniquacQ = 2.84, ChaoSeadAF = 0.2459, ChaoSeadSP = 19345.3, ChaoSeadLV = 0.10229);
  end Monochlorobenzene;
  
  model Iodobenzene
  extends General_Properties(
    SN = 123, name = "Iodobenzene", CAS = "591-50-4", Tc = 721.15, Pc = 4519100,  Vc = 0.351, Cc = 0.265, Tb = 461.6, Tm = 241.83, TT = 241.83, TP = 1.17521, MW = 204.008, LVB = 0.111976, AF = 0.246574, SP = 20450, DM = 5.67E-30, SH = -168070000.0, IGHF = 1.649E+08, GEF = 1.902E+08, AS = 334100, HFMP = 9749000, HOC = -3.05E+09, LiqDen = {105,0.7521,0.26381,721.15,0.2895,0}, VP = {101,79.186,-8185.3,-8.2636,0.0000035963,2}, LiqCp = {16,139830,578.69,1.6453,0.031278,-0.000034279}, HOV = {106,6.148821E+07,0.433906,-0.0102943,-0.0130647,-0.0329532}, VapCp = {16,63442,-692.72,13.003,-0.00048297,1.3499E-07}, LiqVis = {101,-57.177,3157.8,7.1529,-0.0000070913,2}, VapVis = {102,2.1908E-07,0.74366,231.22,-43.688,0}, LiqK = {16,0.077923,1284.8,-17.082,0.050362,-0.00006779}, VapK = {102,0.00026878,0.78911,373.97,187720,0}, Racketparam = 0, UniquacR = 4.2857, UniquacQ = 3.112, ChaoSeadAF = 0.246574, ChaoSeadSP = 20367.4, ChaoSeadLV = 0.111976);
  end Iodobenzene;
  
  model Nitrobenzene
  extends General_Properties(
    SN = 124, name = "Nitrobenzene", CAS = "98-95-3", Tc = 719, Pc = 4400000,  Vc = 0.349, Cc = 0.257, Tb = 483.95, Tm = 278.91, TT = 278.87, TP = 6.69814, MW = 123.109, LVB = 0.102717, AF = 0.449158, SP = 22610, DM = 1.41E-29, SH = -168070000.0, IGHF = 6.75E+07, GEF = 1.63E+08, AS = 342100, HFMP = 1.16E+07, HOC = -2.9782E+09, LiqDen = {105,0.69124,0.24124,719,0.28137,0}, VP = {101,112.2302,-10538.91,-12.95686,5.116363E-06,2}, LiqCp = {16,146460,1160.6,0.44135,0.024575,-0.000013049}, HOV = {106,4.9884E+07,-2.0813,7.5215,-8.8126,3.6947}, VapCp = {16,112710,-1114.3,13.93,-0.0013044,3.7699E-07}, LiqVis = {101,-78.652,4202,10.37,-0.0000091095,2}, VapVis = {102,1.1361E-07,0.80626,193.03,-46.762,0}, LiqK = {16,0.11293,-401.92,1.2826,-0.013207,0.0000075932}, VapK = {102,0.00014373,0.9615,718,-0.0027852,0}, Racketparam = 0.251146, UniquacR = 4.13, UniquacQ = 3.14, ChaoSeadAF = 0.447966, ChaoSeadSP = 22612.4, ChaoSeadLV = 0.102717);
  end Nitrobenzene;
  
  model Benzene
  extends General_Properties(
    SN = 125, name = "Benzene", CAS = "71-43-2", Tc = 562.05, Pc = 4895000,  Vc = 0.256, Cc = 0.268, Tb = 353.24, Tm = 278.68, TT = 278.68, TP = 4764.22, MW = 78.114, LVB = 0.08941, AF = 0.209, SP = 18700, DM = 0, SH = -168070000.0, IGHF = 8.288E+07, GEF = 1.296E+08, AS = 269300, HFMP = 9866000, HOC = -3.136E+09, LiqDen = {105,0.99938,0.26348,562.05,0.27856,0}, VP = {101,88.368,-6712.9,-10.022,0.000007694,2}, LiqCp = {16,111460,-1854.3,22.399,-0.028936,0.000028991}, HOV = {106,4.881E+07,0.61066,-0.25882,0.032238,0.022475}, VapCp = {16,34010.24,-588.0978,12.81777,-0.000197306,5.142899E-08}, LiqVis = {101,-24.61,1576.5,2.1698,-0.0000051366,2}, VapVis = {102,3.1366E-08,0.9675,8.0285,-35.629,0}, LiqK = {16,0.049539,-177.97,0.19475,-0.0073805,0.0000027938}, VapK = {102,0.0000049549,1.4519,154.14,26202,0}, Racketparam = 0.2696, UniquacR = 3.1878, UniquacQ = 2.4, ChaoSeadAF = 0.213, ChaoSeadSP = 18736.78, ChaoSeadLV = 0.0894);
  end Benzene;
  
  model Phenol
  extends General_Properties(
    SN = 126, name = "Phenol", CAS = "108-95-2", Tc = 694.25, Pc = 6130000,  Vc = 0.229, Cc = 0.243, Tb = 455.04, Tm = 314.06, TT = 314.06, TP = 187.979, MW = 94.113, LVB = 0.08787, AF = 0.442, SP = 24630, DM = 4.84E-30, SH = -168070000.0, IGHF = -9.6399E+07, GEF = -3.2637E+07, AS = 314810, HFMP = 1.151E+07, HOC = -2.921E+09, LiqDen = {105,1.4937,0.32883,694.25,0.34018,0}, VP = {101,300.97,-20269,-40.743,0.000021631,2}, LiqCp = {16,86710,-628.11,15.735,-0.0091743,0.0000081827}, HOV = {106,7.270282E+07,-0.265673,2.248545,-2.018709,0.353169}, VapCp = {16,39758,-470.56,12.627,0.000068347,-4.9708E-08}, LiqVis = {101,-203.001,10884.21,28.73615,-0.0000224564,2}, VapVis = {102,1.0771E-07,0.79384,145.89,-11364,0}, LiqK = {16,0.14109,-966.5,10.659,-0.049095,0.000038703}, VapK = {102,0.03495,0.27845,1585.2,862070,0}, Racketparam = 0, UniquacR = 3.5517, UniquacQ = 2.68, ChaoSeadAF = 0.442, ChaoSeadSP = 24632.6, ChaoSeadLV = 0.0889403);
  end Phenol;
  
  model Aniline
  extends General_Properties(
    SN = 127, name = "Aniline", CAS = "62-53-3", Tc = 699, Pc = 5310000,  Vc = 0.2739, Cc = 0.256, Tb = 457.17, Tm = 267.13, TT = 267.13, TP = 7.13219, MW = 93.128, LVB = 0.09152, AF = 0.38, SP = 24120, DM = 5.1E-30, SH = -168070000.0, IGHF = 8.71E+07, GEF = 1.668E+08, AS = 319800, HFMP = 1.054E+07, HOC = -3.239E+09, LiqDen = {105,1.0034,0.27828,699.16,0.26553,0}, VP = {101,51.415,-7256.776,-3.968851,1.89237E-06,1.941839}, LiqCp = {16,113560,-229.45,12.348,-0.001777,0.0000025731}, HOV = {106,6.518054E+07,-0.829815,5.221579,-7.587726,3.672676}, VapCp = {16,53776,-561.43,12.878,-0.00018357,4.6595E-08}, LiqVis = {101,-411.9909,17880.72,61.83069,-0.0000659764,2}, VapVis = {102,1.8398E-07,0.71832,209.33,-5579.1,0}, LiqK = {16,0.065783,-186.09,-0.85045,-0.0016475,-0.0000028261}, VapK = {102,0.00025341,0.90822,897.01,-19862,0}, Racketparam = 0, UniquacR = 3.72, UniquacQ = 2.82, ChaoSeadAF = 0.404143, ChaoSeadSP = 24125.7, ChaoSeadLV = 0.0916034);
  end Aniline;
  
  model Cyclohexanone
  extends General_Properties(
    SN = 128, name = "Cyclohexanone", CAS = "108-94-1", Tc = 653, Pc = 4000000,  Vc = 0.311, Cc = 0.229, Tb = 428.58, Tm = 242, TT = 242, TP = 6.80118, MW = 98.143, LVB = 0.104111, AF = 0.299006, SP = 20250, DM = 1.03E-29, SH = -168070000.0, IGHF = -2.261E+08, GEF = -9.028E+07, AS = 334260, HFMP = 1190000, HOC = -3.299E+09, LiqDen = {105,0.8601,0.26829,653,0.29808,0}, VP = {101,69.93885,-7280.529,-6.943105,3.624646E-06,2}, LiqCp = {16,17987,-72.539,10.794,0.0063056,-0.0000049607}, HOV = {106,6.763E+07,1.0666,-1.0647,0.39633,0.019258}, VapCp = {16,63931,-772.15,13.468,-0.00038098,7.7306E-08}, LiqVis = {101,-37.877,3012.8,3.7501,0.0000021994,2}, VapVis = {102,5.3484E-08,0.89115,65.345,-657.26,0}, LiqK = {16,0.11507,-853.65,4.7946,-0.021722,0.0000091954}, VapK = {102,-1104.9,-0.018396,479160,-8.1392E+09,0}, Racketparam = 0.23, UniquacR = 4.07, UniquacQ = 3.11, ChaoSeadAF = 0.445, ChaoSeadSP = 20139.4, ChaoSeadLV = 0.104167);
  end Cyclohexanone;
  
  model Cyclohexane
  extends General_Properties(
    SN = 129, name = "Cyclohexane", CAS = "110-82-7", Tc = 553.5, Pc = 4073000,  Vc = 0.308, Cc = 0.273, Tb = 353.93, Tm = 279.69, TT = 279.69, TP = 5362.51, MW = 84.161, LVB = 0.10875, AF = 0.211, SP = 16740, DM = 0, SH = -168070000.0, IGHF = -1.233E+08, GEF = 3.191E+07, AS = 297276, HFMP = 2740000, HOC = -3.656E+09, LiqDen = {105,0.93459,0.28022,553.5,0.29409,0}, VP = {101,79.82965,-6246.688,-8.778766,6.933726E-06,2}, LiqCp = {16,116110,127.67,6.7654,0.01311,-0.0000060013}, HOV = {106,4.4856E+07,0.35691,0.26181,-0.47647,0.25741}, VapCp = {16,42569,-588.9,12.962,0.00028376,-1.4009E-07}, LiqVis = {101,-132.2852,5905.41,18.88092,-0.000023942,2}, VapVis = {102,6.7726E-08,0.83665,36.786,-20.301,0}, LiqK = {16,0.073881,-301.5,0.30119,-0.0068406,-0.0000028646}, VapK = {102,8.5865E-07,1.771,243.16,-9.1779,0}, Racketparam = 0.2729, UniquacR = 4.0464, UniquacQ = 3.24, ChaoSeadAF = 0.2032, ChaoSeadSP = 16773.1, ChaoSeadLV = 0.1087);
  end Cyclohexane;
  
  model Onehexene
  extends General_Properties(
    SN = 130, name = "Onehexene", CAS = "592-41-6", Tc = 504, Pc = 3143000,  Vc = 0.3551, Cc = 0.266, Tb = 336.63, Tm = 133.39, TT = 133.39, TP = 0.000516, MW = 84.161, LVB = 0.1259, AF = 0.281, SP = 15130, DM = 1.5E-30, SH = -168070000.0, IGHF = -4.167E+07, GEF = 8.7E+07, AS = 386300, HFMP = 9347000, HOC = -3.7397E+09, LiqDen = {105,0.42588,0.20073,504,0.21659,0}, VP = {101,61.18966,-5302.032,-5.914346,4.387106E-06,2}, LiqCp = {16,120740,197.35,7.4671,0.012038,-0.0000076352}, HOV = {106,4.3654E+07,0.036065,1.7176,-2.6805,1.3349}, VapCp = {16,79063,-588.63,12.822,0.00010837,-3.9549E-08}, LiqVis = {101,-10.027,774.41,-0.14562,-2.993E-08,2}, VapVis = {102,7.708E-08,0.81478,53.202,774.03,0}, LiqK = {16,0.049094,18.334,-2.2175,0.0015607,-0.000010695}, VapK = {102,0.000064257,1.1355,445.14,64830,0}, Racketparam = 0, UniquacR = 4.27, UniquacQ = 3.64, ChaoSeadAF = 0.2463, ChaoSeadSP = 15136.7, ChaoSeadLV = 0.1258);
  end Onehexene;
  
  model Methylcyclopentane
  extends General_Properties(
    SN = 131, name = "Methylcyclopentane", CAS = "96-37-7", Tc = 532.79, Pc = 3784000,  Vc = 0.319, Cc = 0.272, Tb = 344.98, Tm = 130.73, TT = 130.73, TP = 0.000224525, MW = 84.161, LVB = 0.11313, AF = 0.227, SP = 16100, DM = 0, SH = -168070000.0, IGHF = -1.062E+08, GEF = 3.63E+07, AS = 339900, HFMP = 6929000, HOC = -3.6741E+09, LiqDen = {105,0.63455,0.23477,532.79,0.24394,0}, VP = {101,63.18203,-5470.368,-6.215132,4.384737E-06,2}, LiqCp = {16,102830,317.53,4.999,0.022368,-0.000020298}, HOV = {106,4.986429E+07,0.75425,-0.186227,-0.50621,0.35999}, VapCp = {16,55624,-676.34,13.207,-0.0001363,2.6321E-08}, LiqVis = {101,-9.2288,846.65,-0.18612,-0.0000022383,2}, VapVis = {102,0.0000009078,0.495,355.78,10.622,0}, LiqK = {16,-0.040815,4.4808,-1.5434,-0.00050494,-0.0000017671}, VapK = {102,0.0076653,0.48521,479.72,658190,0}, Racketparam = 0, UniquacR = 3.97, UniquacQ = 3.01, ChaoSeadAF = 0.2346, ChaoSeadSP = 16057.17, ChaoSeadLV = 0.1131);
  end Methylcyclopentane;
  
  model Cyclohexanol
  extends General_Properties(
    SN = 132, name = "Cyclohexanol", CAS = "108-93-0", Tc = 650.1, Pc = 4260000,  Vc = 0.322, Cc = 0.254, Tb = 434, Tm = 296.6, TT = 296.6, TP = 76.4997, MW = 100.159, LVB = 0.105751, AF = 0.369047, SP = 23730, DM = 6.2E-30, SH = -168070000.0, IGHF = -2.862E+08, GEF = -1.095E+08, AS = 327700, HFMP = 1783000, HOC = -3.4639E+09, LiqDen = {105,0.90826,0.27716,650.1,0.30685,0}, VP = {101,-31.63718,-3989.985,9.013268,-0.0000126698,2}, LiqCp = {16,-69485,774.7,4.4167,0.025384,-0.000022994}, HOV = {106,7.128838E+07,0.392061,-2.168338,5.552036,-3.376933}, VapCp = {16,82477,-807.95,13.526,-0.00028702,2.5016E-08}, LiqVis = {101,-437.51,22529,63.787,-0.000049001,2}, VapVis = {102,8.1528E-08,0.83387,90.96,4936.6,0}, LiqK = {16,0.075187,-249.81,-0.16784,-0.0068233,0.0000026882}, VapK = {102,0.0030349,0.6097,669.35,478820,0}, Racketparam = 0.24, UniquacR = 4.27, UniquacQ = 3.51, ChaoSeadAF = 0.514148, ChaoSeadSP = 23672.2, ChaoSeadLV = 0.104294);
  end Cyclohexanol;
  
  model TwoTwodimethylbutane
  extends General_Properties(
    SN = 133, name = "TwoTwodimethylbutane", CAS = "75-83-2", Tc = 488.7, Pc = 3080000,  Vc = 0.3591, Cc = 0.272, Tb = 322.87, Tm = 174.28, TT = 174.28, TP = 4.0748, MW = 86.177, LVB = 0.13373, AF = 0.233, SP = 13770, DM = 0, SH = -168070000.0, IGHF = -1.8468E+08, GEF = -8745000, AS = 358340, HFMP = 579100, HOC = -3.8411E+09, LiqDen = {105,0.68727,0.26184,489.01,0.26217,0}, VP = {101,94.2252,-6117.857,-11.25759,0.0000123761,2}, LiqCp = {16,117360,-28.344,9.2143,0.0086854,-0.00000596}, HOV = {106,5.850808E+07,1.595989,-1.437803,0.0287957,0.293443}, VapCp = {16,73375,-521.55,12.775,0.00038975,-1.1854E-07}, LiqVis = {101,22.562,-455.85,-5.0804,-5.7101E-07,2}, VapVis = {102,1.9362E-07,0.68259,102.35,-10.082,0}, LiqK = {16,-0.038291,4.8824,-1.6311,-0.00047294,-0.0000023877}, VapK = {102,0.00018521,0.9549,83.825,174320,0}, Racketparam = 0, UniquacR = 4.4983, UniquacQ = 3.932, ChaoSeadAF = 0.23385, ChaoSeadSP = 13771.5, ChaoSeadLV = 0.133712);
  end TwoTwodimethylbutane;
  
  model TwoThreedimethylbutane
  extends General_Properties(
    SN = 134, name = "TwoThreedimethylbutane", CAS = "79-29-8", Tc = 499.9, Pc = 3130000,  Vc = 0.3576, Cc = 0.269, Tb = 331.12, Tm = 145.19, TT = 145.19, TP = 0.0152127, MW = 86.177, LVB = 0.13117, AF = 0.248, SP = 14300, DM = 0, SH = -168070000.0, IGHF = -1.768E+08, GEF = -3125000, AS = 365920, HFMP = 799100, HOC = -3.84761E+09, LiqDen = {105,0.67999,0.25932,500.01,0.25836,0}, VP = {101,76.80058,-5679.218,-8.443302,7.93783E-06,2}, LiqCp = {16,126350,-53.429,8.8794,0.010279,-0.0000080841}, HOV = {106,4.7443E+07,0.91932,-0.91329,0.50392,-0.089442}, VapCp = {16,46722,-391.59,12.599,0.00056088,-1.7583E-07}, LiqVis = {101,6.9204,231.1,-2.7393,-1.3079E-07,2}, VapVis = {102,6.8449E-07,0.52371,291.92,-3199.1,0}, LiqK = {16,-0.05308,-5.5491,-1.4118,-0.0011735,-7.4229E-07}, VapK = {102,0.000032078,1.1749,-107.52,129270,0}, Racketparam = 0.2694, UniquacR = 4.4982, UniquacQ = 3.848, ChaoSeadAF = 0.24754, ChaoSeadSP = 14352.8, ChaoSeadLV = 0.13105);
  end TwoThreedimethylbutane;
  
  model Nhexane
  extends General_Properties(
    SN = 135, name = "Nhexane", CAS = "110-54-3", Tc = 507.6, Pc = 3025000,  Vc = 0.368, Cc = 0.264, Tb = 341.88, Tm = 177.83, TT = 177.83, TP = 0.901695, MW = 86.177, LVB = 0.13159, AF = 0.297, SP = 14870, DM = 0, SH = -168070000.0, IGHF = -1.6694E+08, GEF = -66340, AS = 388740, HFMP = 1.308E+07, HOC = -3.8551E+09, LiqDen = {105,0.55661,0.23506,507.6,0.24183,0}, VP = {101,71.56625,-5848.968,-7.46028,0.0000050823,2}, LiqCp = {16,155690,5.9137,7.3123,0.013809,-0.0000093814}, HOV = {106,4.086241E+07,-1.014854,4.97802,-6.266175,2.685532}, VapCp = {16,94649,-698.41,13.164,-0.00011992,2.9719E-08}, LiqVis = {101,-62.582,2308.7,8.5085,-0.000019741,2}, VapVis = {102,3.3843E-07,0.62082,239.17,-260.6,0}, LiqK = {16,-0.12682,-1.5015,-1.0467,-0.00088709,-9.3679E-07}, VapK = {102,-569.52,0.7943,-1.1379E+09,-8.2055E+09,0}, Racketparam = 0.2635, UniquacR = 4.4998, UniquacQ = 3.856, ChaoSeadAF = 0.2927, ChaoSeadSP = 14870.79, ChaoSeadLV = 0.1316);
  end Nhexane;
  
  model Twomethylpentane
  extends General_Properties(
    SN = 136, name = "Twomethylpentane", CAS = "107-83-5", Tc = 497.5, Pc = 3010000,  Vc = 0.3667, Cc = 0.267, Tb = 333.4, Tm = 119.55, TT = 119.55, TP = 0.0000206558, MW = 86.177, LVB = 0.13289, AF = 0.278, SP = 14400, DM = 0, SH = -168070000.0, IGHF = -1.7455E+08, GEF = -5338000, AS = 380890, HFMP = 6268000, HOC = -3.84915E+09, LiqDen = {105,0.657,0.25467,497.71,0.26808,0}, VP = {101,77.6873,-5802.911,-8.543267,7.871718E-06,2}, LiqCp = {16,137510,-55.266,8.2006,0.013273,-0.00001165}, HOV = {106,4.724E+07,0.784961,-0.571271,0.114935,0.0796185}, VapCp = {16,70761,-504.8,12.795,0.00029839,-9.4564E-08}, LiqVis = {101,-12.416,938.41,0.18259,4.2586E-07,2}, VapVis = {102,0.0000020458,0.38326,542.64,-1147.6,0}, LiqK = {16,-0.099248,3.6931,-1.2881,-0.00063949,-0.0000011122}, VapK = {102,0.000056887,1.0953,-66.761,139530,0}, Racketparam = 0.2581, UniquacR = 4.499, UniquacQ = 3.852, ChaoSeadAF = 0.2791, ChaoSeadSP = 14417.6, ChaoSeadLV = 0.132931);
  end Twomethylpentane;
  
  model Threemethylpentane
  extends General_Properties(
    SN = 137, name = "Threemethylpentane", CAS = "96-14-0", Tc = 504.4, Pc = 3120000,  Vc = 0.3667, Cc = 0.273, Tb = 336.4, Tm = 110.251, TT = 110.25, TP = 4.13745E-07, MW = 86.177, LVB = 0.13062, AF = 0.273, SP = 14680, DM = 0, SH = -168070000.0, IGHF = -1.72E+08, GEF = -3420000, AS = 383000, HFMP = 5303200, HOC = -3.85137E+09, LiqDen = {105,0.64191,0.2518,504.61,0.25114,0}, VP = {101,103.3869,-6792.289,-12.56583,0.0000127267,2}, LiqCp = {16,124870,37.47,8.4986,0.010489,-0.0000074005}, HOV = {106,5.261039E+07,1.021512,-0.656827,-0.222599,0.294618}, VapCp = {16,66323,-479.35,12.713,0.00041058,-1.3725E-07}, LiqVis = {101,-4.4466,561.39,-0.97496,-4.1525E-07,2}, VapVis = {102,0.0000014857,0.42502,455.77,119.73,0}, LiqK = {16,0.013685,32.912,-2.24,0.00097964,-0.0000056292}, VapK = {102,0.000050178,1.1143,-67.556,138050,0}, Racketparam = 0.2575, UniquacR = 4.499, UniquacQ = 3.852, ChaoSeadAF = 0.275, ChaoSeadSP = 14871.5, ChaoSeadLV = 0.130633);
  end Threemethylpentane;
  
  model Triethyleneglycol
  extends General_Properties(
    SN = 138, name = "Triethyleneglycol", CAS = "112-27-6", Tc = 769.5, Pc = 3320000,  Vc = 0.443, Cc = 0.23, Tb = 561.5, Tm = 265.95, TT = 265.95, TP = 0.000327262, MW = 150.173, LVB = 0.134127, AF = 0.755952, SP = 25710, DM = 9.97E-30, SH = -168070000.0, IGHF = -7.251E+08, GEF = -4.86E+08, AS = 556500, HFMP = 1.82E+07, HOC = -3.2498E+09, LiqDen = {105,0.60697,0.26444,769.5,0.24805,0}, VP = {101,-148.0973,-1446.895,26.95817,-0.0000266538,2}, LiqCp = {16,234210,-89.741,10.328,0.0058089,-0.0000030565}, HOV = {106,1.392895E+08,1.422819,-1.625802,1.207667,-0.563316}, VapCp = {16,88442,-417.2,12.845,0.00037163,-1.3999E-07}, LiqVis = {101,-354.9911,16471.68,54.55389,-0.0481353,1}, VapVis = {102,8.2508E-08,0.8077,134.01,-6653.4,0}, LiqK = {16,-0.089806,0.43077,-1.6802,0.0024003,-0.0000033612}, VapK = {102,0.0000048035,1.4025,164.43,15114,0}, Racketparam = 0.224225, UniquacR = 6.5342, UniquacQ = 6.12, ChaoSeadAF = 0.758714, ChaoSeadSP = 23437.3, ChaoSeadLV = 0.134187);
  end Triethyleneglycol;
  
  model Triethylamine
  extends General_Properties(
    SN = 139, name = "Triethylamine", CAS = "121-44-8", Tc = 535, Pc = 3000000,  Vc = 0.39, Cc = 0.263, Tb = 362.9, Tm = 158.45, TT = 158.45, TP = 0.0106462, MW = 101.192, LVB = 0.13996, AF = 0.316193, SP = 15170, DM = 2.2E-30, SH = -168070000.0, IGHF = -9.58E+07, GEF = 1.141E+08, AS = 405400, HFMP = 8520000, HOC = -4.0405E+09, LiqDen = {105,0.74443,0.28147,535,0.29639,0}, VP = {101,109.5632,-7670.939,-13.23524,8.526035E-06,2}, LiqCp = {16,-68176,-83.963,12.887,-0.00053012,0.0000014554}, HOV = {106,5.6361E+07,1.8179,-4.3508,5.0206,-2.0828}, VapCp = {16,118700,-798.83,13.439,-0.00026576,5.0253E-08}, LiqVis = {101,-8.1405,722.62,-0.37234,-0.0000014417,2}, VapVis = {102,3.6298E-07,0.63337,296.37,-2057.9,0}, LiqK = {16,-0.073124,-11.318,-1.1721,-0.001404,-1.7908E-07}, VapK = {102,0.00013191,0.98598,87.622,150050,0}, Racketparam = 0.262814, UniquacR = 5.01, UniquacQ = 4.26, ChaoSeadAF = 0.316157, ChaoSeadSP = 15176.2, ChaoSeadLV = 0.139672);
  end Triethylamine;
  
  model Toluene
  extends General_Properties(
    SN = 140, name = "Toluene", CAS = "108-88-3", Tc = 591.75, Pc = 4108000,  Vc = 0.316, Cc = 0.264, Tb = 383.79, Tm = 178.18, TT = 178.18, TP = 0.0475285, MW = 92.141, LVB = 0.10687, AF = 0.264, SP = 18250, DM = 1.2E-30, SH = -168070000.0, IGHF = 5.017E+07, GEF = 1.222E+08, AS = 320990, HFMP = 6636000, HOC = -3.734E+09, LiqDen = {105,0.89799,0.27359,591.75,0.30006,0}, VP = {101,32.89891,-5013.81,-1.348918,-1.869928E-06,2}, LiqCp = {16,28291,48.171,10.912,0.0020542,8.7875E-07}, HOV = {106,5.3752E+07,0.50341,0.24755,-0.72898,0.37794}, VapCp = {16,47225,-565.85,12.856,0.000005535,-1.998E-08}, LiqVis = {101,-152.84,5644.6,22.826,-0.000040987,2}, VapVis = {102,8.5581E-07,0.49514,307.82,1891.6,0}, LiqK = {16,-0.072922,-23.153,-1.0277,-0.0017074,3.6787E-07}, VapK = {102,0.000006541,1.4227,190.97,21890,0}, Racketparam = 0.2646, UniquacR = 3.9228, UniquacQ = 2.968, ChaoSeadAF = 0.2591, ChaoSeadSP = 18245.86, ChaoSeadLV = 0.1068);
  end Toluene;
  
  model Mcresol
  extends General_Properties(
    SN = 141, name = "Mcresol", CAS = "108-39-4", Tc = 705.7, Pc = 4560000,  Vc = 0.312, Cc = 0.241, Tb = 475.38, Tm = 285.39, TT = 285.39, TP = 5.86242, MW = 108.14, LVB = 0.10499, AF = 0.452, SP = 23900, DM = 5.3E-30, SH = -168070000.0, IGHF = -1.323E+08, GEF = -4.019E+07, AS = 356040, HFMP = 1.0707E+07, HOC = -3.52783E+09, LiqDen = {105,0.76595,0.25907,705.86,0.2605,0}, VP = {101,143.16,-12586,-17.327,0.0000073113,2}, LiqCp = {16,62676,-205.39,12.221,0.0027125,-0.0000038975}, HOV = {106,9.4557E+07,0.36419,1.602,-2.5634,1.0947}, VapCp = {16,58129,-537.86,12.936,-0.000090368,1.797E-08}, LiqVis = {101,-1098.989,45628.63,168.1502,-0.000185183,2}, VapVis = {102,1.4432E-07,0.74376,166.32,-45.138,0}, LiqK = {16,0.10478,-476.78,0.8844,-0.0090128,0.0000031516}, VapK = {102,0.00016795,0.9362,585.89,24552,0}, Racketparam = 0.241, UniquacR = 4.7567, UniquacQ = 3.888, ChaoSeadAF = 0.45, ChaoSeadSP = 24080.3, ChaoSeadLV = 0.104996);
  end Mcresol;
  
  model Ocresol
  extends General_Properties(
    SN = 142, name = "Ocresol", CAS = "95-48-7", Tc = 697.6, Pc = 5000000,  Vc = 0.282, Cc = 0.243, Tb = 464.17, Tm = 304.19, TT = 304.19, TP = 65.3261, MW = 108.14, LVB = 0.10364, AF = 0.435, SP = 22870, DM = 4.84E-30, SH = -168070000.0, IGHF = -1.2857E+08, GEF = -3.543E+07, AS = 352590, HFMP = 1.582E+07, HOC = -3.528E+09, LiqDen = {105,1.1115,0.30952,697.6,0.31161,0}, VP = {101,140.51,-11819,-17.163,0.0000087043,2}, LiqCp = {16,146600,-116.23,11.009,0.0034596,-0.0000033446}, HOV = {106,9.9721E+07,1.0333,0.08043,-1.2193,0.58124}, VapCp = {16,64367,-535.92,12.871,-0.000033383,-2.2759E-09}, LiqVis = {101,-455.0775,20670.83,67.87773,-0.0000660983,2}, VapVis = {102,8.7371E-08,0.80775,98.538,-0.0034513,0}, LiqK = {16,0.065471,92.351,-2.8415,0.0012245,-0.0000029956}, VapK = {102,0.00018648,0.9302,709.37,-0.0036596,0}, Racketparam = 0, UniquacR = 4.7567, UniquacQ = 3.888, ChaoSeadAF = 0.433455, ChaoSeadSP = 23397.9, ChaoSeadLV = 0.104368);
  end Ocresol;
  
  model Pcresol
  extends General_Properties(
    SN = 143, name = "Pcresol", CAS = "106-44-5", Tc = 704.5, Pc = 5150000,  Vc = 0.277, Cc = 0.244, Tb = 475.12, Tm = 307.93, TT = 307.93, TP = 34.4658, MW = 108.14, LVB = 0.105, AF = 0.51, SP = 24030, DM = 5.2E-30, SH = -168070000.0, IGHF = -1.2535E+08, GEF = -3.166E+07, AS = 350750, HFMP = 1.2707E+07, HOC = -3.52256E+09, LiqDen = {105,0.94818,0.2877,704.66,0.2873,0}, VP = {101,236.9207,-17215.31,-31.28645,0.0000163766,2}, LiqCp = {16,142400,625.27,3.2944,0.02818,-0.000027958}, HOV = {106,1.3617E+08,1.404,0.8091,-3.6055,2.0268}, VapCp = {16,58748,-529.02,12.887,-0.0000351,-1.6131E-09}, LiqVis = {101,-820.7853,35522.87,124.3969,-0.000127538,2}, VapVis = {102,1.4308E-07,0.74508,159.9,-24.834,0}, LiqK = {16,0.061771,-123.88,-1.1823,-0.0033339,0.0000010151}, VapK = {102,0.00016735,0.93839,592.49,25704,0}, Racketparam = 0, UniquacR = 4.7567, UniquacQ = 3.888, ChaoSeadAF = 0.508, ChaoSeadSP = 23827.4, ChaoSeadLV = 0.104957);
  end Pcresol;
  
  model Methylcyclohexane
  extends General_Properties(
    SN = 144, name = "Methylcyclohexane", CAS = "108-87-2", Tc = 572.19, Pc = 3471000,  Vc = 0.368, Cc = 0.268, Tb = 374.09, Tm = 146.58, TT = 146.58, TP = 0.000152251, MW = 98.188, LVB = 0.12835, AF = 0.235, SP = 16060, DM = 0, SH = -168070000.0, IGHF = -1.548E+08, GEF = 2.733E+07, AS = 343300, HFMP = 6751000, HOC = -4.25714E+09, LiqDen = {105,0.54994,0.23476,572.19,0.25237,0}, VP = {101,84.02524,-6720.084,-9.367446,6.892527E-06,2}, LiqCp = {16,121540,-7.0302,8.197,0.012761,-0.000010388}, HOV = {106,5.3741E+07,0.65698,0.0050875,-0.53082,0.29149}, VapCp = {16,82902,-804.58,13.697,-0.00042977,1.1051E-07}, LiqVis = {101,-11.411,1214.3,0.0090457,-0.0000000327,2}, VapVis = {102,6.5256E-07,0.52942,310.39,23.825,0}, LiqK = {16,0.035771,-249.64,0.10904,-0.0066567,0.0000013937}, VapK = {102,0.000074754,1.119,613.15,22882,0}, Racketparam = 0.2699, UniquacR = 4.72, UniquacQ = 3.776, ChaoSeadAF = 0.2421, ChaoSeadSP = 16016.26, ChaoSeadLV = 0.1283);
  end Methylcyclohexane;
  
  model Ethylcyclopentane
  extends General_Properties(
    SN = 145, name = "Ethylcyclopentane", CAS = "1640-89-7", Tc = 569.5, Pc = 3397000,  Vc = 0.375, Cc = 0.269, Tb = 376.59, Tm = 134.71, TT = 134.71, TP = 3.71437E-06, MW = 98.188, LVB = 0.12883, AF = 0.27, SP = 16250, DM = 0, SH = -168070000.0, IGHF = -1.269E+08, GEF = 4.48E+07, AS = 378300, HFMP = 6869700, HOC = -4.2839E+09, LiqDen = {105,0.72259,0.26996,569.5,0.2784,0}, VP = {101,95.769,-7366.4,-11.099,0.0000081014,2}, LiqCp = {16,128880,403.43,3.1567,0.031507,-0.000033176}, HOV = {106,5.78221E+07,0.856257,-0.338119,-0.391894,0.299953}, VapCp = {16,61352,-623.48,13.275,-0.000068613,9.3089E-09}, LiqVis = {101,-3.6105,709.69,-1.12,8.8328E-07,2}, VapVis = {102,0.0000021783,0.38064,577.64,269.9,0}, LiqK = {16,-0.019932,6.51,-1.7114,-0.0004148,-0.0000019629}, VapK = {102,0.0047981,0.52948,335.74,590020,0}, Racketparam = 0, UniquacR = 4.72, UniquacQ = 3.776, ChaoSeadAF = 0.271548, ChaoSeadSP = 16339.4, ChaoSeadLV = 0.128749);
  end Ethylcyclopentane;
  
  model Oneheptene
  extends General_Properties(
    SN = 146, name = "Oneheptene", CAS = "592-76-7", Tc = 537.3, Pc = 2920000,  Vc = 0.409, Cc = 0.267, Tb = 366.79, Tm = 154.12, TT = 154.12, TP = 0.00186, MW = 98.188, LVB = 0.14177, AF = 0.343, SP = 15310, DM = 2.1E-30, SH = -168070000.0, IGHF = -6.289E+07, GEF = 9.482E+07, AS = 425200, HFMP = 1.264E+07, HOC = -4.3499E+09, LiqDen = {105,0.26107,0.16952,537.3,0.1874,0}, VP = {101,109.9184,-7605.67,-13.43227,0.0000123163,2}, LiqCp = {16,58419,89.259,10.549,0.0039271,-8.6181E-07}, HOV = {106,5.631368E+07,1.145386,-1.731438,1.615943,-0.650835}, VapCp = {16,94067,-609.56,13.043,0.000046316,-2.1105E-08}, LiqVis = {101,-10.29,827.04,-0.087144,0.0000001052,2}, VapVis = {102,7.4687E-08,0.81173,52.725,1460.7,0}, LiqK = {16,-0.038053,-34.158,-1.0057,-0.0023353,-3.7702E-08}, VapK = {102,0.000013676,1.341,365.19,6251.8,0}, Racketparam = 0.260462, UniquacR = 4.9441, UniquacQ = 4.184, ChaoSeadAF = 0.358, ChaoSeadSP = 15313.2, ChaoSeadLV = 0.141709);
  end Oneheptene;
  
  model Nheptane
  extends General_Properties(
    SN = 147, name = "Nheptane", CAS = "142-82-5", Tc = 540.2, Pc = 2740000,  Vc = 0.428, Cc = 0.261, Tb = 371.57, Tm = 182.57, TT = 182.57, TP = 0.182694, MW = 100.204, LVB = 0.14747, AF = 0.35, SP = 15240, DM = 0, SH = -168070000.0, IGHF = -1.8765E+08, GEF = 8165000, AS = 427980, HFMP = 1.405E+07, HOC = -4.46473E+09, LiqDen = {105,0.57043,0.25304,540.2,0.27335,0}, VP = {101,89.80457,-7084.845,-10.17918,7.441708E-06,2}, LiqCp = {16,134750,14.937,10.603,0.001438,0.0000036711}, HOV = {106,4.275764E+07,-1.051245,4.601706,-5.558946,2.369496}, VapCp = {16,109310,-704.2,13.352,-0.00017922,4.6992E-08}, LiqVis = {101,-61.08861,2532.297,8.091665,-0.0000152585,2}, VapVis = {102,2.6134E-08,0.948,-37.497,9005.3,0}, LiqK = {16,0.083657,49.111,-3.4536,0.0077989,-0.000025112}, VapK = {102,-0.076333,0.38025,-7539.9,-2646800,0}, Racketparam = 0.2611, UniquacR = 5.1742, UniquacQ = 4.396, ChaoSeadAF = 0.3403, ChaoSeadSP = 15230, ChaoSeadLV = 0.1475);
  end Nheptane;
  
  model Styrene
  extends General_Properties(
    SN = 148, name = "Styrene", CAS = "100-42-5", Tc = 636, Pc = 3840000,  Vc = 0.352, Cc = 0.256, Tb = 418.31, Tm = 242.54, TT = 242.54, TP = 10.6132, MW = 104.149, LVB = 0.115667, AF = 0.297097, SP = 19020, DM = 4.33E-31, SH = -168070000.0, IGHF = 1.474E+08, GEF = 2.139E+08, AS = 345100, HFMP = 1.095E+07, HOC = -4.219E+09, LiqDen = {105,0.57789,0.23139,640.77,0.26351,0}, VP = {101,399.8489,-19017.34,-58.96286,0.0000747957,2}, LiqCp = {16,134310,-99.916,9.4935,0.0058294,-0.0000013972}, HOV = {106,1.110621E+08,3.429275,-6.061051,4.605581,-1.408226}, VapCp = {16,57806.72,-550.4249,12.95376,-0.0000950882,2.294759E-08}, LiqVis = {101,-24.717,1824,1.9977,-4.7933E-07,2}, VapVis = {102,3.6968E-08,0.90482,-32.023,10027,0}, LiqK = {16,-0.071817,-30.013,-1.0262,-0.0015623,2.7674E-07}, VapK = {102,0.010229,0.40085,535.56,704200,0}, Racketparam = 0, UniquacR = 4.37, UniquacQ = 3.3, ChaoSeadAF = 0.2302, ChaoSeadSP = 19015.9, ChaoSeadLV = 0.115667);
  end Styrene;
  
  model Ethylbenzene
  extends General_Properties(
    SN = 149, name = "Ethylbenzene", CAS = "100-41-4", Tc = 617.15, Pc = 3609000,  Vc = 0.374, Cc = 0.263, Tb = 409.36, Tm = 178.2, TT = 178.2, TP = 0.00390778, MW = 106.167, LVB = 0.12308, AF = 0.304, SP = 17980, DM = 2.0E-30, SH = -168070000.0, IGHF = 2.992E+07, GEF = 1.3073E+08, AS = 360630, HFMP = 9180300, HOC = -4.3448E+09, LiqDen = {105,0.66155,0.25394,617.21,0.27883,0}, VP = {101,137.5088,-9745.069,-17.34457,0.0000127987,2}, LiqCp = {16,131820,-90.983,10.031,0.0026504,0.0000033965}, HOV = {106,5.990732E+07,0.380483,1.094304,-2.185536,1.1369}, VapCp = {16,65434,-619.34,13.166,-0.00016412,4.1529E-08}, LiqVis = {101,-14.506,1237.2,0.52859,-9.1363E-08,2}, VapVis = {102,0.0000016833,0.39831,366.45,23750,0}, LiqK = {16,-0.026087,13.301,-1.6623,-0.00027844,-0.0000018214}, VapK = {102,0.000015932,1.3226,486.47,14367,0}, Racketparam = 0, UniquacR = 4.6, UniquacQ = 3.51, ChaoSeadAF = 0.2936, ChaoSeadSP = 17979.95, ChaoSeadLV = 0.1231);
  end Ethylbenzene;
  
  model Mxylene
  extends General_Properties(
    SN = 150, name = "Mxylene", CAS = "108-38-3", Tc = 617, Pc = 3541000,  Vc = 0.375, Cc = 0.259, Tb = 412.34, Tm = 225.3, TT = 225.3, TP = 3.18019, MW = 106.167, LVB = 0.12347, AF = 0.327, SP = 18050, DM = 1.0E-30, SH = -168070000.0, IGHF = 1.732E+07, GEF = 1.1876E+08, AS = 358540, HFMP = 1.157E+07, HOC = -4.3318E+09, LiqDen = {105,0.68902,0.26086,617,0.27479,0}, VP = {101,97.968,-8164.7,-11.269,0.0000072101,2}, LiqCp = {16,127090,-62.999,9.3762,0.0068549,-0.0000032778}, HOV = {106,5.9562E+07,0.67841,-0.38938,0.0061115,0.10219}, VapCp = {16,62092,-572.21,12.975,0.000062577,-3.7811E-08}, LiqVis = {101,-13.362,1141.4,0.37182,-3.9423E-07,2}, VapVis = {102,7.2954E-08,0.8097,14.386,8844.3,0}, LiqK = {16,-0.021158,-27.324,-1.2663,-0.0016664,-3.6744E-07}, VapK = {102,2.8001E-09,2.4298,-575.12,122260,0}, Racketparam = 0.2593, UniquacR = 4.66, UniquacQ = 3.54, ChaoSeadAF = 0.3045, ChaoSeadSP = 18041.31, ChaoSeadLV = 0.1235);
  end Mxylene;
  
  model Oxylene
  extends General_Properties(
    SN = 151, name = "Oxylene", CAS = "95-47-6", Tc = 630.3, Pc = 3732000,  Vc = 0.37, Cc = 0.263, Tb = 417.59, Tm = 247.98, TT = 247.98, TP = 21.842, MW = 106.167, LVB = 0.12125, AF = 0.312, SP = 18390, DM = 2.1E-30, SH = -168070000.0, IGHF = 1.908E+07, GEF = 1.22E+08, AS = 353830, HFMP = 1.36E+07, HOC = -4.333E+09, LiqDen = {105,0.69962,0.26143,630.3,0.27365,0}, VP = {101,88.08217,-7844.793,-9.738423,5.713756E-06,2}, LiqCp = {16,134490,-170.61,10.247,0.0049096,-0.0000031727}, HOV = {106,6.6979E+07,1.259,-1.849,1.5198,-0.50455}, VapCp = {16,73986,-589.13,12.936,0.000080122,-4.5074E-08}, LiqVis = {101,-11.059,1251.7,-0.076438,0.000001254,2}, VapVis = {102,6.783E-08,0.82039,-1.2715,13072,0}, LiqK = {16,-0.018751,-22.77,-1.3391,-0.0014281,-6.1692E-07}, VapK = {102,0.0000059387,1.356,-206,65058,0}, Racketparam = 0.2633, UniquacR = 4.66, UniquacQ = 3.54, ChaoSeadAF = 0.2904, ChaoSeadSP = 18389.04, ChaoSeadLV = 0.1212);
  end Oxylene;
  
  model Pxylene
  extends General_Properties(
    SN = 152, name = "Pxylene", CAS = "106-42-3", Tc = 616.2, Pc = 3511000,  Vc = 0.378, Cc = 0.259, Tb = 411.53, Tm = 286.41, TT = 286.41, TP = 575.533, MW = 106.167, LVB = 0.12393, AF = 0.322, SP = 17910, DM = 0, SH = -168070000.0, IGHF = 1.803E+07, GEF = 1.214E+08, AS = 352165, HFMP = 1.711E+07, HOC = -4.333E+09, LiqDen = {105,0.67752,0.25887,616.2,0.27596,0}, VP = {101,97.352,-8082.1,-11.197,0.0000072605,2}, LiqCp = {16,63084,-343.38,13.438,-0.0033851,0.0000045592}, HOV = {106,5.6332E+07,0.37965,0.42395,-0.85683,0.43704}, VapCp = {16,62397,-585.6,13.025,0.0000037921,-1.7044E-08}, LiqVis = {101,-23.916,1499.8,2.0719,-0.0000037065,2}, VapVis = {102,2.4281E-08,0.95421,-91.329,17547,0}, LiqK = {16,0.00066881,-122.94,-0.60875,-0.0037322,9.7446E-07}, VapK = {102,0.0000001261,1.8916,-453.43,111720,0}, Racketparam = 0.2589, UniquacR = 4.66, UniquacQ = 3.54, ChaoSeadAF = 0.2969, ChaoSeadSP = 17939.04, ChaoSeadLV = 0.124);
  end Pxylene;
  
  model Ethylcyclohexane
  extends General_Properties(
    SN = 153, name = "Ethylcyclohexane", CAS = "1678-91-7", Tc = 609.15, Pc = 3040000,  Vc = 0.43, Cc = 0.258, Tb = 404.945, Tm = 161.839, TT = 161.839, TP = 0.000357389, MW = 112.213, LVB = 0.143036, AF = 0.245525, SP = 16340, DM = 0, SH = -168070000.0, IGHF = -1.715E+08, GEF = 3.955E+07, AS = 382600, HFMP = 8334100, HOC = -4.87051E+09, LiqDen = {105,0.61774,0.26525,609.15,0.28064,0}, VP = {101,80.60435,-7221.846,-8.661516,4.619539E-06,2}, LiqCp = {16,106540,50.724,9.3758,0.0085193,-0.0000058679}, HOV = {106,6.1066E+07,1.1095,-1.6401,1.5232,-0.54256}, VapCp = {16,99579,-799.66,13.811,-0.00043634,1.1487E-07}, LiqVis = {101,-22.531,1686,1.7093,-0.0000001282,2}, VapVis = {102,4.2871E-07,0.57053,258.88,-2237.2,0}, LiqK = {16,-0.040212,3.9673,-1.6044,-0.00049691,-0.0000012623}, VapK = {102,0.000062751,1.1219,488.85,45648,0}, Racketparam = 0, UniquacR = 5.3944, UniquacQ = 4.316, ChaoSeadAF = 0.2426, ChaoSeadSP = 16360, ChaoSeadLV = 0.143117);
  end Ethylcyclohexane;
  
  model Npropylcyclopentane
  extends General_Properties(
    SN = 154, name = "Npropylcyclopentane", CAS = "2040-96-2", Tc = 596, Pc = 3020000,  Vc = 0.428, Cc = 0.261, Tb = 404.11, Tm = 155.81, TT = 155.81, TP = 0.0000458874, MW = 112.213, LVB = 0.145193, AF = 0.326642, SP = 16360, DM = 0, SH = -168070000.0, IGHF = -1.481E+08, GEF = 5.344E+07, AS = 414500, HFMP = 1.003E+07, HOC = -4.89356E+09, LiqDen = {105,0.63061,0.26934,596,0.28169,0}, VP = {101,95.39512,-7846.538,-10.93845,7.332031E-06,2}, LiqCp = {16,121270,281.76,6.7151,0.017545,-0.000016082}, HOV = {106,7.088104E+07,1.477689,-1.919309,1.219865,-0.332624}, VapCp = {16,82387,-676.01,13.514,-0.00019546,4.9854E-08}, LiqVis = {101,-22.725,1601.8,1.7512,2.3108E-07,2}, VapVis = {102,0.0000028167,0.32978,562.31,4948.1,0}, LiqK = {16,-0.033741,2.5308,-1.6237,-0.00058186,-0.0000013118}, VapK = {102,0.000098309,1.0636,611.41,33175,0}, Racketparam = 0, UniquacR = 5.3944, UniquacQ = 4.316, ChaoSeadAF = 0.27189, ChaoSeadSP = 16393.5, ChaoSeadLV = 0.145193);
  end Npropylcyclopentane;
  
  model Noctane
  extends General_Properties(
    SN = 155, name = "Noctane", CAS = "111-65-9", Tc = 568.7, Pc = 2490000,  Vc = 0.492, Cc = 0.259, Tb = 398.82, Tm = 216.38, TT = 216.38, TP = 2.1083, MW = 114.231, LVB = 0.16353, AF = 0.397, SP = 15490, DM = 0, SH = -168070000.0, IGHF = -2.0875E+08, GEF = 1.6E+07, AS = 467230, HFMP = 2.074E+07, HOC = -5.07415E+09, LiqDen = {105,0.4436,0.23818,568.77,0.25171,0}, VP = {101,87.46069,-7578.199,-9.657211,5.664818E-06,2}, LiqCp = {16,184080,362.58,6.1268,0.015908,-0.000010697}, HOV = {106,6.509104E+07,0.906328,-0.61829,0.0251605,0.114898}, VapCp = {16,123360,-700.1,13.486,-0.00019118,4.5401E-08}, LiqVis = {101,-67.06275,2937.699,8.939458,-0.0000146474,2}, VapVis = {102,7.2215E-09,1.1166,-127.08,17623,0}, LiqK = {16,-0.03316,17.841,-1.6367,-0.000047737,-0.0000026501}, VapK = {102,-8968.5,0.84408,-2.7564E+10,-6.5097E+10,0}, Racketparam = 0.2567, UniquacR = 5.8486, UniquacQ = 4.936, ChaoSeadAF = 0.3992, ChaoSeadSP = 15445.57, ChaoSeadLV = 0.163455);
  end Noctane;
  
  model TwoTwoThreetrimethylpentane
  extends General_Properties(
    SN = 156, name = "TwoTwoThreetrimethylpentane", CAS = "564-02-3", Tc = 563.4, Pc = 2730000,  Vc = 0.436, Cc = 0.254, Tb = 382.99, Tm = 160.89, TT = 160.89, TP = 0.0021759, MW = 114.231, LVB = 0.16043, AF = 0.298, SP = 14690, DM = 0, SH = -168070000.0, IGHF = -2.1995E+08, GEF = 1.7726E+07, AS = 423880, HFMP = 8619000, HOC = -5.06754E+09, LiqDen = {105,0.53892,0.263,563.51,0.24185,0}, VP = {101,87.50671,-7031.238,-9.863302,7.128886E-06,2}, LiqCp = {16,170570,-194.18,8.4382,0.017272,-0.000019404}, HOV = {106,6.030131E+07,1.053957,-0.826185,0.00124096,0.214352}, VapCp = {16,45546,-344.09,12.853,0.00059243,-1.8071E-07}, LiqVis = {101,-8.9806,1118.5,-0.42179,0.000001606,2}, VapVis = {102,4.6777E-07,0.5509,223.7,10.797,0}, LiqK = {16,-0.050146,3.605,-1.5994,-0.00051269,-0.0000013443}, VapK = {102,0.000016836,1.25,-167.06,132290,0}, Racketparam = 0, UniquacR = 5.85, UniquacQ = 4.94, ChaoSeadAF = 0.2975, ChaoSeadSP = 14768.5, ChaoSeadLV = 0.160344);
  end TwoTwoThreetrimethylpentane;
  
  model TwoTwoFourtrimethylpentane
  extends General_Properties(
    SN = 157, name = "TwoTwoFourtrimethylpentane", CAS = "540-84-1", Tc = 543.9, Pc = 2570000,  Vc = 0.4697, Cc = 0.266, Tb = 372.39, Tm = 165.777, TT = 165.777, TP = 0.0170695, MW = 114.231, LVB = 0.16607, AF = 0.304, SP = 14080, DM = 0, SH = -168070000.0, IGHF = -2.2401E+08, GEF = 1.394E+07, AS = 422960, HFMP = 9196000, HOC = -5.06528E+09, LiqDen = {105,0.48523,0.24924,543.9,0.25602,0}, VP = {101,83.71044,-6701.601,-9.312194,6.808451E-06,2}, LiqCp = {16,159470,-380.54,12.372,-0.00044236,0.0000034887}, HOV = {106,4.633E+07,0.37451,-0.066775,-0.010135,0.080832}, VapCp = {16,84635,-470.35,13.011,0.00041124,-1.2926E-07}, LiqVis = {101,-22.241,1365.6,1.8379,-0.0000051189,2}, VapVis = {102,1.9933E-07,0.67222,163.02,-5306.3,0}, LiqK = {16,0.044744,-42.414,-1.7361,-0.0023225,-0.0000040597}, VapK = {102,0.000011401,1.3632,286.23,6065.2,0}, Racketparam = 0, UniquacR = 5.85, UniquacQ = 4.94, ChaoSeadAF = 0.3033, ChaoSeadSP = 14050.5, ChaoSeadLV = 0.165452);
  end TwoTwoFourtrimethylpentane;
  
  model TwoThreeThreetrimethylpentane
  extends General_Properties(
    SN = 158, name = "TwoThreeThreetrimethylpentane", CAS = "560-21-4", Tc = 573.5, Pc = 2820000,  Vc = 0.4551, Cc = 0.269, Tb = 387.92, Tm = 172.22, TT = 172.22, TP = 0.0168197, MW = 114.231, LVB = 0.15815, AF = 0.291, SP = 14920, DM = 0, SH = -168070000.0, IGHF = -2.1845E+08, GEF = 1.828E+07, AS = 427020, HFMP = 857720, HOC = -5.06876E+09, LiqDen = {105,0.56592,0.26622,573.5,0.26429,0}, VP = {101,82.87517,-6894.749,-9.15013,6.430758E-06,2}, LiqCp = {16,217000,82.075,1.8853,0.036678,-0.000031911}, HOV = {106,5.838161E+07,1.059379,-1.234692,0.816701,-0.225175}, VapCp = {16,48585,-365.95,12.926,0.00051631,-1.5846E-07}, LiqVis = {101,-10.941,1191.2,-0.045562,-0.0000023087,2}, VapVis = {102,8.2493E-07,0.49302,371.93,-89.774,0}, LiqK = {16,-0.040193,3.6823,-1.645,-0.00052834,-0.0000014091}, VapK = {102,0.000018829,1.2378,-181.1,146480,0}, Racketparam = 0, UniquacR = 5.85, UniquacQ = 4.94, ChaoSeadAF = 0.2903, ChaoSeadSP = 14919.5, ChaoSeadLV = 0.158155);
  end TwoThreeThreetrimethylpentane;
  
  model TwoThreeFourtrimethylpentane
  extends General_Properties(
    SN = 159, name = "TwoThreeFourtrimethylpentane", CAS = "565-75-3", Tc = 566.3, Pc = 2730000,  Vc = 0.4562, Cc = 0.267, Tb = 386.62, Tm = 163.95, TT = 163.95, TP = 0.00303425, MW = 114.231, LVB = 0.15974, AF = 0.316, SP = 14940, DM = 0, SH = -168070000.0, IGHF = -2.1732E+08, GEF = 1.9E+07, AS = 428400, HFMP = 9267560, HOC = -5.06943E+09, LiqDen = {105,0.44061,0.23657,566.41,0.23009,0}, VP = {101,83.41936,-6957.084,-9.207327,0.0000063783,2}, LiqCp = {16,108880,-13.14,10.55,0.00536,-0.0000028819}, HOV = {106,5.6943E+07,0.86512,-0.77048,0.30586,0.021601}, VapCp = {16,26624,-291.65,12.829,0.00059553,-0.0000001821}, LiqVis = {101,-6.3467,935.74,-0.76144,7.5545E-07,2}, VapVis = {102,6.7868E-07,0.51422,325.4,22.347,0}, LiqK = {16,-0.048086,3.7835,-1.6094,-0.00050636,-0.0000013704}, VapK = {102,0.000017892,1.241,-169.67,132780,0}, Racketparam = 0, UniquacR = 5.85, UniquacQ = 4.94, ChaoSeadAF = 0.316137, ChaoSeadSP = 14934.3, ChaoSeadLV = 0.159513);
  end TwoThreeFourtrimethylpentane;
  
  model Tetraethyleneglycol
  extends General_Properties(
    SN = 160, name = "Tetraethyleneglycol", CAS = "112-60-7", Tc = 795, Pc = 2590000,  Vc = 0.564, Cc = 0.221, Tb = 602.7, Tm = 268.15, TT = 268.15, TP = 0.0000138348, MW = 194.226, LVB = 0.172862, AF = 0.917442, SP = 23690, DM = 1.08E-29, SH = -168070000.0, IGHF = -8.83E+08, GEF = -5.599E+08, AS = 650100, HFMP = 3.66E+07, HOC = -4.3431E+09, LiqDen = {105,0.46229,0.26105,795,0.27055,0}, VP = {101,106.7938,-15323.17,-10.86107,-5.284752E-07,2}, LiqCp = {16,180650,-180.95,12.547,0.0020505,-0.0000018444}, HOV = {106,1.282157E+08,0.159236,1.504015,-1.941373,0.658104}, VapCp = {16,122630,-416.14,13.02,0.00050957,-2.1012E-07}, LiqVis = {101,-702.8128,30403.47,106.7279,-0.000116388,2}, VapVis = {102,7.6872E-08,0.801,119.91,0.29361,0}, LiqK = {16,-0.11138,-134.47,-0.46393,-0.00084854,-4.1141E-07}, VapK = {102,0.00016749,0.91863,699.93,16777,0}, Racketparam = 0, UniquacR = 8.1269, UniquacQ = 7.440001, ChaoSeadAF = 0.930639, ChaoSeadSP = 23571.8, ChaoSeadLV = 0.173363);
  end Tetraethyleneglycol;
  
  model Indene
  extends General_Properties(
    SN = 161, name = "Indene", CAS = "95-13-6", Tc = 687, Pc = 3820000,  Vc = 0.368, Cc = 0.246, Tb = 455.77, Tm = 271.7, TT = 271.7, TP = 17.0209, MW = 116.16, LVB = 0.116856, AF = 0.333766, SP = 20310, DM = 2.23E-30, SH = -168070000.0, IGHF = 1.6328E+08, GEF = 2.3396E+08, AS = 336870, HFMP = 1.02E+07, HOC = -4.61948E+09, LiqDen = {105,0.68574,0.25341,687,0.30914,0}, VP = {101,198.3126,-13212.05,-26.47637,0.0000206314,2}, LiqCp = {16,87661,-18.633,10.258,0.0056195,-0.0000040934}, HOV = {106,1.127174E+08,2.195635,-2.278889,0.782692,-0.231351}, VapCp = {16,54598,-572.63,13.077,-0.000062304,-1.4084E-09}, LiqVis = {101,-136.89,6165.4,19.669,-0.000025488,2}, VapVis = {102,8.1278E-07,0.4938,370.54,-3708.9,0}, LiqK = {16,-0.0034145,-80.459,-0.91571,-0.0024408,2.3991E-07}, VapK = {102,0.000075165,1.055,558.89,35355,0}, Racketparam = 0.261272, UniquacR = 4.431773, UniquacQ = 2.892, ChaoSeadAF = 0.262, ChaoSeadSP = 20467.4, ChaoSeadLV = 0.116856);
  end Indene;
  
  model Indane
  extends General_Properties(
    SN = 162, name = "Indane", CAS = "496-11-7", Tc = 684.9, Pc = 3950000,  Vc = 0.393, Cc = 0.273, Tb = 451, Tm = 221.74, TT = 221.74, TP = 0.152927, MW = 118.178, LVB = 0.12315, AF = 0.309213, SP = 19420, DM = 1.8E-30, SH = -168070000.0, IGHF = 6.07E+07, GEF = 1.668E+08, AS = 348910, HFMP = 8598000, HOC = -4.7626E+09, LiqDen = {105,0.63627,0.25179,684.9,0.29165,0}, VP = {101,97.02207,-8795.05,-11.00248,6.105132E-06,2}, LiqCp = {16,136380,-29.478,8.0608,0.01305,-0.000010993}, HOV = {106,6.2067E+07,-0.0045874,2.0817,-3.2476,1.6013}, VapCp = {16,60321,-643.06,13.337,-0.00018807,3.6677E-08}, LiqVis = {101,-151.95,6810.2,21.863,-0.00002342,2}, VapVis = {102,0.0000002842,0.64259,225.95,-643.44,0}, LiqK = {16,-0.041318,5.7098,-1.5369,-0.00043639,-0.0000010195}, VapK = {102,0.0089527,0.43447,617.91,764370,0}, Racketparam = 0.263427, UniquacR = 4.66381, UniquacQ = 3.108, ChaoSeadAF = 0.305, ChaoSeadSP = 19405.1, ChaoSeadLV = 0.123128);
  end Indane;
  
  model Cumene
  extends General_Properties(
    SN = 163, name = "Cumene", CAS = "98-82-8", Tc = 631, Pc = 3209000,  Vc = 0.4347, Cc = 0.261, Tb = 425.52, Tm = 177.14, TT = 177.14, TP = 0.000471313, MW = 120.194, LVB = 0.14017, AF = 0.326, SP = 17420, DM = 1.3E-30, SH = -168070000.0, IGHF = 4000000, GEF = 1.379E+08, AS = 386000, HFMP = 7326000, HOC = -4.951E+09, LiqDen = {105,0.50221,0.23722,631.11,0.26133,0}, VP = {101,118.1491,-9251.635,-14.30054,9.196883E-06,2}, LiqCp = {16,41467,-297.98,13.905,-0.0047724,0.0000064694}, HOV = {106,5.766E+07,0.38939,0,0,0}, VapCp = {16,86134,-649.19,13.375,-0.00027067,7.9617E-08}, LiqVis = {101,-16.711,1557.8,0.70915,0.000002636,2}, VapVis = {102,3.9385E-07,0.59572,281.33,-806.82,0}, LiqK = {16,0.085857,481.58,-8.587,0.025021,-0.000042138}, VapK = {102,1.6743E-07,1.8369,-449.46,112760,0}, Racketparam = 0.2617, UniquacR = 5.2708, UniquacQ = 4.044, ChaoSeadAF = 0.3353, ChaoSeadSP = 17436.2, ChaoSeadLV = 0.139854);
  end Cumene;
  
  model Npropylbenzene
  extends General_Properties(
    SN = 164, name = "Npropylbenzene", CAS = "103-65-1", Tc = 638.35, Pc = 3200000,  Vc = 0.44, Cc = 0.265, Tb = 432.35, Tm = 173.55, TT = 173.55, TP = 0.000181372, MW = 120.194, LVB = 0.1402, AF = 0.345, SP = 17670, DM = 1.23E-30, SH = -168070000.0, IGHF = 7900000, GEF = 1.376E+08, AS = 400140, HFMP = 9268000, HOC = -4.95415E+09, LiqDen = {105,0.56872,0.25108,638.35,0.29337,0}, VP = {101,90.904,-8254.5,-10.105,0.0000055769,2}, LiqCp = {16,44429,65.841,10.897,0.0032658,-5.4402E-07}, HOV = {106,7.1312E+07,1.0445,-0.61076,-0.59569,0.63332}, VapCp = {16,82370,-622.6,13.289,-0.00014307,2.6658E-08}, LiqVis = {101,-15.601,1467.9,0.61045,8.0442E-07,2}, VapVis = {102,4.6834E-07,0.55936,217.09,10253,0}, LiqK = {16,-0.081391,2.87,-1.3455,-0.00061835,-5.1664E-07}, VapK = {102,0.025018,0.26728,100.66,971170,0}, Racketparam = 0.2599, UniquacR = 5.2716, UniquacQ = 4.048, ChaoSeadAF = 0.3444, ChaoSeadSP = 17805.4, ChaoSeadLV = 0.139831);
  end Npropylbenzene;
  
  model Npropylcyclohexane
  extends General_Properties(
    SN = 165, name = "Npropylcyclohexane", CAS = "1678-92-8", Tc = 639.15, Pc = 2807000,  Vc = 0.477, Cc = 0.252, Tb = 429.897, Tm = 178.25, TT = 178.25, TP = 0.000859078, MW = 126.239, LVB = 0.159758, AF = 0.259535, SP = 16350, DM = 0, SH = -168070000.0, IGHF = -1.933E+08, GEF = 4.738E+07, AS = 419530, HFMP = 1.037E+07, HOC = -5.47966E+09, LiqDen = {105,0.55532,0.26594,639.15,0.29886,0}, VP = {101,82.958,-7871.7,-8.8759,0.0000037842,2}, LiqCp = {16,47569,39.903,11.009,0.0038436,-0.0000012583}, HOV = {106,6.8086E+07,1.2548,-2.1193,2.1809,-0.84474}, VapCp = {16,123230,-835.51,14.003,-0.00055451,1.5912E-07}, LiqVis = {101,-18.964,1768.3,1.0133,0.0000031666,2}, VapVis = {102,0.0000010206,0.44533,352.16,7219.8,0}, LiqK = {16,-0.049742,3.3035,-1.5814,-0.00048571,-0.000001015}, VapK = {102,0.000001205,1.6222,-42.945,15739,0}, Racketparam = 0, UniquacR = 6.068799, UniquacQ = 4.856, ChaoSeadAF = 0.2577, ChaoSeadSP = 16377.1, ChaoSeadLV = 0.159758);
  end Npropylcyclohexane;
  
  model Nnonane
  extends General_Properties(
    SN = 166, name = "Nnonane", CAS = "111-84-2", Tc = 594.6, Pc = 2290000,  Vc = 0.555, Cc = 0.257, Tb = 423.97, Tm = 219.66, TT = 219.66, TP = 0.430583, MW = 128.258, LVB = 0.1797, AF = 0.443, SP = 15630, DM = 0, SH = -168070000.0, IGHF = -2.2874E+08, GEF = 2.498E+07, AS = 506400, HFMP = 1.547E+07, HOC = -5.68455E+09, LiqDen = {105,0.46379,0.25569,594.6,0.27961,0}, VP = {101,34.38252,-6235.412,-1.153933,-6.408486E-06,2}, LiqCp = {16,263370,-14466,134.04,-0.36823,0.00038456}, HOV = {106,8.427482E+07,1.573752,-1.785921,0.692082,0.00268541}, VapCp = {16,137710,-699.52,13.613,-0.00021735,5.3695E-08}, LiqVis = {101,-75.488,3420.7,10.183,-0.000014836,2}, VapVis = {102,1.0363E-07,0.77284,221.39,-190.1,0}, LiqK = {16,0.022998,-23.224,-1.6475,-0.000633,-0.0000035211}, VapK = {102,-0.065472,0.27739,-3569.2,-1629700,0}, Racketparam = 0.251687, UniquacR = 6.523, UniquacQ = 5.476, ChaoSeadAF = 0.4439, ChaoSeadSP = 15648.08, ChaoSeadLV = 0.1796);
  end Nnonane;
  
  model Naphthalene
  extends General_Properties(
    SN = 167, name = "Naphthalene", CAS = "91-20-3", Tc = 748.4, Pc = 4050000,  Vc = 0.407, Cc = 0.265, Tb = 491.16, Tm = 353.434, TT = 353.43, TP = 991.297, MW = 128.174, LVB = 0.12913, AF = 0.304, SP = 19490, DM = 0, SH = -168070000.0, IGHF = 1.5058E+08, GEF = 2.2408E+08, AS = 333150, HFMP = 1.898E+07, HOC = -4.9809E+09, LiqDen = {105,0.45282,0.21953,748.4,0.23236,0}, VP = {101,93.15947,-9448.063,-10.23844,4.335455E-06,2}, LiqCp = {16,149170,579.65,3.8152,0.021624,-0.000015657}, HOV = {106,7.732822E+07,1.116621,-1.313575,0.672121,-0.00584514}, VapCp = {16,49831,-547.92,13.201,-0.00013999,2.8208E-08}, LiqVis = {101,-8.2151,1338.2,-0.46592,0.00000135,2}, VapVis = {102,1.2323E-08,1.0475,-162.06,35144,0}, LiqK = {16,0.033214,-361.89,-0.012818,-0.0040236,0.0000012782}, VapK = {102,0.000017754,1.2123,69.759,78517,0}, Racketparam = 0.261, UniquacR = 4.920237, UniquacQ = 3.368, ChaoSeadAF = 0.302, ChaoSeadSP = 19187.5, ChaoSeadLV = 0.130825);
  end Naphthalene;
  
  model Onemethylindene
  extends General_Properties(
    SN = 168, name = "Onemethylindene", CAS = "767-59-9", Tc = 703, Pc = 3460000,  Vc = 0.436, Cc = 0.258, Tb = 471.65, Tm = 0, TT = 0, TP = 0, MW = 130.186, LVB = 0.134643, AF = 0.334861, SP = 19120, DM = 0, SH = -168070000.0, IGHF = 1.912E+08, GEF = 2.97E+08, AS = 354000, HFMP = 0, HOC = -5.28E+09, LiqDen = {105,0.61191,0.25938,703,0.29267,0}, VP = {101,86.18824,-8859.756,-9.212247,3.741568E-06,2}, LiqCp = {16,152820,-189.88,10.81,0.00256,-0.0000011085}, HOV = {106,8.0901E+07,1.9933,-4.5733,5.098,-2.0923}, VapCp = {16,-133130,-213.74,13.196,0.00017372,-4.8074E-08}, LiqVis = {0,0,0,0,0,0}, VapVis = {102,0.0000033072,0.32792,786.18,680.97,0}, LiqK = {16,-0.018671,-66.592,-0.99313,-0.0021306,2.0941E-07}, VapK = {102,0.000091267,1.0385,720.72,-19410,0}, Racketparam = 0.261176, UniquacR = 5.105471, UniquacQ = 3.424, ChaoSeadAF = 0.33569, ChaoSeadSP = 18312.4, ChaoSeadLV = 0.134207);
  end Onemethylindene;
  
  model Twomethylindene
  extends General_Properties(
    SN = 169, name = "Twomethylindene", CAS = "2177-47-1", Tc = 711, Pc = 3460000,  Vc = 0.436, Cc = 0.255, Tb = 479.45, Tm = 353.15, TT = 353.15, TP = 3020.69, MW = 130.186, LVB = 0.13407, AF = 0.350814, SP = 19650, DM = 0, SH = -168070000.0, IGHF = 1.15E+08, GEF = 2.19E+08, AS = 361000, HFMP = 0, HOC = -5.21E+09, LiqDen = {105,0.58652,0.25339,711,0.28941,0}, VP = {101,92.273,-9299.2,-10.097,0.0000042786,2}, LiqCp = {16,156160,-200.07,10.512,0.0025015,-0.0000010635}, HOV = {106,7.303067E+07,0.433923,0.764504,-1.615634,0.843055}, VapCp = {16,-154380,-193.88,13.203,0.00019348,-5.2535E-08}, LiqVis = {0,0,0,0,0,0}, VapVis = {102,9.6835E-07,0.47111,397.83,9327.5,0}, LiqK = {16,0.057046,-181.52,-0.63312,-0.0038758,-8.2839E-07}, VapK = {102,0.00009568,1.0268,701.49,-31051,0}, Racketparam = 0.259776, UniquacR = 5.104812, UniquacQ = 3.552, ChaoSeadAF = 0.32769, ChaoSeadSP = 17790.3, ChaoSeadLV = 0.133656);
  end Twomethylindene;
  
  model Dicyclopentadiene
  extends General_Properties(
    SN = 170, name = "Dicyclopentadiene", CAS = "77-73-6", Tc = 660, Pc = 3060000,  Vc = 0.445, Cc = 0.248, Tb = 443, Tm = 305.15, TT = 305.15, TP = 566.19, MW = 132.202, LVB = 0.134736, AF = 0.288011, SP = 17800, DM = 0, SH = -168070000.0, IGHF = 1.961E+08, GEF = 3.75E+08, AS = 240000, HFMP = 2090000, HOC = -5.535E+09, LiqDen = {105,0.41899,0.20539,660,0.34053,0}, VP = {101,72.31496,-7292.827,-7.388294,3.746895E-06,2}, LiqCp = {16,83937,-392.22,13.886,-0.0031138,0.000003368}, HOV = {106,7.0543E+07,1.9867,-4.6545,5.1772,-2.0831}, VapCp = {16,38735,-535.99,13.553,-0.00031277,0.0000001075}, LiqVis = {101,-11.633,1272.8,0.067676,-1.2999E-07,2}, VapVis = {102,0.0000004337,0.561,232.6,-0.00081701,0}, LiqK = {16,0.029848,47.178,-2.5363,0.0023572,-0.0000058893}, VapK = {102,0.00025878,0.8604,51.14,244020,0}, Racketparam = 0, UniquacR = 5.8156, UniquacQ = 4.548, ChaoSeadAF = 0.285111, ChaoSeadSP = 17445.1, ChaoSeadLV = 0.138585);
  end Dicyclopentadiene;
  
  model Nbutylbenzene
  extends General_Properties(
    SN = 171, name = "Nbutylbenzene", CAS = "104-51-8", Tc = 660.5, Pc = 2890000,  Vc = 0.497, Cc = 0.262, Tb = 456.42, Tm = 185.3, TT = 185.3, TP = 0.000154386, MW = 134.221, LVB = 0.15678, AF = 0.393, SP = 17510, DM = 1.23E-30, SH = -168070000.0, IGHF = -1.314E+07, GEF = 1.454E+08, AS = 439490, HFMP = 1.122E+07, HOC = -5.5644E+09, LiqDen = {105,0.50648,0.25203,660.5,0.29203,0}, VP = {101,100.11,-9186.6,-11.379,0.0000058585,2}, LiqCp = {16,173590,115.14,7.4501,0.014631,-0.000011875}, HOV = {106,6.5698E+07,0.30842,0.67062,-1.1135,0.53276}, VapCp = {16,97423,-619.62,13.35,-0.000032816,-9.3502E-09}, LiqVis = {101,-18.829,1737.7,1.0385,0.0000015468,2}, VapVis = {102,3.4687E-07,0.59512,233.67,177.63,0}, LiqK = {16,0.081204,245.71,-5.5946,0.01322,-0.00002506}, VapK = {102,0.19225,-0.0011093,-156.74,1712400,0}, Racketparam = 0, UniquacR = 5.946, UniquacQ = 4.588, ChaoSeadAF = 0.3923, ChaoSeadSP = 17450.9, ChaoSeadLV = 0.156494);
  end Nbutylbenzene;
  
  model Nbutylcyclohexane
  extends General_Properties(
    SN = 172, name = "Nbutylcyclohexane", CAS = "1678-93-9", Tc = 667, Pc = 2570000,  Vc = 0.534, Cc = 0.247, Tb = 454.131, Tm = 198.42, TT = 198.42, TP = 0.00365804, MW = 140.266, LVB = 0.176266, AF = 0.274326, SP = 16400, DM = 0, SH = -168070000.0, IGHF = -2.1317E+08, GEF = 5.654E+07, AS = 458480, HFMP = 1.416E+07, HOC = -6.0902E+09, LiqDen = {105,0.49786,0.26572,667,0.30254,0}, VP = {101,82.702,-8417.7,-8.6968,0.0000027713,2}, LiqCp = {16,117850,44.861,10.356,0.0053947,-0.0000020204}, HOV = {106,7.7656E+07,1.637,-3.3269,3.6698,-1.48}, VapCp = {16,145450,-890.37,14.241,-0.0007098,2.1101E-07}, LiqVis = {101,-66.15115,3536.438,8.46644,-7.612217E-06,2}, VapVis = {102,5.6992E-07,0.52089,326.29,-3328.7,0}, LiqK = {16,-0.040753,3.9448,-1.6588,-0.00045987,-0.0000010215}, VapK = {102,0.000063509,1.1032,470.22,42922,0}, Racketparam = 0, UniquacR = 6.7432, UniquacQ = 5.396, ChaoSeadAF = 0.3618, ChaoSeadSP = 16411.2, ChaoSeadLV = 0.176266);
  end Nbutylcyclohexane;
  
  model Ndecane
  extends General_Properties(
    SN = 173, name = "Ndecane", CAS = "124-18-5", Tc = 617.7, Pc = 2110000,  Vc = 0.624, Cc = 0.256, Tb = 447.3, Tm = 243.51, TT = 243.51, TP = 1.39297, MW = 142.285, LVB = 0.19595, AF = 0.491, SP = 15720, DM = 0, SH = -168070000.0, IGHF = -2.4946E+08, GEF = 3.318E+07, AS = 545700, HFMP = 2.871E+07, HOC = -6.29422E+09, LiqDen = {105,0.37424,0.2405,617.7,0.27182,0}, VP = {101,6.023802,-5713.196,3.410225,-0.000012633,2}, LiqCp = {16,160660,291.43,8.5687,0.0098408,-0.0000060811}, HOV = {106,5.7689E+07,-1.1412,5.1463,-6.2946,2.6623}, VapCp = {16,152020,-697.29,13.714,-0.00021747,4.9426E-08}, LiqVis = {101,-102.98,4517.9,14.495,-0.00002056,2}, VapVis = {102,2.3638E-08,0.95886,24.698,7541.9,0}, LiqK = {16,0.071684,-217.03,-0.47424,-0.0039028,-0.0000049442}, VapK = {102,-668.49,0.93224,-4.0687E+09,-1.0176E+09,0}, Racketparam = 0.2503, UniquacR = 7.2, UniquacQ = 6.02, ChaoSeadAF = 0.4869, ChaoSeadSP = 15791.26, ChaoSeadLV = 0.196);
  end Ndecane;
  
  model Onemethylnaphthalene
  extends General_Properties(
    SN = 174, name = "Onemethylnaphthalene", CAS = "90-12-0", Tc = 772, Pc = 3600000,  Vc = 0.462, Cc = 0.259, Tb = 517.84, Tm = 242.67, TT = 242.67, TP = 0.043382, MW = 142.2, LVB = 0.13937, AF = 0.348, SP = 19890, DM = 1.7E-30, SH = -168070000.0, IGHF = 1.169E+08, GEF = 2.179E+08, AS = 377400, HFMP = 6945000, HOC = -5.5958E+09, LiqDen = {105,0.59739,0.26468,772,0.2918,0}, VP = {101,73.89852,-9115.529,-7.252019,2.094885E-06,2}, LiqCp = {16,134210,116.27,8.3119,0.012175,-0.000010378}, HOV = {106,7.0001E+07,0.3382,0.060354,-0.021035,-0.0086978}, VapCp = {16,67134,-530.75,13.222,-0.000033319,-3.2916E-09}, LiqVis = {101,8.170859,1169.912,-3.261889,6.874562E-06,2}, VapVis = {102,2.4606E-07,0.6456,239.2,-8656.8,0}, LiqK = {16,-0.049867,2.2749,-1.45,-0.00045282,-7.0729E-07}, VapK = {102,1.5229,-0.35024,-1389.7,2465100,0}, Racketparam = 0, UniquacR = 5.610415, UniquacQ = 3.936, ChaoSeadAF = 0.3337, ChaoSeadSP = 20129.2, ChaoSeadLV = 0.1398);
  end Onemethylnaphthalene;
  
  model Twomethylnaphthalene
  extends General_Properties(
    SN = 175, name = "Twomethylnaphthalene", CAS = "91-57-6", Tc = 761, Pc = 3540000,  Vc = 0.462, Cc = 0.258, Tb = 514.2, Tm = 307.73, TT = 307.73, TP = 18.6897, MW = 142.2, LVB = 0.14577, AF = 0.374, SP = 19680, DM = 1.4E-30, SH = -168070000.0, IGHF = 1.161E+08, GEF = 2.163E+08, AS = 380000, HFMP = 1.212E+07, HOC = -5.58286E+09, LiqDen = {105,0.53405,0.25024,761.16,0.28587,0}, VP = {101,98.05854,-10275.56,-10.82814,3.919145E-06,2}, LiqCp = {16,74335,-307.25,13.46,-0.0028051,0.000003645}, HOV = {106,9.0724E+07,1.2004,-1.1581,0.47852,-0.081108}, VapCp = {16,69292,-534.4,13.21,-0.00001663,-8.8386E-09}, LiqVis = {101,-88.346,4977.8,11.629,-0.0000078261,2}, VapVis = {102,0.0000029847,0.34183,891.22,-28677,0}, LiqK = {16,0.0084839,-307.37,0.18174,-0.0046509,0.0000016652}, VapK = {102,0.000098384,1.0234,722.6,42453,0}, Racketparam = 0, UniquacR = 5.610415, UniquacQ = 3.936, ChaoSeadAF = 0.3815, ChaoSeadSP = 19870.3, ChaoSeadLV = 0.143396);
  end Twomethylnaphthalene;
  
  model Nundecane
  extends General_Properties(
    SN = 176, name = "Nundecane", CAS = "1120-21-4", Tc = 639, Pc = 1980000,  Vc = 0.689, Cc = 0.257, Tb = 469.08, Tm = 247.571, TT = 247.571, TP = 0.408414, MW = 156.312, LVB = 0.21224, AF = 0.538, SP = 15880, DM = 0, SH = -168070000.0, IGHF = -2.7043E+08, GEF = 4.116E+07, AS = 584930, HFMP = 2.218E+07, HOC = -6.9036E+09, LiqDen = {105,0.36785,0.24938,639,0.28395,0}, VP = {101,128.8551,-11029.21,-15.54009,8.030888E-06,2}, LiqCp = {16,208030,521.1,6.1551,0.017086,-0.000013175}, HOV = {106,8.9735E+07,0.81788,0.31647,-1.4781,0.80673}, VapCp = {16,177700,-730.83,13.81,-0.00021088,5.7776E-08}, LiqVis = {101,-92.575,4408.9,12.698,-0.000015556,2}, VapVis = {102,2.9213E-08,0.9335,118.62,-4363.8,0}, LiqK = {16,0.015185,-212.29,-0.044539,-0.0049614,0.0000013629}, VapK = {102,0.037608,0.6852,33443,9124600,0}, Racketparam = 0.243351, UniquacR = 7.871799, UniquacQ = 6.556, ChaoSeadAF = 0.521, ChaoSeadSP = 15934.45, ChaoSeadLV = 0.2122);
  end Nundecane;
  
  model Acenaphthene
  extends General_Properties(
    SN = 177, name = "Acenaphthene", CAS = "83-32-9", Tc = 803.15, Pc = 3100000,  Vc = 0.553, Cc = 0.257, Tb = 550.54, Tm = 366.56, TT = 366.56, TP = 199.997, MW = 154.208, LVB = 0.149792, AF = 0.381147, SP = 19480, DM = 8.5E-31, SH = -168070000.0, IGHF = 1.55E+08, GEF = 2.602E+08, AS = 368900, HFMP = 2.1462E+07, HOC = -6.0014E+09, LiqDen = {105,0.39942,0.22066,803.15,0.24043,0}, VP = {101,73.737,-9735.5,-7.1321,0.0000016079,2}, LiqCp = {16,173930,379.65,5.6292,0.017939,-0.000013551}, HOV = {106,3.785978E+08,10.14483,-25.41937,26.03775,-9.982155}, VapCp = {16,60762,-515.4,13.307,-0.000026823,-1.013E-08}, LiqVis = {101,-8.2073,1373.2,-0.25871,-0.0000036859,2}, VapVis = {102,0.0000015547,0.4064,630.11,26.274,0}, LiqK = {16,0.059552,-91.592,-1.7169,-0.0019056,1.2951E-07}, VapK = {102,0.000078027,1.0286,593.39,37622,0}, Racketparam = 0.257114, UniquacR = 5.997356, UniquacQ = 3.96, ChaoSeadAF = 0.382, ChaoSeadSP = 19480.5, ChaoSeadLV = 0.149792);
  end Acenaphthene;
  
  model Biphenyl
  extends General_Properties(
    SN = 178, name = "Biphenyl", CAS = "92-52-4", Tc = 789.26, Pc = 3847270,  Vc = 0.491118, Cc = 0.294, Tb = 528.15, Tm = 342.35, TT = 342.372, TP = 84.2725, MW = 154.211, LVB = 0.155536, AF = 0.3643, SP = 19383, DM = 0, SH = -168070000.0, IGHF = 1.82088E+08, GEF = 2.80077E+08, AS = 392668, HFMP = 1.85769E+07, HOC = -6.0317E+09, LiqDen = {105,0.50803,0.25417,789.26,0.2795,0}, VP = {101,154.3401,-13555.42,-19.05582,8.30386E-06,2}, LiqCp = {16,24132,-12.395,11.585,0.0029407,-0.0000014331}, HOV = {106,8.680865E+07,0.473092,1.061004,-2.226343,1.156876}, VapCp = {16,79583,-635.84,13.574,-0.00034935,9.291E-08}, LiqVis = {101,-10.998,1574.4,-0.022671,-3.4058E-07,2}, VapVis = {102,1.7776E-07,0.70632,118.6,61798,0}, LiqK = {16,0.086277,-343.48,0.36261,-0.00791,0.0000032504}, VapK = {102,0.000031971,1.1528,215.14,115000,0}, Racketparam = 0, UniquacR = 6.0434, UniquacQ = 4.24, ChaoSeadAF = 0.3643, ChaoSeadSP = 19383, ChaoSeadLV = 0.155536);
  end Biphenyl;
  
  model Ndodecane
  extends General_Properties(
    SN = 179, name = "Ndodecane", CAS = "112-40-3", Tc = 658, Pc = 1820000,  Vc = 0.754, Cc = 0.251, Tb = 489.48, Tm = 263.568, TT = 263.568, TP = 0.615203, MW = 170.338, LVB = 0.22859, AF = 0.571, SP = 15930, DM = 0, SH = -168070000.0, IGHF = -2.9072E+08, GEF = 4.981E+07, AS = 624150, HFMP = 3.684E+07, HOC = -7.51368E+09, LiqDen = {105,0.30334,0.23617,658,0.2706,0}, VP = {101,127.8877,-11582.12,-15.22541,6.680034E-06,2}, LiqCp = {16,203950,627.31,6.2796,0.014676,-0.0000079758}, HOV = {106,9.812979E+07,0.939672,-0.0412509,-0.949322,0.501567}, VapCp = {16,193680,-732.61,13.902,-0.00022284,6.2257E-08}, LiqVis = {101,-83.21108,4238.311,11.14639,-0.0000124656,2}, VapVis = {102,5.4481E-08,0.85223,245.71,-11928,0}, LiqK = {16,0.029364,-108.04,-0.7007,-0.0040791,6.1377E-07}, VapK = {102,0.0000055504,1.4726,558.15,3563.6,0}, Racketparam = 0.2466, UniquacR = 8.5462, UniquacQ = 7.096, ChaoSeadAF = 0.561, ChaoSeadSP = 16036.72, ChaoSeadLV = 0.2286);
  end Ndodecane;
  
  model Fluorene
  extends General_Properties(
    SN = 180, name = "Fluorene", CAS = "86-73-7", Tc = 826, Pc = 3000000,  Vc = 0.524, Cc = 0.229, Tb = 570.44, Tm = 387.94, TT = 387.94, TP = 281.665, MW = 166.219, LVB = 0.15327, AF = 0.404163, SP = 19820, DM = 8.3E-31, SH = -168070000.0, IGHF = 1.869E+08, GEF = 2.901E+08, AS = 381500, HFMP = 1.9578E+07, HOC = -6.4251E+09, LiqDen = {105,0.43683,0.229,826,0.28571,0}, VP = {101,141.8746,-13833.84,-17.04805,0.0000063782,2}, LiqCp = {16,172320,813.11,3.2969,0.023275,-0.000018014}, HOV = {106,9.581E+07,1.317,-1.4739,-0.0034969,0.61586}, VapCp = {16,57825,-560.42,13.575,-0.00027161,7.5804E-08}, LiqVis = {101,-33.053,2454.9,3.4575,-0.0000042581,2}, VapVis = {102,5.7084E-07,0.56204,373.69,-49.196,0}, LiqK = {16,-0.013258,-130.68,-0.68476,-0.0022566,3.0043E-07}, VapK = {102,0.00017437,0.9152,500.25,62613,0}, Racketparam = 0, UniquacR = 6.174687, UniquacQ = 4.076, ChaoSeadAF = 0.349259, ChaoSeadSP = 21645.7, ChaoSeadLV = 0.128237);
  end Fluorene;
  
  model Ntridecane
  extends General_Properties(
    SN = 181, name = "Ntridecane", CAS = "629-50-5", Tc = 675, Pc = 1680000,  Vc = 0.823, Cc = 0.246, Tb = 508.63, Tm = 267.76, TT = 267.76, TP = 0.250959, MW = 184.365, LVB = 0.24494, AF = 0.61, SP = 16060, DM = 0, SH = -168070000.0, IGHF = -3.1177E+08, GEF = 5.771E+07, AS = 663370, HFMP = 2.85E+07, HOC = -8.1229E+09, LiqDen = {105,0.29787,0.24164,675,0.29254,0}, VP = {101,143.3256,-12766.72,-17.45421,7.99709E-06,2}, LiqCp = {16,37167,123.48,11.52,0.0033147,-0.0000011194}, HOV = {106,9.732822E+07,0.667983,0.462399,-1.329972,0.649193}, VapCp = {16,191240,-657.52,13.861,-0.00011498,3.3409E-08}, LiqVis = {101,-81.45907,4309.552,10.81921,-0.000011395,2}, VapVis = {102,3.0146E-08,0.91936,136.12,2279.8,0}, LiqK = {16,0.037294,-193.16,-0.1108,-0.0058295,0.0000022551}, VapK = {102,0.0000050471,1.4806,553.99,7554.4,0}, Racketparam = 0.2465, UniquacR = 9.2206, UniquacQ = 7.636, ChaoSeadAF = 0.6002, ChaoSeadSP = 16139, ChaoSeadLV = 0.2449);
  end Ntridecane;
  
  model Phenanthrene
  extends General_Properties(
    SN = 182, name = "Phenanthrene", CAS = "85-01-8", Tc = 869, Pc = 2900000,  Vc = 0.554, Cc = 0.222, Tb = 610.03, Tm = 372.38, TT = 372.38, TP = 29.2781, MW = 178.229, LVB = 0.167077, AF = 0.470716, SP = 19910, DM = 0, SH = -168070000.0, IGHF = 2.012E+08, GEF = 3.0219E+08, AS = 394500, HFMP = 1.6463E+07, HOC = -6.8282E+09, LiqDen = {105,0.4558,0.25237,869,0.24848,0}, VP = {101,275.0593,-20918.1,-36.87097,0.0000193212,2}, LiqCp = {16,115950,-43.82,10.979,0.0042773,-0.0000023928}, HOV = {106,9.2455E+07,0.28979,1.1393,-1.9946,0.92537}, VapCp = {16,66200,-509.49,13.435,-0.000075274,6.0366E-09}, LiqVis = {101,-22.439,2565.4,1.5699,3.8655E-09,2}, VapVis = {102,0.0000004717,0.52643,268.46,10947,0}, LiqK = {16,0.11683,-580.68,-0.62222,-0.006256,4.1638E-07}, VapK = {102,0.000092871,0.99317,671.87,29972,0}, Racketparam = 0.249255, UniquacR = 6.562953, UniquacQ = 4.336, ChaoSeadAF = 0.54, ChaoSeadSP = 20142.5, ChaoSeadLV = 0.167078);
  end Phenanthrene;
  
  model Ntetradecane
  extends General_Properties(
    SN = 183, name = "Ntetradecane", CAS = "629-59-4", Tc = 693, Pc = 1570000,  Vc = 0.894, Cc = 0.244, Tb = 526.76, Tm = 279.01, TT = 279.01, TP = 0.252685, MW = 198.392, LVB = 0.26132, AF = 0.644, SP = 16140, DM = 0, SH = -168070000.0, IGHF = -3.3244E+08, GEF = 6.599E+07, AS = 702590, HFMP = 4.507E+07, HOC = -8.73282E+09, LiqDen = {105,0.26297,0.23695,693,0.26861,0}, VP = {101,141.7696,-13265.67,-17.07041,6.905252E-06,2}, LiqCp = {16,84257,110.32,11.507,0.0033723,-0.0000011739}, HOV = {106,1.216371E+08,1.28014,-0.352636,-1.241735,0.826459}, VapCp = {16,204940,-657.01,13.943,-0.00013248,4.0902E-08}, LiqVis = {101,-84.61448,4567.43,11.25434,-0.0000111579,2}, VapVis = {102,3.4874E-09,1.2039,-69.467,11809,0}, LiqK = {16,0.039135,-208.63,-0.066493,-0.005844,0.0000021711}, VapK = {102,-122.4,0.86814,-5.5021E+08,-2.1347E+10,0}, Racketparam = 0.234049, UniquacR = 9.895, UniquacQ = 8.176001, ChaoSeadAF = 0.6399, ChaoSeadSP = 16200.36, ChaoSeadLV = 0.2613);
  end Ntetradecane;
  
  model Npentadecane
  extends General_Properties(
    SN = 184, name = "Npentadecane", CAS = "629-62-9", Tc = 708, Pc = 1480000,  Vc = 0.966, Cc = 0.243, Tb = 543.83, Tm = 283.072, TT = 283.072, TP = 0.128872, MW = 212.419, LVB = 0.27771, AF = 0.685, SP = 16210, DM = 0, SH = -168070000.0, IGHF = -3.5311E+08, GEF = 7.426E+07, AS = 741810, HFMP = 3.459E+07, HOC = -9.34237E+09, LiqDen = {105,0.26611,0.24483,708,0.29579,0}, VP = {101,105.7905,-12176.19,-11.51031,2.157424E-06,2}, LiqCp = {16,44888,73.977,11.979,0.0027483,-9.4622E-07}, HOV = {106,1.334182E+08,1.382258,-0.345375,-1.508041,0.995233}, VapCp = {16,218790,-655.87,14.013,-0.00013811,4.3573E-08}, LiqVis = {101,-91.37005,4965.801,12.24551,-0.0000115231,2}, VapVis = {102,3.2252E-08,0.90575,168.22,3233.4,0}, LiqK = {16,0.010742,-152.75,-0.43594,-0.0040245,0.0000012373}, VapK = {102,0.0000047787,1.4851,642.9,182.7,0}, Racketparam = 0.245, UniquacR = 10.5694, UniquacQ = 8.716001, ChaoSeadAF = 0.6743, ChaoSeadSP = 16282.18, ChaoSeadLV = 0.2778);
  end Npentadecane;
  
  model Fluoranthene
  extends General_Properties(
    SN = 185, name = "Fluoranthene", CAS = "206-44-0", Tc = 905, Pc = 2610000,  Vc = 0.655, Cc = 0.227, Tb = 655.95, Tm = 383.33, TT = 383.33, TP = 15.7016, MW = 202.251, LVB = 0.184362, AF = 0.587526, SP = 19290, DM = 7.6E-31, SH = -168070000.0, IGHF = 2.889E+08, GEF = 3.862E+08, AS = 418500, HFMP = 1.873E+07, HOC = -7.695E+09, LiqDen = {105,0.34656,0.22699,905,0.28508,0}, VP = {101,96.11781,-12362.08,-10.3511,0.0000032319,2}, LiqCp = {16,241580,1296.9,0.78013,0.023496,-0.000011773}, HOV = {106,1.442678E+08,2.403711,-3.376173,1.404001,0.0327511}, VapCp = {16,59938,-461.32,13.513,-0.00005781,-5.6701E-09}, LiqVis = {101,-68.502,5208.9,8.4007,-0.0000042979,2}, VapVis = {102,0.0000010875,0.41309,444.51,-25.424,0}, LiqK = {16,-0.045864,-83.397,-0.96049,-0.0013219,-5.1355E-10}, VapK = {102,0.00011776,0.94788,660.84,38292,0}, Racketparam = 0.239005, UniquacR = 7.187871, UniquacQ = 4.504, ChaoSeadAF = 0.5, ChaoSeadSP = 19277.2, ChaoSeadLV = 0.184693);
  end Fluoranthene;
  
  model Pyrene
  extends General_Properties(
    SN = 186, name = "Pyrene", CAS = "129-00-0", Tc = 936, Pc = 2610000,  Vc = 0.66, Cc = 0.221, Tb = 667.95, Tm = 423.81, TT = 423.81, TP = 70.0313, MW = 202.251, LVB = 0.184923, AF = 0.507416, SP = 19670, DM = 0, SH = -168070000.0, IGHF = 2.25E+08, GEF = 3.272E+08, AS = 402000, HFMP = 1.736E+07, HOC = -7.63094E+09, LiqDen = {105,0.54272,0.27165,936,0.41522,0}, VP = {101,68.91405,-11628.85,-6.184331,6.420723E-07,2}, LiqCp = {16,149400,-94.468,11.128,0.0038746,-0.0000019128}, HOV = {106,9.198843E+07,-0.224752,1.989996,-2.139885,0.666532}, VapCp = {16,117680,-754.3,14.068,-0.00069165,2.0484E-07}, LiqVis = {101,-131.9,8597.1,17.746,-0.000010523,2}, VapVis = {102,4.4284E-07,0.52754,289.9,15025,0}, LiqK = {16,0.10165,-731.42,0.75712,-0.0079846,0.0000028317}, VapK = {102,0.000092503,0.97453,647.35,45503,0}, Racketparam = 0.246034, UniquacR = 7.187871, UniquacQ = 4.504, ChaoSeadAF = 0.344, ChaoSeadSP = 20762.5, ChaoSeadLV = 0.17368);
  end Pyrene;
  
  model Onephenylnaphthalene
  extends General_Properties(
    SN = 187, name = "Onephenylnaphthalene", CAS = "605-02-7", Tc = 849, Pc = 2630000,  Vc = 0.656, Cc = 0.244, Tb = 607.15, Tm = 318.15, TT = 318.15, TP = 0.282425, MW = 204.266, LVB = 0.189925, AF = 0.530878, SP = 19910, DM = 0, SH = -168070000.0, IGHF = 2.47E+08, GEF = 3.71108E+08, AS = 459000, HFMP = 0, HOC = -7.92E+09, LiqDen = {105,0.36822,0.24155,849,0.29048,0}, VP = {101,136.2471,-14614.66,-16.02104,5.425361E-06,2}, LiqCp = {16,180260,-2.5213,10.037,0.0072742,-0.0000049656}, HOV = {106,1.0967E+08,1.3201,-2.3901,2.4598,-0.96728}, VapCp = {16,77509,-521.03,13.602,-0.000094316,9.2363E-09}, LiqVis = {101,-6.144,1205.6,-0.56682,-0.0000005706,2}, VapVis = {102,0.0000030793,0.30949,742.15,16342,0}, LiqK = {16,-0.052282,-21.251,-1.3126,-0.00073663,-3.6032E-07}, VapK = {102,0.000092251,0.99676,619.05,42835,0}, Racketparam = 0, UniquacR = 7.679631, UniquacQ = 5.184, ChaoSeadAF = 0.530878, ChaoSeadSP = 19911.7, ChaoSeadLV = 0.189925);
  end Onephenylnaphthalene;
  
  model Nhexadecane
  extends General_Properties(
    SN = 188, name = "Nhexadecane", CAS = "544-76-3", Tc = 723, Pc = 1400000,  Vc = 1.034, Cc = 0.241, Tb = 559.98, Tm = 291.308, TT = 291.308, TP = 0.0922432, MW = 226.446, LVB = 0.29411, AF = 0.726, SP = 16190, DM = 0, SH = -168070000.0, IGHF = -3.7417E+08, GEF = 8.216E+07, AS = 781020, HFMP = 5.3358E+07, HOC = -9.95145E+09, LiqDen = {105,0.23237,0.23642,723,0.28403,0}, VP = {101,138.0173,-14151.1,-16.24379,5.027608E-06,2}, LiqCp = {16,387360,-123.61,10.738,0.005,-0.0000019617}, HOV = {106,1.2775E+08,0.92612,0.52583,-2.1415,1.2039}, VapCp = {16,232700,-655.34,14.079,-0.0001451,4.6597E-08}, LiqVis = {101,-84.70059,4841.907,11.15158,-9.617336E-06,2}, VapVis = {102,1.3203E-07,0.72722,424.3,4562.7,0}, LiqK = {16,0.006807,-152.97,-0.44096,-0.0038892,0.0000012245}, VapK = {102,0.0000035961,1.5118,510.88,23814,0}, Racketparam = 0.226854, UniquacR = 11.24, UniquacQ = 9.26, ChaoSeadAF = 0.7078, ChaoSeadSP = 16343.54, ChaoSeadLV = 0.2941);
  end Nhexadecane;
  
  model Chrysene
  extends General_Properties(
    SN = 189, name = "Chrysene", CAS = "218-01-9", Tc = 979, Pc = 2390000,  Vc = 0.749, Cc = 0.22, Tb = 714.15, Tm = 531.15, TT = 531.15, TP = 1028.09, MW = 228.288, LVB = 0.223221, AF = 0.603008, SP = 18920, DM = 2.33E-30, SH = -168070000.0, IGHF = 2.698E+08, GEF = 4.03E+08, AS = 440000, HFMP = 2.62E+07, HOC = -8.6796E+09, LiqDen = {105,0.30846,0.21991,979,0.32162,0}, VP = {101,171.0845,-19845.5,-20.41887,4.689312E-06,2}, LiqCp = {16,314190,239.97,9.0147,0.0068894,-0.0000035685}, HOV = {106,1.2779E+08,0.96651,-1.3609,1.2985,-0.49651}, VapCp = {16,124010,-668.94,14.001,-0.0004632,1.3177E-07}, LiqVis = {101,-12.612,2823.3,-0.058693,2.8981E-08,2}, VapVis = {102,3.4146E-07,0.54263,230.08,-3.8758,0}, LiqK = {16,0.032525,-322.45,-0.056163,-0.0034819,4.4935E-07}, VapK = {102,0.0001111,0.947,689.64,45041,0}, Racketparam = 0.237646, UniquacR = 8.250494, UniquacQ = 5.304, ChaoSeadAF = 0.603954, ChaoSeadSP = 19486.9, ChaoSeadLV = 0.210334);
  end Chrysene;
  
  model Cisdecahydronaphthalene
  extends General_Properties(
    SN = 190, name = "Cisdecahydronaphthalene", CAS = "493-01-6", Tc = 702.25, Pc = 3242400,  Vc = 0.48, Cc = 0.267, Tb = 468.965, Tm = 230.17, TT = 230.2, TP = 0.157166, MW = 138.253, LVB = 0.154615, AF = 0.294204, SP = 17625.3, DM = 0, SH = -168070000.0, IGHF = -1.6924E+08, GEF = 8.552E+07, AS = 377730, HFMP = 9489000, HOC = -5.89213E+09, LiqDen = {105,0.5563,0.26613,702.25,0.2872,0}, VP = {101,133.51,-10671,-16.446,0.0000090618,2}, LiqCp = {16,22875,183.22,9.7191,0.0080113,-0.0000053261}, HOV = {106,7.893812E+07,1.120046,-0.590284,-0.648808,0.601197}, VapCp = {16,90923,-788.66,14.021,-0.00046171,0.0000001235}, LiqVis = {101,-102.87,5387.9,14.086,-0.000014127,2}, VapVis = {102,7.2745E-07,0.51364,404.18,49.274,0}, LiqK = {16,0.087597,-101,-1.0253,-0.0090174,0.0000045064}, VapK = {102,0.0000017593,1.7742,317.62,37605,0}, Racketparam = 0.264744, UniquacR = 6.289, UniquacQ = 4.776, ChaoSeadAF = 0.294204, ChaoSeadSP = 17625.3, ChaoSeadLV = 0.154615);
  end Cisdecahydronaphthalene;
  
  model Transdecahydronaphthalene
  extends General_Properties(
    SN = 191, name = "Transdecahydronaphthalene", CAS = "493-02-7", Tc = 687.05, Pc = 2837100,  Vc = 0.48, Cc = 0.238, Tb = 460.46, Tm = 242.77, TT = 242.79, TP = 1.14983, MW = 138.253, LVB = 0.159325, AF = 0.253611, SP = 17042.7, DM = 0, SH = -168070000.0, IGHF = -1.8217E+08, GEF = 7.355E+07, AS = 374550, HFMP = 1.441E+07, HOC = -5.88088E+09, LiqDen = {105,0.5599,0.26991,687.05,0.2952,0}, VP = {101,112.0059,-9619.314,-13.21808,6.974439E-06,2}, LiqCp = {16,110470,-81.629,10.313,0.0068781,-0.0000045952}, HOV = {106,7.646155E+07,0.918445,0.395142,-2.202434,1.398354}, VapCp = {16,81351,-707.34,13.793,-0.00018944,2.0365E-08}, LiqVis = {101,-47.21,3037.9,5.4682,-0.0000042842,2}, VapVis = {102,2.7061E-07,0.60485,153.09,81.09,0}, LiqK = {16,0.087771,45.415,-2.1613,-0.0061939,0.0000022159}, VapK = {102,-13.928,0.65448,-2837300,-2.043E+09,0}, Racketparam = 0.268306, UniquacR = 6.289, UniquacQ = 4.776, ChaoSeadAF = 0.253611, ChaoSeadSP = 17042.7, ChaoSeadLV = 0.159325);
  end Transdecahydronaphthalene;
  
  model Methyltertbutylether
  extends General_Properties(
    SN = 192, name = "Methyltertbutylether", CAS = "1634-04-4", Tc = 497.1, Pc = 3430000,  Vc = 0.329, Cc = 0.273, Tb = 328.35, Tm = 164.55, TT = 164.55, TP = 0.535656, MW = 88.1482, LVB = 0.119887, AF = 0.266059, SP = 15070, DM = 4.54E-30, SH = -168070000.0, IGHF = -2.835E+08, GEF = -1.175E+08, AS = 357800, HFMP = 7600000, HOC = -3.1049E+09, LiqDen = {105,1.013,0.29119,513.95,0.39929,0}, VP = {101,63.31041,-5322.676,-6.212745,3.951136E-06,2}, LiqCp = {16,135550,-54.229,8.6558,0.010329,-0.0000078206}, HOV = {106,7.685222E+07,4.561833,-12.06881,13.61234,-5.569118}, VapCp = {16,89729,-682.14,12.912,0.000021441,-2.0192E-08}, LiqVis = {101,-7.136,821.59,-0.64419,4.8322E-07,2}, VapVis = {102,1.6185E-07,0.73614,130.03,-727.78,0}, LiqK = {16,0.073008,306.73,-6.3111,0.019235,-0.000037933}, VapK = {102,0.00023034,0.92128,391.6,80274,0}, Racketparam = 0.267213, UniquacR = 4.0678, UniquacQ = 3.632, ChaoSeadAF = 0.266059, ChaoSeadSP = 15070, ChaoSeadLV = 0.119887);
  end Methyltertbutylether;
  
  model Methyltertpentylether
  extends General_Properties(
    SN = 193, name = "Methyltertpentylether", CAS = "994-05-8", Tc = 534, Pc = 3040000,  Vc = 0.386, Cc = 0.264, Tb = 359.51, Tm = 0, TT = 0, TP = 0, MW = 102.175, LVB = 0.133437, AF = 0.298071, SP = 15480, DM = 4.90339E-30, SH = -168070000.0, IGHF = -3.054E+08, GEF = -1.137E+08, AS = 408000, HFMP = 0, HOC = -3.71229E+09, LiqDen = {105,0.68843,0.26574,534,0.27067,0}, VP = {101,127.09,-8433.7,-15.94,0.000013112,2}, LiqCp = {16,96936,-844.6,17.426,-0.01423,0.000014683}, HOV = {106,6.112039E+07,2.144847,-4.987322,5.569725,-2.294462}, VapCp = {16,86134,-503.3,12.828,0.00026316,-9.3404E-08}, LiqVis = {101,-11.271,991.37,-0.019082,-2.1664E-08,2}, VapVis = {102,6.9893E-08,0.83491,61.227,-3034.8,0}, LiqK = {16,-0.10613,12.391,-1.3082,-0.00026248,-0.0000013654}, VapK = {102,0.12493,0.14978,1706.4,1349200,0}, Racketparam = 0.264404, UniquacR = 4.7422, UniquacQ = 4.172, ChaoSeadAF = 0.298071, ChaoSeadSP = 15480, ChaoSeadLV = 0.133437);
  end Methyltertpentylether;
  
  model TwomethylTwobutanol
  extends General_Properties(
    SN = 194, name = "TwomethylTwobutanol", CAS = "75-85-4", Tc = 545, Pc = 3790000,  Vc = 0.323, Cc = 0.27, Tb = 375.15, Tm = 264.35, TT = 264.35, TP = 161.196, MW = 88.15, LVB = 0.1095, AF = 0.478, SP = 20840, DM = 5.67E-30, SH = -168070000.0, IGHF = -3.297E+08, GEF = -1.652E+08, AS = 362800, HFMP = 4456000, HOC = -3.0391E+09, LiqDen = {105,0.71131,0.24603,545,0.25077,0}, VP = {101,111.96,-9620.4,-12.673,0.0000022964,2}, LiqCp = {16,145240,-80.948,10.283,0.0042992,0.0000021924}, HOV = {106,1.022286E+08,1.245977,-0.515176,-0.350588,0.262112}, VapCp = {16,74328,-529.61,12.79,0.000073612,-9.0525E-09}, LiqVis = {101,-783.84,31606,120.39,-0.00015466,2}, VapVis = {102,1.8945E-07,0.71394,173.97,-1855.4,0}, LiqK = {16,0.052544,-120.78,-0.20746,-0.0081579,0.0000039201}, VapK = {102,1156.2,0.93842,5.9829E+09,-1.5337E+11,0}, Racketparam = 0.248616, UniquacR = 4.5972, UniquacQ = 4.284, ChaoSeadAF = 0.478, ChaoSeadSP = 20840, ChaoSeadLV = 0.1095);
  end TwomethylTwobutanol;
  
  model Nitrogentrioxide
  extends General_Properties(
    SN = 195, name = "Nitrogentrioxide", CAS = "10544-73-7", Tc = 451, Pc = 6990000,  Vc = 0.195, Cc = 0.386, Tb = 276.65, Tm = 171.15, TT = 172.45, TP = 15.1767, MW = 76.0116, LVB = 0.0531885, AF = 0.431227, SP = 32600, DM = 7.078E-30, SH = 82843000.0, IGHF = 8.2843E+07, GEF = 1.39727E+08, AS = 308450, HFMP = 0, HOC = -8.2843E+07, LiqDen = {105,2.7664,0.37489,451,0.040027,0}, VP = {101,137.96,-7584.5,-17.9,0.000022014,2}, LiqCp = {0,0,0,0,0,0}, HOV = {106,6.1243E+07,0.17457,-0.20195,-0.16172,0.24757}, VapCp = {16,37365,-232.94,10.977,0.00031169,-1.1931E-07}, LiqVis = {0,0,0,0,0,0}, VapVis = {0,0,0,0,0,0}, LiqK = {16,0,0,0,0,0}, VapK = {0,0,0,0,0,0}, Racketparam = 0.386, UniquacR = 1.738827, UniquacQ = 1.7628, ChaoSeadAF = 0.431227, ChaoSeadSP = 32600, ChaoSeadLV = 0.0531885);
  end Nitrogentrioxide;
  
  model Nitrogentetroxide
  extends General_Properties(
    SN = 196, name = "Nitrogentetroxide", CAS = "10544-72-6", Tc = 431.15, Pc = 1.00312E+07,  Vc = 0.08249, Cc = 0.233, Tb = 294.3, Tm = 263.01, TT = 261.9, TP = 18558.7, MW = 92.011, LVB = 0.06407, AF = 0.853274, SP = 24123.32, DM = 0, SH = 9162960.0, IGHF = 9162960, GEF = 9.785E+07, AS = 304320, HFMP = 1.465E+07, HOC = 1983170, LiqDen = {105,2.117,0.32671,431.15,0.20832,0}, VP = {101,72.419,-5432,-7.7259,0.00001711,2}, LiqCp = {16,112080,15.081,5.5387,0.025083,-0.000030338}, HOV = {106,3.0678E+07,0.17744,-0.16521,-0.11792,0.13193}, VapCp = {16,39950.82,-260.1236,11.41281,0.000224817,-1.049284E-07}, LiqVis = {101,-340.1,10957,53.641,-0.00011365,2}, VapVis = {102,0.0000080298,0.2905,212.56,117290,0}, LiqK = {16,0.11499,26916,-297.75,1.089,-0.0013592}, VapK = {102,0.000019664,1.1277,265.48,-210280,0}, Racketparam = 0.233, UniquacR = 1.982861, UniquacQ = 1.984, ChaoSeadAF = 0.853274, ChaoSeadSP = 24123.32, ChaoSeadLV = 0.06407);
  end Nitrogentetroxide;
  
  model HeliumFour
  extends General_Properties(
    SN = 197, name = "HeliumFour", CAS = "7440-59-7", Tc = 5.19, Pc = 227000,  Vc = 0.0573, Cc = 0.301, Tb = 4.3, Tm = 1.763, TT = 1.763, TP = 1478.21, MW = 4.003, LVB = 0.03254, AF = -0.39, SP = 1222, DM = 0, SH = 0.0, IGHF = 0, GEF = 0, AS = 126044, HFMP = 50000, HOC = 0, LiqDen = {105,0.31844,0.089499,5.21,0.063807,0}, VP = {101,8.8804,-4.8932,2.5648,0.0062779,2}, LiqCp = {16,-72432,14.864,0.90909,1.9106,-0.057997}, HOV = {106,191120,4.6881,-12.652,12.947,-4.5859}, VapCp = {1,20786,0,0,0,0}, LiqVis = {101,-21.436,10.949,5.7389,-0.11646,2}, VapVis = {102,3.3098E-07,0.71183,-10.485,126.3,0}, LiqK = {16,-0.19278,-0.8853,-0.83633,-0.19115,0.016867}, VapK = {102,0.00226,0.7305,-18.63,440,0}, Racketparam = 0.301, UniquacR = 0.456163, UniquacQ = 0.592, ChaoSeadAF = -0.39, ChaoSeadSP = 1222, ChaoSeadLV = 0.03254);
  end HeliumFour;
  
  model Fluorine
  extends General_Properties(
    SN = 198, name = "Fluorine", CAS = "7782-41-4", Tc = 144.3, Pc = 5215000,  Vc = 0.0662, Cc = 0.288, Tb = 84.95, Tm = 53.53, TT = 53.48, TP = 252, MW = 37.997, LVB = 0.02516, AF = 0.051, SP = 15210, DM = 0, SH = 0.0, IGHF = 0, GEF = 0, AS = 202690, HFMP = 510360, HOC = 0, LiqDen = {105,2.7003,0.23171,144.42,0.21541,0}, VP = {101,19.18299,-840.6862,0.560464,-0.0000352006,2}, LiqCp = {16,56031,-8382.1,267.49,-2.7228,0.0096889}, HOV = {106,2.7497E+07,7.2112,-17.699,17.895,-6.7781}, VapCp = {16,29021.05,-721.5995,10.44015,-0.00105401,3.331903E-07}, LiqVis = {101,9.2895,-86.903,-3.7445,0.0000058477,2}, VapVis = {102,7.0875E-07,0.64956,73.747,-637.02,0}, LiqK = {16,-0.15422,9.0003,-1.0608,-0.0018487,-0.00001682}, VapK = {102,0.00012664,0.93229,1.6645,205.53,0}, Racketparam = 0.288, UniquacR = 0.75, UniquacQ = 0.88, ChaoSeadAF = 0.051, ChaoSeadSP = 15210, ChaoSeadLV = 0.02516);
  end Fluorine;
  
  model Krypton
  extends General_Properties(
    SN = 199, name = "Krypton", CAS = "7439-90-9", Tc = 209.4, Pc = 5500000,  Vc = 0.0912, Cc = 0.288, Tb = 119.74, Tm = 115.77, TT = 115.78, TP = 73149.9, MW = 83.8, LVB = 0.03463, AF = 0.005, SP = 15280, DM = 0, SH = 0.0, IGHF = 0, GEF = 0, AS = 163975, HFMP = 1640130, HOC = 0, LiqDen = {105,2.5742,0.26395,209.4,0.25018,0}, VP = {101,48.208,-1609,-4.9593,0.0000342,2}, LiqCp = {16,36193,105.13,3.9876,0.048456,-0.0001134}, HOV = {106,1.7515E+07,2.6595,-6.0031,6.068,-2.2776}, VapCp = {16,20754,0,0,0,0}, LiqVis = {101,-7.7422,-0.3975,-0.00054036,-9.2221E-08,2}, VapVis = {102,0.0000018282,0.5384,165.83,-1432.5,0}, LiqK = {16,-0.22624,-10.133,-0.77044,-0.0023081,-0.0000013009}, VapK = {102,0.00075369,0.52925,198.58,-4150.2,0}, Racketparam = 0.288, UniquacR = 1.12, UniquacQ = 1.12, ChaoSeadAF = 0.005, ChaoSeadSP = 15280, ChaoSeadLV = 0.03463);
  end Krypton;
  
  model Xenon
  extends General_Properties(
    SN = 200, name = "Xenon", CAS = "7440-63-3", Tc = 289.74, Pc = 5840000,  Vc = 0.118, Cc = 0.286, Tb = 165.01, Tm = 161.25, TT = 161.25, TP = 81667.9, MW = 131.29, LVB = 0.04291, AF = 0.006, SP = 15910, DM = 0, SH = 0.0, IGHF = 0, GEF = 0, AS = 169578, HFMP = 2294950, HOC = 0, LiqDen = {105,2.4063,0.28552,289.74,0.28967,0}, VP = {101,31.497,-1758.9,-1.8727,0.0000091652,2}, LiqCp = {16,44610,-221,1.0811,0.026515,-0.000013257}, HOV = {106,1.740633E+07,-0.233725,3.148357,-4.995262,2.477111}, VapCp = {16,20786,0,0,0,0}, LiqVis = {101,-7.7421,-0.53776,-0.00050184,-5.2934E-08,2}, VapVis = {102,0.0000014055,0.57778,188.46,-312.26,0}, LiqK = {16,-0.012175,143.58,-4.2655,0.011041,-0.000032937}, VapK = {102,0.00026719,0.62046,215.6,-8144.4,0}, Racketparam = 0.286, UniquacR = 1.13, UniquacQ = 1.13, ChaoSeadAF = 0.006, ChaoSeadSP = 15910, ChaoSeadLV = 0.04291);
  end Xenon;
  
  model Ozone
  extends General_Properties(
    SN = 201, name = "Ozone", CAS = "10028-15-6", Tc = 261.05, Pc = 5570000,  Vc = 0.0894, Cc = 0.229, Tb = 161.8, Tm = 22.1499, TT = 80.15, TP = 0.734621, MW = 47.998, LVB = 0.0354, AF = 0.224, SP = 18740, DM = 1.8E-30, SH = 143100000.0, IGHF = 1.431E+08, GEF = 1.63164E+08, AS = 238823, HFMP = 2000000, HOC = -1.42671E+08, LiqDen = {105,2.6432,0.26544,261.05,0.25239,0}, VP = {101,33.80011,-2066.264,-1.865143,3.696996E-08,2}, LiqCp = {16,64500,-60.205,9.9787,0.0080434,-0.000010929}, HOV = {106,1.6254E+07,-0.073447,0.14823,0.62225,-0.43277}, VapCp = {16,32859.57,-604.7407,10.91207,-0.000287995,2.632407E-08}, LiqVis = {101,-37.036,815.78,4.8971,-0.000047646,2}, VapVis = {102,0.0000001896,0.78539,36.908,-2041.9,0}, LiqK = {16,0.23255,-678.09,-6.5705,-0.074977,0.00025391}, VapK = {102,0.0043907,0.47832,709.48,233.72,0}, Racketparam = 0.229, UniquacR = 1.1, UniquacQ = 1.27, ChaoSeadAF = 0.224, ChaoSeadSP = 18740, ChaoSeadLV = 0.0354);
  end Ozone;
  
  model Carbonylsulfide
  extends General_Properties(
    SN = 202, name = "Carbonylsulfide", CAS = "463-58-1", Tc = 375.15, Pc = 6349000,  Vc = 0.14, Cc = 0.272, Tb = 223.15, Tm = 134.35, TT = 134.3, TP = 101.325, MW = 60.0751, LVB = 0.0510474, AF = 0.137779, SP = 14270, DM = 2.37E-30, SH = -138410000.0, IGHF = -1.3841E+08, GEF = -1.692E+08, AS = 231470, HFMP = 4725000, HOC = -5.4827E+08, LiqDen = {105,1.8896,0.27226,378.81,0.25315,0}, VP = {101,74.34266,-3813.497,-8.620386,0.0000180431,2}, LiqCp = {16,71808,-8528.4,73.159,-0.16854,0.00016953}, HOV = {106,3.0555E+07,0.84937,-0.32129,-0.52716,0.40226}, VapCp = {16,28351,-363.89,10.752,-0.00019902,7.0945E-08}, LiqVis = {101,-9.091,494.42,-0.20653,-6.4588E-07,2}, VapVis = {102,0.000010184,0.2938,1012.7,-12250,0}, LiqK = {16,0.032218,-41.011,-0.83624,-0.0051268,0.0000012154}, VapK = {102,0.0012701,0.60437,545.23,3627.6,0}, Racketparam = 0.272, UniquacR = 1.707317, UniquacQ = 1.620988, ChaoSeadAF = 0.096, ChaoSeadSP = 14270, ChaoSeadLV = 0.0510474);
  end Carbonylsulfide;
  
  model Sulfurhexafluoride
  extends General_Properties(
    SN = 203, name = "Sulfurhexafluoride", CAS = "2551-62-4", Tc = 318.72, Pc = 3760000,  Vc = 0.1984, Cc = 0.282, Tb = 209.25, Tm = 222.65, TT = 223.15, TP = 232670, MW = 146.056, LVB = 0.07981, AF = 0.208, SP = 7681, DM = 0, SH = -1209000000.0, IGHF = -1.209E+09, GEF = -1.1053E+09, AS = 291710, HFMP = 5024200, HOC = 9.24E+08, LiqDen = {105,1.0016,0.23435,318.74,0.24027,0}, VP = {101,-17.60907,-1028.369,6.556299,-0.0000178874,2}, LiqCp = {16,119500,-2040,-9.5251,0.005216,-0.000044691}, HOV = {106,5.0769E+07,8.5605,-25.709,29.437,-11.774}, VapCp = {16,32322,-368.1,12.478,-0.00063326,1.9169E-07}, LiqVis = {101,20.959,-457.46,-4.9486,0.0000065105,2}, VapVis = {102,5.9343E-07,0.62415,62.573,13289,0}, LiqK = {16,-0.064331,-179.32,0.36969,-0.0050683,-0.0000040693}, VapK = {102,0.0013269,0.52727,30.264,73930,0}, Racketparam = 0.282, UniquacR = 3.085036, UniquacQ = 3.28, ChaoSeadAF = 0.208, ChaoSeadSP = 7681, ChaoSeadLV = 0.07981);
  end Sulfurhexafluoride;
  
  model Dimethylsulfoxide
  extends General_Properties(
    SN = 204, name = "Dimethylsulfoxide", CAS = "67-68-5", Tc = 729, Pc = 5650000,  Vc = 0.227, Cc = 0.212, Tb = 462.15, Tm = 291.67, TT = 291.67, TP = 50.2288, MW = 78.1334, LVB = 0.071277, AF = 0.280551, SP = 26750, DM = 1.32E-29, SH = -1209000000.0, IGHF = -2.092E+08, GEF = -1.157E+08, AS = 306300, HFMP = 1.393E+07, HOC = -1.6054E+09, LiqDen = {105,1.1064,0.25156,729,0.33043,0}, VP = {101,87.24911,-9095.583,-9.246359,3.215062E-06,2}, LiqCp = {16,148920,274.35,2.2127,0.017296,-0.000001184}, HOV = {106,4.1934E+08,12.701,-33.974,36.922,-14.839}, VapCp = {16,61635,-582.63,12.205,-0.000053872,2.2232E-08}, LiqVis = {101,33.492,223.29,-7.3227,0.000014294,2}, VapVis = {102,8.6219E-08,0.83436,168.37,-97.445,0}, LiqK = {16,0.081843,-215.42,0.15922,-0.0051305,0.0000011114}, VapK = {102,0.0006441,0.77214,1010.2,82198,0}, Racketparam = 0.212, UniquacR = 2.8266, UniquacQ = 2.472, ChaoSeadAF = 0.280551, ChaoSeadSP = 26750, ChaoSeadLV = 0.071277);
  end Dimethylsulfoxide;
  
  model Nheptadecane
  extends General_Properties(
    SN = 205, name = "Nheptadecane", CAS = "629-78-7", Tc = 736, Pc = 1340000,  Vc = 1.103, Cc = 0.242, Tb = 574.56, Tm = 295.127, TT = 295.134, TP = 0.0465559, MW = 240.473, LVB = 0.31045, AF = 0.762, SP = 16100, DM = 0, SH = -1209000000.0, IGHF = -3.939E+08, GEF = 9.083E+07, AS = 820230, HFMP = 4.0459E+07, HOC = -1.05618E+10, LiqDen = {105,0.1972,0.22446,736,0.27261,0}, VP = {101,230.4768,-19512.15,-29.73776,0.0000119109,2}, LiqCp = {16,341660,-48.077,11.234,0.0041437,-0.0000017269}, HOV = {106,1.1837E+08,0.45937,1.0501,-1.8353,0.77357}, VapCp = {16,247870,-663.74,14.166,-0.00017722,5.7891E-08}, LiqVis = {101,-77.193,4597,9.9892,-0.0000084702,2}, VapVis = {102,3.2694E-07,0.5961,448.22,45523,0}, LiqK = {16,-0.015537,-239.33,0.042685,-0.0038367,8.6547E-07}, VapK = {102,-115.33,1.0524,-2.1515E+09,-1.3137E+10,0}, Racketparam = 0.242, UniquacR = 11.9182, UniquacQ = 9.796, ChaoSeadAF = 0.762, ChaoSeadSP = 16100, ChaoSeadLV = 0.31045);
  end Nheptadecane;
  
  model Noctadecane
  extends General_Properties(
    SN = 206, name = "Noctadecane", CAS = "593-45-3", Tc = 747, Pc = 1290000,  Vc = 1.189, Cc = 0.247, Tb = 588.3, Tm = 301.33, TT = 301.33, TP = 0.0339091, MW = 254.5, LVB = 0.32666, AF = 0.808, SP = 16100, DM = 0, SH = -1209000000.0, IGHF = -4.1457E+08, GEF = 9.921E+07, AS = 859450, HFMP = 6.1986E+07, HOC = -1.11726E+10, LiqDen = {105,0.21099,0.23901,748.16,0.28153,0}, VP = {101,156.4726,-16120.27,-18.72498,5.38655E-06,2}, LiqCp = {16,332820,-15.176,11.369,0.0039066,-0.0000015738}, HOV = {106,1.214E+08,0.36333,1.283,-2.0514,0.85175}, VapCp = {16,258960,-641.43,14.136,-0.000068602,1.814E-08}, LiqVis = {101,-83.956,4978.7,10.99,-0.0000089834,2}, VapVis = {102,3.2955E-07,0.58255,343.75,67974,0}, LiqK = {16,-0.046627,-130.56,-0.64842,-0.0017182,-4.6995E-07}, VapK = {102,-198.99,1.1011,-5.9685E+09,5.2419E+11,0}, Racketparam = 0.247, UniquacR = 12.5926, UniquacQ = 10.336, ChaoSeadAF = 0.808, ChaoSeadSP = 16100, ChaoSeadLV = 0.32666);
  end Noctadecane;
  
  model Nnonadecane
  extends General_Properties(
    SN = 207, name = "Nnonadecane", CAS = "629-92-5", Tc = 760, Pc = 1230000,  Vc = 1.1, Cc = 0.215, Tb = 603.75, Tm = 305.05, TT = 305.04, TP = 0.0159089, MW = 268.521, LVB = 0.343701, AF = 0.8271, SP = 16200, DM = 0, SH = -1209000000.0, IGHF = -4.3514E+08, GEF = 1.075E+08, AS = 898930, HFMP = 5.02E+07, HOC = -1.17812E+10, LiqDen = {105,0.20149,0.23831,760,0.29903,0}, VP = {101,182.4003,-17843.62,-22.48728,7.349606E-06,2}, LiqCp = {16,244790,42.54,11.446,0.0046334,-0.0000026668}, HOV = {106,1.5404E+08,1.2215,-0.32899,-1.0541,0.6821}, VapCp = {16,274480,-648.39,14.221,-0.00011095,3.3607E-08}, LiqVis = {101,-84.761,5101,11.082,-0.0000087239,2}, VapVis = {102,3.0651E-07,0.58942,341.93,67425,0}, LiqK = {16,-0.057019,73.111,-2.1518,0.0021618,-0.0000035171}, VapK = {102,0.000043333,1.271,2799.6,138170,0}, Racketparam = 0.215, UniquacR = 13.267, UniquacQ = 10.876, ChaoSeadAF = 0.8271, ChaoSeadSP = 16200, ChaoSeadLV = 0.343701);
  end Nnonadecane;
  
  model Nheneicosane
  extends General_Properties(
    SN = 208, name = "Nheneicosane", CAS = "629-94-7", Tc = 798.64, Pc = 1391000,  Vc = 1.197, Cc = 0.211, Tb = 629.65, Tm = 313.65, TT = 313.35, TP = 0.00621532, MW = 296.574, LVB = 0.376581, AF = 0.942004, SP = 15900, DM = 0, SH = -1209000000.0, IGHF = -4.778E+08, GEF = 1.229E+08, AS = 985000, HFMP = 4.7698E+07, HOC = -1.296E+10, LiqDen = {105,0.0010945,0.018629,798.64,0.095543,0}, VP = {101,107.2451,-14833.82,-11.21418,3.606473E-07,2}, LiqCp = {16,268470,50.971,11.858,0.0031331,-0.0000010628}, HOV = {106,2.0592E+08,3.1557,-6.6833,7.1267,-3.099}, VapCp = {16,253120,-507.31,13.984,0.00027572,-9.6316E-08}, LiqVis = {101,-25.108,2540.9,2.0324,-0.0000013549,2}, VapVis = {102,2.9575E-07,0.62136,718.74,3255.3,0}, LiqK = {16,-0.22263,31.196,-1.0701,0.0001617,-7.0064E-07}, VapK = {102,-237.86,1.0527,-4.9708E+09,-8.9521E+10,0}, Racketparam = 0.211, UniquacR = 14.6158, UniquacQ = 11.956, ChaoSeadAF = 0.942004, ChaoSeadSP = 15900, ChaoSeadLV = 0.376581);
  end Nheneicosane;
  
  model Ndocosane
  extends General_Properties(
    SN = 209, name = "Ndocosane", CAS = "629-97-0", Tc = 808.83, Pc = 1339000,  Vc = 1.252, Cc = 0.209, Tb = 641.75, Tm = 318.25, TT = 317.15, TP = 0.00359575, MW = 310.601, LVB = 0.393226, AF = 0.973, SP = 15800, DM = 0, SH = -1209000000.0, IGHF = -4.985E+08, GEF = 1.307E+08, AS = 1019000, HFMP = 4.8953E+07, HOC = -1.357E+10, LiqDen = {105,0.00088994,0.017172,808.83,0.094179,0}, VP = {101,270.663,-22731.61,-35.81794,0.0000193308,2}, LiqCp = {16,94846,-114.81,13.466,0.000531,3.3532E-07}, HOV = {106,1.5383E+08,1.0955,-1.2067,1.3977,-0.85529}, VapCp = {16,291820,-567.43,14.157,0.00012912,-4.9166E-08}, LiqVis = {101,-27.314,2728.1,2.3358,-0.0000013135,2}, VapVis = {102,2.8858E-07,0.62154,714.54,4582.3,0}, LiqK = {16,-0.148,-22.716,-0.91136,-0.00059496,-3.4759E-07}, VapK = {102,-270.77,1.0546,-5.8977E+09,-1.0935E+11,0}, Racketparam = 0.209, UniquacR = 15.2902, UniquacQ = 12.496, ChaoSeadAF = 0.973, ChaoSeadSP = 15800, ChaoSeadLV = 0.393226);
  end Ndocosane;
  
  model Ntricosane
  extends General_Properties(
    SN = 210, name = "Ntricosane", CAS = "638-67-5", Tc = 818.25, Pc = 1290000,  Vc = 1.307, Cc = 0.208, Tb = 653.15, Tm = 320.95, TT = 320.65, TP = 0.00186855, MW = 324.627, LVB = 0.4074, AF = 1.02617, SP = 15800, DM = 0, SH = -1209000000.0, IGHF = -5.192E+08, GEF = 1.39E+08, AS = 1064000, HFMP = 5.3974E+07, HOC = -1.417E+10, LiqDen = {105,0.048866,0.12922,818.25,0.20531,0}, VP = {101,-22.08031,-9534.111,8.274049,-0.0000125255,2}, LiqCp = {16,-58655,-99.845,13.754,0.00030768,3.7705E-07}, HOV = {106,1.6434E+08,1.0068,-0.55169,0.31454,-0.3244}, VapCp = {16,304710,-567.01,14.201,0.00012862,-4.8999E-08}, LiqVis = {101,-8.8394,1949.8,-0.47088,0.0000010446,2}, VapVis = {102,2.8518E-07,0.61933,704.01,6598.3,0}, LiqK = {16,-0.18218,0.19147,-0.94906,-0.00035642,-3.5025E-07}, VapK = {102,-232.83,1.0566,-5.2747E+09,-9.8604E+10,0}, Racketparam = 0.208, UniquacR = 15.9646, UniquacQ = 13.036, ChaoSeadAF = 1.02617, ChaoSeadSP = 15800, ChaoSeadLV = 0.4074);
  end Ntricosane;
  
  model Ntetracosane
  extends General_Properties(
    SN = 211, name = "Ntetracosane", CAS = "646-31-1", Tc = 810, Pc = 1020000,  Vc = 1.36, Cc = 0.207, Tb = 664.45, Tm = 324.05, TT = 323.75, TP = 0.00138507, MW = 338.654, LVB = 0.426088, AF = 1.07102, SP = 15800, DM = 0, SH = -1209000000.0, IGHF = -5.4E+08, GEF = 1.472E+08, AS = 1097000, HFMP = 5.4894E+07, HOC = -1.479E+10, LiqDen = {105,0.013821,0.07087,810,0.13885,0}, VP = {101,118.4643,-17014.83,-12.51446,1.109888E-07,2}, LiqCp = {16,397960,-97.814,12.108,0.0038156,-0.0000022229}, HOV = {106,1.5462E+08,0.24892,1.8808,-2.829,1.1319}, VapCp = {16,318880,-569.39,14.249,0.00012213,-4.6983E-08}, LiqVis = {101,-64.748,4433,8.0272,-0.0000059771,2}, VapVis = {102,2.9788E-07,0.59708,514.64,49388,0}, LiqK = {16,0.046069,-245.01,-0.62562,-0.0019192,-0.0000023135}, VapK = {102,-232.02,1.063,-5.6529E+09,-8.4042E+10,0}, Racketparam = 0.207, UniquacR = 16.639, UniquacQ = 13.576, ChaoSeadAF = 1.07102, ChaoSeadSP = 15800, ChaoSeadLV = 0.426088);
  end Ntetracosane;
  
  model Npentacosane
  extends General_Properties(
    SN = 212, name = "Npentacosane", CAS = "629-99-2", Tc = 836.31, Pc = 1202000,  Vc = 1.418, Cc = 0.205, Tb = 675.05, Tm = 327.9, TT = 326.65, TP = 0.00079876, MW = 352.68, LVB = 0.442767, AF = 1.10526, SP = 15800, DM = 0, SH = -1209000000.0, IGHF = -5.607E+08, GEF = 1.553E+08, AS = 1143000, HFMP = 5.7739E+07, HOC = -1.539E+10, LiqDen = {105,0.00063401,0.015388,836.31,0.093752,0}, VP = {101,-203.2504,-1095.063,35.1974,-0.0000282197,2}, LiqCp = {16,528340,-126.87,12.075,0.002955,-9.8642E-07}, HOV = {106,1.9288E+08,1.8937,-3.4712,3.9636,-1.9344}, VapCp = {16,330530,-566.25,14.283,0.00012874,-4.9096E-08}, LiqVis = {101,-9.804,1971.8,-0.26998,3.9914E-07,2}, VapVis = {102,2.8769E-07,0.61575,746.72,4040.4,0}, LiqK = {16,0.0058343,-203.86,-0.37432,-0.0029792,2.4773E-07}, VapK = {102,-266.99,1.0606,-6.4961E+09,-1.2167E+11,0}, Racketparam = 0.205, UniquacR = 17.3134, UniquacQ = 14.116, ChaoSeadAF = 1.10526, ChaoSeadSP = 15800, ChaoSeadLV = 0.442767);
  end Npentacosane;
  
  model Nhexacosane
  extends General_Properties(
    SN = 213, name = "Nhexacosane", CAS = "630-01-3", Tc = 844.7, Pc = 1162000,  Vc = 1.473, Cc = 0.203, Tb = 685.35, Tm = 329.55, TT = 329.25, TP = 0.000515816, MW = 366.707, LVB = 0.4561, AF = 1.15444, SP = 15800, DM = 0, SH = -1209000000.0, IGHF = -5.814E+08, GEF = 1.636E+08, AS = 1176000, HFMP = 5.9496E+07, HOC = -1.6E+10, LiqDen = {105,0.0012458,0.021983,844.7,0.10464,0}, VP = {101,-181.3952,-2296.288,31.90668,-0.0000256231,2}, LiqCp = {16,657670,-651.68,14.164,-0.00036454,7.7672E-07}, HOV = {106,2.0502E+08,2.0708,-3.8957,4.3419,-2.0579}, VapCp = {16,342560,-564.25,14.318,0.00013185,-5.001E-08}, LiqVis = {101,-92.13292,5845.982,12.08985,-8.198834E-06,2}, VapVis = {102,2.7977E-07,0.616,732.48,6359.2,0}, LiqK = {16,0.020148,-211.96,-0.39294,-0.0031327,1.9698E-07}, VapK = {102,-164.53,1.0626,-4.163E+09,-7.6944E+10,0}, Racketparam = 0.203, UniquacR = 17.9878, UniquacQ = 14.656, ChaoSeadAF = 1.15444, ChaoSeadSP = 15800, ChaoSeadLV = 0.4561);
  end Nhexacosane;
  
  model Nheptacosane
  extends General_Properties(
    SN = 214, name = "Nheptacosane", CAS = "593-49-7", Tc = 826, Pc = 883000,  Vc = 1.58, Cc = 0.203, Tb = 695.25, Tm = 332.65, TT = 332.15, TP = 0.000283125, MW = 380.734, LVB = 0.48815, AF = 1.21357, SP = 15810, DM = 0, SH = -1209000000.0, IGHF = -6.021E+08, GEF = 1.716E+08, AS = 1216000, HFMP = 6.0417E+07, HOC = -1.66E+10, LiqDen = {105,0.13373,0.23061,826,0.29272,0}, VP = {101,254.28,-25266,-32.268,0.0000098574,2}, LiqCp = {16,287690,-499.88,15.238,-0.0020847,0.000001614}, HOV = {106,1.738E+08,0.55455,0.6619,-1.1864,0.39235}, VapCp = {16,324210,-507.11,14.235,0.00027032,-9.4813E-08}, LiqVis = {101,-11.337,2071.7,-0.014083,1.056E-08,2}, VapVis = {102,2.7943E-07,0.60493,599.04,42458,0}, LiqK = {16,-0.12846,8.4662,-1.1232,-0.00036291,-3.8993E-07}, VapK = {102,-177.26,1.0676,-4.7446E+09,-7.2852E+10,0}, Racketparam = 0.203, UniquacR = 18.6622, UniquacQ = 15.196, ChaoSeadAF = 1.21357, ChaoSeadSP = 15810, ChaoSeadLV = 0.48815);
  end Nheptacosane;
  
  model Noctacosane
  extends General_Properties(
    SN = 215, name = "Noctacosane", CAS = "630-02-4", Tc = 843, Pc = 888000,  Vc = 1.58, Cc = 0.2, Tb = 704.75, Tm = 334.55, TT = 334.35, TP = 0.000104457, MW = 394.76, LVB = 0.492645, AF = 1.23752, SP = 15700, DM = 0, SH = -1209000000.0, IGHF = -6.228E+08, GEF = 1.799E+08, AS = 1255000, HFMP = 6.4643E+07, HOC = -1.722E+10, LiqDen = {105,0.0073167,0.055448,843,0.13236,0}, VP = {101,196.5874,-22285.21,-23.91336,7.155924E-06,2}, LiqCp = {16,494250,-131.76,12.406,0.0033619,-0.0000018387}, HOV = {106,2.0593E+08,0.90796,0.4061,-1.298,0.44283}, VapCp = {16,335140,-505.51,14.268,0.00027376,-9.6008E-08}, LiqVis = {101,-110.67,6750.2,14.886,-0.000010312,2}, VapVis = {102,0.0000003028,0.58316,487.28,64252,0}, LiqK = {16,-0.0095167,-82.828,-0.8204,-0.0023614,5.0131E-07}, VapK = {102,-190.77,1.0711,-5.355E+09,-7.036E+10,0}, Racketparam = 0.2, UniquacR = 19.3366, UniquacQ = 15.736, ChaoSeadAF = 1.23752, ChaoSeadSP = 15700, ChaoSeadLV = 0.492645);
  end Noctacosane;
  
  model Nnonacosane
  extends General_Properties(
    SN = 216, name = "Nnonacosane", CAS = "630-03-5", Tc = 838, Pc = 826000,  Vc = 1.69, Cc = 0.2, Tb = 713.95, Tm = 339.15, TT = 336.85, TP = 0.0000684619, MW = 408.787, LVB = 0.523824, AF = 1.26531, SP = 15500, DM = 0, SH = -1209000000.0, IGHF = -6.435E+08, GEF = 1.879E+08, AS = 1295000, HFMP = 6.6107E+07, HOC = -1.782E+10, LiqDen = {105,0.12857,0.23366,838,0.30121,0}, VP = {101,-4.241455,-11668.64,5.534214,-8.103778E-06,2}, LiqCp = {16,-89782,-199.31,14.448,-0.00027681,5.1812E-07}, HOV = {106,1.9213E+08,0.53282,0.78359,-0.96953,0.062608}, VapCp = {16,383900,-568.27,14.435,0.00012081,-4.6695E-08}, LiqVis = {101,-11.543,2141.6,0.0076776,-5.4408E-09,2}, VapVis = {102,2.7904E-07,0.59854,575.23,50800,0}, LiqK = {16,-0.1272,8.851,-1.1267,-0.00035068,-3.6961E-07}, VapK = {102,-257.69,1.0697,-7.2501E+09,-1.1593E+11,0}, Racketparam = 0.2, UniquacR = 20.011, UniquacQ = 16.276, ChaoSeadAF = 1.26531, ChaoSeadSP = 15500, ChaoSeadLV = 0.523824);
  end Nnonacosane;
  
  model Squalane
  extends General_Properties(
    SN = 217, name = "Squalane", CAS = "111-01-3", Tc = 863, Pc = 868000,  Vc = 1.64, Cc = 0.198, Tb = 623.15, Tm = 235.15, TT = 235.15, TP = 1.70072E-12, MW = 422.813, LVB = 0.526135, AF = 0.915303, SP = 14490, DM = 0, SH = -1209000000.0, IGHF = -6.896E+08, GEF = 1.868E+08, AS = 1272000, HFMP = 4.7E+07, HOC = -1.85E+10, LiqDen = {105,0.15996,0.26223,863,0.38604,0}, VP = {101,518.45,-40342,-70.491,0.00002486,2}, LiqCp = {16,-38276,-113.46,13.728,0.001186,-3.7363E-07}, HOV = {106,1.3274E+08,0.38,0,0,0}, VapCp = {16,369830,-553.39,14.489,0.00010319,-3.8186E-08}, LiqVis = {118,-347.8968,71874.9,53.72611,-0.0000616157,1.3}, VapVis = {102,2.2128E-07,0.5436,144.2,25.787,0}, LiqK = {16,-0.045427,7.6198,-1.8982,-0.00026051,-5.9557E-07}, VapK = {102,0.000056714,1.0625,551.79,75579,0}, Racketparam = 0.198, UniquacR = 20.6854, UniquacQ = 16.816, ChaoSeadAF = 0.915303, ChaoSeadSP = 14490, ChaoSeadLV = 0.526135);
  end Squalane;
  
  model Twomethylhexane
  extends General_Properties(
    SN = 218, name = "Twomethylhexane", CAS = "591-76-4", Tc = 530.1, Pc = 2730000,  Vc = 0.421, Cc = 0.261, Tb = 363.18, Tm = 154.9, TT = 154.9, TP = 0.00429886, MW = 100.204, LVB = 0.1486, AF = 0.331, SP = 14730, DM = 0, SH = -1209000000.0, IGHF = -1.9472E+08, GEF = 3470000, AS = 420410, HFMP = 9184000, HOC = -4.45935E+09, LiqDen = {105,0.4821,0.23526,530.41,0.23824,0}, VP = {101,90.20617,-6876.202,-10.31895,8.219062E-06,2}, LiqCp = {16,142210,82.605,8.5784,0.010085,-0.000006336}, HOV = {106,4.861947E+07,0.640142,-0.832218,0.945728,-0.370956}, VapCp = {16,88324,-552.27,13.044,0.00017909,-6.2753E-08}, LiqVis = {101,-10.237,971.42,-0.18335,0.0000010057,2}, VapVis = {102,0.0000041509,0.28637,700.76,14523,0}, LiqK = {16,0.060786,305.44,-6.3461,0.018265,-0.000033419}, VapK = {102,0.000062491,1.0749,-62.587,153720,0}, Racketparam = 0.261, UniquacR = 5.1734, UniquacQ = 4.392, ChaoSeadAF = 0.331, ChaoSeadSP = 14730, ChaoSeadLV = 0.1486);
  end Twomethylhexane;
  
  model Threemethylhexane
  extends General_Properties(
    SN = 219, name = "Threemethylhexane", CAS = "589-34-4", Tc = 535.2, Pc = 2810000,  Vc = 0.404, Cc = 0.255, Tb = 365, Tm = 153.75, TT = 153.75, TP = 0.00321303, MW = 100.204, LVB = 0.14674, AF = 0.323, SP = 14950, DM = 0, SH = -1209000000.0, IGHF = -1.9133E+08, GEF = 5080000, AS = 425930, HFMP = 9460000, HOC = -4.46177E+09, LiqDen = {105,0.53784,0.24926,535.2,0.22945,0}, VP = {101,86.76736,-6773.074,-9.77749,7.535909E-06,2}, LiqCp = {16,151720,437.07,3.0907,0.032504,-0.000034822}, HOV = {106,5.817768E+07,1.085699,-1.05321,0.37877,0.0254378}, VapCp = {16,80171,-511.41,12.979,0.00025345,-8.5984E-08}, LiqVis = {101,-11.794,999.53,0.086997,-2.3727E-07,2}, VapVis = {102,4.5226E-07,0.55481,210.53,14.061,0}, LiqK = {16,-0.14432,11.474,-1.2132,-0.00022172,-0.0000010949}, VapK = {102,0.000041038,1.1288,-121.44,150080,0}, Racketparam = 0.255, UniquacR = 5.1734, UniquacQ = 4.392, ChaoSeadAF = 0.323, ChaoSeadSP = 14950, ChaoSeadLV = 0.14674);
  end Threemethylhexane;
  
  model Threeethylpentane
  extends General_Properties(
    SN = 220, name = "Threeethylpentane", CAS = "617-78-7", Tc = 540.5, Pc = 2890000,  Vc = 0.4158, Cc = 0.267, Tb = 366.63, Tm = 154.55, TT = 154.55, TP = 0.00170947, MW = 100.204, LVB = 0.1444, AF = 0.311, SP = 15040, DM = 0, SH = -1209000000.0, IGHF = -1.89661E+08, GEF = 1.09202E+07, AS = 411540, HFMP = 9547890, HOC = -4.4642E+09, LiqDen = {105,0.56112,0.24813,540.61,0.27074,0}, VP = {101,89.99315,-6915.896,-10.27777,8.039283E-06,2}, LiqCp = {16,152590,204.56,5.9318,0.021701,-0.000022224}, HOV = {106,5.3257E+07,1.2647,-2.6729,3.1124,-1.3109}, VapCp = {16,102980,-630.04,13.15,0.000058616,-2.6799E-08}, LiqVis = {101,-11.885,1001.1,0.10351,-0.0000003544,2}, VapVis = {102,6.1521E-07,0.52741,287.77,1840.5,0}, LiqK = {16,-0.055574,4.7874,-1.5746,-0.0003945,-0.0000016303}, VapK = {102,0.000065519,1.0691,-74.423,161360,0}, Racketparam = 0.267, UniquacR = 5.1734, UniquacQ = 4.392, ChaoSeadAF = 0.311, ChaoSeadSP = 15040, ChaoSeadLV = 0.1444);
  end Threeethylpentane;
  
  model TwoTwodimethylpentane
  extends General_Properties(
    SN = 221, name = "TwoTwodimethylpentane", CAS = "590-35-2", Tc = 520.4, Pc = 2770000,  Vc = 0.4158, Cc = 0.266, Tb = 352.32, Tm = 149.34, TT = 149.34, TP = 0.00317517, MW = 100.204, LVB = 0.14967, AF = 0.287, SP = 14260, DM = 0, SH = -1209000000.0, IGHF = -2.06146E+08, GEF = 550000, AS = 392580, HFMP = 5824000, HOC = -4.45048E+09, LiqDen = {105,0.5639,0.25328,520.51,0.25578,0}, VP = {101,85.15112,-6377.959,-9.646055,8.426861E-06,2}, LiqCp = {16,129920,-35.818,9.4637,0.0091865,-0.0000074351}, HOV = {106,5.34663E+07,0.794603,-0.00994342,-0.969824,0.623819}, VapCp = {16,80553,-507.91,12.99,0.00027095,-7.6982E-08}, LiqVis = {101,-24.348,1370.4,2.2619,-0.0000092505,2}, VapVis = {102,3.1425E-07,0.61072,160.83,5436.3,0}, LiqK = {16,-0.052706,3.783,-1.5822,-0.00046167,-0.0000017248}, VapK = {102,0.000010009,1.3247,-199.43,115550,0}, Racketparam = 0.266, UniquacR = 5.1727, UniquacQ = 4.472, ChaoSeadAF = 0.287, ChaoSeadSP = 14260, ChaoSeadLV = 0.14967);
  end TwoTwodimethylpentane;
  
  model TwoThreedimethylpentane
  extends General_Properties(
    SN = 222, name = "TwoThreedimethylpentane", CAS = "565-59-3", Tc = 537.3, Pc = 2910000,  Vc = 0.393, Cc = 0.256, Tb = 362.91, Tm = 0, TT = 0, TP = 0, MW = 100.204, LVB = 0.14505, AF = 0.297, SP = 14820, DM = 0, SH = -1209000000.0, IGHF = -1.941E+08, GEF = 5610000, AS = 414550, HFMP = 0, HOC = -4.45567E+09, LiqDen = {105,0.60743,0.26317,537.3,0.2444,0}, VP = {101,81.051,-6444.3,-8.9383,0.0000069583,2}, LiqCp = {16,144370,-45.964,9.0642,0.010184,-0.0000082901}, HOV = {106,5.686611E+07,1.319959,-1.914129,1.410201,-0.377243}, VapCp = {16,33579,-324.43,12.683,0.00063287,-2.0243E-07}, LiqVis = {101,-16.952,1255.2,0.89405,-0.0000015964,2}, VapVis = {102,0.0000005037,0.54462,227.41,8.0354,0}, LiqK = {16,-0.054333,2.0859,-1.4922,-0.00079317,-0.0000012037}, VapK = {102,0.000019733,1.2301,-158.93,129950,0}, Racketparam = 0.256, UniquacR = 5.1726, UniquacQ = 4.388, ChaoSeadAF = 0.297, ChaoSeadSP = 14820, ChaoSeadLV = 0.14505);
  end TwoThreedimethylpentane;
  
  model TwoFourdimethylpentane
  extends General_Properties(
    SN = 223, name = "TwoFourdimethylpentane", CAS = "108-08-7", Tc = 519.7, Pc = 2740000,  Vc = 0.4175, Cc = 0.265, Tb = 353.62, Tm = 153.908, TT = 153.912, TP = 0.0066994, MW = 100.204, LVB = 0.14995, AF = 0.304, SP = 14290, DM = 0, SH = -1209000000.0, IGHF = -2.0167E+08, GEF = 3310000, AS = 397000, HFMP = 6845000, HOC = -4.454E+09, LiqDen = {105,0.49944,0.24101,519.81,0.23086,0}, VP = {101,86.23433,-6498.287,-9.772628,8.133363E-06,2}, LiqCp = {16,90283,22.117,10.293,0.0058192,-0.0000033296}, HOV = {106,5.636917E+07,1.083678,-0.919235,0.1428,0.13605}, VapCp = {16,66100,-427.67,12.876,0.00036594,-1.1245E-07}, LiqVis = {101,-15.849,1204.5,0.70216,-0.0000021284,2}, VapVis = {102,1.8633E-07,0.67603,100.62,-68.047,0}, LiqK = {16,-0.10048,3.798,-1.3824,-0.00040413,-0.0000011783}, VapK = {102,0.0002569,0.9033,147.33,182490,0}, Racketparam = 0.265, UniquacR = 5.1726, UniquacQ = 4.388, ChaoSeadAF = 0.304, ChaoSeadSP = 14290, ChaoSeadLV = 0.14995);
  end TwoFourdimethylpentane;
  
  model ThreeThreedimethylpentane
  extends General_Properties(
    SN = 224, name = "ThreeThreedimethylpentane", CAS = "562-49-2", Tc = 536.3, Pc = 2950000,  Vc = 0.4141, Cc = 0.274, Tb = 359.19, Tm = 138.7, TT = 138.7, TP = 0.000229687, MW = 100.204, LVB = 0.1454, AF = 0.269, SP = 14530, DM = 0, SH = -1209000000.0, IGHF = -2.0146E+08, GEF = 2719600, AS = 398150, HFMP = 7066780, HOC = -4.45458E+09, LiqDen = {105,0.57981,0.25238,536.41,0.28345,0}, VP = {101,74.58125,-6059.883,-7.986446,6.250113E-06,2}, LiqCp = {16,122500,86.779,8.7861,0.0099608,-0.0000069264}, HOV = {106,5.254E+07,1.1834,-1.8011,1.5275,-0.48856}, VapCp = {16,67595,-428.94,12.79,0.00052141,-1.6453E-07}, LiqVis = {101,-7.1051,998.94,-0.73694,0.0000026961,2}, VapVis = {102,9.3561E-07,0.48169,385.32,9.0702,0}, LiqK = {16,-0.050708,3.465,-1.5874,-0.00046821,-0.000001622}, VapK = {102,0.000069501,1.0643,-68.32,160740,0}, Racketparam = 0.274, UniquacR = 5.1727, UniquacQ = 4.472, ChaoSeadAF = 0.269, ChaoSeadSP = 14530, ChaoSeadLV = 0.1454);
  end ThreeThreedimethylpentane;
  
  model TwoTwoThreetrimethylbutane
  extends General_Properties(
    SN = 225, name = "TwoTwoThreetrimethylbutane", CAS = "464-06-2", Tc = 531.1, Pc = 2950000,  Vc = 0.3976, Cc = 0.266, Tb = 354.01, Tm = 248.253, TT = 248.57, TP = 914.054, MW = 100.204, LVB = 0.14615, AF = 0.25, SP = 14250, DM = 0, SH = -1209000000.0, IGHF = -2.04765E+08, GEF = 4600000, AS = 383340, HFMP = 2261030, HOC = -4.45223E+09, LiqDen = {105,0.36152,0.20413,531.16,0.1958,0}, VP = {101,68.92285,-5729.492,-7.139255,5.482993E-06,2}, LiqCp = {16,95157,-51.889,10.538,0.0057229,-0.0000043706}, HOV = {106,4.4282E+07,0.37696,0.13995,-0.28638,0.1473}, VapCp = {16,64561,-425.21,12.779,0.00055174,-1.7221E-07}, LiqVis = {101,15.143,240.01,-4.2433,0.0000080652,2}, VapVis = {102,8.5825E-08,0.78963,152.98,-29510,0}, LiqK = {16,0.044619,-214.12,0.30167,-0.0096656,0.0000053979}, VapK = {102,0.000030164,1.1874,-102.65,141040,0}, Racketparam = 0.266, UniquacR = 5.1719, UniquacQ = 4.468, ChaoSeadAF = 0.25, ChaoSeadSP = 14250, ChaoSeadLV = 0.14615);
  end TwoTwoThreetrimethylbutane;
  
  model Twomethylheptane
  extends General_Properties(
    SN = 226, name = "Twomethylheptane", CAS = "592-27-8", Tc = 559.6, Pc = 2480000,  Vc = 0.4882, Cc = 0.26, Tb = 390.8, Tm = 164.16, TT = 164.16, TP = 0.0010587, MW = 114.231, LVB = 0.16463, AF = 0.378, SP = 15050, DM = 0, SH = -1209000000.0, IGHF = -2.154E+08, GEF = 1.18E+07, AS = 459570, HFMP = 1.1878E+07, HOC = -5.06933E+09, LiqDen = {105,0.40246,0.22797,559.66,0.23428,0}, VP = {101,97.9971,-7746.664,-11.37588,8.143433E-06,2}, LiqCp = {16,66821,33.207,11.285,0.0021902,8.6142E-07}, HOV = {106,6.657838E+07,1.352117,-1.871983,1.354613,-0.391149}, VapCp = {16,108850,-612.4,13.327,-0.0000091854,-2.9587E-09}, LiqVis = {101,-7.3762,968.16,-0.65227,0.0000018143,2}, VapVis = {102,4.5347E-07,0.55194,231.19,-1256.6,0}, LiqK = {16,-0.00038221,38.981,-2.075,0.00062625,-0.0000038423}, VapK = {102,0.000048089,1.0964,-142.76,170130,0}, Racketparam = 0.26, UniquacR = 5.8478, UniquacQ = 4.932, ChaoSeadAF = 0.378, ChaoSeadSP = 15050, ChaoSeadLV = 0.16463);
  end Twomethylheptane;
  
  model Threemethylheptane
  extends General_Properties(
    SN = 227, name = "Threemethylheptane", CAS = "589-81-1", Tc = 563.6, Pc = 2550000,  Vc = 0.4711, Cc = 0.253, Tb = 392.08, Tm = 152.65, TT = 152.6, TP = 0.0000523002, MW = 114.231, LVB = 0.16278, AF = 0.371, SP = 15180, DM = 0, SH = -1209000000.0, IGHF = -2.1251E+08, GEF = 1.275E+07, AS = 465510, HFMP = 1.163E+07, HOC = -5.0721E+09, LiqDen = {105,0.48768,0.25064,563.66,0.24544,0}, VP = {101,94.76732,-7652.539,-10.86325,7.450521E-06,2}, LiqCp = {16,137930,50.329,9.9028,0.0059467,-0.0000024618}, HOV = {106,6.899021E+07,1.39863,-1.771662,1.093723,-0.270846}, VapCp = {16,103080,-583.42,13.271,0.000052348,-2.126E-08}, LiqVis = {101,-7.3817,976.23,-0.66335,0.0000021183,2}, VapVis = {102,0.0000069865,0.21161,854.03,-2592.5,0}, LiqK = {16,-0.043161,22.706,-1.6829,-0.000063735,-0.0000020484}, VapK = {102,0.000042535,1.1138,-151.71,168420,0}, Racketparam = 0.253, UniquacR = 5.8478, UniquacQ = 4.932, ChaoSeadAF = 0.371, ChaoSeadSP = 15180, ChaoSeadLV = 0.16278);
  end Threemethylheptane;
  
  model Fourmethylheptane
  extends General_Properties(
    SN = 228, name = "Fourmethylheptane", CAS = "589-53-7", Tc = 561.7, Pc = 2540000,  Vc = 0.476, Cc = 0.259, Tb = 390.86, Tm = 152.19, TT = 152.2, TP = 0.0000457034, MW = 114.231, LVB = 0.16306, AF = 0.371, SP = 15140, DM = 0, SH = -1209000000.0, IGHF = -2.1196E+08, GEF = 1.571E+07, AS = 457390, HFMP = 1.08E+07, HOC = -5.07282E+09, LiqDen = {105,0.41247,0.23007,561.76,0.23229,0}, VP = {101,97.33843,-7742.706,-11.25952,7.843366E-06,2}, LiqCp = {16,123600,-18.717,11.067,0.0020327,0.0000016218}, HOV = {106,6.797167E+07,1.151616,-0.835173,-0.171743,0.314726}, VapCp = {16,100250,-569.74,13.266,0.000060406,-2.5661E-08}, LiqVis = {101,-11.11,1066.3,-0.039384,1.7455E-07,2}, VapVis = {102,0.0000043616,0.27023,695.06,-2959.1,0}, LiqK = {16,-0.096483,12.321,-1.3603,-0.00031289,-0.0000012186}, VapK = {102,0.000040274,1.1204,-164.18,166050,0}, Racketparam = 0.259, UniquacR = 5.8478, UniquacQ = 4.932, ChaoSeadAF = 0.371, ChaoSeadSP = 15140, ChaoSeadLV = 0.16306);
  end Fourmethylheptane;
  
  model Threeethylhexane
  extends General_Properties(
    SN = 229, name = "Threeethylhexane", CAS = "619-99-8", Tc = 565.4, Pc = 2610000,  Vc = 0.4605, Cc = 0.253, Tb = 391.69, Tm = 0, TT = 0, TP = 0, MW = 114.231, LVB = 0.16101, AF = 0.362, SP = 15210, DM = 0, SH = -1209000000.0, IGHF = -2.10874E+08, GEF = 1.68615E+07, AS = 457860, HFMP = 0, HOC = -5.07398E+09, LiqDen = {105,0.46206,0.24436,565.51,0.22747,0}, VP = {101,97.09596,-7733.566,-11.22583,7.810756E-06,2}, LiqCp = {16,80628,-64.909,11.186,0.0048319,-0.0000040172}, HOV = {106,5.4799E+07,0.26737,0.81877,-1.2904,0.59915}, VapCp = {16,115160,-618.28,13.279,0.0000464,-2.6202E-08}, LiqVis = {101,-7.8742,897.68,-0.5066,2.0784E-08,2}, VapVis = {102,3.7627E-07,0.57415,196.9,-172.94,0}, LiqK = {16,-0.001637,-138.28,-0.62782,-0.0040963,8.9774E-07}, VapK = {102,0.000056588,1.0789,-123.05,173090,0}, Racketparam = 0.253, UniquacR = 5.8478, UniquacQ = 4.932, ChaoSeadAF = 0.362, ChaoSeadSP = 15210, ChaoSeadLV = 0.16101);
  end Threeethylhexane;
  
  model TwoTwodimethylhexane
  extends General_Properties(
    SN = 230, name = "TwoTwodimethylhexane", CAS = "590-73-8", Tc = 549.8, Pc = 2530000,  Vc = 0.478, Cc = 0.265, Tb = 379.99, Tm = 151.97, TT = 151.97, TP = 0.000215228, MW = 114.231, LVB = 0.16529, AF = 0.339, SP = 14580, DM = 0, SH = -1209000000.0, IGHF = -2.24723E+08, GEF = 1.0711E+07, AS = 432710, HFMP = 6778080, HOC = -5.06247E+09, LiqDen = {105,0.54681,0.26386,549.8,0.27774,0}, VP = {101,94.06922,-7328.821,-10.84298,7.99047E-06,2}, LiqCp = {16,125360,373.89,5.844,0.022419,-0.00002308}, HOV = {106,6.211522E+07,1.000418,-0.588989,-0.277913,0.313577}, VapCp = {16,97647,-528.4,13.112,0.00027844,-9.0187E-08}, LiqVis = {101,-11.328,1166.6,-0.039718,2.6889E-07,2}, VapVis = {102,0.0000018535,0.38476,528.24,78.686,0}, LiqK = {16,-0.03878,5.2314,-1.6985,-0.00038448,-0.000001806}, VapK = {102,0.000045965,1.1142,-113.91,162780,0}, Racketparam = 0.265, UniquacR = 5.8471, UniquacQ = 5.012, ChaoSeadAF = 0.339, ChaoSeadSP = 14580, ChaoSeadLV = 0.16529);
  end TwoTwodimethylhexane;
  
  model TwoThreedimethylhexane
  extends General_Properties(
    SN = 231, name = "TwoThreedimethylhexane", CAS = "584-94-1", Tc = 563.4, Pc = 2630000,  Vc = 0.4682, Cc = 0.263, Tb = 388.76, Tm = 0, TT = 0, TP = 0, MW = 114.231, LVB = 0.16131, AF = 0.347, SP = 15020, DM = 0, SH = -1209000000.0, IGHF = -2.13886E+08, GEF = 1.50206E+07, AS = 451960, HFMP = 0, HOC = -5.07176E+09, LiqDen = {105,0.48655,0.24924,563.43,0.24533,0}, VP = {101,106.31,-8083.9,-12.636,0.000008991,2}, LiqCp = {16,-256410,53.354,11.988,0.00458,-0.0000045457}, HOV = {106,5.5877E+07,0.44475,0.4503,-0.98905,0.49662}, VapCp = {16,55247,-379.2,12.913,0.00048944,-1.5722E-07}, LiqVis = {101,8.0389,480.9,-3.1555,0.0000074225,2}, VapVis = {102,4.4497E-07,0.56168,244.71,41.585,0}, LiqK = {16,-0.0041864,-133.36,-0.65326,-0.003975,8.3867E-07}, VapK = {102,0.000025619,1.1862,-177.9,153600,0}, Racketparam = 0.263, UniquacR = 5.847, UniquacQ = 4.928, ChaoSeadAF = 0.347, ChaoSeadSP = 15020, ChaoSeadLV = 0.16131);
  end TwoThreedimethylhexane;
  
  model TwoFourdimethylhexane
  extends General_Properties(
    SN = 232, name = "TwoFourdimethylhexane", CAS = "589-43-5", Tc = 553.5, Pc = 2560000,  Vc = 0.472, Cc = 0.263, Tb = 382.58, Tm = 0, TT = 0, TP = 0, MW = 114.231, LVB = 0.16408, AF = 0.344, SP = 14650, DM = 0, SH = -1209000000.0, IGHF = -2.19409E+08, GEF = 1.17152E+07, AS = 447600, HFMP = 0, HOC = -5.06733E+09, LiqDen = {105,0.49412,0.25086,553.5,0.26728,0}, VP = {101,110.28,-8135.7,-13.268,0.0000097316,2}, LiqCp = {16,-373730,38.479,12.478,0.0035274,-0.0000034858}, HOV = {106,5.4006E+07,0.43973,0.30966,-0.70429,0.35515}, VapCp = {16,68028,-390.94,12.9,0.00049032,-1.6117E-07}, LiqVis = {101,-12.459,1208.2,0.16649,-2.1296E-07,2}, VapVis = {102,0.0000013835,0.41886,453.95,-1216.3,0}, LiqK = {16,-0.012272,-146.3,-0.49024,-0.0043592,0.0000013669}, VapK = {102,0.000028277,1.1747,-150.01,140960,0}, Racketparam = 0.263, UniquacR = 5.847, UniquacQ = 4.928, ChaoSeadAF = 0.344, ChaoSeadSP = 14650, ChaoSeadLV = 0.16408);
  end TwoFourdimethylhexane;
  
  model TwoFivedimethylhexane
  extends General_Properties(
    SN = 233, name = "TwoFivedimethylhexane", CAS = "592-13-2", Tc = 550, Pc = 2490000,  Vc = 0.482, Cc = 0.262, Tb = 382.26, Tm = 182, TT = 182, TP = 0.0683715, MW = 114.231, LVB = 0.1657, AF = 0.357, SP = 14740, DM = 0, SH = -1209000000.0, IGHF = -2.22631E+08, GEF = 1.046E+07, AS = 442330, HFMP = 1.29537E+07, HOC = -5.06398E+09, LiqDen = {105,0.49779,0.2525,550,0.26429,0}, VP = {101,87.65473,-7122.285,-9.843559,7.04047E-06,2}, LiqCp = {16,-51796,-110.09,12.759,0.00089408,-0.0000004354}, HOV = {106,6.2389E+07,1.0017,-0.72582,-0.024698,0.19155}, VapCp = {16,66542,-399.08,12.9,0.00049831,-1.6255E-07}, LiqVis = {101,-2.9399,836.45,-1.3966,0.00000447,2}, VapVis = {102,8.3872E-07,0.47833,344.26,27.957,0}, LiqK = {16,-0.074336,3.6543,-1.5091,-0.00039812,-0.0000013255}, VapK = {102,0.000029331,1.1695,-138.07,145330,0}, Racketparam = 0.262, UniquacR = 5.847, UniquacQ = 4.928, ChaoSeadAF = 0.357, ChaoSeadSP = 14740, ChaoSeadLV = 0.1657);
  end TwoFivedimethylhexane;
  
  model ThreeThreedimethylhexane
  extends General_Properties(
    SN = 234, name = "ThreeThreedimethylhexane", CAS = "563-16-6", Tc = 562, Pc = 2650000,  Vc = 0.4428, Cc = 0.251, Tb = 385.12, Tm = 147.05, TT = 147.05, TP = 0.0000473645, MW = 114.231, LVB = 0.16181, AF = 0.32, SP = 14880, DM = 0, SH = -1209000000.0, IGHF = -2.2012E+08, GEF = 1.32633E+07, AS = 438230, HFMP = 7112800, HOC = -5.06682E+09, LiqDen = {105,0.45959,0.24567,562,0.21162,0}, VP = {101,109.95,-8119.3,-13.232,0.0000097251,2}, LiqCp = {16,130950,-54.41,9.7102,0.0098373,-0.0000089507}, HOV = {106,5.8755E+07,0.81257,-0.27217,-0.51422,0.40803}, VapCp = {16,73854,-426.62,12.974,0.00044554,-1.4645E-07}, LiqVis = {101,-7.0202,924.42,-0.69061,0.0000021821,2}, VapVis = {102,1.9286E-07,0.65784,75.166,8686.9,0}, LiqK = {16,-0.074777,3.6654,-1.4953,-0.00045709,-0.000001113}, VapK = {102,0.000028072,1.1786,-168.43,151580,0}, Racketparam = 0.251, UniquacR = 5.8471, UniquacQ = 5.012, ChaoSeadAF = 0.32, ChaoSeadSP = 14880, ChaoSeadLV = 0.16181);
  end ThreeThreedimethylhexane;
  
  model ThreeFourdimethylhexane
  extends General_Properties(
    SN = 235, name = "ThreeFourdimethylhexane", CAS = "583-48-2", Tc = 568.8, Pc = 2690000,  Vc = 0.4588, Cc = 0.265, Tb = 390.88, Tm = 0, TT = 0, TP = 0, MW = 114.231, LVB = 0.15973, AF = 0.338, SP = 15140, DM = 0, SH = -1209000000.0, IGHF = -2.13007E+08, GEF = 1.674E+07, AS = 451580, HFMP = 0, HOC = -5.07251E+09, LiqDen = {105,0.45439,0.24011,568.8,0.23618,0}, VP = {101,93.68625,-7521.509,-10.73445,7.52569E-06,2}, LiqCp = {16,-327870,47.226,12.229,0.0041484,-0.000004128}, HOV = {106,5.4702E+07,0.45918,0.1856,-0.51513,0.26338}, VapCp = {16,34075,-331.34,12.881,0.00054108,-1.7153E-07}, LiqVis = {101,-41.742,2125.1,4.8163,-0.0000056466,2}, VapVis = {102,6.4152E-07,0.51789,310.46,157.69,0}, LiqK = {16,-0.0004002,-144.47,-0.57247,-0.0042745,0.0000010836}, VapK = {102,0.000020807,1.2133,-200.76,152640,0}, Racketparam = 0.265, UniquacR = 5.847, UniquacQ = 4.928, ChaoSeadAF = 0.338, ChaoSeadSP = 15140, ChaoSeadLV = 0.15973);
  end ThreeFourdimethylhexane;
  
  model TwomethylThreeethylpentane
  extends General_Properties(
    SN = 236, name = "TwomethylThreeethylpentane", CAS = "609-26-7", Tc = 567, Pc = 2700000,  Vc = 0.4453, Cc = 0.254, Tb = 388.81, Tm = 158.2, TT = 158.2, TP = 0.000447428, MW = 114.231, LVB = 0.15972, AF = 0.331, SP = 15140, DM = 0, SH = -1209000000.0, IGHF = -2.11208E+08, GEF = 1.87861E+07, AS = 443760, HFMP = 1.13386E+07, HOC = -5.07477E+09, LiqDen = {105,0.54567,0.26412,567.03,0.24308,0}, VP = {101,92.12933,-7403.468,-10.51119,7.396006E-06,2}, LiqCp = {16,11076,-131.1,12.479,0.0013888,-7.3844E-07}, HOV = {106,5.9697E+07,0.73134,0.033175,-0.91459,0.58962}, VapCp = {16,86476,-441,12.894,0.00051253,-1.9205E-07}, LiqVis = {101,-10.931,1059.8,-0.066598,1.3283E-07,2}, VapVis = {102,5.6587E-07,0.52506,255.1,-76.481,0}, LiqK = {16,-0.069311,4.0311,-1.5221,-0.00039448,-0.0000012799}, VapK = {102,0.000026967,1.1845,-133.92,140280,0}, Racketparam = 0.254, UniquacR = 5.847, UniquacQ = 4.928, ChaoSeadAF = 0.331, ChaoSeadSP = 15140, ChaoSeadLV = 0.15972);
  end TwomethylThreeethylpentane;
  
  model ThreemethylThreeethylpentane
  extends General_Properties(
    SN = 237, name = "ThreemethylThreeethylpentane", CAS = "1067-08-9", Tc = 576.5, Pc = 2810000,  Vc = 0.4551, Cc = 0.267, Tb = 391.42, Tm = 182.28, TT = 182.28, TP = 0.0625263, MW = 114.231, LVB = 0.15788, AF = 0.305, SP = 15060, DM = 0, SH = -1209000000.0, IGHF = -2.1485E+08, GEF = 2.288E+07, AS = 432960, HFMP = 1.08E+07, HOC = -5.0716E+09, LiqDen = {105,0.59884,0.27253,576.5,0.28169,0}, VP = {101,85.77668,-7097.92,-9.572218,6.70781E-06,2}, LiqCp = {16,77769,172.95,9.182,0.01021,-0.0000086615}, HOV = {106,6.3775E+07,1.5194,-2.4569,2.0687,-0.69375}, VapCp = {16,89715,-509.11,13.135,0.00024858,-7.767E-08}, LiqVis = {101,-18.59,1270.3,1.2467,-0.0000036226,2}, VapVis = {102,7.5822E-07,0.50218,361.22,-3635.6,0}, LiqK = {16,-0.037427,7.7785,-1.7161,-0.00028317,-0.0000017728}, VapK = {102,0.000021773,1.2197,-136.64,138470,0}, Racketparam = 0.267, UniquacR = 5.8471, UniquacQ = 5.012, ChaoSeadAF = 0.305, ChaoSeadSP = 15060, ChaoSeadLV = 0.15788);
  end ThreemethylThreeethylpentane;
  
  model TwoTwoThreeThreetetramethylbutane
  extends General_Properties(
    SN = 238, name = "TwoTwoThreeThreetetramethylbutane", CAS = "594-82-1", Tc = 567.8, Pc = 2870000,  Vc = 0.482, Cc = 0.28, Tb = 379.44, Tm = 373.84, TT = 373.96, TP = 86930.2, MW = 114.231, LVB = 0.13902, AF = 0.248, SP = 12790, DM = 0, SH = -1209000000.0, IGHF = -2.256E+08, GEF = 2.223E+07, AS = 389360, HFMP = 7540000, HOC = -5.0558E+09, LiqDen = {105,0.61397,0.27674,567.8,0.28198,0}, VP = {101,120.66,-8500.6,-14.863,0.000010649,2}, LiqCp = {16,239620,55.905,3.1054,0.027363,-0.000020376}, HOV = {106,5.3062E+07,0.30484,0.85323,-1.2161,0.48282}, VapCp = {16,73914,-415.76,12.897,0.00056384,-1.6707E-07}, LiqVis = {101,-17.538,1603.5,0.8804,-0.0000034564,2}, VapVis = {102,7.9099E-07,0.51128,412.18,-5389.1,0}, LiqK = {16,-0.0058143,-354.88,0.79351,-0.0067293,0.0000023134}, VapK = {102,0.000012508,1.3068,-132.52,121650,0}, Racketparam = 0.28, UniquacR = 5.8456, UniquacQ = 5.088, ChaoSeadAF = 0.248, ChaoSeadSP = 12790, ChaoSeadLV = 0.13902);
  end TwoTwoThreeThreetetramethylbutane;
  
  model TwoTwoFivetrimethylhexane
  extends General_Properties(
    SN = 239, name = "TwoTwoFivetrimethylhexane", CAS = "3522-94-9", Tc = 568.05, Pc = 2330000,  Vc = 0.519, Cc = 0.255, Tb = 397.24, Tm = 167.39, TT = 167.39, TP = 0.000968629, MW = 128.255, LVB = 0.18225, AF = 0.3571, SP = 14380, DM = 0, SH = -1209000000.0, IGHF = -2.533E+08, GEF = 1.38E+07, AS = 461700, HFMP = 6200000, HOC = -5.66643E+09, LiqDen = {105,0.45081,0.25256,569.81,0.27357,0}, VP = {101,133.84,-9023.578,-17.08913,0.0000169305,2}, LiqCp = {16,84566,233.86,8.46,0.013452,-0.000012421}, HOV = {106,8.039801E+07,1.702411,-1.574913,0.0056916,0.373292}, VapCp = {16,102010,-531.68,13.312,0.00017105,-4.7837E-08}, LiqVis = {101,-12.084,1011.7,0.13186,-0.000000312,2}, VapVis = {102,6.7588E-07,0.49876,301.49,-1437,0}, LiqK = {16,-0.13721,56.65,-1.9542,0.0024543,-0.0000043702}, VapK = {102,0.000030176,1.1642,-156.95,161470,0}, Racketparam = 0.255, UniquacR = 6.5207, UniquacQ = 5.548, ChaoSeadAF = 0.3571, ChaoSeadSP = 14380, ChaoSeadLV = 0.18225);
  end TwoTwoFivetrimethylhexane;
  
  model TwoFourFourtrimethylhexane
  extends General_Properties(
    SN = 240, name = "TwoFourFourtrimethylhexane", CAS = "16747-30-1", Tc = 583, Pc = 2500000,  Vc = 0.509, Cc = 0.26, Tb = 403.81, Tm = 159.78, TT = 159.78, TP = 0.000306827, MW = 128.255, LVB = 0.178125, AF = 0.352203, SP = 14590, DM = 0, SH = -1209000000.0, IGHF = -2.403E+08, GEF = 2.5E+07, AS = 468400, HFMP = 1.13E+07, HOC = -5.68E+09, LiqDen = {105,0.098546,0.11862,583,0.15161,0}, VP = {101,143.1127,-9541.532,-18.4559,0.0000171318,2}, LiqCp = {16,36795,-79.414,11.689,0.0041098,-0.0000031494}, HOV = {106,5.5551E+07,0.63316,-0.60532,0.59593,-0.24062}, VapCp = {16,84170,-452.22,13.167,0.00035197,-1.1076E-07}, LiqVis = {101,-6.9748,1194.1,-0.75025,-2.9452E-08,2}, VapVis = {102,0.0000003308,0.60466,252.52,-7535.6,0}, LiqK = {16,-0.061213,3.6115,-1.5687,-0.00048198,-0.000001134}, VapK = {102,0.000028131,1.1825,-103.57,142450,0}, Racketparam = 0.26, UniquacR = 6.5207, UniquacQ = 5.548, ChaoSeadAF = 0.352203, ChaoSeadSP = 14590, ChaoSeadLV = 0.178125);
  end TwoFourFourtrimethylhexane;
  
  model ThreeThreediethylpentane
  extends General_Properties(
    SN = 241, name = "ThreeThreediethylpentane", CAS = "1067-20-5", Tc = 610.05, Pc = 2674980,  Vc = 0.473, Cc = 0.249, Tb = 419.34, Tm = 240.12, TT = 240.12, TP = 13.7918, MW = 128.255, LVB = 0.171012, AF = 0.3379, SP = 15220, DM = 0, SH = -1209000000.0, IGHF = -2.31835E+08, GEF = 4.17E+07, AS = 436500, HFMP = 9800000, HOC = -5.68438E+09, LiqDen = {105,0.61216,0.28967,610.05,0.29325,0}, VP = {101,143.8917,-9842.666,-18.51396,0.000016514,2}, LiqCp = {16,167890,37.678,8.6605,0.012988,-0.000011813}, HOV = {106,5.0222E+07,-0.028455,0.90984,-0.78409,0.24027}, VapCp = {16,120540,-563.25,13.32,0.00012473,-3.6626E-08}, LiqVis = {101,-12.975,1131.8,0.25767,-3.4761E-07,2}, VapVis = {102,3.6575E-07,0.57536,184.44,2017.7,0}, LiqK = {16,-0.021495,-29.993,-1.4603,-0.0013716,-7.6272E-07}, VapK = {102,0.000069723,1.0959,342.29,74930,0}, Racketparam = 0.249, UniquacR = 6.5215, UniquacQ = 5.552, ChaoSeadAF = 0.3379, ChaoSeadSP = 15220, ChaoSeadLV = 0.171012);
  end ThreeThreediethylpentane;
  
  model TwoTwoThreeThreetetramethylpentane
  extends General_Properties(
    SN = 242, name = "TwoTwoThreeThreetetramethylpentane", CAS = "7154-79-2", Tc = 607.6, Pc = 2740000,  Vc = 0.478, Cc = 0.269, Tb = 413.44, Tm = 263.26, TT = 263.26, TP = 133.839, MW = 128.258, LVB = 0.17034, AF = 0.304, SP = 15060, DM = 0, SH = -1209000000.0, IGHF = -2.36856E+08, GEF = 3.74E+07, AS = 436600, HFMP = 2300000, HOC = -5.68149E+09, LiqDen = {105,0.58952,0.28267,607.6,0.29572,0}, VP = {101,139.0487,-9535.451,-17.78617,0.0000157521,2}, LiqCp = {16,116740,-86.104,11.13,0.0046308,-0.000003068}, HOV = {106,5.3713E+07,0.39899,-0.032998,0.06374,-0.0535}, VapCp = {16,55048,-357.31,13.013,0.00055209,-1.6211E-07}, LiqVis = {101,-9.7597,1441.2,-0.37772,-0.000001226,2}, VapVis = {102,8.1934E-07,0.48521,356.82,-1384.3,0}, LiqK = {16,-0.0045701,-120.11,-0.775,-0.0036256,9.650699E-07}, VapK = {102,0.000014917,1.2661,-211.67,155870,0}, Racketparam = 0.269, UniquacR = 6.52, UniquacQ = 5.628, ChaoSeadAF = 0.304, ChaoSeadSP = 15060, ChaoSeadLV = 0.17034);
  end TwoTwoThreeThreetetramethylpentane;
  
  model TwoTwoThreeFourtetramethylpentane
  extends General_Properties(
    SN = 243, name = "TwoTwoThreeFourtetramethylpentane", CAS = "1186-53-4", Tc = 592.7, Pc = 2530000,  Vc = 0.49, Cc = 0.258, Tb = 406.18, Tm = 152.06, TT = 152.06, TP = 0.000053591, MW = 128.258, LVB = 0.179229, AF = 0.301, SP = 14730, DM = 0, SH = -1209000000.0, IGHF = -2.37358E+08, GEF = 3.26352E+07, AS = 452834, HFMP = 500000, HOC = -5.68208E+09, LiqDen = {105,0.42889,0.24425,592.7,0.24983,0}, VP = {101,137.07,-9700.5,-17.255,0.000012062,2}, LiqCp = {16,177720,-50.337,8.3416,0.015008,-0.000013849}, HOV = {106,5.771831E+07,1.016576,-1.835135,2.12911,-0.921819}, VapCp = {16,83946,-465.16,13.193,0.000328,-9.6189E-08}, LiqVis = {101,-8.182,1248.5,-0.55988,-2.1902E-07,2}, VapVis = {102,3.9083E-07,0.57522,220.52,-776.34,0}, LiqK = {16,-0.045924,4.3553,-1.6529,-0.00040588,-0.000001389}, VapK = {102,0.000019408,1.2262,-198.62,159810,0}, Racketparam = 0.258, UniquacR = 6.5199, UniquacQ = 5.544, ChaoSeadAF = 0.301, ChaoSeadSP = 14730, ChaoSeadLV = 0.179229);
  end TwoTwoThreeFourtetramethylpentane;
  
  model TwoTwoFourFourtetramethylpentane
  extends General_Properties(
    SN = 244, name = "TwoTwoFourFourtetramethylpentane", CAS = "1070-87-7", Tc = 571.35, Pc = 2360870,  Vc = 0.504, Cc = 0.263, Tb = 395.44, Tm = 206.95, TT = 206.95, TP = 1.83952, MW = 128.255, LVB = 0.17923, AF = 0.313609, SP = 14150, DM = 0, SH = -1209000000.0, IGHF = -2.41375E+08, GEF = 3.40159E+07, AS = 431496, HFMP = 9700000, HOC = -5.67978E+09, LiqDen = {105,0.47711,0.25904,574.61,0.26647,0}, VP = {101,136.5701,-9035.55,-17.5287,0.0000167892,2}, LiqCp = {16,119280,88.665,9.3063,0.010453,-0.0000091934}, HOV = {106,5.75823E+07,1.154086,-2.055247,2.209851,-0.923166}, VapCp = {16,122670,-599.26,13.402,0.000099085,-1.741E-08}, LiqVis = {101,-10.148,1468.8,-0.33327,-0.0000013179,2}, VapVis = {102,5.8808E-07,0.52306,289.62,-2721.1,0}, LiqK = {16,-0.038909,-2.6455,-1.623,-0.0006558,-0.0000013711}, VapK = {102,0.000015165,1.2696,-148.49,133700,0}, Racketparam = 0.263, UniquacR = 6.52, UniquacQ = 5.628, ChaoSeadAF = 0.313609, ChaoSeadSP = 14150, ChaoSeadLV = 0.17923);
  end TwoTwoFourFourtetramethylpentane;
  
  model TwoThreeThreeFourtetramethylpentane
  extends General_Properties(
    SN = 245, name = "TwoThreeThreeFourtetramethylpentane", CAS = "16747-38-9", Tc = 607.1, Pc = 2670000,  Vc = 0.493, Cc = 0.261, Tb = 414.71, Tm = 171.05, TT = 171.03, TP = 0.00089642, MW = 128.258, LVB = 0.17076, AF = 0.313, SP = 15110, DM = 0, SH = -1209000000.0, IGHF = -2.361E+08, GEF = 3.8E+07, AS = 436900, HFMP = 9000000, HOC = -5.6822E+09, LiqDen = {105,0.49299,0.25927,607.51,0.27003,0}, VP = {101,79.047,-7201.2,-8.4677,0.0000051332,2}, LiqCp = {16,61477,20.611,11.082,0.0041652,-0.0000014763}, HOV = {106,5.5207E+07,0.63465,-0.82041,1.0175,-0.45604}, VapCp = {16,50811,-338.13,12.991,0.00056259,-1.7284E-07}, LiqVis = {101,-7.4098,1217,-0.67198,-2.7904E-07,2}, VapVis = {102,3.7299E-07,0.59636,289.93,-9056.4,0}, LiqK = {16,-0.058699,3.5637,-1.5648,-0.000479,-0.0000010469}, VapK = {102,0.000035577,1.1602,-50.424,142790,0}, Racketparam = 0.261, UniquacR = 6.5199, UniquacQ = 5.544, ChaoSeadAF = 0.313, ChaoSeadSP = 15110, ChaoSeadLV = 0.17076);
  end TwoThreeThreeFourtetramethylpentane;
  
  model Twomethyloctane
  extends General_Properties(
    SN = 246, name = "Twomethyloctane", CAS = "3221-61-2", Tc = 587, Pc = 2310000,  Vc = 0.529, Cc = 0.25, Tb = 416.44, Tm = 193.05, TT = 193.05, TP = 0.0206, MW = 128.258, LVB = 0.18075, AF = 0.423, SP = 15310, DM = 0, SH = -1209000000.0, IGHF = -2.348E+08, GEF = 2.21E+07, AS = 496800, HFMP = 1.8E+07, HOC = -5.6791E+09, LiqDen = {105,0.048725,0.083928,587,0.13299,0}, VP = {101,117.6637,-9065.067,-14.28093,0.0000101806,2}, LiqCp = {16,69326,112.91,10.449,0.0058606,-0.0000035224}, HOV = {106,6.8687E+07,1.3406,-2.5809,2.7985,-1.1501}, VapCp = {16,145390,-732.92,13.658,-0.00027343,8.6186E-08}, LiqVis = {101,-14.31,1234.5,0.50422,-0.0000012054,2}, VapVis = {102,0.0000005318,0.52649,272.37,-710.16,0}, LiqK = {16,-0.15278,14.586,-1.1974,-0.00013887,-9.4417E-07}, VapK = {102,0.00002892,1.1595,-163.72,160440,0}, Racketparam = 0.25, UniquacR = 6.5222, UniquacQ = 5.472, ChaoSeadAF = 0.423, ChaoSeadSP = 15310, ChaoSeadLV = 0.18075);
  end Twomethyloctane;
  
  model Threemethyloctane
  extends General_Properties(
    SN = 247, name = "Threemethyloctane", CAS = "2216-33-3", Tc = 590.15, Pc = 2340000,  Vc = 0.529, Cc = 0.252, Tb = 417.38, Tm = 165.55, TT = 165.55, TP = 0.0000898613, MW = 128.255, LVB = 0.178944, AF = 0.412346, SP = 15380, DM = 0, SH = -1209000000.0, IGHF = -2.336E+08, GEF = 2.17E+07, AS = 501660, HFMP = 1.7E+07, HOC = -5.68128E+09, LiqDen = {105,0.4999,0.26438,590.15,0.29155,0}, VP = {101,169.345,-11170.36,-22.26865,0.0000190112,2}, LiqCp = {16,39163,25.328,11.626,0.0021572,2.6369E-07}, HOV = {106,6.3378E+07,0.67667,-0.53996,0.45608,-0.18958}, VapCp = {16,118620,-596.81,13.418,0.0000088283,-1.2271E-08}, LiqVis = {101,-11.252,1147.6,-0.021999,4.3706E-08,2}, VapVis = {102,4.9482E-07,0.53152,245.99,4.1109,0}, LiqK = {16,-0.1642,10.91,-1.1265,-0.00023366,-7.9637E-07}, VapK = {102,0.000040968,1.1096,-178.72,180220,0}, Racketparam = 0.252, UniquacR = 6.5222, UniquacQ = 5.472, ChaoSeadAF = 0.412346, ChaoSeadSP = 15380, ChaoSeadLV = 0.178944);
  end Threemethyloctane;
  
  model Fourmethyloctane
  extends General_Properties(
    SN = 248, name = "Fourmethyloctane", CAS = "2216-34-4", Tc = 587.65, Pc = 2340000,  Vc = 0.523, Cc = 0.25, Tb = 415.59, Tm = 159.95, TT = 159.95, TP = 0.0000317697, MW = 128.255, LVB = 0.179037, AF = 0.412925, SP = 15300, DM = 0, SH = -1209000000.0, IGHF = -2.336E+08, GEF = 2.17E+07, AS = 501660, HFMP = 1.6E+07, HOC = -5.68166E+09, LiqDen = {105,0.51336,0.26824,587.65,0.29075,0}, VP = {101,168.4912,-11138.63,-22.13486,0.0000188399,2}, LiqCp = {16,71582,100.57,10.612,0.0050783,-0.0000024905}, HOV = {106,6.2916E+07,0.7446,-0.80882,0.80228,-0.33895}, VapCp = {16,116790,-588.34,13.412,0.000015201,-1.4561E-08}, LiqVis = {101,-11.837,1162,0.077237,-2.6336E-07,2}, VapVis = {102,3.2706E-07,0.5848,183.92,0.068678,0}, LiqK = {16,-0.1663,9.2848,-1.1068,-0.00028405,-0.0000007408}, VapK = {102,0.000038784,1.117,-185.06,177130,0}, Racketparam = 0.25, UniquacR = 6.5222, UniquacQ = 5.472, ChaoSeadAF = 0.412925, ChaoSeadSP = 15300, ChaoSeadLV = 0.179037);
  end Fourmethyloctane;
  
  model Threeethylheptane
  extends General_Properties(
    SN = 249, name = "Threeethylheptane", CAS = "15869-80-4", Tc = 594.3, Pc = 2430000,  Vc = 0.5213, Cc = 0.257, Tb = 416.35, Tm = 158.25, TT = 158.25, TP = 0.0000277743, MW = 128.255, LVB = 0.177515, AF = 0.407991, SP = 15300, DM = 0, SH = -1209000000.0, IGHF = -2.3146E+08, GEF = 2.494E+07, AS = 497400, HFMP = 1.6E+07, HOC = -5.6838E+09, LiqDen = {105,0.38578,0.23273,594.3,0.25158,0}, VP = {101,103.6653,-8269.445,-12.32292,0.000012256,2}, LiqCp = {16,29546,-3.2521,11.386,0.0045932,-0.0000035582}, HOV = {106,6.3311E+07,1.0505,-1.9581,2.2955,-0.98973}, VapCp = {16,137360,-689.88,13.586,-0.00018791,5.2355E-08}, LiqVis = {101,-11.279,1149.8,-0.019903,1.7111E-07,2}, VapVis = {102,0.0000007497,0.48637,340.94,-2876.9,0}, LiqK = {16,-0.038271,3.4169,-1.6847,-0.00052626,-0.0000013295}, VapK = {102,0.000030963,1.1527,-150.17,156710,0}, Racketparam = 0.257, UniquacR = 6.5222, UniquacQ = 5.472, ChaoSeadAF = 0.407991, ChaoSeadSP = 15300, ChaoSeadLV = 0.177515);
  end Threeethylheptane;
  
  model TwoTwodimethylheptane
  extends General_Properties(
    SN = 250, name = "TwoTwodimethylheptane", CAS = "1071-26-7", Tc = 577.8, Pc = 2350000,  Vc = 0.525, Cc = 0.257, Tb = 405.97, Tm = 160.15, TT = 160.15, TP = 0.000152983, MW = 128.258, LVB = 0.18151, AF = 0.383, SP = 14720, DM = 0, SH = -1209000000.0, IGHF = -2.461E+08, GEF = 1.79E+07, AS = 471800, HFMP = 8900000, HOC = -5.672E+09, LiqDen = {105,0.19929,0.16944,577.8,0.19098,0}, VP = {101,173.1768,-10891.65,-23.04354,0.0000217483,2}, LiqCp = {16,188490,-126.2,10.161,0.0065361,-0.0000033154}, HOV = {106,5.677584E+07,0.420266,0.0606766,-0.058971,-0.0565229}, VapCp = {16,119340,-582.53,13.386,0.000067675,-2.1229E-08}, LiqVis = {101,-11.654,1250.4,0.03445,-6.0618E-08,2}, VapVis = {102,8.0205E-07,0.4765,340.6,-3260.3,0}, LiqK = {16,-0.04961,4.5364,-1.657,-0.00038774,-0.0000014465}, VapK = {102,0.000023582,1.1966,-148.34,144910,0}, Racketparam = 0.257, UniquacR = 6.5215, UniquacQ = 5.552, ChaoSeadAF = 0.383, ChaoSeadSP = 14720, ChaoSeadLV = 0.18151);
  end TwoTwodimethylheptane;
  
  model ThreeThreeFivetrimethylheptane
  extends General_Properties(
    SN = 251, name = "ThreeThreeFivetrimethylheptane", CAS = "7154-80-5", Tc = 609.6, Pc = 2320000,  Vc = 0.564, Cc = 0.258, Tb = 428.83, Tm = 165, TT = 165, TP = 0.0000151957, MW = 142.285, LVB = 0.19248, AF = 0.383, SP = 15010, DM = 0, SH = -1209000000.0, IGHF = -2.588E+08, GEF = 3.23E+07, AS = 513420, HFMP = 1.4E+07, HOC = -6.2911E+09, LiqDen = {105,0.32798,0.22465,609.6,0.2413,0}, VP = {101,165.0702,-10873.83,-21.67781,0.0000174271,2}, LiqCp = {16,181900,88.778,8.7398,0.011239,-0.0000078705}, HOV = {106,5.692041E+07,-0.369689,2.788348,-3.430471,1.37842}, VapCp = {16,93450,-461.09,13.294,0.00031582,-1.0309E-07}, LiqVis = {101,-7.8795,1294.8,-0.60549,-4.2086E-07,2}, VapVis = {102,5.7085E-07,0.52829,329.98,-4470.2,0}, LiqK = {16,0.0037809,-39.052,-1.5072,-0.0019367,-8.6862E-07}, VapK = {102,0.000042493,1.1211,-89.298,167970,0}, Racketparam = 0.258, UniquacR = 7.1951, UniquacQ = 6.088, ChaoSeadAF = 0.383, ChaoSeadSP = 15010, ChaoSeadLV = 0.19248);
  end ThreeThreeFivetrimethylheptane;
  
  model TwoTwodimethyloctane
  extends General_Properties(
    SN = 252, name = "TwoTwodimethyloctane", CAS = "15869-87-1", Tc = 602.4, Pc = 2110000,  Vc = 0.5897, Cc = 0.248, Tb = 430.05, Tm = 0, TT = 0, TP = 0, MW = 142.282, LVB = 0.197405, AF = 0.428759, SP = 14870, DM = 0, SH = -1209000000.0, IGHF = -2.67E+08, GEF = 2.6E+07, AS = 511000, HFMP = 1.7E+07, HOC = -6.281E+09, LiqDen = {105,0.27519,0.20873,602.4,0.22241,0}, VP = {101,128.2162,-9736.787,-15.87938,0.0000121145,2}, LiqCp = {16,130180,214,8.9638,0.010626,-0.0000085091}, HOV = {106,6.2139E+07,0.81955,-1.4728,1.7846,-0.74179}, VapCp = {16,133300,-582.81,13.49,0.000049115,-1.5637E-08}, LiqVis = {101,-12.132,1337.2,0.10372,-1.6576E-07,2}, VapVis = {102,6.6483E-07,0.48953,292.37,276.07,0}, LiqK = {16,-0.054905,-9.2849,-1.513,-0.00077582,-8.6839E-07}, VapK = {102,0.000023992,1.186,-157.89,154490,0}, Racketparam = 0.248, UniquacR = 7.1959, UniquacQ = 6.092, ChaoSeadAF = 0.428759, ChaoSeadSP = 14870, ChaoSeadLV = 0.197405);
  end TwoTwodimethyloctane;
  
  model Threemethylnonane
  extends General_Properties(
    SN = 253, name = "Threemethylnonane", CAS = "5911-04-6", Tc = 613.7, Pc = 2140000,  Vc = 0.5904, Cc = 0.247, Tb = 440.95, Tm = 188.35, TT = 188.35, TP = 0.000565366, MW = 142.282, LVB = 0.195076, AF = 0.464925, SP = 15470, DM = 0, SH = -1209000000.0, IGHF = -2.544E+08, GEF = 2.88E+07, AS = 543900, HFMP = 1.88E+07, HOC = -6.291E+09, LiqDen = {105,0.19012,0.17319,613.7,0.19349,0}, VP = {101,90.738,-8476.8,-10.023,0.0000053448,2}, LiqCp = {16,78506,74.892,11.023,0.0040568,-0.0000015927}, HOV = {106,8.354164E+07,1.024481,-0.0908156,-1.228122,0.762381}, VapCp = {16,133050,-599.42,13.53,-0.000017353,-3.363E-09}, LiqVis = {101,-12.922,1267.3,0.28159,-8.3807E-07,2}, VapVis = {102,6.1879E-07,0.49638,289.26,-877.62,0}, LiqK = {16,-0.1781,10.557,-1.078,-0.00023148,-6.8221E-07}, VapK = {102,0.000033407,1.1338,-162.76,171650,0}, Racketparam = 0.247, UniquacR = 7.196599, UniquacQ = 6.012, ChaoSeadAF = 0.464925, ChaoSeadSP = 15470, ChaoSeadLV = 0.195076);
  end Threemethylnonane;
  
  model Twomethylnonane
  extends General_Properties(
    SN = 254, name = "Twomethylnonane", CAS = "871-83-0", Tc = 621, Pc = 2050000,  Vc = 0.601, Cc = 0.244, Tb = 440.15, Tm = 198.5, TT = 198.5, TP = 0.00248675, MW = 142.282, LVB = 0.196826, AF = 0.472342, SP = 15380, DM = 0, SH = -1209000000.0, IGHF = -2.5652E+08, GEF = 2.841E+07, AS = 538020, HFMP = 1.75E+07, HOC = -6.2888E+09, LiqDen = {105,0.2243,0.18661,621,0.23259,0}, VP = {101,133.13,-10462,-16.388,0.0000099287,2}, LiqCp = {16,-52606,80.981,11.786,0.0026831,-6.0448E-07}, HOV = {106,7.023987E+07,-0.879246,6.371272,-9.404583,4.418702}, VapCp = {16,137030,-599.28,13.509,0.0000018563,-1.0781E-08}, LiqVis = {101,-3.1519,949.54,-1.2725,0.0000012986,2}, VapVis = {102,9.2127E-07,0.44292,352.44,-1163.9,0}, LiqK = {16,-0.16513,15.121,-1.1582,-0.00011252,-0.0000008534}, VapK = {102,0.000030641,1.1437,-171.78,168770,0}, Racketparam = 0.244, UniquacR = 7.196599, UniquacQ = 6.012, ChaoSeadAF = 0.472342, ChaoSeadSP = 15380, ChaoSeadLV = 0.196826);
  end Twomethylnonane;
  
  model Fourmethylnonane
  extends General_Properties(
    SN = 255, name = "Fourmethylnonane", CAS = "17301-94-9", Tc = 613.7, Pc = 2140000,  Vc = 0.5904, Cc = 0.248, Tb = 438.85, Tm = 174.45, TT = 174.45, TP = 0.000108068, MW = 142.282, LVB = 0.195426, AF = 0.465073, SP = 15500, DM = 0, SH = -1209000000.0, IGHF = -2.547E+08, GEF = 2.89E+07, AS = 541900, HFMP = 1.52E+07, HOC = -6.291E+09, LiqDen = {105,0.046753,0.085687,613.7,0.13909,0}, VP = {101,143.6866,-10632.15,-18.17547,0.0000137486,2}, LiqCp = {16,41953,56.5,11.484,0.0029861,-0.0000006055}, HOV = {106,6.2873E+07,0.39496,-0.054115,0.081779,-0.040701}, VapCp = {16,130820,-589.61,13.519,-0.0000013811,-1.0182E-08}, LiqVis = {101,-8.7174,1148.5,-0.42278,0.000000818,2}, VapVis = {102,5.0899E-07,0.5228,260.59,-971.93,0}, LiqK = {16,-0.16198,12.531,-1.1439,-0.00019006,-7.9079E-07}, VapK = {102,0.000039332,1.1131,-152.11,174490,0}, Racketparam = 0.248, UniquacR = 7.196599, UniquacQ = 6.012, ChaoSeadAF = 0.465073, ChaoSeadSP = 15500, ChaoSeadLV = 0.195426);
  end Fourmethylnonane;
  
  model Fivemethylnonane
  extends General_Properties(
    SN = 256, name = "Fivemethylnonane", CAS = "15869-85-9", Tc = 609.6, Pc = 2140000,  Vc = 0.5904, Cc = 0.248, Tb = 438.25, Tm = 186, TT = 185.45, TP = 0.000438465, MW = 142.282, LVB = 0.195298, AF = 0.456177, SP = 15440, DM = 0, SH = -1209000000.0, IGHF = -2.5472E+08, GEF = 3.06E+07, AS = 536500, HFMP = 1.66E+07, HOC = -6.291E+09, LiqDen = {105,0.41463,0.2529,610.01,0.28051,0}, VP = {101,215.6392,-13712.31,-29.15861,0.0000236309,2}, LiqCp = {16,230160,-61.977,9.1603,0.0096645,-0.0000061376}, HOV = {106,6.5588E+07,0.029762,1.6061,-2.0417,0.80324}, VapCp = {16,131700,-594.98,13.529,-0.000014234,-5.0987E-09}, LiqVis = {101,-13.838,1303.8,0.41828,-8.7942E-07,2}, VapVis = {102,5.7631E-07,0.50736,283.05,-1279.5,0}, LiqK = {16,-0.183,10.49,-1.0698,-0.00021616,-6.8913E-07}, VapK = {102,0.00003614,1.1239,-159.13,172680,0}, Racketparam = 0.248, UniquacR = 7.196599, UniquacQ = 6.012, ChaoSeadAF = 0.456177, ChaoSeadSP = 15440, ChaoSeadLV = 0.195298);
  end Fivemethylnonane;
  
  model CisTwohexene
  extends General_Properties(
    SN = 257, name = "CisTwohexene", CAS = "7688-21-3", Tc = 511.4, Pc = 3160000,  Vc = 0.345, Cc = 0.256, Tb = 342.03, Tm = 132, TT = 132.03, TP = 0.000232, MW = 84.1595, LVB = 0.1234, AF = 0.287374, SP = 15360, DM = 1.015E-30, SH = -1209000000.0, IGHF = -4.856E+07, GEF = 8.025E+07, AS = 386500, HFMP = 8857530, HOC = -3.728E+09, LiqDen = {105,0.77464,0.2672,511.4,0.28571,0}, VP = {101,104.3995,-6791.221,-12.84602,0.0000165576,2}, LiqCp = {16,135610,570.7,1.6392,0.033591,-0.000032605}, HOV = {106,4.9E+07,1.281,-2.4971,2.499,-0.86824}, VapCp = {16,88576,-789.82,13.286,-0.00034537,1.0091E-07}, LiqVis = {101,-10.864,787.8,0.0025561,-7.6676E-08,2}, VapVis = {102,3.6061E-08,0.91362,-8.4415,1515.2,0}, LiqK = {16,-0.038625,3.4165,-1.4421,-0.00078927,-0.0000017176}, VapK = {102,0.000053674,1.0887,-86.934,155330,0}, Racketparam = 0.256, UniquacR = 4.2677, UniquacQ = 3.643, ChaoSeadAF = 0.287374, ChaoSeadSP = 15360, ChaoSeadLV = 0.1234);
  end CisTwohexene;
  
  model TransTwohexene
  extends General_Properties(
    SN = 258, name = "TransTwohexene", CAS = "4050-45-7", Tc = 509.8, Pc = 3168000,  Vc = 0.345, Cc = 0.258, Tb = 341.02, Tm = 140.17, TT = 140.17, TP = 0.00179, MW = 84.1595, LVB = 0.125, AF = 0.288635, SP = 15250, DM = 0, SH = -1209000000.0, IGHF = -5.381E+07, GEF = 7.675E+07, AS = 380600, HFMP = 8255030, HOC = -3.72648E+09, LiqDen = {105,0.7854,0.271,509.8,0.28571,0}, VP = {101,102.7613,-6858.249,-12.46469,0.0000134849,2}, LiqCp = {16,145330,591.61,0.45085,0.040176,-0.000043449}, HOV = {106,4.402196E+07,0.563356,-0.497314,0.306975,0.0161359}, VapCp = {16,96839,-758.81,13.112,-0.00018911,4.7057E-08}, LiqVis = {101,-11.296,798.85,0.074688,-2.5765E-07,2}, VapVis = {102,3.5985E-08,0.91455,-9.2013,1687.6,0}, LiqK = {16,-0.091076,-0.14352,-1.1963,-0.00093801,-0.0000007123}, VapK = {102,0.000094853,1.0175,2.8366,154410,0}, Racketparam = 0.258, UniquacR = 4.2677, UniquacQ = 3.643, ChaoSeadAF = 0.288635, ChaoSeadSP = 15250, ChaoSeadLV = 0.125);
  end TransTwohexene;
  
  model Oneoctene
  extends General_Properties(
    SN = 259, name = "Oneoctene", CAS = "111-66-0", Tc = 567, Pc = 2680000,  Vc = 0.468, Cc = 0.266, Tb = 394.44, Tm = 171.45, TT = 171.45, TP = 0.00298, MW = 112.215, LVB = 0.15785, AF = 0.393, SP = 15540, DM = 1.4E-30, SH = -1209000000.0, IGHF = -8.194E+07, GEF = 1.057E+08, AS = 463700, HFMP = 1.531E+07, HOC = -4.961E+09, LiqDen = {105,0.44684,0.23463,567,0.24846,0}, VP = {101,177.7155,-11137.29,-23.58923,0.000019592,2}, LiqCp = {16,-24253,87.834,11.35,0.0032002,-0.0000012467}, HOV = {106,5.7062E+07,0.3453,0.41628,-0.36125,-0.059539}, VapCp = {16,106430,-593.77,13.154,0.00006689,-2.6274E-08}, LiqVis = {101,-5.8042,945.32,-0.93827,0.0000032767,2}, VapVis = {102,0.000047664,0.084052,3514.6,21127,0}, LiqK = {16,0.035226,40.754,-2.2668,0.00092297,-0.0000060301}, VapK = {102,0.000014109,1.354,610.51,-30915,0}, Racketparam = 0.266, UniquacR = 5.6185, UniquacQ = 4.724, ChaoSeadAF = 0.393, ChaoSeadSP = 15540, ChaoSeadLV = 0.15785);
  end Oneoctene;
  
  model Onenonene
  extends General_Properties(
    SN = 260, name = "Onenonene", CAS = "124-11-8", Tc = 594, Pc = 2330000,  Vc = 0.526, Cc = 0.248, Tb = 420.03, Tm = 191.91, TT = 191.91, TP = 0.0204, MW = 126.242, LVB = 0.17405, AF = 0.411, SP = 15500, DM = 2.0E-30, SH = -1209000000.0, IGHF = -1.035E+08, GEF = 1.123E+08, AS = 504100, HFMP = 1.9359E+07, HOC = -5.5716E+09, LiqDen = {105,0.18062,0.15802,594,0.18969,0}, VP = {101,120.37,-9418.7,-14.583,0.0000094863,2}, LiqCp = {16,58309,119.15,10.75,0.0042025,-0.0000015805}, HOV = {106,5.0729E+07,-0.72017,3.2276,-3.6347,1.4659}, VapCp = {16,122350,-622.4,13.352,-0.000015236,-2.3169E-10}, LiqVis = {101,-10.296,1057.3,-0.12431,2.0281E-07,2}, VapVis = {102,7.2319E-08,0.81707,155.31,-12572,0}, LiqK = {16,0.024602,-118.29,-0.40946,-0.0056136,0.0000021909}, VapK = {102,0.000019761,1.2983,563.96,24829,0}, Racketparam = 0.248, UniquacR = 6.2929, UniquacQ = 5.264, ChaoSeadAF = 0.411, ChaoSeadSP = 15500, ChaoSeadLV = 0.17405);
  end Onenonene;
  
  model Oneundecene
  extends General_Properties(
    SN = 261, name = "Oneundecene", CAS = "821-95-4", Tc = 637.8, Pc = 2044000,  Vc = 0.657, Cc = 0.253, Tb = 465.82, Tm = 223.99, TT = 223.99, TP = 0.0473, MW = 154.292, LVB = 0.2065, AF = 0.522466, SP = 15680, DM = 1.8E-30, SH = -1209000000.0, IGHF = -1.449E+08, GEF = 1.283E+08, AS = 582180, HFMP = 1.699E+07, HOC = -6.7878E+09, LiqDen = {105,0.38001,0.24991,637.8,0.28571,0}, VP = {101,93.64799,-9306.494,-10.26144,4.149832E-06,2}, LiqCp = {16,99868,144.48,10.69,0.0042614,-0.0000010791}, HOV = {106,2.3696E+07,-6.3933,18.084,-19.033,7.4719}, VapCp = {16,138670,-549.63,13.4,0.00014861,-5.2026E-08}, LiqVis = {101,-49.01257,2643.166,5.957949,-8.451873E-06,2}, VapVis = {102,5.0406E-08,0.85093,112.38,-8900.1,0}, LiqK = {16,0.067847,-250.41,0.40201,-0.0082828,0.0000014058}, VapK = {102,0.000018335,1.3031,709.58,-2804.6,0}, Racketparam = 0.253, UniquacR = 7.6417, UniquacQ = 6.344, ChaoSeadAF = 0.522466, ChaoSeadSP = 15680, ChaoSeadLV = 0.2065);
  end Oneundecene;
  
  model TwomethylOnepentene
  extends General_Properties(
    SN = 262, name = "TwomethylOnepentene", CAS = "763-29-1", Tc = 507, Pc = 3160000,  Vc = 0.359, Cc = 0.261, Tb = 335.26, Tm = 137.43, TT = 137.42, TP = 0.000805463, MW = 84.1595, LVB = 0.124649, AF = 0.261138, SP = 15070, DM = 1.89E-30, SH = -1209000000.0, IGHF = -5.22581E+07, GEF = 7.2969E+07, AS = 374000, HFMP = 7029120, HOC = -3.72209E+09, LiqDen = {105,0.13372,0.11276,507,0.1472,0}, VP = {101,85.161,-6171.1,-9.6632,0.0000085639,2}, LiqCp = {16,173630,-41311,386.78,-1.1602,0.0012063}, HOV = {106,5.397303E+07,1.23932,-1.433928,0.797889,-0.142823}, VapCp = {16,92049,-683.66,13.009,-0.000089454,1.0969E-08}, LiqVis = {101,-11.406,797.71,0.099228,-5.3373E-07,2}, VapVis = {102,6.3076E-07,0.52447,272.22,-3046.8,0}, LiqK = {16,-0.026056,4.3913,-1.6749,-0.00048682,-0.0000023385}, VapK = {102,0.000074858,1.0485,-32.169,140340,0}, Racketparam = 0.261, UniquacR = 4.2689, UniquacQ = 3.64, ChaoSeadAF = 0.261138, ChaoSeadSP = 15070, ChaoSeadLV = 0.124649);
  end TwomethylOnepentene;
  
  model FourmethylcisTwopentene
  extends General_Properties(
    SN = 263, name = "FourmethylcisTwopentene", CAS = "691-38-3", Tc = 499, Pc = 3220000,  Vc = 0.346, Cc = 0.269, Tb = 329.53, Tm = 138.72, TT = 138.3, TP = 0.00215772, MW = 84.1595, LVB = 0.126648, AF = 0.244178, SP = 14610, DM = 7.18E-31, SH = -1209000000.0, IGHF = -5.03335E+07, GEF = 7.69856E+07, AS = 373338, HFMP = 7363840, HOC = -3.72502E+09, LiqDen = {105,0.77793,0.27017,499,0.2861,0}, VP = {101,83.573,-5993.9,-9.4501,0.0000085686,2}, LiqCp = {16,-59803,-16.203,11.773,0.0034333,-0.0000037581}, HOV = {106,5.4227E+07,1.5628,-2.6171,2.4298,-0.92758}, VapCp = {16,101130,-861.95,13.463,-0.00060529,2.0212E-07}, LiqVis = {101,-11.752,820.42,0.14056,-7.3435E-07,2}, VapVis = {102,6.3021E-07,0.52941,268.94,16.597,0}, LiqK = {16,-0.050868,4.0553,-1.554,-0.00045968,-0.000001981}, VapK = {102,0.000052516,1.0978,-60.883,128130,0}, Racketparam = 0.269, UniquacR = 4.2669, UniquacQ = 3.639, ChaoSeadAF = 0.244178, ChaoSeadSP = 14610, ChaoSeadLV = 0.126648);
  end FourmethylcisTwopentene;
  
  model FourmethyltransTwopentene
  extends General_Properties(
    SN = 264, name = "FourmethyltransTwopentene", CAS = "674-76-0", Tc = 501, Pc = 3220000,  Vc = 0.346, Cc = 0.267, Tb = 331.76, Tm = 132.36, TT = 132.35, TP = 0.000344783, MW = 84.1595, LVB = 0.126739, AF = 0.255237, SP = 14730, DM = 3.63E-31, SH = -1209000000.0, IGHF = -5.43501E+07, GEF = 7.43497E+07, AS = 368390, HFMP = 7154640, HOC = -3.7205E+09, LiqDen = {105,0.77321,0.26966,501,0.28578,0}, VP = {101,81.691,-5972.8,-9.1408,0.0000081285,2}, LiqCp = {16,22279,6.5061,10.859,0.0058182,-0.000006387}, HOV = {106,5.3985E+07,1.4966,-2.4784,2.2857,-0.85991}, VapCp = {16,95377,-622.83,12.814,0.000074545,-3.6318E-08}, LiqVis = {101,-11.038,805.55,0.01464,-7.2359E-08,2}, VapVis = {102,7.4971E-07,0.50587,292.11,780.77,0}, LiqK = {16,-0.02241,4.5423,-1.7038,-0.00048445,-0.0000024834}, VapK = {102,0.000062348,1.0772,-17.479,116240,0}, Racketparam = 0.267, UniquacR = 4.2669, UniquacQ = 3.639, ChaoSeadAF = 0.255237, ChaoSeadSP = 14730, ChaoSeadLV = 0.126739);
  end FourmethyltransTwopentene;
  
  model Cyclohexene
  extends General_Properties(
    SN = 265, name = "Cyclohexene", CAS = "110-83-8", Tc = 560.42, Pc = 4350000,  Vc = 0.291, Cc = 0.272, Tb = 356.12, Tm = 169.67, TT = 169.67, TP = 0.103772, MW = 82.1436, LVB = 0.101877, AF = 0.212302, SP = 17420, DM = 1.83E-30, SH = -1209000000.0, IGHF = -4520000, GEF = 1.077E+08, AS = 310750, HFMP = 3290000, HOC = -3.532E+09, LiqDen = {105,0.807,0.25253,560.42,0.26738,0}, VP = {101,82.052,-6388.7,-9.1035,0.0000071317,2}, LiqCp = {16,97738,2.3363,7.7626,0.013772,-0.000011653}, HOV = {106,5.794402E+07,1.587579,-2.225474,1.109627,0.041589}, VapCp = {16,48919,-644.33,13.16,-0.0002758,9.0717E-08}, LiqVis = {101,-11.901,1159.3,0.11228,-1.9651E-07,2}, VapVis = {102,0.0000013322,0.45371,444.45,117.38,0}, LiqK = {16,0.11174,816.81,-14.373,0.055987,-0.00010104}, VapK = {102,0.000094336,1.0783,568.3,34471,0}, Racketparam = 0.272, UniquacR = 3.8143, UniquacQ = 3.027, ChaoSeadAF = 0.212302, ChaoSeadSP = 17420, ChaoSeadLV = 0.101877);
  end Cyclohexene;
  
  model OneOnedimethylcyclopentane
  extends General_Properties(
    SN = 266, name = "OneOnedimethylcyclopentane", CAS = "1638-26-2", Tc = 547, Pc = 3445000,  Vc = 0.36, Cc = 0.273, Tb = 361, Tm = 203.36, TT = 203.68, TP = 9.04909, MW = 98.1861, LVB = 0.130925, AF = 0.272354, SP = 15460, DM = 0, SH = -1209000000.0, IGHF = -1.3828E+08, GEF = 3.9037E+07, AS = 359280, HFMP = 1080000, HOC = -4.2752E+09, LiqDen = {105,0.77031,0.27731,547,0.30161,0}, VP = {101,80.69439,-6444.768,-8.840923,5.777915E-06,2}, LiqCp = {16,63403,-76.912,11.112,0.0033685,-0.0000013786}, HOV = {106,6.4753E+07,1.835,-2.4221,1.0097,0.083052}, VapCp = {16,84040,-831.97,13.78,-0.00060484,0.0000001825}, LiqVis = {101,-7.8132,901.76,-0.51373,0.0000011607,2}, VapVis = {102,0.0000055348,0.28035,888.45,60.9,0}, LiqK = {16,-0.012548,-26.729,-1.3811,-0.0017046,-8.8213E-07}, VapK = {102,0.0025566,0.60638,165.73,477660,0}, Racketparam = 0.273, UniquacR = 4.7193, UniquacQ = 3.856, ChaoSeadAF = 0.272354, ChaoSeadSP = 15460, ChaoSeadLV = 0.130925);
  end OneOnedimethylcyclopentane;
  
  model CisOneTwodimethylcyclopentane
  extends General_Properties(
    SN = 267, name = "CisOneTwodimethylcyclopentane", CAS = "1192-18-3", Tc = 565.15, Pc = 3445050,  Vc = 0.37, Cc = 0.271, Tb = 372.68, Tm = 219.26, TT = 219.26, TP = 24.1041, MW = 98.1861, LVB = 0.127822, AF = 0.2692, SP = 16160, DM = 0, SH = -1209000000.0, IGHF = -1.29453E+08, GEF = 4.58148E+07, AS = 366142, HFMP = 1657280, HOC = -4.28203E+09, LiqDen = {105,0.72465,0.26829,565.15,0.28378,0}, VP = {101,88.755,-6920,-10.09,0.0000077797,2}, LiqCp = {16,91966,30.661,9.7483,0.0064492,-0.0000032985}, HOV = {106,5.8904E+07,1.2615,-1.6517,1.1747,-0.3566}, VapCp = {16,85421,-827.36,13.75,-0.00058187,1.7604E-07}, LiqVis = {101,-30.744,1578.9,3.2397,-0.0000069313,2}, VapVis = {102,5.0794E-07,0.561,243.58,7280.5,0}, LiqK = {16,-0.014002,-51.607,-1.1286,-0.0024368,4.2617E-08}, VapK = {102,0.011269,0.40836,151.71,760020,0}, Racketparam = 0.271, UniquacR = 4.7192, UniquacQ = 3.772, ChaoSeadAF = 0.2692, ChaoSeadSP = 16160, ChaoSeadLV = 0.127822);
  end CisOneTwodimethylcyclopentane;
  
  model TransOneTwodimethylcyclopentane
  extends General_Properties(
    SN = 268, name = "TransOneTwodimethylcyclopentane", CAS = "822-50-4", Tc = 553.15, Pc = 3445050,  Vc = 0.36, Cc = 0.27, Tb = 365.02, Tm = 155.58, TT = 155.58, TP = 0.00329595, MW = 98.1861, LVB = 0.131474, AF = 0.2692, SP = 15760, DM = 0, SH = -1209000000.0, IGHF = -1.36566E+08, GEF = 3.84928E+07, AS = 366811, HFMP = 7167190, HOC = -4.27609E+09, LiqDen = {105,0.77149,0.27784,553.15,0.30964,0}, VP = {101,89.97,-6815.6,-10.323,0.000008493,2}, LiqCp = {16,-27570,-6.4733,11.325,0.0043522,-0.0000035776}, HOV = {106,5.4143E+07,0.72069,0.072069,-0.93971,0.57146}, VapCp = {16,86316,-831.39,13.757,-0.0005975,1.8263E-07}, LiqVis = {101,-10.501,979.94,-0.073247,2.6464E-07,2}, VapVis = {102,0.0000015301,0.42849,479.07,3.9541,0}, LiqK = {16,-0.028286,5.044,-1.6594,-0.00043322,-0.000001941}, VapK = {102,0.0087025,0.4463,190.1,689820,0}, Racketparam = 0.27, UniquacR = 4.7192, UniquacQ = 3.772, ChaoSeadAF = 0.2692, ChaoSeadSP = 15760, ChaoSeadLV = 0.131474);
  end TransOneTwodimethylcyclopentane;
  
  model CisOneThreedimethylcyclopentane
  extends General_Properties(
    SN = 269, name = "CisOneThreedimethylcyclopentane", CAS = "2532-58-3", Tc = 551, Pc = 3400000,  Vc = 0.3633, Cc = 0.277, Tb = 364.71, Tm = 139.45, TT = 139.45, TP = 0.000172698, MW = 98.188, LVB = 0.13191, AF = 0.276, SP = 15490, DM = 0, SH = -1209000000.0, IGHF = -1.3585E+08, GEF = 3.9204E+07, AS = 366810, HFMP = 7397000, HOC = -4.2771E+09, LiqDen = {105,0.77224,0.27858,551,0.31293,0}, VP = {101,59.262,-5561.3,-5.5932,0.0000039124,2}, LiqCp = {16,65786,-81.345,11.138,0.0032931,-0.0000013405}, HOV = {106,5.964754E+07,1.992198,-3.906039,3.442342,-1.064932}, VapCp = {16,86318,-831.43,13.758,-0.00059782,1.8276E-07}, LiqVis = {101,-11.311,1000.6,0.063555,-2.0388E-07,2}, VapVis = {102,4.8359E-07,0.57388,271.6,-5017.7,0}, LiqK = {16,-0.041732,3.5995,-1.581,-0.00048911,-0.0000016476}, VapK = {102,0.0021721,0.62882,203.61,446440,0}, Racketparam = 0.277, UniquacR = 4.7192, UniquacQ = 3.772, ChaoSeadAF = 0.276, ChaoSeadSP = 15490, ChaoSeadLV = 0.13191);
  end CisOneThreedimethylcyclopentane;
  
  model TransOneThreedimethylcyclopentane
  extends General_Properties(
    SN = 270, name = "TransOneThreedimethylcyclopentane", CAS = "1759-58-6", Tc = 553, Pc = 3400000,  Vc = 0.3633, Cc = 0.276, Tb = 363.9, Tm = 139.18, TT = 139.18, TP = 0.0000437759, MW = 98.188, LVB = 0.13264, AF = 0.253, SP = 15660, DM = 0, SH = -1209000000.0, IGHF = -1.336E+08, GEF = 4.1463E+07, AS = 366810, HFMP = 7398000, HOC = -4.279E+09, LiqDen = {105,0.77915,0.2805,553,0.30466,0}, VP = {101,72.714,-6038.9,-7.709,0.0000063511,2}, LiqCp = {16,128140,215.87,5.2004,0.02446,-0.000024789}, HOV = {106,6.568557E+07,1.547069,-1.429715,-0.00159084,0.362451}, VapCp = {16,86318,-831.43,13.758,-0.00059782,1.8276E-07}, LiqVis = {101,-11.152,996.91,0.036374,-1.1545E-07,2}, VapVis = {102,0.0000007023,0.52532,331.02,-5427.4,0}, LiqK = {16,-0.034026,3.551,-1.6156,-0.00049883,-0.0000017475}, VapK = {102,0.0021472,0.63073,213.01,445470,0}, Racketparam = 0.276, UniquacR = 4.7192, UniquacQ = 3.772, ChaoSeadAF = 0.253, ChaoSeadSP = 15660, ChaoSeadLV = 0.13264);
  end TransOneThreedimethylcyclopentane;
  
  model Isopropylcyclopentane
  extends General_Properties(
    SN = 271, name = "Isopropylcyclopentane", CAS = "3875-51-2", Tc = 601, Pc = 3000000,  Vc = 0.422, Cc = 0.259, Tb = 399.58, Tm = 161.79, TT = 161.79, TP = 0.000981869, MW = 112.213, LVB = 0.14527, AF = 0.302996, SP = 15940, DM = 0, SH = -1209000000.0, IGHF = -1.5071E+08, GEF = 5.305E+07, AS = 407080, HFMP = 1.041E+07, HOC = -4.8944E+09, LiqDen = {105,0.01997,0.048466,601,0.10484,0}, VP = {101,70.74905,-6671.509,-7.204875,3.983606E-06,2}, LiqCp = {16,77318,-174.75,11.36,0.00375,-0.0000015189}, HOV = {106,5.807013E+07,1.420456,-3.256998,3.923183,-1.686337}, VapCp = {16,31291,-392.29,12.88,0.0005799,-2.3026E-07}, LiqVis = {101,-11.637,1116.2,0.10394,-3.9216E-07,2}, VapVis = {102,6.3283E-08,0.84204,92.528,-7299.5,0}, LiqK = {16,-0.057129,3.4704,-1.5201,-0.00050193,-0.0000011418}, VapK = {102,0.10336,0.072913,-474.32,1330800,0}, Racketparam = 0.259, UniquacR = 5.3936, UniquacQ = 4.312, ChaoSeadAF = 0.302996, ChaoSeadSP = 15940, ChaoSeadLV = 0.14527);
  end Isopropylcyclopentane;
  
  model OnemethylOneethylcyclopentane
  extends General_Properties(
    SN = 272, name = "OnemethylOneethylcyclopentane", CAS = "16747-50-5", Tc = 582, Pc = 3020000,  Vc = 0.428, Cc = 0.267, Tb = 394.672, Tm = 129.35, TT = 129.35, TP = 2.16711E-07, MW = 112.213, LVB = 0.144502, AF = 0.329811, SP = 15840, DM = 0, SH = -1209000000.0, IGHF = -1.549E+08, GEF = 5.067E+07, AS = 401000, HFMP = 0, HOC = -4.88921E+09, LiqDen = {105,0.62398,0.26553,582,0.28568,0}, VP = {101,70.30095,-6628.265,-7.112201,3.497931E-06,2}, LiqCp = {16,96111,-59.039,10.164,0.0078449,-0.0000067267}, HOV = {106,5.14848E+07,0.288357,0.487845,-0.669561,0.236062}, VapCp = {16,80936,-652.6,13.464,-0.00013102,2.6661E-08}, LiqVis = {101,-10.773,1099.9,-0.048343,1.7107E-07,2}, VapVis = {102,4.5602E-07,0.57042,274.82,-5055.3,0}, LiqK = {16,-0.0033033,9.4359,-1.8646,-0.00027,-0.0000024258}, VapK = {102,0.0026462,0.59802,270.85,473470,0}, Racketparam = 0.267, UniquacR = 5.3937, UniquacQ = 4.396, ChaoSeadAF = 0.329811, ChaoSeadSP = 15840, ChaoSeadLV = 0.144502);
  end OnemethylOneethylcyclopentane;
  
  model Nbutylcyclopentane
  extends General_Properties(
    SN = 273, name = "Nbutylcyclopentane", CAS = "2040-95-1", Tc = 621, Pc = 2710000,  Vc = 0.482, Cc = 0.254, Tb = 429.75, Tm = 165.165, TT = 165.18, TP = 0.0000370087, MW = 126.239, LVB = 0.161572, AF = 0.37188, SP = 16390, DM = 0, SH = -1209000000.0, IGHF = -1.683E+08, GEF = 6.217E+07, AS = 453800, HFMP = 1.131E+07, HOC = -5.5037E+09, LiqDen = {105,0.55321,0.26684,621,0.28873,0}, VP = {101,59.57026,-7247.203,-5.051393,-2.973642E-06,2}, LiqCp = {16,165400,317.8,5.7051,0.0202,-0.000017103}, HOV = {106,5.633912E+07,-0.222347,2.054738,-2.396364,0.924309}, VapCp = {16,82154,-554.7,13.299,0.00015408,-5.7536E-08}, LiqVis = {101,-10.446,1200.4,-0.12541,4.6316E-07,2}, VapVis = {102,0.0000029081,0.33269,700.46,-5220.4,0}, LiqK = {16,-0.059329,3.6894,-1.5397,-0.00046539,-0.0000010217}, VapK = {102,0.001615,0.65033,212.05,447790,0}, Racketparam = 0.254, UniquacR = 6.068799, UniquacQ = 4.856, ChaoSeadAF = 0.37188, ChaoSeadSP = 16390, ChaoSeadLV = 0.161572);
  end Nbutylcyclopentane;
  
  model OneOnedimethylcyclohexane
  extends General_Properties(
    SN = 274, name = "OneOnedimethylcyclohexane", CAS = "590-66-9", Tc = 591.15, Pc = 2938430,  Vc = 0.45, Cc = 0.269, Tb = 392.69, Tm = 239.66, TT = 239.66, TP = 60.5841, MW = 112.213, LVB = 0.144469, AF = 0.2376, SP = 15670, DM = 0, SH = -1209000000.0, IGHF = -1.81E+08, GEF = 3.52293E+07, AS = 365012, HFMP = 2020870, HOC = -4.8639E+09, LiqDen = {105,0.55073,0.24971,591.15,0.27534,0}, VP = {101,81.518,-6942.5,-8.9,0.0000054941,2}, LiqCp = {16,108760,-1.4419,9.7271,0.0071596,-0.0000038148}, HOV = {106,7.5815E+07,2.7664,-6.0218,6.1598,-2.4093}, VapCp = {16,97627,-847.07,13.952,-0.00053736,1.4024E-07}, LiqVis = {101,-7.7034,1042.4,-0.53177,8.3765E-07,2}, VapVis = {102,7.8141E-07,0.4995,371.04,124.2,0}, LiqK = {16,-0.0057011,-80.549,-0.98212,-0.0030094,4.8733E-07}, VapK = {102,0.01079,0.39433,-74.36,805370,0}, Racketparam = 0.269, UniquacR = 5.3937, UniquacQ = 4.396, ChaoSeadAF = 0.2376, ChaoSeadSP = 15670, ChaoSeadLV = 0.144469);
  end OneOnedimethylcyclohexane;
  
  model CisOneTwodimethylcyclohexane
  extends General_Properties(
    SN = 275, name = "CisOneTwodimethylcyclohexane", CAS = "2207-01-4", Tc = 606.15, Pc = 2938430,  Vc = 0.46, Cc = 0.268, Tb = 402.94, Tm = 223.16, TT = 223.16, TP = 6.41394, MW = 112.213, LVB = 0.141645, AF = 0.2363, SP = 16250, DM = 0, SH = -1209000000.0, IGHF = -1.72172E+08, GEF = 4.12124E+07, AS = 374510, HFMP = 1645150, HOC = -4.87084E+09, LiqDen = {105,0.52003,0.24148,606.15,0.2655,0}, VP = {101,79.675,-7110.6,-8.5422,0.0000045741,2}, LiqCp = {16,111710,52.625,9.3729,0.0077553,-0.0000040932}, HOV = {106,6.6247E+07,1.824,-3.744,3.9502,-1.5633}, VapCp = {16,99210,-835.35,13.925,-0.00054754,1.5043E-07}, LiqVis = {101,-12.312,1465.3,0.097955,-4.4792E-07,2}, VapVis = {102,8.4568E-07,0.48702,397.94,11.816,0}, LiqK = {16,-0.013234,-31.366,-1.3892,-0.0016087,-0.0000006162}, VapK = {102,0.015824,0.34516,-25.388,892770,0}, Racketparam = 0.268, UniquacR = 5.3936, UniquacQ = 4.312, ChaoSeadAF = 0.2363, ChaoSeadSP = 16250, ChaoSeadLV = 0.141645);
  end CisOneTwodimethylcyclohexane;
  
  model TransOneTwodimethylcyclohexane
  extends General_Properties(
    SN = 276, name = "TransOneTwodimethylcyclohexane", CAS = "6876-23-9", Tc = 596.15, Pc = 2938430,  Vc = 0.46, Cc = 0.273, Tb = 396.58, Tm = 184.99, TT = 184.99, TP = 0.0803872, MW = 112.213, LVB = 0.145347, AF = 0.2416, SP = 15780, DM = 0, SH = -1209000000.0, IGHF = -1.79996E+08, GEF = 3.44761E+07, AS = 370912, HFMP = 1.04223E+07, HOC = -4.86436E+09, LiqDen = {105,0.54418,0.25029,596.15,0.26582,0}, VP = {101,78.951,-6905.8,-8.4915,0.0000050406,2}, LiqCp = {16,107760,95.278,8.9456,0.0091345,-0.000005166}, HOV = {106,6.3964E+07,1.6946,-3.2086,3.1663,-1.1947}, VapCp = {16,97739,-799.79,13.856,-0.00049041,1.3436E-07}, LiqVis = {101,-9.8695,1124.4,-0.19468,4.6083E-07,2}, VapVis = {102,0.0000004616,0.56409,251.76,9969.9,0}, LiqK = {16,-0.096966,-4.6856,-1.2678,-0.00075424,-4.7962E-07}, VapK = {102,0.014659,0.3596,28.311,846250,0}, Racketparam = 0.273, UniquacR = 5.3936, UniquacQ = 4.312, ChaoSeadAF = 0.2416, ChaoSeadSP = 15780, ChaoSeadLV = 0.145347);
  end TransOneTwodimethylcyclohexane;
  
  model CisOneThreedimethylcyclohexane
  extends General_Properties(
    SN = 277, name = "CisOneThreedimethylcyclohexane", CAS = "638-04-0", Tc = 591.15, Pc = 2938430,  Vc = 0.45, Cc = 0.269, Tb = 393.24, Tm = 197.61, TT = 197.58, TP = 0.562747, MW = 112.213, LVB = 0.147281, AF = 0.2414, SP = 15640, DM = 0, SH = -1209000000.0, IGHF = -1.84765E+08, GEF = 2.98319E+07, AS = 370451, HFMP = 1.08211E+07, HOC = -4.85972E+09, LiqDen = {105,0.56146,0.25431,591.15,0.28196,0}, VP = {101,80.304,-6952.9,-8.6838,0.000005071,2}, LiqCp = {16,91638,67.51,9.6813,0.0069535,-0.0000034278}, HOV = {106,6.8345E+07,2.0984,-4.3187,4.4054,-1.7047}, VapCp = {16,100690,-836.69,13.908,-0.00051206,1.3582E-07}, LiqVis = {101,-19.068,1358.3,1.3526,-0.0000038202,2}, VapVis = {102,0.0000012434,0.44274,472.75,75.213,0}, LiqK = {16,-0.04198,-3.8682,-1.5284,-0.00074068,-0.0000011056}, VapK = {102,0.015195,0.35206,-46.167,870770,0}, Racketparam = 0.269, UniquacR = 5.3936, UniquacQ = 4.312, ChaoSeadAF = 0.2414, ChaoSeadSP = 15640, ChaoSeadLV = 0.147281);
  end CisOneThreedimethylcyclohexane;
  
  model TransOneThreedimethylcyclohexane
  extends General_Properties(
    SN = 278, name = "TransOneThreedimethylcyclohexane", CAS = "2207-03-6", Tc = 598.15, Pc = 2938430,  Vc = 0.46, Cc = 0.272, Tb = 397.61, Tm = 183.07, TT = 183.05, TP = 0.0422148, MW = 112.213, LVB = 0.143768, AF = 0.2356, SP = 16040, DM = 0, SH = -1209000000.0, IGHF = -1.76565E+08, GEF = 3.63171E+07, AS = 376225, HFMP = 9865870, HOC = -4.86695E+09, LiqDen = {105,0.51304,0.23992,598.15,0.27441,0}, VP = {101,80.341,-7070.2,-8.6503,0.0000047054,2}, LiqCp = {16,121960,76.643,8.8176,0.0095602,-0.0000057205}, HOV = {106,6.9382E+07,2.1184,-4.4766,4.6776,-1.8318}, VapCp = {16,101700,-844.25,13.931,-0.00056374,1.5762E-07}, LiqVis = {101,-10.854,1074.4,-0.03203,4.561E-08,2}, VapVis = {102,0.0000023976,0.3653,664.66,3836.7,0}, LiqK = {16,-0.046977,2.8897,-1.5646,-0.00046419,-0.0000013304}, VapK = {102,0.016485,0.34326,5.6687,894520,0}, Racketparam = 0.272, UniquacR = 5.3936, UniquacQ = 4.312, ChaoSeadAF = 0.2356, ChaoSeadSP = 16040, ChaoSeadLV = 0.143768);
  end TransOneThreedimethylcyclohexane;
  
  model CisOneFourdimethylcyclohexane
  extends General_Properties(
    SN = 279, name = "CisOneFourdimethylcyclohexane", CAS = "624-29-3", Tc = 598.15, Pc = 2938430,  Vc = 0.46, Cc = 0.272, Tb = 397.48, Tm = 185.744, TT = 185.72, TP = 0.0704204, MW = 112.213, LVB = 0.144106, AF = 0.2348, SP = 15980, DM = 0, SH = -1209000000.0, IGHF = -1.76648E+08, GEF = 3.79489E+07, AS = 370451, HFMP = 9307730, HOC = -4.86704E+09, LiqDen = {105,0.53336,0.24533,598.15,0.2771,0}, VP = {101,79.163,-7004.6,-8.4779,0.0000046053,2}, LiqCp = {16,110770,140.07,8.7617,0.0091373,-0.0000048302}, HOV = {106,7.1514E+07,2.3724,-5.2021,5.4751,-2.1521}, VapCp = {16,101700,-844.25,13.931,-0.00056374,1.5762E-07}, LiqVis = {101,-20.704,1391.4,1.6378,-0.0000047953,2}, VapVis = {102,0.0000024207,0.36412,666.44,4231,0}, LiqK = {16,-0.063527,3.3026,-1.4941,-0.0004362,-0.0000011663}, VapK = {102,0.016747,0.34072,-1.7965,898230,0}, Racketparam = 0.272, UniquacR = 5.3936, UniquacQ = 4.312, ChaoSeadAF = 0.2348, ChaoSeadSP = 15980, ChaoSeadLV = 0.144106);
  end CisOneFourdimethylcyclohexane;
  
  model TransOneFourdimethylcyclohexane
  extends General_Properties(
    SN = 280, name = "TransOneFourdimethylcyclohexane", CAS = "2207-04-7", Tc = 590.15, Pc = 2940000,  Vc = 0.45, Cc = 0.271, Tb = 392.51, Tm = 236.21, TT = 236.21, TP = 44.9802, MW = 112.213, LVB = 0.147921, AF = 0.2429, SP = 15490, DM = 0, SH = -1209000000.0, IGHF = -1.84598E+08, GEF = 3.17147E+07, AS = 364803, HFMP = 1.2332E+07, HOC = -4.86026E+09, LiqDen = {105,0.064652,0.087885,590.15,0.13093,0}, VP = {101,85.56244,-7078.051,-9.547047,6.602527E-06,2}, LiqCp = {16,119770,186.95,7.9604,0.011554,-0.0000069633}, HOV = {106,5.5648E+07,0.9536,-1.3747,1.3927,-0.55606}, VapCp = {16,97979,-830.68,13.935,-0.00055238,1.5056E-07}, LiqVis = {101,-8.7946,1113.8,-0.41314,9.8767E-07,2}, VapVis = {102,6.6365E-07,0.52158,345.67,-1560.6,0}, LiqK = {16,-0.0015458,-71.843,-1.1073,-0.0027831,1.5512E-07}, VapK = {102,0.012496,0.37939,-0.8405,811480,0}, Racketparam = 0.271, UniquacR = 5.3936, UniquacQ = 4.312, ChaoSeadAF = 0.2429, ChaoSeadSP = 15490, ChaoSeadLV = 0.147921);
  end TransOneFourdimethylcyclohexane;
  
  model Tertbutylcyclohexane
  extends General_Properties(
    SN = 281, name = "Tertbutylcyclohexane", CAS = "3178-22-1", Tc = 652, Pc = 2660000,  Vc = 0.51, Cc = 0.25, Tb = 444.65, Tm = 231.98, TT = 231.98, TP = 1.2, MW = 140.266, LVB = 0.1734, AF = 0.299134, SP = 16040, DM = 0, SH = -1209000000.0, IGHF = -2.169E+08, GEF = 5.695E+07, AS = 445700, HFMP = 1.12E+07, HOC = -6.091E+09, LiqDen = {105,0.52388,0.26705,652,0.32913,0}, VP = {101,123.1664,-9675.557,-15.08186,0.0000105041,2}, LiqCp = {16,40996,-122.74,11.846,0.0032488,-0.0000015611}, HOV = {106,6.9454E+07,0.40915,1.6494,-3.4494,1.9573}, VapCp = {16,95339,-601.24,13.623,-0.000018521,-1.574E-08}, LiqVis = {101,-11.549,1445.9,0,0,0}, VapVis = {102,4.6046E-08,0.87493,72.873,-5600.2,0}, LiqK = {16,0.054405,-203.55,-0.50495,-0.0065818,0.0000029095}, VapK = {102,0.077607,0.14004,-91.94,1372500,0}, Racketparam = 0.25, UniquacR = 6.7417, UniquacQ = 5.472, ChaoSeadAF = 0.299134, ChaoSeadSP = 16040, ChaoSeadLV = 0.1734);
  end Tertbutylcyclohexane;
  
  model Oethyltoluene
  extends General_Properties(
    SN = 282, name = "Oethyltoluene", CAS = "611-14-3", Tc = 651.15, Pc = 3040000,  Vc = 0.46, Cc = 0.26, Tb = 438.33, Tm = 192.35, TT = 192.35, TP = 0.00376669, MW = 120.192, LVB = 0.136967, AF = 0.2941, SP = 18090, DM = 1.87E-30, SH = -1209000000.0, IGHF = 1213360, GEF = 1.31055E+08, AS = 399350, HFMP = 9962100, HOC = -4.94607E+09, LiqDen = {105,0.37928,0.20513,651.15,0.23356,0}, VP = {101,96.1971,-8650.261,-10.86209,5.918239E-06,2}, LiqCp = {16,-102370,-26.419,12.162,0.0026059,-0.000002126}, HOV = {106,8.227273E+07,1.968046,-3.535916,3.107317,-1.061436}, VapCp = {16,85432,-569.61,13.054,0.000095945,-4.3717E-08}, LiqVis = {101,-10.303,1378.1,-0.24629,5.1436E-07,2}, VapVis = {102,4.4089E-07,0.56719,270.1,-4560.2,0}, LiqK = {16,-0.059289,4.2071,-1.4739,-0.00039236,-0.0000010623}, VapK = {102,0.000092842,1.0422,544.16,63099,0}, Racketparam = 0.26, UniquacR = 5.3322, UniquacQ = 4.076, ChaoSeadAF = 0.2941, ChaoSeadSP = 18090, ChaoSeadLV = 0.136967);
  end Oethyltoluene;
  
  model Methyltoluene
  extends General_Properties(
    SN = 283, name = "Methyltoluene", CAS = "620-14-4", Tc = 637.15, Pc = 2840000,  Vc = 0.49, Cc = 0.254, Tb = 434.48, Tm = 177.61, TT = 177.61, TP = 0.000664959, MW = 120.192, LVB = 0.139685, AF = 0.3232, SP = 17630, DM = 1.1E-30, SH = -1209000000.0, IGHF = -1920000, GEF = 1.2643E+08, AS = 404280, HFMP = 7610000, HOC = -4.94377E+09, LiqDen = {105,0.61007,0.26045,637.15,0.2946,0}, VP = {101,59.906,-6895.5,-5.4176,0.00000211,2}, LiqCp = {16,136340,-1484.6,20.724,-0.020829,0.000018949}, HOV = {106,6.562712E+07,1.251642,-2.311984,2.123485,-0.635116}, VapCp = {16,77831,-586.35,13.16,0.0000010287,-1.3417E-08}, LiqVis = {101,-10.732,1285.7,-0.12931,2.7444E-07,2}, VapVis = {102,4.7246E-07,0.55389,274.11,-5848.6,0}, LiqK = {16,-0.048117,4.2831,-1.5331,-0.00039971,-0.0000012216}, VapK = {102,0.000091259,1.0513,653.39,40428,0}, Racketparam = 0.254, UniquacR = 5.3322, UniquacQ = 4.076, ChaoSeadAF = 0.3232, ChaoSeadSP = 17630, ChaoSeadLV = 0.139685);
  end Methyltoluene;
  
  model Pethyltoluene
  extends General_Properties(
    SN = 284, name = "Pethyltoluene", CAS = "622-96-8", Tc = 640.2, Pc = 3230000,  Vc = 0.44, Cc = 0.259, Tb = 435.13, Tm = 210.83, TT = 210.83, TP = 0.0782406, MW = 120.194, LVB = 0.1396, AF = 0.364, SP = 17710, DM = 0, SH = -1209000000.0, IGHF = -3260000, GEF = 1.268E+08, AS = 398900, HFMP = 1.336E+07, HOC = -4.94268E+09, LiqDen = {105,0.60155,0.25704,640.2,0.31664,0}, VP = {101,21.19382,-5103.792,0.409026,-2.319216E-06,2}, LiqCp = {16,30748,-85.511,11.539,0.0037389,-0.0000030029}, HOV = {106,7.1677E+07,1.0708,-1.1055,0.62044,-0.16372}, VapCp = {16,75636,-568.13,13.103,0.000082441,-4.4902E-08}, LiqVis = {101,-23.973,1681.2,1.9315,6.328E-08,2}, VapVis = {102,5.7075E-07,0.5347,318.96,-7211.9,0}, LiqK = {16,-0.065655,1.2156,-1.4285,-0.00047761,-9.6417E-07}, VapK = {102,0.000095782,1.0471,660.61,40132,0}, Racketparam = 0.259, UniquacR = 5.3322, UniquacQ = 4.076, ChaoSeadAF = 0.364, ChaoSeadSP = 17710, ChaoSeadLV = 0.1396);
  end Pethyltoluene;
  
  model OneTwoThreetrimethylbenzene
  extends General_Properties(
    SN = 285, name = "OneTwoThreetrimethylbenzene", CAS = "526-73-8", Tc = 664.5, Pc = 3454000,  Vc = 0.435, Cc = 0.267, Tb = 449.23, Tm = 247.79, TT = 247.79, TP = 3.70834, MW = 120.194, LVB = 0.13322, AF = 0.367, SP = 18480, DM = 1.87E-30, SH = -1209000000.0, IGHF = -9568810, GEF = 1.244E+08, AS = 380500, HFMP = 8170000, HOC = -4.93394E+09, LiqDen = {105,0.47081,0.22935,664.5,0.22914,0}, VP = {101,103.4032,-9139.734,-11.94112,6.875135E-06,2}, LiqCp = {16,158190,-110.87,9.7005,0.0066246,-0.000003875}, HOV = {106,5.897E+07,0.31296,0.11034,-0.18707,0.12203}, VapCp = {16,97344,-642.53,13.123,0.000061931,-4.6438E-08}, LiqVis = {101,-13.622,1547.6,0.25604,-4.4218E-07,2}, VapVis = {102,7.8569E-07,0.49843,362.98,-102.15,0}, LiqK = {16,0.066267,303.46,-5.2163,0.0092731,-0.000014825}, VapK = {102,0.000093303,1.0419,539.24,56545,0}, Racketparam = 0.267, UniquacR = 5.3928, UniquacQ = 4.104, ChaoSeadAF = 0.367, ChaoSeadSP = 18480, ChaoSeadLV = 0.13322);
  end OneTwoThreetrimethylbenzene;
  
  model OneTwoFourtrimethylbenzene
  extends General_Properties(
    SN = 286, name = "OneTwoFourtrimethylbenzene", CAS = "95-63-6", Tc = 649.1, Pc = 3232000,  Vc = 0.435, Cc = 0.256, Tb = 442.49, Tm = 229.38, TT = 229.33, TP = 0.69347, MW = 120.194, LVB = 0.136, AF = 0.377, SP = 18090, DM = 1.0E-30, SH = -1209000000.0, IGHF = -1.392E+07, GEF = 1.17E+08, AS = 395870, HFMP = 1.319E+07, HOC = -4.93067E+09, LiqDen = {105,0.61782,0.26243,649.1,0.28053,0}, VP = {101,60.23044,-7113.208,-5.408973,1.637451E-06,2}, LiqCp = {16,159260,100.48,7.176,0.015511,-0.000013842}, HOV = {106,6.6212E+07,0.612793,0.157992,-1.024462,0.66352}, VapCp = {16,86220,-588.22,13.049,0.00013217,-6.3042E-08}, LiqVis = {101,-22.655,1676.9,1.8204,-0.0000040799,2}, VapVis = {102,9.0311E-07,0.47728,388.95,-1321.5,0}, LiqK = {16,-0.097311,-7.9329,-1.1933,-0.00075728,-4.2291E-07}, VapK = {102,0.000071734,1.0715,503.12,48355,0}, Racketparam = 0.256, UniquacR = 5.3928, UniquacQ = 4.104, ChaoSeadAF = 0.377, ChaoSeadSP = 18090, ChaoSeadLV = 0.136);
  end OneTwoFourtrimethylbenzene;
  
  model Mesitylene
  extends General_Properties(
    SN = 287, name = "Mesitylene", CAS = "108-67-8", Tc = 637.3, Pc = 3127000,  Vc = 0.43, Cc = 0.252, Tb = 437.9, Tm = 228.46, TT = 228.42, TP = 0.742135, MW = 120.194, LVB = 0.14299, AF = 0.399, SP = 17940, DM = 0, SH = -1209000000.0, IGHF = -1.605E+07, GEF = 1.181E+08, AS = 385410, HFMP = 9514000, HOC = -4.92904E+09, LiqDen = {105,0.59019,0.25742,637.3,0.27724,0}, VP = {101,118.5616,-9560.276,-14.30644,9.375247E-06,2}, LiqCp = {16,152130,279.49,4.8304,0.024632,-0.000024309}, HOV = {106,6.9292E+07,1.0706,-1.5094,1.269,-0.42864}, VapCp = {16,76799,-561.49,13.016,0.00018488,-8.0041E-08}, LiqVis = {101,-11.283,1439.3,-0.15787,0.0000019934,2}, VapVis = {102,3.4877E-07,0.61399,342.31,-16742,0}, LiqK = {16,-0.012521,77.398,-2.4912,0.0027181,-0.0000053908}, VapK = {102,0.3225,-0.079944,-464.54,1938200,0}, Racketparam = 0.252, UniquacR = 5.3928, UniquacQ = 4.104, ChaoSeadAF = 0.399, ChaoSeadSP = 17940, ChaoSeadLV = 0.14299);
  end Mesitylene;
  
  model Isobutylbenzene
  extends General_Properties(
    SN = 288, name = "Isobutylbenzene", CAS = "538-93-2", Tc = 650, Pc = 3050000,  Vc = 0.48, Cc = 0.271, Tb = 445.9, Tm = 221.7, TT = 221.7, TP = 0.289087, MW = 134.221, LVB = 0.15808, AF = 0.383, SP = 16860, DM = 1.5E-30, SH = -1209000000.0, IGHF = -2.054E+07, GEF = 1.388E+08, AS = 439700, HFMP = 1.25E+07, HOC = -5.56974E+09, LiqDen = {105,0.54967,0.26271,650,0.30807,0}, VP = {101,97.24209,-8752.864,-11.04244,6.424651E-06,2}, LiqCp = {16,116150,-36.608,10.189,0.0074074,-0.0000060747}, HOV = {106,6.0838E+07,0.30052,0.25612,-0.19969,-0.0011249}, VapCp = {16,83364,-556.41,13.277,0.000016037,-2.0047E-08}, LiqVis = {101,-12.546,1392.5,0.17362,-2.3672E-07,2}, VapVis = {102,3.8764E-07,0.58977,249.51,1034.4,0}, LiqK = {16,-0.033263,-23.962,-1.3695,-0.001338,-2.5251E-07}, VapK = {102,0.000022162,1.2141,174.06,50162,0}, Racketparam = 0.271, UniquacR = 5.9452, UniquacQ = 4.584, ChaoSeadAF = 0.383, ChaoSeadSP = 16860, ChaoSeadLV = 0.15808);
  end Isobutylbenzene;
  
  model Secbutylbenzene
  extends General_Properties(
    SN = 289, name = "Secbutylbenzene", CAS = "135-98-8", Tc = 664.54, Pc = 2930000,  Vc = 0.478, Cc = 0.265, Tb = 446.48, Tm = 197.717, TT = 197.717, TP = 0.00180534, MW = 134.218, LVB = 0.156497, AF = 0.279149, SP = 17050, DM = 1.3E-30, SH = -1209000000.0, IGHF = -1.73E+07, GEF = 1.4523E+08, AS = 439600, HFMP = 9830000, HOC = -5.563E+09, LiqDen = {105,0.51273,0.25494,664.54,0.28096,0}, VP = {101,222.2329,-13854.88,-30.30702,0.0000262583,2}, LiqCp = {16,163140,-1794.7,23.385,-0.029199,0.000028}, HOV = {106,3.1793E+07,-4.1563,12.591,-13.449,5.2588}, VapCp = {16,118430,-784.79,13.745,-0.00050199,1.4393E-07}, LiqVis = {10,-9.695648,-444.5934,-129.1082,0,0}, VapVis = {102,0.000001223,0.44278,495.81,151.45,0}, LiqK = {16,-0.042864,5.3464,-1.6033,-0.00035754,-0.0000011781}, VapK = {102,0.000022,1.2101,186.5,49434,0}, Racketparam = 0.265, UniquacR = 5.9452, UniquacQ = 4.584, ChaoSeadAF = 0.279149, ChaoSeadSP = 17050, ChaoSeadLV = 0.156497);
  end Secbutylbenzene;
  
  model Tertbutylbenzene
  extends General_Properties(
    SN = 290, name = "Tertbutylbenzene", CAS = "98-06-6", Tc = 660, Pc = 2970000,  Vc = 0.46, Cc = 0.266, Tb = 442.3, Tm = 215.27, TT = 215.27, TP = 0.0910321, MW = 134.218, LVB = 0.155605, AF = 0.267406, SP = 17130, DM = 2.33E-30, SH = -1209000000.0, IGHF = -2.26E+07, GEF = 1.4995E+08, AS = 401400, HFMP = 8393000, HOC = -5.5547E+09, LiqDen = {105,0.50957,0.25071,660,0.30584,0}, VP = {101,87.574,-8352.2,-9.5118,0.0000039953,2}, LiqCp = {16,164930,701.24,1.184,0.037122,-0.000038006}, HOV = {106,6.3167E+07,0.45262,0,0,0}, VapCp = {16,113750,-776.86,13.825,-0.0005797,1.6467E-07}, LiqVis = {101,-11.7,1364.1,0.038741,-3.8013E-08,2}, VapVis = {102,7.2957E-07,0.50871,384.51,-23.513,0}, LiqK = {16,0.052023,-143.3,-0.69673,-0.0057333,0.0000022627}, VapK = {102,0.000018955,1.2291,130.74,53349,0}, Racketparam = 0.266, UniquacR = 5.9452, UniquacQ = 4.584, ChaoSeadAF = 0.267406, ChaoSeadSP = 17130, ChaoSeadLV = 0.155605);
  end Tertbutylbenzene;
  
  model Ocymene
  extends General_Properties(
    SN = 291, name = "Ocymene", CAS = "527-84-4", Tc = 670.15, Pc = 2895870,  Vc = 0.478, Cc = 0.26, Tb = 451.33, Tm = 201.64, TT = 201.64, TP = 0.0177118, MW = 134.218, LVB = 0.153824, AF = 0.2769, SP = 17160, DM = 2.0E-30, SH = -1209000000.0, IGHF = -2.56061E+07, GEF = 1.37359E+08, AS = 425500, HFMP = 1.0E+07, HOC = -5.56053E+09, LiqDen = {105,0.017298,0.046645,670.15,0.11526,0}, VP = {101,47.323,-6536.6,-3.5074,6.0254E-07,2}, LiqCp = {16,130330,-123.14,10.583,0.0062464,-0.0000049954}, HOV = {106,8.44827E+07,3.205721,-8.334975,9.055186,-3.399515}, VapCp = {16,105060,-664.9,13.437,-0.00013826,2.1794E-08}, LiqVis = {101,-8.1679,885.64,-0.29176,-7.7161E-07,2}, VapVis = {102,0.0000020745,0.37852,642.92,259.27,0}, LiqK = {16,0.06145,-173.56,-0.23519,-0.0077758,0.0000038715}, VapK = {102,0.000020459,1.2217,183.94,51167,0}, Racketparam = 0.26, UniquacR = 6.0058, UniquacQ = 4.612, ChaoSeadAF = 0.2769, ChaoSeadSP = 17160, ChaoSeadLV = 0.153824);
  end Ocymene;
  
  model Mcymene
  extends General_Properties(
    SN = 292, name = "Mcymene", CAS = "535-77-3", Tc = 666.25, Pc = 2810000,  Vc = 0.478, Cc = 0.257, Tb = 448.23, Tm = 209.44, TT = 209.44, TP = 0.0405569, MW = 134.218, LVB = 0.156604, AF = 0.342, SP = 17110, DM = 1.2E-30, SH = -1209000000.0, IGHF = -2.79909E+07, GEF = 1.301E+08, AS = 432200, HFMP = 1.37E+07, HOC = -5.55802E+09, LiqDen = {105,0.17699,0.14976,666.25,0.19922,0}, VP = {101,72.132,-7676.5,-7.2263,0.0000031742,2}, LiqCp = {16,129560,-114.64,10.436,0.006807,-0.0000055776}, HOV = {106,1.132017E+08,4.402749,-10.71693,11.0294,-4.113621}, VapCp = {16,118290,-808.58,13.818,-0.00057669,1.7291E-07}, LiqVis = {101,-8.2582,1048.3,-0.41448,-1.0836E-07,2}, VapVis = {102,0.0000018208,0.39157,589.66,3771.8,0}, LiqK = {16,-0.042558,-18.046,-1.3081,-0.0015377,2.6414E-07}, VapK = {102,0.0000098162,1.3084,45.918,51418,0}, Racketparam = 0.257, UniquacR = 6.0058, UniquacQ = 4.612, ChaoSeadAF = 0.342, ChaoSeadSP = 17110, ChaoSeadLV = 0.156604);
  end Mcymene;
  
  model Pcymene
  extends General_Properties(
    SN = 293, name = "Pcymene", CAS = "99-87-6", Tc = 652, Pc = 2800000,  Vc = 0.497, Cc = 0.248, Tb = 450.26, Tm = 205.25, TT = 205.25, TP = 0.010391, MW = 134.221, LVB = 0.15749, AF = 0.376, SP = 17290, DM = 0, SH = -1209000000.0, IGHF = -2.799E+07, GEF = 1.3352E+08, AS = 426400, HFMP = 9661000, HOC = -5.558E+09, LiqDen = {105,0.44838,0.23842,653.16,0.26866,0}, VP = {101,130.8986,-10357.88,-16.09943,9.850105E-06,2}, LiqCp = {16,99148,48.442,10.281,0.006034,-0.0000045515}, HOV = {106,8.966039E+07,1.950064,-3.032433,2.16162,-0.588861}, VapCp = {16,119360,-822.32,13.841,-0.00060036,1.8085E-07}, LiqVis = {101,-29.824,1974.9,2.8359,-0.0000010565,2}, VapVis = {102,0.0000032148,0.32014,730.34,10237,0}, LiqK = {16,0.018679,-10.656,-1.722,-0.0015047,-7.6885E-07}, VapK = {102,0.00010761,1.0275,670.75,67288,0}, Racketparam = 0.248, UniquacR = 6.0058, UniquacQ = 4.612, ChaoSeadAF = 0.376, ChaoSeadSP = 17290, ChaoSeadLV = 0.15749);
  end Pcymene;
  
  model Odiethylbenzene
  extends General_Properties(
    SN = 294, name = "Odiethylbenzene", CAS = "135-01-3", Tc = 668, Pc = 2880000,  Vc = 0.502, Cc = 0.26, Tb = 456.573, Tm = 241.91, TT = 241.929, TP = 1.04119, MW = 134.2182, LVB = 0.15328, AF = 0.3879, SP = 17760, DM = 1.96803E-30, SH = -1209000000.0, IGHF = -1.89535E+07, GEF = 1.41084E+08, AS = 434800, HFMP = 1.67778E+07, HOC = -5.5596E+09, LiqDen = {105,0.52086,0.25389,668,0.28666,0}, VP = {101,136.1844,-10760.78,-16.88233,0.0000109939,2}, LiqCp = {16,13731,7.9227,11.237,0.004718,-0.0000037106}, HOV = {106,4.4827E+07,-1.9073,6.1295,-6.3772,2.4857}, VapCp = {16,122330,-723.39,13.531,-0.00028953,7.2562E-08}, LiqVis = {101,-13.971,1608.7,0.32395,-5.0533E-07,2}, VapVis = {102,4.8451E-08,0.84013,-72.915,24855,0}, LiqK = {16,-0.047218,-11.073,-1.4189,-0.00077787,-7.5252E-07}, VapK = {102,0.000087851,1.0397,505.4,47466,0}, Racketparam = 0.26, UniquacR = 6.0066, UniquacQ = 4.616, ChaoSeadAF = 0.3879, ChaoSeadSP = 17760, ChaoSeadLV = 0.15328);
  end Odiethylbenzene;
  
  model Mdiethylbenzene
  extends General_Properties(
    SN = 295, name = "Mdiethylbenzene", CAS = "141-93-5", Tc = 663, Pc = 2880000,  Vc = 0.488, Cc = 0.255, Tb = 454.252, Tm = 189.23, TT = 189.259, TP = 0.000664991, MW = 134.2182, LVB = 0.156083, AF = 0.354019, SP = 17460, DM = 1.2E-30, SH = -1209000000.0, IGHF = -2.18E+07, GEF = 1.367E+08, AS = 439500, HFMP = 1.097E+07, HOC = -5.5546E+09, LiqDen = {105,0.52578,0.25663,663,0.2955,0}, VP = {101,153.5552,-11090.88,-19.79091,0.000016846,2}, LiqCp = {16,-15019,20.098,11.35,0.0044704,-0.0000034473}, HOV = {106,6.460804E+07,0.433681,-0.0244308,0.0154888,-0.0245419}, VapCp = {16,115660,-734.22,13.598,-0.00034186,8.9326E-08}, LiqVis = {101,-11.504,1313.6,0.03353,-9.5074E-08,2}, VapVis = {102,0.0000018496,0.38185,552.33,63.517,0}, LiqK = {16,-0.056303,5.6194,-1.5408,-0.00033118,-0.0000010873}, VapK = {102,0.25407,-0.039016,-216.19,1832400,0}, Racketparam = 0.255, UniquacR = 6.0066, UniquacQ = 4.616, ChaoSeadAF = 0.354019, ChaoSeadSP = 17460, ChaoSeadLV = 0.156083);
  end Mdiethylbenzene;
  
  model Pdiethylbenzene
  extends General_Properties(
    SN = 296, name = "Pdiethylbenzene", CAS = "105-05-5", Tc = 657.9, Pc = 2803000,  Vc = 0.4805, Cc = 0.247, Tb = 456.9, Tm = 230.3, TT = 230.325, TP = 0.21291, MW = 134.2182, LVB = 0.15645, AF = 0.403, SP = 17660, DM = 0, SH = -1209000000.0, IGHF = -2.23E+07, GEF = 1.385E+08, AS = 433100, HFMP = 1.06E+07, HOC = -5.5553E+09, LiqDen = {105,0.50239,0.25108,657.9,0.28806,0}, VP = {101,108.74,-9636.7,-12.656,0.000006664,2}, LiqCp = {16,42717,-14.138,11.106,0.0050234,-0.0000039715}, HOV = {106,5.468714E+07,-1.551219,6.621841,-8.199596,3.486311}, VapCp = {16,117030,-755.24,13.637,-0.00037709,9.9721E-08}, LiqVis = {101,-11.766,1322.3,0.075076,-1.4518E-07,2}, VapVis = {102,7.2136E-07,0.49617,343.97,-290.07,0}, LiqK = {16,-0.054323,-5.9143,-1.4413,-0.00065059,-8.3255E-07}, VapK = {102,0.000023956,1.1969,213.51,48127,0}, Racketparam = 0.247, UniquacR = 6.0066, UniquacQ = 4.616, ChaoSeadAF = 0.403, ChaoSeadSP = 17660, ChaoSeadLV = 0.15645);
  end Pdiethylbenzene;
  
  model OneTwoThreeFourtetramethylbenzene
  extends General_Properties(
    SN = 297, name = "OneTwoThreeFourtetramethylbenzene", CAS = "488-23-3", Tc = 690, Pc = 2860000,  Vc = 0.482, Cc = 0.256, Tb = 478.19, Tm = 266.9, TT = 266.9, TP = 2.9878, MW = 134.218, LVB = 0.149073, AF = 0.417172, SP = 18860, DM = 1.66E-30, SH = -1209000000.0, IGHF = -3.305E+07, GEF = 1.324E+08, AS = 416500, HFMP = 1.123E+07, HOC = -5.5376E+09, LiqDen = {105,0.62671,0.276,690,0.30501,0}, VP = {101,103.3938,-9866.6,-11.74655,5.432648E-06,2}, LiqCp = {16,191090,-1527.7,20.231,-0.019977,0.000019333}, HOV = {106,6.827737E+07,0.20659,0.354625,0.156354,-0.400825}, VapCp = {16,108680,-536.06,13.006,0.00026578,-1.0197E-07}, LiqVis = {101,-12.555,1810.8,0.0032112,-3.0199E-09,2}, VapVis = {102,8.0975E-08,0.80432,144.14,-8326.5,0}, LiqK = {16,-0.046705,-31.572,-1.2356,-0.0012463,-2.6103E-07}, VapK = {102,0.0001001,1.0331,653.92,21466,0}, Racketparam = 0.256, UniquacR = 6.1278, UniquacQ = 4.672, ChaoSeadAF = 0.417172, ChaoSeadSP = 18860, ChaoSeadLV = 0.149073);
  end OneTwoThreeFourtetramethylbenzene;
  
  model OneTwoThreeFivetetramethylbenzene
  extends General_Properties(
    SN = 298, name = "OneTwoThreeFivetetramethylbenzene", CAS = "527-53-7", Tc = 679, Pc = 3220000,  Vc = 0.436, Cc = 0.254, Tb = 471.15, Tm = 249.46, TT = 249.46, TP = 0.886139, MW = 134.218, LVB = 0.151385, AF = 0.459061, SP = 18330, DM = 0, SH = -1209000000.0, IGHF = -4.054E+07, GEF = 1.231E+08, AS = 422500, HFMP = 1.072E+07, HOC = -5.532E+09, LiqDen = {105,0.5261,0.25428,679,0.28565,0}, VP = {101,108.28,-9936.6,-12.519,0.0000062754,2}, LiqCp = {16,180380,-63.604,9.2496,0.0072443,-0.0000031051}, HOV = {106,6.6549E+07,0.31372,0.25924,-0.3264,0.12301}, VapCp = {16,109230,-579.21,13.116,0.00014705,-5.951E-08}, LiqVis = {101,-14.031,1747.6,0.263,-3.7653E-07,2}, VapVis = {102,6.7114E-07,0.50662,335.88,-402.07,0}, LiqK = {16,-0.064932,-8.9077,-1.3593,-0.00066705,-6.8372E-07}, VapK = {102,0.000082384,1.0555,595.15,34335,0}, Racketparam = 0.254, UniquacR = 6.1278, UniquacQ = 4.672, ChaoSeadAF = 0.426, ChaoSeadSP = 18330, ChaoSeadLV = 0.151385);
  end OneTwoThreeFivetetramethylbenzene;
  
  model OneTwoFourFivetetramethylbenzene
  extends General_Properties(
    SN = 299, name = "OneTwoFourFivetetramethylbenzene", CAS = "95-93-2", Tc = 676, Pc = 2900000,  Vc = 0.482, Cc = 0.249, Tb = 470, Tm = 352.384, TT = 352.384, TP = 1784.79, MW = 134.221, LVB = 0.15228, AF = 0.423, SP = 17140, DM = 0, SH = -1209000000.0, IGHF = -4.527E+07, GEF = 1.177E+08, AS = 418500, HFMP = 2.1E+07, HOC = -5.507E+09, LiqDen = {105,0.65779,0.28461,677.16,0.31429,0}, VP = {101,96.028,-9355.7,-10.676,0.0000049509,2}, LiqCp = {16,139940,1169.1,1.2977,0.02859,-0.000023286}, HOV = {106,1.607707E+08,4.915197,-10.37671,9.303886,-3.220797}, VapCp = {16,110940,-562.53,13.019,0.00027207,-1.0669E-07}, LiqVis = {101,-9.4175,1452.8,-0.39341,2.9469E-07,2}, VapVis = {102,7.2635E-07,0.49106,324.48,3435.1,0}, LiqK = {16,0.023024,-350.01,0.1946,-0.0044419,6.7822E-07}, VapK = {102,0.000066062,1.0649,306.1,93850,0}, Racketparam = 0.249, UniquacR = 6.1278, UniquacQ = 4.672, ChaoSeadAF = 0.423, ChaoSeadSP = 17140, ChaoSeadLV = 0.15228);
  end OneTwoFourFivetetramethylbenzene;
  
  model Twoethylmxylene
  extends General_Properties(
    SN = 300, name = "Twoethylmxylene", CAS = "2870-04-4", Tc = 670, Pc = 2960000,  Vc = 0.446, Cc = 0.261, Tb = 463.19, Tm = 257, TT = 256.89, TP = 2.81505, MW = 134.218, LVB = 0.151424, AF = 0.405, SP = 18140, DM = 0, SH = -1209000000.0, IGHF = -2.623E+07, GEF = 1.379E+08, AS = 421000, HFMP = 1.471E+07, HOC = -5.548E+09, LiqDen = {105,0.55372,0.25979,670,0.29804,0}, VP = {101,101.54,-9425,-11.552,0.0000057989,2}, LiqCp = {16,77646,-101.26,11.392,0.0045401,-0.0000038677}, HOV = {106,8.2672E+07,1.1027,-0.68529,-0.33367,0.36103}, VapCp = {16,80902,-471.57,13.059,0.00022749,-9.0171E-08}, LiqVis = {101,-15.587,1737.4,0.54173,-0.0000007502,2}, VapVis = {102,0.0000044354,0.29008,895.67,100.88,0}, LiqK = {16,-0.038284,-32.06,-1.2755,-0.0012699,-0.0000004068}, VapK = {102,0.000097738,1.031,536.66,42862,0}, Racketparam = 0.261, UniquacR = 6.0672, UniquacQ = 4.644, ChaoSeadAF = 0.405, ChaoSeadSP = 18140, ChaoSeadLV = 0.151424);
  end Twoethylmxylene;
  
  model Twoethylpxylene
  extends General_Properties(
    SN = 301, name = "Twoethylpxylene", CAS = "1758-88-9", Tc = 680, Pc = 3380000,  Vc = 0.461, Cc = 0.252, Tb = 460.09, Tm = 219, TT = 219.52, TP = 0.0748611, MW = 134.218, LVB = 0.153715, AF = 0.36, SP = 17610, DM = 0, SH = -1209000000.0, IGHF = -3.218E+07, GEF = 1.273E+08, AS = 436600, HFMP = 1.519E+07, HOC = -5.543E+09, LiqDen = {105,0.15639,0.13957,680,0.19566,0}, VP = {101,51.35796,-7093.865,-3.98884,0.0000002143,2}, LiqCp = {16,115180,-69.179,10.574,0.0065199,-0.0000055164}, HOV = {106,8.269938E+07,2.580922,-6.4761,7.125795,-2.740318}, VapCp = {16,90693,-533.27,13.139,0.00014143,-6.0863E-08}, LiqVis = {101,-12.139,1509,0.050995,-2.3531E-08,2}, VapVis = {102,0.0000010483,0.4491,412.22,-1561.4,0}, LiqK = {16,-0.080449,4.7926,-1.4191,-0.00032019,-9.3368E-07}, VapK = {102,0.000085732,1.0445,516.18,46622,0}, Racketparam = 0.252, UniquacR = 6.0672, UniquacQ = 4.644, ChaoSeadAF = 0.36, ChaoSeadSP = 17610, ChaoSeadLV = 0.153715);
  end Twoethylpxylene;
  
  model Fourethylmxylene
  extends General_Properties(
    SN = 302, name = "Fourethylmxylene", CAS = "874-41-9", Tc = 665, Pc = 2850000,  Vc = 0.456, Cc = 0.251, Tb = 461.59, Tm = 210, TT = 210.27, TP = 0.0181496, MW = 134.218, LVB = 0.153864, AF = 0.409, SP = 17650, DM = 0, SH = -1209000000.0, IGHF = -3.08E+07, GEF = 1.286E+08, AS = 436600, HFMP = 1.293E+07, HOC = -5.544E+09, LiqDen = {105,0.53184,0.25635,665,0.29535,0}, VP = {101,109.6,-9849.7,-12.73,0.0000063582,2}, LiqCp = {16,95699,-84.431,11.066,0.0051032,-0.0000041785}, HOV = {106,6.586476E+07,0.958711,-1.952194,2.240006,-0.865941}, VapCp = {16,90693,-533.27,13.139,0.00014143,-6.0863E-08}, LiqVis = {101,-12.665,1419.5,0.18354,-0.0000003451,2}, VapVis = {102,0.0000037216,0.29591,752.65,-7.7443,0}, LiqK = {16,-0.081171,5.0587,-1.4195,-0.00031748,-9.1756E-07}, VapK = {102,0.000083547,1.0482,520.64,45100,0}, Racketparam = 0.251, UniquacR = 6.0672, UniquacQ = 4.644, ChaoSeadAF = 0.409, ChaoSeadSP = 17650, ChaoSeadLV = 0.153864);
  end Fourethylmxylene;
  
  model Fourethyloxylene
  extends General_Properties(
    SN = 303, name = "Fourethyloxylene", CAS = "934-80-5", Tc = 666, Pc = 2890000,  Vc = 0.452, Cc = 0.254, Tb = 462.93, Tm = 206, TT = 206.22, TP = 0.00343448, MW = 134.218, LVB = 0.154172, AF = 0.42, SP = 17990, DM = 0, SH = -1209000000.0, IGHF = -3.209E+07, GEF = 1.274E+08, AS = 436600, HFMP = 1.205E+07, HOC = -5.542E+09, LiqDen = {105,0.54664,0.26088,666,0.29186,0}, VP = {101,96.694,-9142.9,-10.852,0.0000055519,2}, LiqCp = {16,89767,-77.889,11.113,0.0049399,-0.0000039958}, HOV = {106,4.3714E+07,-2.7554,9.4578,-11.023,4.6307}, VapCp = {16,90693,-533.27,13.139,0.00014143,-6.0863E-08}, LiqVis = {101,-9.1159,1410.6,-0.43411,7.8135E-07,2}, VapVis = {102,5.8567E-07,0.52279,312.52,-1851,0}, LiqK = {16,-0.061613,4.0176,-1.4936,-0.00037218,-9.9721E-07}, VapK = {102,0.000083697,1.0475,520.73,45665,0}, Racketparam = 0.254, UniquacR = 6.0672, UniquacQ = 4.644, ChaoSeadAF = 0.42, ChaoSeadSP = 17990, ChaoSeadLV = 0.154172);
  end Fourethyloxylene;
  
  model OnemethylThreenpropylbenzene
  extends General_Properties(
    SN = 304, name = "OnemethylThreenpropylbenzene", CAS = "1074-43-7", Tc = 656, Pc = 2860000,  Vc = 0.482, Cc = 0.249, Tb = 455.13, Tm = 190.57, TT = 190.57, TP = 0.000721452, MW = 134.218, LVB = 0.156623, AF = 0.412785, SP = 17510, DM = 4.07E-31, SH = -1209000000.0, IGHF = -2.414E+07, GEF = 1.352E+08, AS = 436800, HFMP = 1.06E+07, HOC = -5.5516E+09, LiqDen = {105,0.18222,0.15152,656,0.20178,0}, VP = {101,107.4588,-9508.773,-12.48918,6.776919E-06,2}, LiqCp = {16,156110,-38.093,10.159,0.0050313,-0.0000015247}, HOV = {106,6.194565E+07,0.0524158,1.088831,-1.22236,0.439479}, VapCp = {16,97127,-599.11,13.273,0.000011665,-1.9003E-08}, LiqVis = {101,-17.301,1601.4,0.91018,-0.0000014707,2}, VapVis = {102,7.3681E-08,0.81524,130.94,-9552,0}, LiqK = {16,-0.074198,4.023,-1.4364,-0.00042252,-0.0000008562}, VapK = {102,0.000083513,1.0517,570.8,33790,0}, Racketparam = 0.249, UniquacR = 6.0066, UniquacQ = 4.616, ChaoSeadAF = 0.412785, ChaoSeadSP = 17510, ChaoSeadLV = 0.156623);
  end OnemethylThreenpropylbenzene;
  
  model OnemethylFournpropylbenzene
  extends General_Properties(
    SN = 305, name = "OnemethylFournpropylbenzene", CAS = "1074-55-1", Tc = 658, Pc = 2860000,  Vc = 0.482, Cc = 0.248, Tb = 456.53, Tm = 209.455, TT = 209.55, TP = 0.0171898, MW = 134.218, LVB = 0.157097, AF = 0.413441, SP = 17460, DM = 0, SH = -1209000000.0, IGHF = -2.314E+07, GEF = 1.382E+08, AS = 430400, HFMP = 1.151E+07, HOC = -5.5528E+09, LiqDen = {105,0.48219,0.24259,658,0.32531,0}, VP = {101,103.2332,-9321.423,-11.85346,6.228128E-06,2}, LiqCp = {16,128960,-102.23,11.269,0.0022913,5.0742E-07}, HOV = {106,5.9632E+07,-0.13089,1.5769,-1.8325,0.74608}, VapCp = {16,97127,-599.11,13.273,0.000011665,-1.9003E-08}, LiqVis = {101,-65.00531,3273.06,8.413079,-0.0000101347,2}, VapVis = {102,7.8653E-08,0.80621,137.95,-9253.2,0}, LiqK = {16,-0.081049,3.2759,-1.4026,-0.00043634,-7.9035E-07}, VapK = {102,0.000083347,1.0517,573.97,33136,0}, Racketparam = 0.248, UniquacR = 6.0066, UniquacQ = 4.616, ChaoSeadAF = 0.413441, ChaoSeadSP = 17460, ChaoSeadLV = 0.157097);
  end OnemethylFournpropylbenzene;
  
  model Pdiisopropylbenzene
  extends General_Properties(
    SN = 306, name = "Pdiisopropylbenzene", CAS = "100-18-5", Tc = 675, Pc = 2360000,  Vc = 0.584, Cc = 0.256, Tb = 483.52, Tm = 256.08, TT = 256.08, TP = 0.697953, MW = 162.271, LVB = 0.190236, AF = 0.476415, SP = 16930, DM = 0, SH = -1209000000.0, IGHF = -7.76E+07, GEF = 1.47804E+08, AS = 488000, HFMP = 0, HOC = -6.77E+09, LiqDen = {105,0.77801,0.34547,675,0.38736,0}, VP = {101,121.6259,-10711.76,-14.56272,8.944308E-06,2}, LiqCp = {16,-70570,94.476,11.349,0.0048258,-0.0000034771}, HOV = {106,9.572101E+07,2.166143,-4.616074,4.777254,-1.852374}, VapCp = {16,100830,-531.56,13.456,0.000043333,-2.4118E-08}, LiqVis = {101,-8.9912,1148.7,-0.35833,4.6037E-07,2}, VapVis = {102,8.0354E-07,0.48062,391.1,176.97,0}, LiqK = {16,-0.043466,-14.777,-1.4776,-0.00080068,-0.0000006904}, VapK = {102,0.31596,-0.074042,-318.59,1928600,0}, Racketparam = 0.256, UniquacR = 7.3538, UniquacQ = 5.688, ChaoSeadAF = 0.390023, ChaoSeadSP = 16930, ChaoSeadLV = 0.190236);
  end Pdiisopropylbenzene;
  
  model Methylisobutylketone
  extends General_Properties(
    SN = 307, name = "Methylisobutylketone", CAS = "108-10-1", Tc = 574.6, Pc = 3270000,  Vc = 0.3406, Cc = 0.256, Tb = 389.15, Tm = 189.15, TT = 189.15, TP = 0.0698742, MW = 100.161, LVB = 0.12581, AF = 0.352, SP = 17420, DM = 9.0E-30, SH = -1209000000.0, IGHF = -2.88E+08, GEF = -1.351E+08, AS = 407000, HFMP = 9710000, HOC = -3.49E+09, LiqDen = {105,0.70438,0.26215,574.6,0.2872,0}, VP = {101,151.9969,-9958.63,-19.68914,0.0000167819,2}, LiqCp = {16,93433,-8.9197,10.885,0.0029916,-6.6769E-07}, HOV = {106,2.7929E+07,-4.5647,14.372,-16.097,6.5387}, VapCp = {16,97540,-634.68,12.939,0.000018497,-1.9665E-08}, LiqVis = {101,-9.5441,1138.8,-0.34128,0.0000016581,2}, VapVis = {102,2.9033E-07,0.63516,190.41,3013.2,0}, LiqK = {16,0.05085,-96.32,-0.95078,-0.0031661,-0.0000020547}, VapK = {102,-874190,0.020464,1.7911E+07,-8.1274E+12,0}, Racketparam = 0.256, UniquacR = 4.5959, UniquacQ = 3.952, ChaoSeadAF = 0.352, ChaoSeadSP = 17420, ChaoSeadLV = 0.12581);
  end Methylisobutylketone;
  
  model Threeheptanone
  extends General_Properties(
    SN = 308, name = "Threeheptanone", CAS = "106-35-4", Tc = 605, Pc = 3010000,  Vc = 0.421, Cc = 0.251, Tb = 420.55, Tm = 234.15, TT = 234.15, TP = 2.29921, MW = 114.185, LVB = 0.140257, AF = 0.407565, SP = 17940, DM = 9.37E-30, SH = -1209000000.0, IGHF = -3.01E+08, GEF = -1.196E+08, AS = 448500, HFMP = 1.81E+07, HOC = -4.098E+09, LiqDen = {105,0.65544,0.26958,605,0.29059,0}, VP = {101,59.93996,-7156.968,-5.201278,1.288938E-07,2}, LiqCp = {16,215140,447.78,3.9106,0.020539,-0.000013511}, HOV = {106,6.726896E+07,0.830475,-1.256385,1.592723,-0.756362}, VapCp = {16,122140,-668.77,13.117,-0.0000064986,-3.4969E-08}, LiqVis = {101,-11.982,1284.2,0.095491,-8.1894E-07,2}, VapVis = {102,1.4757E-07,0.71999,184.44,-6805,0}, LiqK = {16,-0.025728,-61.893,-0.97852,-0.0021604,1.2683E-07}, VapK = {102,1201.8,1.0398,1.4113E+10,-9.6162E+10,0}, Racketparam = 0.251, UniquacR = 5.2711, UniquacQ = 4.496, ChaoSeadAF = 0.407565, ChaoSeadSP = 17940, ChaoSeadLV = 0.140257);
  end Threeheptanone;
  
  model Fourheptanone
  extends General_Properties(
    SN = 309, name = "Fourheptanone", CAS = "123-19-3", Tc = 595, Pc = 2920000,  Vc = 0.421, Cc = 0.253, Tb = 417.15, Tm = 240.65, TT = 240.65, TP = 7.95766, MW = 114.185, LVB = 0.140625, AF = 0.471409, SP = 17410, DM = 8.34E-30, SH = -1209000000.0, IGHF = -3.01E+08, GEF = -1.196E+08, AS = 448600, HFMP = 1.86E+07, HOC = -4.09E+09, LiqDen = {105,0.78297,0.29215,595,0.33209,0}, VP = {101,121.5579,-9310.284,-14.85267,0.000010781,2}, LiqCp = {16,209750,222.65,6.403,0.014092,-0.0000084677}, HOV = {106,6.630562E+07,0.51436,0.600897,-1.414428,0.688564}, VapCp = {16,121670,-659.01,13.093,0.000016432,-4.1637E-08}, LiqVis = {101,-29.013,1989.1,2.6786,-0.0000019943,2}, VapVis = {102,1.5516E-07,0.71327,190.48,-6907.5,0}, LiqK = {16,-0.084176,-5.3333,-1.1753,-0.00094427,-3.0728E-07}, VapK = {102,2007.9,1.0403,2.325E+10,-1.556E+11,0}, Racketparam = 0.253, UniquacR = 5.2711, UniquacQ = 4.496, ChaoSeadAF = 0.411976, ChaoSeadSP = 17410, ChaoSeadLV = 0.140625);
  end Fourheptanone;
  
  model Threehexanone
  extends General_Properties(
    SN = 310, name = "Threehexanone", CAS = "589-38-8", Tc = 582.8, Pc = 3320000,  Vc = 0.378, Cc = 0.256, Tb = 396.65, Tm = 215, TT = 217.5, TP = 2.22016, MW = 100.161, LVB = 0.12343, AF = 0.38, SP = 17930, DM = 9.57E-30, SH = -1209000000.0, IGHF = -2.777E+08, GEF = -1.253E+08, AS = 409200, HFMP = 1.11E+07, HOC = -3.492E+09, LiqDen = {105,0.60844,0.24303,582.83,0.26177,0}, VP = {101,109.4591,-8520.55,-13.01531,9.019631E-06,2}, LiqCp = {16,185400,578.77,3.0261,0.02276,-0.000015777}, HOV = {106,5.134266E+07,-0.294625,1.94188,-1.96318,0.653572}, VapCp = {16,108160,-675.23,12.973,-0.000036372,-1.5789E-08}, LiqVis = {101,-3.119,957.18,-1.3764,0.0000033013,2}, VapVis = {102,1.7969E-07,0.70065,200.48,-7668.6,0}, LiqK = {16,0.0083801,80.808,-2.2377,0.00083175,-0.0000033028}, VapK = {102,-0.24291,0.11759,-2306.6,-3681900,0}, Racketparam = 0.256, UniquacR = 4.5967, UniquacQ = 3.956, ChaoSeadAF = 0.38, ChaoSeadSP = 17930, ChaoSeadLV = 0.12343);
  end Threehexanone;
  
  model Twopentanone
  extends General_Properties(
    SN = 311, name = "Twopentanone", CAS = "107-87-9", Tc = 561.1, Pc = 3690000,  Vc = 0.301, Cc = 0.238, Tb = 375.39, Tm = 196.29, TT = 196.29, TP = 0.752347, MW = 86.134, LVB = 0.10733, AF = 0.346, SP = 18290, DM = 9.07E-30, SH = -1209000000.0, IGHF = -2.592E+08, GEF = -1.384E+08, AS = 378600, HFMP = 1.062E+07, HOC = -2.88E+09, LiqDen = {105,0.8193,0.25958,561.1,0.28941,0}, VP = {101,92.01772,-7341.876,-10.45756,7.61086E-06,2}, LiqCp = {16,119520,155.09,9.2758,0.0038398,0.0000015236}, HOV = {106,6.074187E+07,1.097819,-1.350154,0.926065,-0.25017}, VapCp = {16,86927,-727.52,12.986,-0.00023161,6.926E-08}, LiqVis = {101,-8.4812,921.84,-0.40943,6.8984E-07,2}, VapVis = {102,2.4641E-07,0.66525,208.96,-62.76,0}, LiqK = {16,0.010889,-36.658,-1.2206,-0.0022413,-2.5211E-07}, VapK = {102,-0.017912,0.4825,-3887.7,-1296300,0}, Racketparam = 0.238, UniquacR = 3.9223, UniquacQ = 3.416, ChaoSeadAF = 0.346, ChaoSeadSP = 18290, ChaoSeadLV = 0.10733);
  end Twopentanone;
  
  model Twohexanone
  extends General_Properties(
    SN = 312, name = "Twohexanone", CAS = "591-78-6", Tc = 587, Pc = 3320000,  Vc = 0.378, Cc = 0.254, Tb = 400.7, Tm = 217.35, TT = 217.35, TP = 1.44559, MW = 100.161, LVB = 0.1241, AF = 0.393, SP = 17600, DM = 8.94E-30, SH = -1209000000.0, IGHF = -2.79826E+08, GEF = -1.30081E+08, AS = 417856, HFMP = 1.49E+07, HOC = -3.49E+09, LiqDen = {105,0.58528,0.23872,587.62,0.26191,0}, VP = {101,81.22606,-7467.987,-8.650385,4.736711E-06,2}, LiqCp = {16,171430,304.46,6.7554,0.010928,-0.0000044198}, HOV = {106,8.140665E+07,1.724728,-1.991428,0.65901,0.10235}, VapCp = {16,101950,-647,12.874,0.00017699,-1.3836E-07}, LiqVis = {101,-9.5407,1129.1,-0.30673,6.1273E-07,2}, VapVis = {102,1.7562E-07,0.7037,196.23,-7085.8,0}, LiqK = {16,-0.0056603,-27.398,-1.2811,-0.0017572,-3.9285E-07}, VapK = {102,-0.96934,0.03859,-1883.3,-1.1142E+07,0}, Racketparam = 0.254, UniquacR = 4.5967, UniquacQ = 3.956, ChaoSeadAF = 0.393, ChaoSeadSP = 17600, ChaoSeadLV = 0.1241);
  end Twohexanone;
  
  model Twoheptanone
  extends General_Properties(
    SN = 313, name = "Twoheptanone", CAS = "110-43-0", Tc = 611.55, Pc = 2920000,  Vc = 0.421, Cc = 0.251, Tb = 424.05, Tm = 238.15, TT = 238.15, TP = 3.54477, MW = 114.185, LVB = 0.140675, AF = 0.418982, SP = 17400, DM = 8.71E-30, SH = -1209000000.0, IGHF = -3.00453E+08, GEF = -1.21796E+08, AS = 456893, HFMP = 1.84E+07, HOC = -4.09952E+09, LiqDen = {105,0.42296,0.21673,611.55,0.2517,0}, VP = {101,104.1321,-8934.299,-12.02629,6.758209E-06,2}, LiqCp = {16,168580,759.37,3.3604,0.023088,-0.000017848}, HOV = {106,6.522658E+07,0.472207,0.238382,-0.54369,0.222217}, VapCp = {16,119760,-702.71,13.229,-0.000074262,-4.5595E-08}, LiqVis = {101,-9.5709,1186.6,-0.30187,0.0000013185,2}, VapVis = {102,1.5766E-07,0.71212,201.61,-8396.4,0}, LiqK = {16,0.061916,-162.99,-0.59984,-0.0044095,-0.0000013415}, VapK = {102,2047.3,1.0324,2.297E+10,7.8096E+08,0}, Racketparam = 0.251, UniquacR = 5.2711, UniquacQ = 4.496, ChaoSeadAF = 0.418982, ChaoSeadSP = 17400, ChaoSeadLV = 0.140675);
  end Twoheptanone;
  
  model FivemethylTwohexanone
  extends General_Properties(
    SN = 314, name = "FivemethylTwohexanone", CAS = "110-12-3", Tc = 601, Pc = 2970000,  Vc = 0.421, Cc = 0.25, Tb = 417.95, Tm = 199.25, TT = 199.25, TP = 0.0241997, MW = 114.185, LVB = 0.141298, AF = 0.434398, SP = 17740, DM = 0, SH = -1209000000.0, IGHF = -3.04E+08, GEF = -1.22E+08, AS = 446000, HFMP = 0, HOC = -4.1E+09, LiqDen = {105,0.59436,0.2568,601,0.28571,0}, VP = {101,114.12,-9180,-13.613,0.0000087656,2}, LiqCp = {16,125240,163.14,9.1111,0.0074883,-0.0000035144}, HOV = {106,8.005371E+07,1.17745,-0.708374,-0.221424,0.184955}, VapCp = {16,96832,-530.6,12.878,0.00028483,-1.1552E-07}, LiqVis = {101,-15.292,1388.7,0.61336,-0.0000015372,2}, VapVis = {102,3.5504E-07,0.6089,292.03,-90.104,0}, LiqK = {16,-0.18233,17.124,-1.0595,-0.000040298,-9.9547E-07}, VapK = {102,1467.4,1.0438,1.713E+10,-1.5385E+11,0}, Racketparam = 0.25, UniquacR = 5.2703, UniquacQ = 4.492, ChaoSeadAF = 0.434398, ChaoSeadSP = 17740, ChaoSeadLV = 0.141298);
  end FivemethylTwohexanone;
  
  model ThreeThreedimethylTwobutanone
  extends General_Properties(
    SN = 315, name = "ThreeThreedimethylTwobutanone", CAS = "75-97-8", Tc = 567, Pc = 3470000,  Vc = 0.368, Cc = 0.261, Tb = 379.45, Tm = 221.15, TT = 221.15, TP = 14.4334, MW = 100.159, LVB = 0.124869, AF = 0.327309, SP = 16920, DM = 9.37E-30, SH = -1209000000.0, IGHF = -2.905E+08, GEF = -1.307E+08, AS = 384400, HFMP = 1.133E+07, HOC = -3.4837E+09, LiqDen = {105,0.050005,0.070782,567,0.11676,0}, VP = {101,93.48771,-7385.263,-10.71444,7.878115E-06,2}, LiqCp = {16,154180,195.77,7.7152,0.0092036,-0.0000029177}, HOV = {106,5.0163E+07,0.36416,-0.10654,0.27936,-0.16414}, VapCp = {16,104260,-866.95,13.572,-0.00063607,2.0716E-07}, LiqVis = {101,-19.254,1373.2,1.3346,-0.0000032641,2}, VapVis = {102,1.8869E-07,0.70026,190.78,-6542.3,0}, LiqK = {16,-0.15399,9.8963,-1.0886,-0.00030883,-9.2007E-07}, VapK = {102,1744.4,1.0305,1.6872E+10,-1.3896E+11,0}, Racketparam = 0.261, UniquacR = 4.5952, UniquacQ = 4.032, ChaoSeadAF = 0.327309, ChaoSeadSP = 16920, ChaoSeadLV = 0.124869);
  end ThreeThreedimethylTwobutanone;
  
  model Diisobutylketone
  extends General_Properties(
    SN = 316, name = "Diisobutylketone", CAS = "108-83-8", Tc = 620, Pc = 2530000,  Vc = 0.522, Cc = 0.253, Tb = 441.4, Tm = 227, TT = 227.17, TP = 0.249815, MW = 142.239, LVB = 0.177418, AF = 0.511608, SP = 16450, DM = 8.87E-30, SH = -1209000000.0, IGHF = -3.576E+08, GEF = -1.13E+08, AS = 509000, HFMP = 0, HOC = -5.31E+09, LiqDen = {105,0.3783,0.23231,620,0.24664,0}, VP = {101,122.1783,-10064.3,-14.70184,8.652147E-06,2}, LiqCp = {16,85834,-102.6,11.702,0.0033978,-0.0000021321}, HOV = {106,4.9161E+07,-1.6509,5.8937,-6.6307,2.7354}, VapCp = {16,118320,-505.35,13.11,0.00028036,-1.0389E-07}, LiqVis = {101,-74.692,4018.6,9.6018,-0.0000061216,2}, VapVis = {102,1.3916E-07,0.72063,190.96,-7816.5,0}, LiqK = {16,-0.12088,22.25,-1.2974,0.0000088903,-0.0000012079}, VapK = {102,-380230,0.02484,1.3363E+08,-3.9523E+12,0}, Racketparam = 0.253, UniquacR = 6.6183, UniquacQ = 5.568, ChaoSeadAF = 0.511608, ChaoSeadSP = 16450, ChaoSeadLV = 0.177418);
  end Diisobutylketone;
  
  model Diisopropylketone
  extends General_Properties(
    SN = 317, name = "Diisopropylketone", CAS = "565-80-0", Tc = 582, Pc = 3380000,  Vc = 0.416, Cc = 0.262, Tb = 397.5, Tm = 204, TT = 204.81, TP = 0.820585, MW = 114.185, LVB = 0.142561, AF = 0.404427, SP = 16330, DM = 9.11E-30, SH = -1209000000.0, IGHF = -3.16E+08, GEF = -1.237E+08, AS = 427000, HFMP = 1.118E+07, HOC = -4.095E+09, LiqDen = {105,0.013793,0.039842,582,0.095675,0}, VP = {101,107.12,-8385.7,-12.681,0.0000089823,2}, LiqCp = {16,180230,-51.129,8.6687,0.010407,-0.0000076786}, HOV = {106,8.205456E+07,3.802881,-9.83224,10.38407,-3.829124}, VapCp = {16,60064,-502.12,13.055,0.00012498,-3.7343E-08}, LiqVis = {101,-5.6405,1129.7,-1.0122,0.0000027665,2}, VapVis = {102,1.7015E-07,0.70572,193.2,-7481.9,0}, LiqK = {16,-0.11955,20.681,-1.3034,0.0000051067,-0.0000013764}, VapK = {102,-9.5076,-0.0072136,2380.8,-7.251E+07,0}, Racketparam = 0.262, UniquacR = 5.0493, UniquacQ = 4.568, ChaoSeadAF = 0.404427, ChaoSeadSP = 16330, ChaoSeadLV = 0.142561);
  end Diisopropylketone;
  
  model Propanal
  extends General_Properties(
    SN = 318, name = "Propanal", CAS = "123-38-6", Tc = 493.15, Pc = 4650000,  Vc = 0.223, Cc = 0.239, Tb = 321.15, Tm = 193.15, TT = 170, TP = 1.31328, MW = 58.0791, LVB = 0.0734076, AF = 0.330077, SP = 19320, DM = 8.41E-30, SH = -1209000000.0, IGHF = -1.874E+08, GEF = -1.244E+08, AS = 304700, HFMP = 8580000, HOC = -1.6857E+09, LiqDen = {105,0.81482,0.2126,493.15,0.21277,0}, VP = {101,110.8631,-6856.828,-13.8218,0.0000173391,2}, LiqCp = {16,116710,75.622,5.752,0.010877,0.0000042986}, HOV = {106,6.196909E+07,1.837694,-1.953499,-0.000443949,0.620394}, VapCp = {16,-181030,9.3832,12.233,0.00079415,-2.4738E-07}, LiqVis = {101,-10.033,843.41,-0.14954,3.8846E-08,2}, VapVis = {102,1.9173E-07,0.71905,111.91,4618.1,0}, LiqK = {16,0.020248,-83.587,-0.55331,-0.0042681,0.0000015626}, VapK = {102,776.87,0.94095,4.8356E+09,-1.3358E+11,0}, Racketparam = 0.239, UniquacR = 2.5735, UniquacQ = 2.336, ChaoSeadAF = 0.255909, ChaoSeadSP = 19320, ChaoSeadLV = 0.0734076);
  end Propanal;
  
  model Butanal
  extends General_Properties(
    SN = 319, name = "Butanal", CAS = "123-72-8", Tc = 521.15, Pc = 4000000,  Vc = 0.263, Cc = 0.25, Tb = 347.95, Tm = 176.75, TT = 176.75, TP = 0.316993, MW = 72.1057, LVB = 0.0904328, AF = 0.277417, SP = 18660, DM = 9.07E-30, SH = -1209000000.0, IGHF = -2.07E+08, GEF = -1.1539E+08, AS = 344900, HFMP = 1.109E+07, HOC = -2.3035E+09, LiqDen = {105,1.0715,0.2723,521.3,0.27225,0}, VP = {101,99.51827,-7112.269,-11.7407,9.521179E-06,2}, LiqCp = {16,146790,-6569.4,41.653,-0.01116,-0.000075065}, HOV = {106,4.118197E+07,-1.36073,5.949252,-7.213209,2.926745}, VapCp = {16,84791,-954.83,13.167,-0.00050103,1.5222E-07}, LiqVis = {101,-14.207,1014.9,0.55992,-0.0000018129,2}, VapVis = {102,9.4037E-07,0.50713,464.89,-11049,0}, LiqK = {16,0.054171,0.30189,-1.9042,-0.00054405,-0.0000037387}, VapK = {102,784.27,0.98392,6.406E+09,-1.3461E+11,0}, Racketparam = 0.25, UniquacR = 3.2479, UniquacQ = 2.876, ChaoSeadAF = 0.277417, ChaoSeadSP = 18660, ChaoSeadLV = 0.0904328);
  end Butanal;
  
  model Pentanal
  extends General_Properties(
    SN = 320, name = "Pentanal", CAS = "110-62-3", Tc = 554, Pc = 3500000,  Vc = 0.316, Cc = 0.264, Tb = 376.15, Tm = 190.15, TT = 182, TP = 0.0522823, MW = 86.1323, LVB = 0.107035, AF = 0.390803, SP = 18440, DM = 8.57E-30, SH = -1209000000.0, IGHF = -2.2669E+08, GEF = -1.0711E+08, AS = 382890, HFMP = 1.5E+07, HOC = -2.91E+09, LiqDen = {105,0.76227,0.25072,566.11,0.27912,0}, VP = {101,92.63614,-7428.499,-10.51804,7.160109E-06,2}, LiqCp = {16,156770,199.89,4.2571,0.024547,-0.000022679}, HOV = {106,6.99504E+07,0.991037,0.252443,-1.761713,0.936026}, VapCp = {16,101560,-929.74,13.391,-0.0005525,1.6606E-07}, LiqVis = {101,-10.884,982.07,-0.00046989,2.2767E-08,2}, VapVis = {102,2.2718E-07,0.67661,192.16,-86.47,0}, LiqK = {16,0.010965,-0.28239,-1.5585,-0.0012856,-0.0000013221}, VapK = {102,-3901000,-0.05461,1.6551E+09,-2.4357E+13,0}, Racketparam = 0.264, UniquacR = 3.9223, UniquacQ = 3.416, ChaoSeadAF = 0.347159, ChaoSeadSP = 18440, ChaoSeadLV = 0.107035);
  end Pentanal;
  
  model Hexanal
  extends General_Properties(
    SN = 321, name = "Hexanal", CAS = "66-25-1", Tc = 579, Pc = 3110000,  Vc = 0.369, Cc = 0.26, Tb = 401.45, Tm = 217.15, TT = 217.15, TP = 1.24729, MW = 100.159, LVB = 0.123708, AF = 0.439121, SP = 18150, DM = 8.6E-30, SH = -1209000000.0, IGHF = -2.4732E+08, GEF = -9.882E+07, AS = 422140, HFMP = 1.89E+07, HOC = -3.52E+09, LiqDen = {105,1.3196,0.35571,579,0.38551,0}, VP = {101,209.3738,-12430.59,-28.59364,0.0000281667,2}, LiqCp = {16,175480,98.975,6.7267,0.013876,-0.0000081365}, HOV = {106,5.570251E+07,-0.000821879,0.788181,-0.0470431,-0.460389}, VapCp = {16,115820,-867.39,13.422,-0.00036658,7.4569E-08}, LiqVis = {101,-11.85,1055.4,0.17945,-3.4838E-07,2}, VapVis = {102,1.6626E-07,0.71206,185.2,-6483.1,0}, LiqK = {16,0.0039289,-19.957,-1.3588,-0.0017925,-6.0508E-07}, VapK = {102,-5919900,-0.017833,2.2842E+09,-4.7916E+13,0}, Racketparam = 0.26, UniquacR = 4.5967, UniquacQ = 3.956, ChaoSeadAF = 0.387184, ChaoSeadSP = 18150, ChaoSeadLV = 0.123708);
  end Hexanal;
  
  model Heptanal
  extends General_Properties(
    SN = 322, name = "Heptanal", CAS = "111-71-7", Tc = 603, Pc = 2800000,  Vc = 0.421, Cc = 0.267, Tb = 425.95, Tm = 230.15, TT = 229.8, TP = 1.44979, MW = 114.185, LVB = 0.140287, AF = 0.488466, SP = 17780, DM = 8.6E-30, SH = -1209000000.0, IGHF = -2.6401E+08, GEF = -8.653E+07, AS = 461380, HFMP = 2.359E+07, HOC = -4.136E+09, LiqDen = {105,0.53646,0.24452,616.81,0.26981,0}, VP = {101,108.36,-9179.6,-12.655,0.0000073363,2}, LiqCp = {16,200220,128.23,7.474,0.012008,-0.0000080423}, HOV = {106,6.244116E+07,0.224744,0.949788,-1.500319,0.675167}, VapCp = {16,131660,-858.87,13.596,-0.00041213,8.8955E-08}, LiqVis = {101,8.4077,475.87,-3.0758,0.0000053404,2}, VapVis = {102,1.4563E-07,0.72362,184.89,-7288.6,0}, LiqK = {16,0.02754,-55.074,-1.243,-0.0022084,-0.0000010637}, VapK = {102,1569.2,1.0102,1.4874E+10,2.7536E+11,0}, Racketparam = 0.267, UniquacR = 5.2711, UniquacQ = 4.496, ChaoSeadAF = 0.42794, ChaoSeadSP = 17780, ChaoSeadLV = 0.140287);
  end Heptanal;
  
  model Diisopropylether
  extends General_Properties(
    SN = 323, name = "Diisopropylether", CAS = "108-20-3", Tc = 500.05, Pc = 2880000,  Vc = 0.386, Cc = 0.267, Tb = 341.45, Tm = 187.65, TT = 187.65, TP = 6.8582, MW = 102.175, LVB = 0.141775, AF = 0.338683, SP = 14450, DM = 3.77E-30, SH = -1209000000.0, IGHF = -3.18988E+08, GEF = -1.248E+08, AS = 382000, HFMP = 1.103E+07, HOC = -3.70234E+09, LiqDen = {105,0.72527,0.27594,500.05,0.29413,0}, VP = {101,109.5333,-7120.297,-13.51365,0.0000143778,2}, LiqCp = {16,161880,-2.8879,7.7638,0.014551,-0.000013251}, HOV = {106,5.8041E+07,2.3385,-5.2086,5.0367,-1.6926}, VapCp = {16,69454,-410.18,12.642,0.00044085,-1.3595E-07}, LiqVis = {101,-9.064,932.47,-0.38815,0.0000010323,2}, VapVis = {102,4.0782E-07,0.58517,121.4,19303,0}, LiqK = {16,0.067752,-462.02,2.3997,-0.014453,0.0000029856}, VapK = {102,0.00010149,1.0246,180.97,93179,0}, Racketparam = 0.267, UniquacR = 4.7421, UniquacQ = 4.088, ChaoSeadAF = 0.338683, ChaoSeadSP = 14450, ChaoSeadLV = 0.141775);
  end Diisopropylether;
  
  model Dinbutylether
  extends General_Properties(
    SN = 324, name = "Dinbutylether", CAS = "142-96-1", Tc = 580.15, Pc = 2380000,  Vc = 0.511, Cc = 0.247, Tb = 415.35, Tm = 177.95, TT = 175.3, TP = 0.000714135, MW = 130.228, LVB = 0.17041, AF = 0.447646, SP = 15830, DM = 3.9E-30, SH = -1209000000.0, IGHF = -3.339E+08, GEF = -8.827E+07, AS = 481200, HFMP = 1.63E+07, HOC = -4.94716E+09, LiqDen = {105,0.22926,0.17412,584.11,0.21764,0}, VP = {101,95.7043,-8294.241,-10.81822,6.127187E-06,2}, LiqCp = {16,198760,65.432,9.8123,0.0039694,8.4178E-07}, HOV = {106,6.4859E+07,0.77992,-0.72383,0.38094,-0.025388}, VapCp = {16,152990,-805.71,13.605,-0.00024656,5.3497E-08}, LiqVis = {101,20.743,-83.003,-4.9404,0.000004096,2}, VapVis = {102,0.0000002113,0.66224,141.56,6932,0}, LiqK = {16,-0.067128,2.4703,-1.3291,-0.0010011,-2.5742E-07}, VapK = {102,0.0036064,0.57918,1401.9,287150,0}, Racketparam = 0.247, UniquacR = 6.0925, UniquacQ = 5.176, ChaoSeadAF = 0.447646, ChaoSeadSP = 15830, ChaoSeadLV = 0.17041);
  end Dinbutylether;
  
  model Disecbutylether
  extends General_Properties(
    SN = 325, name = "Disecbutylether", CAS = "6863-58-7", Tc = 562, Pc = 2556000,  Vc = 0.487, Cc = 0.269, Tb = 394.2, Tm = 173.15, TT = 173.15, TP = 0.0027863, MW = 130.228, LVB = 0.171577, AF = 0.329, SP = 14950, DM = 0, SH = -1209000000.0, IGHF = -3.609E+08, GEF = -1.157E+08, AS = 501000, HFMP = 0, HOC = -4.9233E+09, LiqDen = {105,0.038135,0.072155,562,0.11862,0}, VP = {101,102.5292,-8146.755,-11.97808,8.058954E-06,2}, LiqCp = {16,102180,-37.551,10.606,0.0064949,-0.0000048029}, HOV = {106,5.5999E+07,0.34375,0.18962,-0.14755,-0.0040987}, VapCp = {16,94528,-497.39,13.241,0.000057744,-1.2606E-09}, LiqVis = {101,-10.318,1230.4,-0.20919,4.9411E-07,2}, VapVis = {102,1.1864E-07,0.74861,137.78,-4500.8,0}, LiqK = {16,0.027499,27.604,-2.2754,0.00032105,-0.0000044406}, VapK = {102,0.00016749,0.96101,656.84,-691.7,0}, Racketparam = 0.269, UniquacR = 6.0909, UniquacQ = 5.168, ChaoSeadAF = 0.329, ChaoSeadSP = 14950, ChaoSeadLV = 0.171577);
  end Disecbutylether;
  
  model Methylethylether
  extends General_Properties(
    SN = 326, name = "Methylethylether", CAS = "540-67-0", Tc = 437.8, Pc = 4400000,  Vc = 0.221, Cc = 0.267, Tb = 280.5, Tm = 160, TT = 160, TP = 7.85121, MW = 60.096, LVB = 0.08585, AF = 0.236, SP = 15370, DM = 4.1E-30, SH = -216400000.0, IGHF = -2.164E+08, GEF = -1.177E+08, AS = 308810, HFMP = 7980000, HOC = -1.9314E+09, LiqDen = {105,1.1195,0.26367,437.86,0.25231,0}, VP = {101,63.84,-4659.2,-6.4137,0.0000057727,2}, LiqCp = {16,109050,-31.645,7.7783,0.0084684,0.0000041202}, HOV = {106,1.3679E+08,9.4948,-25.655,28.424,-11.603}, VapCp = {16,60571,-557.18,12.079,0.00048084,-1.7581E-07}, LiqVis = {101,-11.138,628.05,0.042345,-2.0281E-08,2}, VapVis = {102,2.9661E-07,0.6716,174.02,-2778.1,0}, LiqK = {16,0.029003,34.124,-1.9356,0.0010295,-0.0000079939}, VapK = {102,0.00021058,0.94472,515.36,8108.3,0}, Racketparam = 0.267, UniquacR = 2.7205, UniquacQ = 2.476, ChaoSeadAF = 0.236, ChaoSeadSP = 15370, ChaoSeadLV = 0.08585);
  end Methylethylether;
  
  model Methylnpropylether
  extends General_Properties(
    SN = 327, name = "Methylnpropylether", CAS = "557-17-5", Tc = 472, Pc = 3801000,  Vc = 0.274, Cc = 0.265, Tb = 312.29, Tm = 123.15, TT = 133.97, TP = 0.00289599, MW = 74.1216, LVB = 0.1032, AF = 0.276999, SP = 15730, DM = 4.14E-30, SH = -216400000.0, IGHF = -2.379E+08, GEF = -1.108E+08, AS = 352000, HFMP = 7670000, HOC = -2.517E+09, LiqDen = {105,1.1427,0.28927,472,0.3185,0}, VP = {101,59.81269,-4968.626,-5.703041,3.962175E-06,2}, LiqCp = {16,136920,43.97,5.0864,0.024992,-0.000027384}, HOV = {106,4.425282E+07,0.586164,-0.378014,0.582618,-0.440041}, VapCp = {16,93668,-926.82,13.189,-0.0004818,0.000000144}, LiqVis = {101,-11.301,802.09,0.054938,-4.1844E-07,2}, VapVis = {102,1.0896E-07,0.78578,98.829,-6562.3,0}, LiqK = {16,-0.0079788,3.9001,-1.4224,-0.0010693,-0.0000025315}, VapK = {102,0.010718,0.485,2083.9,283110,0}, Racketparam = 0.265, UniquacR = 3.3949, UniquacQ = 3.016, ChaoSeadAF = 0.276999, ChaoSeadSP = 15730, ChaoSeadLV = 0.1032);
  end Methylnpropylether;
  
  model Isopropylbutylether
  extends General_Properties(
    SN = 328, name = "Isopropylbutylether", CAS = "1860-27-1", Tc = 549, Pc = 2740000,  Vc = 0.435, Cc = 0.261, Tb = 378.15, Tm = 180, TT = 180, TP = 0.0337504, MW = 116.201, LVB = 0.155791, AF = 0.403229, SP = 15260, DM = 4.24E-30, SH = -216400000.0, IGHF = -3.269E+08, GEF = -1.071E+08, AS = 450200, HFMP = 1.22E+07, HOC = -4.324E+09, LiqDen = {105,0.62258,0.27082,549,0.30735,0}, VP = {101,85.99635,-7315.405,-9.426402,5.236755E-06,2}, LiqCp = {16,200760,-0.77126,8.116,0.0093067,-0.00000176}, HOV = {106,5.2177E+07,0.38027,0,0,0}, VapCp = {16,76973,-443.41,12.925,0.00032949,-1.1644E-07}, LiqVis = {101,-11.496,1171.6,0.0066892,-1.6659E-08,2}, VapVis = {102,0.000000176,0.70157,181.76,-5946.4,0}, LiqK = {16,-0.10095,17.355,-1.4146,-0.000082157,-0.0000014735}, VapK = {102,0.00016013,0.96562,574.46,18419,0}, Racketparam = 0.261, UniquacR = 5.4173, UniquacQ = 4.632, ChaoSeadAF = 0.403229, ChaoSeadSP = 15260, ChaoSeadLV = 0.155791);
  end Isopropylbutylether;
  
  model Methylisobutylether
  extends General_Properties(
    SN = 329, name = "Methylisobutylether", CAS = "625-44-5", Tc = 497, Pc = 3410000,  Vc = 0.329, Cc = 0.272, Tb = 331.7, Tm = 0, TT = 0, TP = 0, MW = 88.1482, LVB = 0.121242, AF = 0.307786, SP = 15100, DM = 4.7E-30, SH = -216400000.0, IGHF = -2.66E+08, GEF = -1.07E+08, AS = 381000, HFMP = 0, HOC = -3.122E+09, LiqDen = {105,0.83514,0.27544,497,0.27525,0}, VP = {101,67.83965,-5584.772,-6.90156,5.177794E-06,2}, LiqCp = {16,156890,481.87,3.1798,0.023292,-0.000015219}, HOV = {106,4.281E+07,0.34436,0.050812,-0.029168,0.014527}, VapCp = {16,84480,-573.48,12.645,0.00036001,-1.6026E-07}, LiqVis = {101,-6.5049,776.05,-0.79051,0.0000029469,2}, VapVis = {102,2.7344E-07,0.65828,203.42,-5560.1,0}, LiqK = {16,-0.1664,6.1773,-1.0308,-0.0004394,-9.9213E-07}, VapK = {102,0.00016088,0.97231,471.48,30281,0}, Racketparam = 0.272, UniquacR = 4.0685, UniquacQ = 3.552, ChaoSeadAF = 0.307786, ChaoSeadSP = 15100, ChaoSeadLV = 0.121242);
  end Methylisobutylether;
  
  model Methylisopropylether
  extends General_Properties(
    SN = 330, name = "Methylisopropylether", CAS = "598-53-8", Tc = 464.48, Pc = 3762000,  Vc = 0.276, Cc = 0.269, Tb = 303.92, Tm = 127.93, TT = 127.93, TP = 0.00332352, MW = 74.1216, LVB = 0.1046, AF = 0.26555, SP = 15160, DM = 4.16E-30, SH = -216400000.0, IGHF = -2.52E+08, GEF = -1.209E+08, AS = 338300, HFMP = 5850000, HOC = -2.5311E+09, LiqDen = {105,0.82094,0.24798,464.48,0.26184,0}, VP = {101,61.57822,-4874.158,-6.034163,5.097159E-06,2}, LiqCp = {16,123760,190.2,5.9878,0.016259,-0.000010176}, HOV = {106,4.2811E+07,1.2196,-2.6572,3.1706,-1.3477}, VapCp = {16,84263,-798.1,12.945,-0.00018216,3.6316E-08}, LiqVis = {101,-10.884,730.8,-0.038881,2.6764E-07,2}, VapVis = {102,1.9275E-07,0.70897,109.56,-107.54,0}, LiqK = {16,-0.21567,5.2547,-0.85956,-0.00045627,-9.7493E-07}, VapK = {102,1.3675,-0.14071,1446.2,3030500,0}, Racketparam = 0.269, UniquacR = 3.3941, UniquacQ = 3.012, ChaoSeadAF = 0.26555, ChaoSeadSP = 15160, ChaoSeadLV = 0.1046);
  end Methylisopropylether;
  
  model Tertbutylethylether
  extends General_Properties(
    SN = 331, name = "Tertbutylethylether", CAS = "637-92-3", Tc = 512, Pc = 3149000,  Vc = 0.382, Cc = 0.272, Tb = 345.65, Tm = 176.15, TT = 179.15, TP = 0.880264, MW = 102.175, LVB = 0.138991, AF = 0.295672, SP = 14800, DM = 4.07E-30, SH = -216400000.0, IGHF = -3.165E+08, GEF = -1.217E+08, AS = 397500, HFMP = 9530000, HOC = -3.684E+09, LiqDen = {105,0.74373,0.27619,512,0.30602,0}, VP = {101,59.92213,-5564.171,-5.601322,3.389291E-06,2}, LiqCp = {16,135520,9.8807,8.6914,0.01077,-0.0000076034}, HOV = {106,4.5825E+07,0.349787,0.137025,-0.301886,0.219717}, VapCp = {16,78915,-487.03,12.843,0.00025385,-8.879E-08}, LiqVis = {101,-12.011,1089.8,0.081011,-2.1688E-07,2}, VapVis = {102,1.9715E-07,0.697,171.3,-4885.5,0}, LiqK = {16,-0.1316,11.716,-1.2478,-0.00024672,-0.0000012519}, VapK = {102,0.000058788,1.0907,235.7,33150,0}, Racketparam = 0.272, UniquacR = 4.7422, UniquacQ = 4.172, ChaoSeadAF = 0.295672, ChaoSeadSP = 14800, ChaoSeadLV = 0.138991);
  end Tertbutylethylether;
  
  model Ethyltertpentylether
  extends General_Properties(
    SN = 332, name = "Ethyltertpentylether", CAS = "919-94-8", Tc = 544, Pc = 2740000,  Vc = 0.435, Cc = 0.273, Tb = 374.15, Tm = 190, TT = 190, TP = 0.729523, MW = 116.201, LVB = 0.152635, AF = 0.338192, SP = 14970, DM = 5.14E-30, SH = -216400000.0, IGHF = -3.324E+08, GEF = -1.094E+08, AS = 439200, HFMP = 1.2E+07, HOC = -4.32E+09, LiqDen = {105,0.65888,0.27797,544,0.29227,0}, VP = {101,47.12433,-5006.625,-3.892102,0.0000058438,2}, LiqCp = {16,-79604,-398.25,15.392,-0.0067505,0.0000071337}, HOV = {106,6.448049E+07,2.475757,-5.830862,5.958177,-2.135539}, VapCp = {16,119820,-647.93,13.251,-0.00004893,2.8951E-09}, LiqVis = {101,-11.435,1134.3,-0.0102,2.552E-08,2}, VapVis = {102,1.2029E-07,0.7552,122.76,-2833.2,0}, LiqK = {16,-0.13805,13.252,-1.2618,-0.00018101,-0.0000010967}, VapK = {102,0.00013295,0.98504,431.52,34060,0}, Racketparam = 0.273, UniquacR = 5.4166, UniquacQ = 4.712, ChaoSeadAF = 0.338192, ChaoSeadSP = 14970, ChaoSeadLV = 0.152635);
  end Ethyltertpentylether;
  
  model Butylvinylether
  extends General_Properties(
    SN = 333, name = "Butylvinylether", CAS = "111-34-2", Tc = 540.5, Pc = 3200000,  Vc = 0.38362, Cc = 0.273, Tb = 367.131, Tm = 181.15, TT = 181.15, TP = 0.134811, MW = 100.163, LVB = 0.130251, AF = 0.358, SP = 16460, DM = 4.16955E-30, SH = -216400000.0, IGHF = -1.83E+08, GEF = -3.61974E+07, AS = 428000, HFMP = 1.38E+07, HOC = -3.59144E+09, LiqDen = {105,0.51202,0.22443,540.5,0.25269,0}, VP = {101,80.48089,-6835.53,-8.641032,5.192611E-06,2}, LiqCp = {16,179060,294.15,4.464,0.023293,-0.000021892}, HOV = {106,5.9857E+07,1.4054,-2.9112,3.3585,-1.4378}, VapCp = {16,70271,-440.11,12.531,0.00054467,-2.1666E-07}, LiqVis = {101,-13.973,1139.1,0.44727,-0.0000011861,2}, VapVis = {102,9.4315E-08,0.78571,41.584,9100.4,0}, LiqK = {16,-0.13174,16.987,-1.2513,-0.000050242,-0.000001447}, VapK = {102,0.00002407,1.1842,65.04,40153,0}, Racketparam = 0.273, UniquacR = 4.7403, UniquacQ = 4.192, ChaoSeadAF = 0.358, ChaoSeadSP = 16460, ChaoSeadLV = 0.130251);
  end Butylvinylether;
  
  model Anisole
  extends General_Properties(
    SN = 334, name = "Anisole", CAS = "100-66-3", Tc = 642.15, Pc = 4180000,  Vc = 0.337, Cc = 0.267, Tb = 426.95, Tm = 235.85, TT = 235.65, TP = 2.44662, MW = 108.138, LVB = 0.109167, AF = 0.350169, SP = 20110, DM = 4.54E-30, SH = -216400000.0, IGHF = -6.8E+07, GEF = 2.27E+07, AS = 361000, HFMP = 9600000, HOC = -3.6018E+09, LiqDen = {105,0.67524,0.24431,645.61,0.26239,0}, VP = {101,117.0581,-9318.991,-14.12565,9.850515E-06,2}, LiqCp = {16,128070,-77.615,10.002,0.0059631,-0.0000043683}, HOV = {106,6.1782E+07,0.29654,0.81637,-1.3762,0.64684}, VapCp = {16,-116340,-170.41,12.829,0.00034368,-1.0767E-07}, LiqVis = {101,-16.864,1572.6,0.82898,-2.2828E-07,2}, VapVis = {102,1.7587E-07,0.71998,171.18,1705.8,0}, LiqK = {16,-0.15959,21.142,-1.1373,-0.0000023738,-0.0000009757}, VapK = {102,0.00055356,0.7624,342.48,235670,0}, Racketparam = 0.267, UniquacR = 4.1667, UniquacQ = 3.208, ChaoSeadAF = 0.350169, ChaoSeadSP = 20110, ChaoSeadLV = 0.109167);
  end Anisole;
  
  model Isopropylacetate
  extends General_Properties(
    SN = 335, name = "Isopropylacetate", CAS = "108-21-4", Tc = 516.15, Pc = 3495640,  Vc = 0.343881, Cc = 0.25, Tb = 361.65, Tm = 199.75, TT = 199.75, TP = 3.8692, MW = 102.132, LVB = 0.117579, AF = 0.542817, SP = 17150, DM = 5.84E-30, SH = -216400000.0, IGHF = -4.817E+08, GEF = -3.337E+08, AS = 390200, HFMP = 8880000, HOC = -2.658E+09, LiqDen = {105,1.7447,0.38746,516.15,0.46246,0}, VP = {101,53.596,-5675.5,-4.5065,0.0000012831,2}, LiqCp = {16,131390,-46.486,8.1047,0.013597,-0.000010999}, HOV = {106,4.852874E+07,0.139799,0.87492,-1.379465,0.721356}, VapCp = {16,49388,-461.23,12.886,-0.00010674,6.959E-08}, LiqVis = {101,-10.895,1115.7,-0.084451,4.8399E-07,2}, VapVis = {102,3.7177E-07,0.62086,249.31,-266.55,0}, LiqK = {16,-0.09612,7.576,-1.2028,-0.00070085,-9.2097E-07}, VapK = {102,-5913400,-0.12076,3.6992E+09,-2.5996E+13,0}, Racketparam = 0.25, UniquacR = 4.1522, UniquacQ = 3.652, ChaoSeadAF = 0.367774, ChaoSeadSP = 17150, ChaoSeadLV = 0.117579);
  end Isopropylacetate;
  
  model Nbutylacetate
  extends General_Properties(
    SN = 336, name = "Nbutylacetate", CAS = "123-86-4", Tc = 579, Pc = 3090000,  Vc = 0.4128, Cc = 0.253, Tb = 399.12, Tm = 199.65, TT = 199.65, TP = 0.0816516, MW = 116.16, LVB = 0.13251, AF = 0.407, SP = 17670, DM = 6.14E-30, SH = -216400000.0, IGHF = -4.856E+08, GEF = -3.123E+08, AS = 442500, HFMP = 1.44E+07, HOC = -3.283E+09, LiqDen = {105,0.13588,0.1193,579,0.16305,0}, VP = {101,90.42793,-7625.342,-10.22284,8.987208E-06,2}, LiqCp = {16,201710,-19.025,8.0191,0.0068889,0.0000021505}, HOV = {106,8.192574E+07,1.151594,0.0889674,-1.859865,1.113952}, VapCp = {16,92876,-666.17,13.432,-0.00066148,3.0678E-07}, LiqVis = {101,-17.008,1461.1,0.8424,1.1193E-07,2}, VapVis = {102,1.0488E-07,0.76809,52.337,8271.1,0}, LiqK = {16,0.04366,-125.65,-0.40686,-0.0059305,0.0000024167}, VapK = {102,5.9364E-09,2.3739,-402.22,69606,0}, Racketparam = 0.253, UniquacR = 4.8274, UniquacQ = 4.196, ChaoSeadAF = 0.407, ChaoSeadSP = 17670, ChaoSeadLV = 0.13251);
  end Nbutylacetate;
  
  model Isobutylacetate
  extends General_Properties(
    SN = 337, name = "Isobutylacetate", CAS = "110-19-0", Tc = 561, Pc = 3160000,  Vc = 0.413, Cc = 0.266, Tb = 389.72, Tm = 174.3, TT = 174.3, TP = 0.00622415, MW = 116.16, LVB = 0.13387, AF = 0.456, SP = 17050, DM = 6.24E-30, SH = -216400000.0, IGHF = -4.93E+08, GEF = -3.222E+08, AS = 441000, HFMP = 1.24E+07, HOC = -3.319E+09, LiqDen = {105,0.40843,0.20784,561,0.21394,0}, VP = {101,28.45261,-5051.537,-0.615949,-1.95606E-06,2}, LiqCp = {16,161610,660.76,3.3098,0.024476,-0.000019195}, HOV = {106,6.408651E+07,1.313221,-1.992233,1.203843,-0.0654865}, VapCp = {16,100140,-654.65,13.176,-0.00017464,3.2068E-08}, LiqVis = {101,-7.1351,566.94,-0.24427,-0.0000078548,2}, VapVis = {102,1.0879E-07,0.78101,111.13,1059.5,0}, LiqK = {16,0.070874,405.28,-7.1892,0.020474,-0.000033831}, VapK = {102,-0.0010112,0.95292,-6813.9,270410,0}, Racketparam = 0.266, UniquacR = 4.8266, UniquacQ = 4.192, ChaoSeadAF = 0.456, ChaoSeadSP = 17050, ChaoSeadLV = 0.13387);
  end Isobutylacetate;
  
  model Npentylacetate
  extends General_Properties(
    SN = 338, name = "Npentylacetate", CAS = "628-63-7", Tc = 605.15, Pc = 2800000,  Vc = 0.442, Cc = 0.245, Tb = 422.15, Tm = 202.35, TT = 202.35, TP = 0.0185761, MW = 130.185, LVB = 0.149382, AF = 0.413866, SP = 17360, DM = 6.44E-30, SH = -216400000.0, IGHF = -5.055E+08, GEF = -3.035E+08, AS = 481800, HFMP = 1.65E+07, HOC = -3.89405E+09, LiqDen = {105,0.12608,0.12252,605.15,0.16886,0}, VP = {101,168.7214,-11229.65,-22.11732,0.0000177213,2}, LiqCp = {16,162580,80.092,8.5511,0.011513,-0.0000095523}, HOV = {106,7.883914E+07,0.946213,-0.171734,-0.730153,0.419139}, VapCp = {16,47433,-339.24,12.756,0.0005476,-2.1862E-07}, LiqVis = {101,-24.376,1661.3,2.1378,-0.0000051198,2}, VapVis = {102,4.6095E-07,0.57889,337.64,-259.28,0}, LiqK = {16,-0.08346,4.4855,-1.2866,-0.00064282,-6.6262E-07}, VapK = {102,-0.014827,0.47704,-3337.4,-1003300,0}, Racketparam = 0.245, UniquacR = 5.5018, UniquacQ = 4.736, ChaoSeadAF = 0.447773, ChaoSeadSP = 17360, ChaoSeadLV = 0.149382);
  end Npentylacetate;
  
  model Vinylacetate
  extends General_Properties(
    SN = 339, name = "Vinylacetate", CAS = "108-05-4", Tc = 501.45, Pc = 4150000,  Vc = 0.266, Cc = 0.248, Tb = 345.65, Tm = 180.35, TT = 180.35, TP = 0.70586, MW = 86.0892, LVB = 0.0929486, AF = 0.529352, SP = 18580, DM = 5.97E-30, SH = -216400000.0, IGHF = -3.157E+08, GEF = -2.287E+08, AS = 334400, HFMP = 5370000, HOC = -1.95E+09, LiqDen = {105,0.80837,0.2388,524.34,0.25151,0}, VP = {101,-28.90631,-2451.071,8.43748,-0.000014969,2}, LiqCp = {16,104670,68.241,7.8309,0.01301,-0.00001011}, HOV = {106,5.178411E+07,1.329393,-3.127105,3.542901,-1.384803}, VapCp = {16,50651,-432.89,12.118,0.00048734,-1.8964E-07}, LiqVis = {101,-20.187,1398,1.3362,8.2076E-07,2}, VapVis = {102,1.4727E-07,0.76076,119.27,67.359,0}, LiqK = {16,-0.068153,28.848,-1.5016,0.00051317,-0.0000030057}, VapK = {102,-5281900,-0.16154,2.8419E+09,-1.7045E+13,0}, Racketparam = 0.248, UniquacR = 3.2485, UniquacQ = 2.904, ChaoSeadAF = 0.351307, ChaoSeadSP = 18580, ChaoSeadLV = 0.0929486);
  end Vinylacetate;
  
  model Nhexylacetate
  extends General_Properties(
    SN = 340, name = "Nhexylacetate", CAS = "142-92-7", Tc = 623.5, Pc = 2410000,  Vc = 0.519, Cc = 0.244, Tb = 444.65, Tm = 192.25, TT = 192.25, TP = 0.000851561, MW = 144.211, LVB = 0.166008, AF = 0.461433, SP = 17200, DM = 6.2E-30, SH = -216400000.0, IGHF = -5.263E+08, GEF = -2.954E+08, AS = 520900, HFMP = 1.69E+07, HOC = -4.505E+09, LiqDen = {105,0.39801,0.22828,623.5,0.26879,0}, VP = {101,135.2,-10778,-16.633,0.000010146,2}, LiqCp = {16,152410,849.23,3.575,0.024024,-0.000019964}, HOV = {106,7.6365E+07,1.3535,-2.7266,3.0189,-1.2516}, VapCp = {16,74275,-423.1,13.088,0.00020721,-5.6794E-08}, LiqVis = {101,-11.853,1437.9,0.03568,-1.5887E-07,2}, VapVis = {102,0.0000001052,0.76244,141.7,-5217.3,0}, LiqK = {16,0.076217,432.06,-6.6217,0.014354,-0.00002134}, VapK = {102,-96.991,-0.0010535,51726,-1.0193E+09,0}, Racketparam = 0.244, UniquacR = 6.1762, UniquacQ = 5.276, ChaoSeadAF = 0.539588, ChaoSeadSP = 17200, ChaoSeadLV = 0.166008);
  end Nhexylacetate;
  
  model Onepentanol
  extends General_Properties(
    SN = 341, name = "Onepentanol", CAS = "71-41-0", Tc = 588.15, Pc = 3909000,  Vc = 0.326, Cc = 0.262, Tb = 411.16, Tm = 194.95, TT = 195.56, TP = 0.000345245, MW = 88.15, LVB = 0.10863, AF = 0.579, SP = 22520, DM = 5.67059E-30, SH = -216400000.0, IGHF = -3.0016E+08, GEF = -1.46022E+08, AS = 402501, HFMP = 9790560, HOC = -3.06051E+09, LiqDen = {105,0.54137,0.21848,588.15,0.20812,0}, VP = {101,150.9933,-11938.85,-18.59103,8.735585E-06,2}, LiqCp = {16,151460,721.52,-3.5691,0.059604,-0.000063767}, HOV = {106,1.1853E+08,1.9668,-2.5741,1.6268,-0.41037}, VapCp = {16,78144,-573.83,12.781,0.00015431,-6.6745E-08}, LiqVis = {101,-29.696,3126.2,2.4167,-0.0000024327,2}, VapVis = {102,1.9935E-07,0.70293,200.97,-2040.7,0}, LiqK = {16,0.14679,201570,-2097.5,7.255,-0.0083973}, VapK = {102,1221.5,0.95117,8.0014E+09,-2.8255E+11,0}, Racketparam = 0.262, UniquacR = 4.5987, UniquacQ = 4.208, ChaoSeadAF = 0.579, ChaoSeadSP = 22520, ChaoSeadLV = 0.10863);
  end Onepentanol;
  
  model Twopentanol
  extends General_Properties(
    SN = 342, name = "Twopentanol", CAS = "6032-29-7", Tc = 552, Pc = 3880000,  Vc = 0.327, Cc = 0.26, Tb = 392.15, Tm = 200, TT = 200, TP = 0.00596587, MW = 88.1482, LVB = 0.109448, AF = 0.674371, SP = 21700, DM = 5.39E-30, SH = -216400000.0, IGHF = -3.138E+08, GEF = -1.593E+08, AS = 396400, HFMP = 8480000, HOC = -3.0515E+09, LiqDen = {105,1.319,0.3371,552,0.32218,0}, VP = {101,156.6278,-11701.22,-19.61134,0.0000119964,2}, LiqCp = {16,223900,2827.9,-24.806,0.11426,-0.00010479}, HOV = {106,8.4515E+07,0.5603,0.52669,-1.3675,0.83639}, VapCp = {16,81533,-562.17,12.749,0.00015514,-6.2807E-08}, LiqVis = {101,-161.5575,9388.477,22.02304,-0.0000121894,2}, VapVis = {102,3.2586E-07,0.63457,242.49,-572.84,0}, LiqK = {16,-0.29342,50.682,-1.2923,0.0017888,-0.0000028966}, VapK = {102,1300.2,0.95377,8.1158E+09,-2.9211E+11,0}, Racketparam = 0.26, UniquacR = 4.5979, UniquacQ = 4.204, ChaoSeadAF = 0.558707, ChaoSeadSP = 21700, ChaoSeadLV = 0.109448);
  end Twopentanol;
  
  model TwomethylOnebutanol
  extends General_Properties(
    SN = 343, name = "TwomethylOnebutanol", CAS = "137-32-6", Tc = 575.4, Pc = 3940000,  Vc = 0.329, Cc = 0.271, Tb = 401.85, Tm = 195, TT = 195, TP = 0.000803, MW = 88.148, LVB = 0.1083, AF = 0.587733, SP = 22080, DM = 6.27E-30, SH = -216400000.0, IGHF = -3.0209E+08, GEF = -1.41E+08, AS = 386900, HFMP = 7430000, HOC = -3.062E+09, LiqDen = {105,0.88123,0.27569,576.16,0.26459,0}, VP = {101,169.4054,-12535.91,-21.44821,0.000011664,2}, LiqCp = {16,64512,-115.41,11.54,0.0018322,0.0000027168}, HOV = {106,1.7446E+08,5.4789,-13.886,15.653,-6.6531}, VapCp = {16,76232,-567.6,12.811,0.000074113,-1.3012E-08}, LiqVis = {101,0.00893998,2796.534,-2.732303,0.0000087109,2}, VapVis = {102,0.000000189,0.70643,185.92,-6046.6,0}, LiqK = {16,0.080313,-215.29,-0.17577,-0.0076457,0.000003672}, VapK = {102,1262.3,0.94565,7.7547E+09,-2.8418E+11,0}, Racketparam = 0.271, UniquacR = 4.5979, UniquacQ = 4.204, ChaoSeadAF = 0.587733, ChaoSeadSP = 22080, ChaoSeadLV = 0.1083);
  end TwomethylOnebutanol;
  
  model TwoTwodimethylOnepropanol
  extends General_Properties(
    SN = 344, name = "TwoTwodimethylOnepropanol", CAS = "75-84-3", Tc = 552.7, Pc = 4078000,  Vc = 0.327, Cc = 0.29, Tb = 386.25, Tm = 328.15, TT = 328.15, TP = 8050, MW = 88.1482, LVB = 0.1255, AF = 0.595013, SP = 19040, DM = 5.47E-30, SH = -216400000.0, IGHF = -3.021E+08, GEF = -1.4E+08, AS = 370000, HFMP = 3500000, HOC = -3.061E+09, LiqDen = {105,0.88741,0.29,552.7,0.28571,0}, VP = {101,192.4683,-12413.62,-25.59931,0.0000246643,2}, LiqCp = {16,124850,368.96,4.9094,0.027472,-0.00002893}, HOV = {106,4.5224E+07,-1.2435,2.138,0.13988,-0.73989}, VapCp = {16,72294.67,-550.0374,12.86817,0.000039202,-1.255351E-08}, LiqVis = {101,-12.693,3446.8,-0.71456,0.0000011322,2}, VapVis = {102,0.000021696,0.15612,1926.2,5137.4,0}, LiqK = {16,-0.11602,10.416,-1.227,-0.00033355,-0.00000113}, VapK = {102,1.2842E-07,1.9773,-61.933,2946,0}, Racketparam = 0.29, UniquacR = 4.5972, UniquacQ = 4.284, ChaoSeadAF = 0.595013, ChaoSeadSP = 19040, ChaoSeadLV = 0.1255);
  end TwoTwodimethylOnepropanol;
  
  model Onehexanol
  extends General_Properties(
    SN = 345, name = "Onehexanol", CAS = "111-27-3", Tc = 611.4, Pc = 3510000,  Vc = 0.381, Cc = 0.263, Tb = 430.44, Tm = 228.55, TT = 228.55, TP = 0.0295499, MW = 102.177, LVB = 0.12519, AF = 0.58, SP = 21830, DM = 5.5E-30, SH = -216400000.0, IGHF = -3.18E+08, GEF = -1.344E+08, AS = 440000, HFMP = 1.54E+07, HOC = -3.67439E+09, LiqDen = {105,0.12172,0.11263,611.4,0.13194,0}, VP = {101,140.4065,-11996.05,-16.8497,6.25688E-06,2}, LiqCp = {16,-13352,695.57,4.4864,0.026504,-0.000025444}, HOV = {106,9.9912E+07,1.0345,-0.71214,0.038869,0.22103}, VapCp = {16,93733,-618.92,13.098,-0.000028541,-8.6478E-09}, LiqVis = {101,-78.019,5186.5,9.8395,-0.0000094042,2}, VapVis = {102,2.3121E-07,0.66402,127.06,17987,0}, LiqK = {16,0.09203,1297.6,-15.712,0.045447,-0.000056017}, VapK = {102,-2143900,-0.092957,1.682E+08,-1.0339E+13,0}, Racketparam = 0.263, UniquacR = 5.2731, UniquacQ = 4.748, ChaoSeadAF = 0.58, ChaoSeadSP = 21830, ChaoSeadLV = 0.12519);
  end Onehexanol;
  
  model Oneheptanol
  extends General_Properties(
    SN = 346, name = "Oneheptanol", CAS = "111-70-6", Tc = 631.9, Pc = 3150000,  Vc = 0.435, Cc = 0.261, Tb = 449.81, Tm = 239.15, TT = 239.15, TP = 0.0117728, MW = 116.203, LVB = 0.14195, AF = 0.582, SP = 21540, DM = 5.57E-30, SH = -216400000.0, IGHF = -3.32E+08, GEF = -1.253E+08, AS = 480000, HFMP = 1.322E+07, HOC = -4.2887E+09, LiqDen = {105,0.53584,0.24833,632.61,0.25556,0}, VP = {101,251.8216,-17683.63,-33.48375,0.000017626,2}, LiqCp = {16,-85727,742.02,4.7157,0.026441,-0.000025674}, HOV = {106,1.173181E+08,1.489028,-2.632241,3.547284,-1.892409}, VapCp = {16,106760,-598.85,13.165,0.000054117,-4.1018E-08}, LiqVis = {101,-78.864,5896.7,9.4721,-3.3466E-07,2}, VapVis = {102,2.5718E-07,0.65021,248.54,12.534,0}, LiqK = {16,0.090359,1107.5,-13.417,0.037115,-0.000045589}, VapK = {102,-0.060066,0.28898,-3437.9,-1686200,0}, Racketparam = 0.261, UniquacR = 5.2731, UniquacQ = 4.748, ChaoSeadAF = 0.582, ChaoSeadSP = 21540, ChaoSeadLV = 0.14195);
  end Oneheptanol;
  
  model OneFourbutanediol
  extends General_Properties(
    SN = 347, name = "OneFourbutanediol", CAS = "110-63-4", Tc = 667, Pc = 4880000,  Vc = 0.297, Cc = 0.261, Tb = 501.15, Tm = 293.05, TT = 293.05, TP = 0.437872, MW = 90.121, LVB = 0.0888513, AF = 1.17696, SP = 28850, DM = 1.31E-29, SH = -216400000.0, IGHF = -4.267E+08, GEF = -2.78E+08, AS = 381000, HFMP = 1.63E+07, HOC = -2.2801E+09, LiqDen = {105,0.87669,0.26038,667,0.18382,0}, VP = {101,273.87,-20688,-36.39,0.000020662,2}, LiqCp = {16,-147300,-151.29,13.013,0.00082927,-4.8483E-07}, HOV = {106,8.835E+07,0.2441,0,0,0}, VapCp = {16,78857,-613.48,12.793,-0.00013274,6.7309E-08}, LiqVis = {101,-135.2818,9167.078,18.06409,-0.0000115446,2}, VapVis = {102,1.0592E-07,0.79673,195.38,-19182,0}, LiqK = {16,0.17847,-272.57,-0.42428,-0.0080796,0.0000034419}, VapK = {102,-0.69878,0.86746,-2810400,-7.1005E+07,0}, Racketparam = 0.261, UniquacR = 4.6976, UniquacQ = 4.56, ChaoSeadAF = 1.17696, ChaoSeadSP = 28850, ChaoSeadLV = 0.0888513);
  end OneFourbutanediol;
  
  model Methylmercaptan
  extends General_Properties(
    SN = 348, name = "Methylmercaptan", CAS = "74-93-1", Tc = 470, Pc = 7230000,  Vc = 0.145, Cc = 0.268, Tb = 279.11, Tm = 150.18, TT = 150.18, TP = 3.14785, MW = 48.109, LVB = 0.05552, AF = 0.15, SP = 19470, DM = 5.07E-30, SH = -22600000.0, IGHF = -2.26E+07, GEF = -9920000, AS = 255000, HFMP = 5904000, HOC = -1.1517E+09, LiqDen = {105,1.954,0.28171,470,0.28737,0}, VP = {101,115.1598,-6300.053,-14.66478,0.0000195265,2}, LiqCp = {16,87318,-59222,550.29,-1.6599,0.001702}, HOV = {106,3.221375E+07,-0.00310105,0.657759,-0.0249162,-0.340052}, VapCp = {16,38535,-588.35,11.232,0.00044782,-1.6363E-07}, LiqVis = {101,-8.947,607.01,-0.26447,0.0000011807,2}, VapVis = {102,1.9969E-07,0.74097,130.67,-839.04,0}, LiqK = {16,-0.011242,-11.424,-1.1701,-0.0017729,-0.0000012043}, VapK = {102,0.000024689,1.1702,4.7184,35466,0}, Racketparam = 0.268, UniquacR = 1.877, UniquacQ = 1.676, ChaoSeadAF = 0, ChaoSeadSP = 0, ChaoSeadLV = 0);
  end Methylmercaptan;
  
  model Npropylmercaptan
  extends General_Properties(
    SN = 349, name = "Npropylmercaptan", CAS = "107-03-9", Tc = 536, Pc = 4520000,  Vc = 0.254, Cc = 0.264, Tb = 340.65, Tm = 159.85, TT = 160, TP = 0.0651025, MW = 76.1606, LVB = 0.0911676, AF = 0.225, SP = 18020, DM = 5.17E-30, SH = -22600000.0, IGHF = -6.75E+07, GEF = 2700000, AS = 336400, HFMP = 5477000, HOC = -2.345E+09, LiqDen = {105,0.98491,0.2613,536.61,0.28105,0}, VP = {101,81.44938,-6196.556,-9.018418,0.0000073391,2}, LiqCp = {16,104970,204.83,8.2793,0.0048108,0.0000020317}, HOV = {106,4.183879E+07,-0.0306824,1.010385,-0.640892,-0.0194755}, VapCp = {16,69258,-718.05,12.587,-0.000090812,1.349E-08}, LiqVis = {101,-8.6328,806.3,-0.3609,0.0000011977,2}, VapVis = {102,2.0609E-07,0.72623,217.41,-10810,0}, LiqK = {16,-0.061115,3.3836,-1.3478,-0.00049487,-0.0000016211}, VapK = {102,0.0088953,0.51444,2337.9,345110,0}, Racketparam = 0.264, UniquacR = 3.2265, UniquacQ = 2.756, ChaoSeadAF = 0.225, ChaoSeadSP = 18020, ChaoSeadLV = 0.0911676);
  end Npropylmercaptan;
  
  model Tertbutylmercaptan
  extends General_Properties(
    SN = 350, name = "Tertbutylmercaptan", CAS = "75-66-1", Tc = 530, Pc = 4060000,  Vc = 0.307, Cc = 0.283, Tb = 337.37, Tm = 274.26, TT = 274.42, TP = 7907.71, MW = 90.1872, LVB = 0.113524, AF = 0.191395, SP = 15790, DM = 5.3E-30, SH = -22600000.0, IGHF = -1.096E+08, GEF = 1006000, AS = 338000, HFMP = 2482000, HOC = -2.9396E+09, LiqDen = {105,0.89711,0.27544,530,0.31359,0}, VP = {101,107.5154,-7030.549,-13.1586,0.0000127338,2}, LiqCp = {16,154160,506.03,1.848,0.027991,-0.000021961}, HOV = {106,5.3137E+07,1.4502,-2.4713,2.4297,-0.95458}, VapCp = {16,81989,-677.66,12.907,-0.00021031,4.8543E-08}, LiqVis = {101,-8.3337,1214.8,-0.59208,0.0000022318,2}, VapVis = {102,3.9123E-07,0.6395,316.74,-8533.3,0}, LiqK = {16,0.031454,-260.91,0.599,-0.0079027,0.0000031638}, VapK = {102,0.032499,0.31482,1562.3,775320,0}, Racketparam = 0.283, UniquacR = 4.3543, UniquacQ = 3.912, ChaoSeadAF = 0.191395, ChaoSeadSP = 15790, ChaoSeadLV = 0.113524);
  end Tertbutylmercaptan;
  
  model Isobutylmercaptan
  extends General_Properties(
    SN = 351, name = "Isobutylmercaptan", CAS = "513-44-0", Tc = 557, Pc = 3900000,  Vc = 0.307, Cc = 0.268, Tb = 361.64, Tm = 128.31, TT = 128.3, TP = 4.75023E-06, MW = 90.1872, LVB = 0.108751, AF = 0.25, SP = 17240, DM = 5.1E-30, SH = -22600000.0, IGHF = -9.694E+07, GEF = 6100000, AS = 362840, HFMP = 4982300, HOC = -2.949E+09, LiqDen = {105,0.97433,0.28543,557,0.30684,0}, VP = {101,94.36165,-7005.04,-10.97315,8.971409E-06,2}, LiqCp = {16,113680,117.72,9.1822,0.0046628,2.8876E-09}, HOV = {106,4.696233E+07,0.280539,0.393074,-0.340509,0.0160184}, VapCp = {16,83649,-694.35,12.849,-0.00014111,3.1023E-08}, LiqVis = {101,-10.885,935.58,0.015703,-1.4837E-10,2}, VapVis = {102,8.5691E-08,0.8336,119.56,-8012,0}, LiqK = {16,-0.03575,3.5477,-1.4952,-0.00050318,-0.0000017356}, VapK = {102,0.00014532,0.98673,557.5,22542,0}, Racketparam = 0.268, UniquacR = 3.9001, UniquacQ = 3.292, ChaoSeadAF = 0.25, ChaoSeadSP = 17240, ChaoSeadLV = 0.108751);
  end Isobutylmercaptan;
  
  model Secbutylmercaptan
  extends General_Properties(
    SN = 352, name = "Secbutylmercaptan", CAS = "513-53-1", Tc = 551, Pc = 3970000,  Vc = 0.307, Cc = 0.271, Tb = 358.13, Tm = 133.01, TT = 133.01, TP = 0.0000339902, MW = 90.1872, LVB = 0.10943, AF = 0.25, SP = 17000, DM = 5.17E-30, SH = -22600000.0, IGHF = -9.66E+07, GEF = 5200000, AS = 366730, HFMP = 6477000, HOC = -2.95E+09, LiqDen = {105,0.81743,0.26237,554.01,0.28149,0}, VP = {101,85.20348,-6580.804,-9.568603,0.0000075683,2}, LiqCp = {16,132220,286.96,6.629,0.011753,-0.0000059086}, HOV = {106,4.567571E+07,0.16352,0.885588,-1.131485,0.438377}, VapCp = {16,85634,-697.09,12.792,-0.00003836,-5.0229E-09}, LiqVis = {101,-11.718,953.76,0.15985,-4.5581E-07,2}, VapVis = {102,8.4539E-08,0.83594,117.21,-7872.1,0}, LiqK = {16,-0.032852,4.221,-1.5207,-0.0004702,-0.0000018598}, VapK = {102,0.97519,-0.11286,1130.7,3149700,0}, Racketparam = 0.271, UniquacR = 4.1276, UniquacQ = 3.604, ChaoSeadAF = 0.25, ChaoSeadSP = 17000, ChaoSeadLV = 0.10943);
  end Secbutylmercaptan;
  
  model Nhexylmercaptan
  extends General_Properties(
    SN = 353, name = "Nhexylmercaptan", CAS = "111-31-9", Tc = 622, Pc = 3025000,  Vc = 0.412, Cc = 0.245, Tb = 424.15, Tm = 192.15, TT = 192.62, TP = 0.0130959, MW = 118.24, LVB = 0.141006, AF = 0.369, SP = 17450, DM = 5.17E-30, SH = -22600000.0, IGHF = -1.292E+08, GEF = 2.77E+07, AS = 454600, HFMP = 1.801E+07, HOC = -4.176E+09, LiqDen = {105,0.60827,0.26212,623.01,0.27785,0}, VP = {101,102.0208,-8530.272,-11.91139,8.521739E-06,2}, LiqCp = {16,168110,243.92,7.741,0.0099925,-0.0000054522}, HOV = {106,6.053718E+07,0.532372,-0.222059,0.0696209,-0.00101028}, VapCp = {16,116170,-711.75,13.18,-0.000044297,1.0562E-09}, LiqVis = {101,-35.723,1823.3,4.0853,-0.0000098564,2}, VapVis = {102,6.7616E-08,0.85134,101.57,-4277.1,0}, LiqK = {16,-0.076932,5.5076,-1.3601,-0.00033003,-0.000001155}, VapK = {102,0.090806,0.27994,4707,1982000,0}, Racketparam = 0.245, UniquacR = 5.2497, UniquacQ = 4.376, ChaoSeadAF = 0.369, ChaoSeadSP = 17450, ChaoSeadLV = 0.141006);
  end Nhexylmercaptan;
  
  model Methylethylsulfide
  extends General_Properties(
    SN = 354, name = "Methylethylsulfide", CAS = "624-89-5", Tc = 533, Pc = 4260000,  Vc = 0.26, Cc = 0.25, Tb = 339.8, Tm = 167.24, TT = 167.23, TP = 0.224563, MW = 76.163, LVB = 0.09102, AF = 0.208, SP = 18010, DM = 5.34E-30, SH = -22600000.0, IGHF = -5.93E+07, GEF = 1.19E+07, AS = 332100, HFMP = 9761000, HOC = -2.3531E+09, LiqDen = {105,1.067,0.27102,533,0.29364,0}, VP = {101,84.44792,-6287.173,-9.497514,8.101952E-06,2}, LiqCp = {16,128430,1340.2,-7.9347,0.062009,-0.00006022}, HOV = {106,5.1014E+07,1.045,-1.3834,1.1914,-0.41055}, VapCp = {16,65018,-602.45,12.269,0.00023938,-9.0299E-08}, LiqVis = {101,-11.137,871.68,0.048227,-1.2198E-07,2}, VapVis = {102,1.5396E-07,0.76205,156.76,-5273.3,0}, LiqK = {16,-0.050172,-1.1207,-1.3208,-0.00082247,-0.0000013076}, VapK = {102,0.0034168,0.62158,1811.6,162180,0}, Racketparam = 0.25, UniquacR = 3.1885, UniquacQ = 2.756, ChaoSeadAF = 0.208, ChaoSeadSP = 18010, ChaoSeadLV = 0.09102);
  end Methylethylsulfide;
  
  model Methylnpropylsulfide
  extends General_Properties(
    SN = 355, name = "Methylnpropylsulfide", CAS = "3877-15-4", Tc = 552, Pc = 3800000,  Vc = 0.322, Cc = 0.259, Tb = 368.69, Tm = 160.17, TT = 160.17, TP = 0.00425588, MW = 90.1872, LVB = 0.107699, AF = 0.356915, SP = 17710, DM = 5.5E-30, SH = -22600000.0, IGHF = -8.19E+07, GEF = 1.793E+07, AS = 371700, HFMP = 9912000, HOC = -2.962E+09, LiqDen = {105,1.528,0.35328,552,0.39953,0}, VP = {101,83.78969,-6786.538,-9.267875,6.742312E-06,2}, LiqCp = {16,140680,477.81,3.8109,0.020949,-0.000014877}, HOV = {106,5.460643E+07,0.610381,0.183873,-0.864255,0.448129}, VapCp = {16,76201,-575.5,12.472,0.00030373,-1.0224E-07}, LiqVis = {101,-11.683,983.43,0.11996,-4.1262E-07,2}, VapVis = {102,5.4928E-08,0.89154,78.07,-5628.6,0}, LiqK = {16,-0.062059,3.0814,-1.3629,-0.00055214,-0.0000012783}, VapK = {102,0.0023304,0.67586,1803.3,153300,0}, Racketparam = 0.259, UniquacR = 3.8629, UniquacQ = 3.296, ChaoSeadAF = 0.273669, ChaoSeadSP = 17710, ChaoSeadLV = 0.107699);
  end Methylnpropylsulfide;
  
  model Methyltbutylsulfide
  extends General_Properties(
    SN = 356, name = "Methyltbutylsulfide", CAS = "6163-64-0", Tc = 585, Pc = 3400000,  Vc = 0.37, Cc = 0.269, Tb = 372.048, Tm = 190.84, TT = 190.84, TP = 0.818336, MW = 104.214, LVB = 0.12697, AF = 0.107514, SP = 16230, DM = 5.2E-30, SH = -22600000.0, IGHF = -1.209E+08, GEF = 7400000, AS = 414300, HFMP = 8414000, HOC = -3.558E+09, LiqDen = {105,0.0025324,0.015967,585,0.080614,0}, VP = {101,84.46516,-6786.586,-9.396892,6.668285E-06,2}, LiqCp = {16,141210,178.65,7.6994,0.011393,-0.0000080501}, HOV = {106,6.776086E+07,2.156989,-4.009149,3.630339,-1.236406}, VapCp = {16,87862,-573.15,12.832,0.000097962,-4.8038E-08}, LiqVis = {101,-10.768,996.37,0.0046964,-1.0865E-08,2}, VapVis = {102,1.4934E-07,0.74231,170.99,-8263.5,0}, LiqK = {16,-0.049324,-5.479,-1.3559,-0.00091706,-9.5073E-07}, VapK = {102,0.00016838,0.95767,599.31,12993,0}, Racketparam = 0.269, UniquacR = 4.5358, UniquacQ = 3.912, ChaoSeadAF = 0.233365, ChaoSeadSP = 16230, ChaoSeadLV = 0.12697);
  end Methyltbutylsulfide;
  
  model Methyltpentylsulfide
  extends General_Properties(
    SN = 357, name = "Methyltpentylsulfide", CAS = "13286-92-5", Tc = 632, Pc = 3130000,  Vc = 0.412, Cc = 0.259, Tb = 401.15, Tm = 195, TT = 195, TP = 0.0547032, MW = 118.24, LVB = 0.141236, AF = 0.283554, SP = 16850, DM = 5.2E-30, SH = -22600000.0, IGHF = -1.374E+08, GEF = 2.884E+07, AS = 422900, HFMP = 8320000, HOC = -4.171E+09, LiqDen = {105,0.59566,0.25918,632,0.28571,0}, VP = {101,71.41151,-7073.516,-7.244729,3.628693E-06,2}, LiqCp = {16,181970,283.58,5.3016,0.020294,-0.000016827}, HOV = {106,5.4045E+07,0.37325,0,0,0}, VapCp = {16,109660,-656.23,13.164,-0.000084618,-5.7336E-09}, LiqVis = {101,-11.248,1169.1,-0.00088104,1.198E-09,2}, VapVis = {102,8.9322E-08,0.79515,142.11,-9151.1,0}, LiqK = {16,-0.059845,-0.6973,-1.3681,-0.00062696,-0.0000008708}, VapK = {102,0.00014528,0.96627,637.8,13351,0}, Racketparam = 0.259, UniquacR = 5.2102, UniquacQ = 4.452, ChaoSeadAF = 0.283554, ChaoSeadSP = 16850, ChaoSeadLV = 0.141236);
  end Methyltpentylsulfide;
  
  model Dinpropylsulfide
  extends General_Properties(
    SN = 358, name = "Dinpropylsulfide", CAS = "111-47-7", Tc = 608, Pc = 3080000,  Vc = 0.412, Cc = 0.251, Tb = 415.978, Tm = 170.55, TT = 170.44, TP = 0.000440358, MW = 118.24, LVB = 0.141918, AF = 0.374042, SP = 17110, DM = 5.5E-30, SH = -22600000.0, IGHF = -1.254E+08, GEF = 2.15E+07, AS = 447000, HFMP = 1.214E+07, HOC = -4.1801E+09, LiqDen = {105,0.66296,0.27313,608,0.29224,0}, VP = {101,149.6373,-10251.56,-19.3067,0.0000171365,2}, LiqCp = {16,165300,330.45,6.4516,0.01426,-0.000009041}, HOV = {106,5.7575E+07,0.38334,0.098397,-0.17233,0.065159}, VapCp = {16,105470,-659.93,13.199,-0.00015,2.3041E-08}, LiqVis = {101,-10.285,1150.9,-0.17064,6.2281E-07,2}, VapVis = {102,7.5739E-08,0.838,116.99,-6475.6,0}, LiqK = {16,-0.078109,7.1733,-1.4231,-0.000097639,-0.0000015465}, VapK = {102,0.0086151,0.48706,1648.6,489220,0}, Racketparam = 0.251, UniquacR = 5.2117, UniquacQ = 4.376, ChaoSeadAF = 0.374042, ChaoSeadSP = 17110, ChaoSeadLV = 0.141918);
  end Dinpropylsulfide;
  
  model Diethylsulfide
  extends General_Properties(
    SN = 359, name = "Diethylsulfide", CAS = "352-93-2", Tc = 557, Pc = 3960000,  Vc = 0.318, Cc = 0.269, Tb = 365.25, Tm = 169.22, TT = 169.2, TP = 0.099321, MW = 90.189, LVB = 0.10851, AF = 0.295, SP = 17490, DM = 5.14E-30, SH = -22600000.0, IGHF = -8.347E+07, GEF = 1.778E+07, AS = 368000, HFMP = 1.19035E+07, HOC = -2.9607E+09, LiqDen = {105,0.71845,0.24674,557.16,0.25292,0}, VP = {101,70.99138,-6108.92,-7.37143,5.835752E-06,2}, LiqCp = {16,145900,1485.7,-9.9348,0.077005,-0.000088463}, HOV = {106,4.6317E+07,0.40563,-0.17525,0.12561,0.018959}, VapCp = {16,84916,-751.54,12.969,-0.00026179,6.4336E-08}, LiqVis = {101,-2.9987,606.92,-1.2077,8.2651E-07,2}, VapVis = {102,6.8477E-08,0.85168,55.152,236.99,0}, LiqK = {16,-0.07619,7.9978,-1.3835,-0.00020735,-0.0000016592}, VapK = {102,0.0017352,0.67658,1116.5,181260,0}, Racketparam = 0.269, UniquacR = 3.8629, UniquacQ = 3.296, ChaoSeadAF = 0.295, ChaoSeadSP = 17490, ChaoSeadLV = 0.10851);
  end Diethylsulfide;
  
  model Diethyldisulfide
  extends General_Properties(
    SN = 360, name = "Diethyldisulfide", CAS = "110-81-6", Tc = 642, Pc = 3870000,  Vc = 0.358, Cc = 0.26, Tb = 427.15, Tm = 171.65, TT = 171.64, TP = 0.000220562, MW = 122.252, LVB = 0.12376, AF = 0.346925, SP = 18630, DM = 6.54E-30, SH = -22600000.0, IGHF = -7.47E+07, GEF = 2.301E+07, AS = 414000, HFMP = 9406000, HOC = -3.257E+09, LiqDen = {105,0.77633,0.27774,642,0.3008,0}, VP = {101,177.1651,-11358.16,-23.65597,0.0000232121,2}, LiqCp = {16,184820,1402.4,-9.485,0.072797,-0.00007939}, HOV = {106,5.898575E+07,0.279736,0.523521,-0.500907,0.0214669}, VapCp = {16,100900,-621.21,12.713,-0.0000050655,-1.705E-08}, LiqVis = {101,-12.559,1373.4,0.15118,-3.7692E-07,2}, VapVis = {102,6.5143E-08,0.87157,110.73,-9132.4,0}, LiqK = {16,-0.047803,3.9799,-1.4697,-0.00042308,-0.0000011998}, VapK = {102,0.00017171,0.93356,610.03,20030,0}, Racketparam = 0.26, UniquacR = 4.5748, UniquacQ = 3.816, ChaoSeadAF = 0.346925, ChaoSeadSP = 18630, ChaoSeadLV = 0.12376);
  end Diethyldisulfide;
  
  model Dimethyldisulfide
  extends General_Properties(
    SN = 361, name = "Dimethyldisulfide", CAS = "624-92-0", Tc = 606, Pc = 5360000,  Vc = 0.252, Cc = 0.264, Tb = 382.9, Tm = 188.44, TT = 188.44, TP = 0.207156, MW = 94.199, LVB = 0.0890926, AF = 0.266353, SP = 20060, DM = 6.57E-30, SH = -22600000.0, IGHF = -2.35978E+07, GEF = 1.53553E+07, AS = 336686, HFMP = 9192000, HOC = -2.04376E+09, LiqDen = {105,1.0289,0.26919,615.01,0.29771,0}, VP = {101,81.238,-6951.5,-8.8055,0.0000055663,2}, LiqCp = {16,143050,-21950,190.58,-0.51509,0.00050194}, HOV = {106,5.473869E+07,0.511523,0.456682,-1.152343,0.579651}, VapCp = {16,74603,-691.43,12.21,-0.0000028522,-1.9217E-08}, LiqVis = {101,-11.014,1197,-0.085106,2.8649E-07,2}, VapVis = {102,7.8221E-08,0.86272,109.17,-8364.4,0}, LiqK = {16,-0.035195,-0.25311,-1.4287,-0.00064815,-0.0000012773}, VapK = {102,0.00022814,0.8901,687.63,4695.8,0}, Racketparam = 0.264, UniquacR = 3.226, UniquacQ = 2.736, ChaoSeadAF = 0.205916, ChaoSeadSP = 20060, ChaoSeadLV = 0.0890926);
  end Dimethyldisulfide;
  
  model Dinpropyldisulfide
  extends General_Properties(
    SN = 362, name = "Dinpropyldisulfide", CAS = "629-19-6", Tc = 727.15, Pc = 3009350,  Vc = 0.518, Cc = 0.25, Tb = 466.65, Tm = 187.15, TT = 187.66, TP = 0.000767693, MW = 150.305, LVB = 0.157229, AF = 0.142024, SP = 17950, DM = 6.6E-30, SH = -22600000.0, IGHF = -1.173E+08, GEF = 3.849E+07, AS = 490000, HFMP = 1.381E+07, HOC = -4.53027E+09, LiqDen = {105,0.0083051,0.032244,727.15,0.12866,0}, VP = {101,37.30305,-7362.883,-1.323142,-8.891834E-06,2}, LiqCp = {16,195280,206.99,8.2539,0.0083402,-0.0000036311}, HOV = {106,5.27924E+07,-0.627848,2.812662,-3.633008,1.997715}, VapCp = {16,135200,-728.45,13.4,-0.00037376,9.4294E-08}, LiqVis = {101,-9.576,1437.8,-0.35065,0.0000011166,2}, VapVis = {102,6.2944E-08,0.86495,121.54,-9663.6,0}, LiqK = {16,-0.066065,4.827,-1.4132,-0.00039942,-9.1868E-07}, VapK = {102,0.00015595,0.95139,651.61,14665,0}, Racketparam = 0.25, UniquacR = 5.9236, UniquacQ = 4.896, ChaoSeadAF = 0.436981, ChaoSeadSP = 17950, ChaoSeadLV = 0.157229);
  end Dinpropyldisulfide;
  
  model Ditertbutyldisulfide
  extends General_Properties(
    SN = 363, name = "Ditertbutyldisulfide", CAS = "110-06-5", Tc = 689.7, Pc = 3159000,  Vc = 0.518, Cc = 0.285, Tb = 473.6, Tm = 268.2, TT = 268.2, TP = 9.12, MW = 178.359, LVB = 0.1947, AF = 0.402005, SP = 15680, DM = 6.2E-30, SH = -22600000.0, IGHF = -1.998E+08, GEF = 3.427E+07, AS = 500100, HFMP = 1.31E+07, HOC = -5.665E+09, LiqDen = {105,0.60778,0.31522,689.7,0.2884,0}, VP = {101,113.63,-10180,-13.332,0.0000068178,2}, LiqCp = {16,273850,-799.3,13.794,-0.001521,0.0000014598}, HOV = {106,5.0039E+07,-1.4285,5.5884,-6.8503,3.0089}, VapCp = {16,171300,-806,13.98,-0.00069575,1.6372E-07}, LiqVis = {101,-10.435,1172.7,0,0,0}, VapVis = {102,0.0000001005,0.79652,148.51,-7648.2,0}, LiqK = {16,-0.019283,-53.989,-1.1745,-0.0017696,-1.3435E-07}, VapK = {102,0.00018425,0.91582,448.35,58650,0}, Racketparam = 0.285, UniquacR = 5.9221, UniquacQ = 4.972, ChaoSeadAF = 0.402005, ChaoSeadSP = 15680, ChaoSeadLV = 0.1947);
  end Ditertbutyldisulfide;
  
  model Ethylmethyldisulfide
  extends General_Properties(
    SN = 364, name = "Ethylmethyldisulfide", CAS = "20333-39-5", Tc = 628.9, Pc = 4615000,  Vc = 0.312, Cc = 0.275, Tb = 407.15, Tm = 183.22, TT = 183.22, TP = 0.0416, MW = 108.226, LVB = 0.1066, AF = 0.301, SP = 18730, DM = 8.25E-30, SH = -22600000.0, IGHF = -4.94E+07, GEF = 1.709E+07, AS = 381100, HFMP = 9210000, HOC = -2.65E+09, LiqDen = {105,0.88258,0.27523,628.9,0.28571,0}, VP = {101,96.027,-8038.4,-10.972,0.0000070895,2}, LiqCp = {100,187520,-208.62,0.55295,0,0}, HOV = {106,4.8216E+07,0.48633,-0.6279,0.476,0}, VapCp = {16,84149,-628.71,12.564,-0.0001652,8.9754E-08}, LiqVis = {101,-74.45287,3204.964,10.10529,-0.0000144504,2}, VapVis = {102,7.0201E-08,0.85571,90.077,-7385.7,0}, LiqK = {16,-0.21083,11.426,-1.0307,0.00012249,-0.0000010671}, VapK = {102,0.00027958,0.86411,843.3,7471.1,0}, Racketparam = 0.275, UniquacR = 3.9004, UniquacQ = 3.276, ChaoSeadAF = 0.301, ChaoSeadSP = 18730, ChaoSeadLV = 0.1066);
  end Ethylmethyldisulfide;
  
  model Ethylpropyldisulfide
  extends General_Properties(
    SN = 365, name = "Ethylpropyldisulfide", CAS = "30453-31-7", Tc = 660, Pc = 3612000,  Vc = 0.417, Cc = 0.274, Tb = 446.85, Tm = 165, TT = 165, TP = 0.00002, MW = 136.279, LVB = 0.1405, AF = 0.391, SP = 17840, DM = 7.69E-30, SH = -22600000.0, IGHF = -9.625E+07, GEF = 2.796E+07, AS = 460300, HFMP = 1.08E+07, HOC = -3.866E+09, LiqDen = {105,0.65822,0.27459,660,0.28571,0}, VP = {101,110.6,-9574.8,-12.96,0.0000072115,2}, LiqCp = {100,223630,-139.83,0.57232,0,0}, HOV = {106,5.9782E+07,0.63427,-0.74757,0.47275,0}, VapCp = {16,105720,-573.79,12.857,0.000058344,8.0803E-09}, LiqVis = {101,-37.87,2334.8,4.1564,-0.0000036099,2}, VapVis = {102,6.9027E-08,0.8462,109.98,-9618.4,0}, LiqK = {16,-0.20064,12.059,-1.0757,0.00011826,-0.000000977}, VapK = {102,0.00000124,1.5526,-137.7,30422,0}, Racketparam = 0.274, UniquacR = 5.2492, UniquacQ = 4.356, ChaoSeadAF = 0.391, ChaoSeadSP = 17840, ChaoSeadLV = 0.1405);
  end Ethylpropyldisulfide;
  
  model Diphenyldisulfide
  extends General_Properties(
    SN = 366, name = "Diphenyldisulfide", CAS = "882-33-7", Tc = 829.8, Pc = 3569000,  Vc = 0.584, Cc = 0.302, Tb = 583.15, Tm = 333.5, TT = 333.5, TP = 0.49, MW = 218.338, LVB = 0.2076, AF = 0.569717, SP = 20480, DM = 5.97E-30, SH = -22600000.0, IGHF = 2.628E+08, GEF = 3.518E+08, AS = 489300, HFMP = 1.93E+07, HOC = -6.676E+09, LiqDen = {105,0.5173,0.302,829.8,0.28571,0}, VP = {101,927.5541,-59320.23,-131.1073,0.000060625,2}, LiqCp = {100,267470,28.884,0.54728,0,0}, HOV = {106,1.1805E+08,0.46278,0.25764,-0.22402,-0.0012437}, VapCp = {16,50433,-472.23,13.469,-0.00011605,2.3877E-08}, LiqVis = {101,-10.832,1659.3,-0.039017,-1.1543E-07,2}, VapVis = {102,5.542E-08,0.87669,123.7,-14104,0}, LiqK = {16,-0.040762,-52.269,-1.2013,-0.001172,-1.6247E-07}, VapK = {102,0.0000021936,1.4453,-128.48,46604,0}, Racketparam = 0.302, UniquacR = 7.6308, UniquacQ = 5.496, ChaoSeadAF = 0.569717, ChaoSeadSP = 20480, ChaoSeadLV = 0.2076);
  end Diphenyldisulfide;
  
  model Monoethanolamine
  extends General_Properties(
    SN = 367, name = "Monoethanolamine", CAS = "141-43-5", Tc = 671.4, Pc = 8030000,  Vc = 0.225, Cc = 0.284, Tb = 444.15, Tm = 283.65, TT = 283.65, TP = 13.3683, MW = 61.0831, LVB = 0.0603415, AF = 0.550815, SP = 31830, DM = 2.59E-30, SH = -22600000.0, IGHF = -1.96E+08, GEF = -1.033E+08, AS = 320000, HFMP = 2.0496E+07, HOC = -1.363E+09, LiqDen = {105,0.648,0.18183,678.21,0.17947,0}, VP = {10,23.09274,4319.625,-69.95024,0,0}, LiqCp = {4,78653.42,311.4162,-0.0607137,-2.713217E-06,-0.000017988}, HOV = {106,1.012031E+08,1.976961,-4.399887,4.906054,-1.945886}, VapCp = {16,50668,-516.86,12.167,0.00008641,2.8656E-10}, LiqVis = {101,-370.3,17780,54.624,-0.000051065,2}, VapVis = {102,5.78881E-08,0.876532,75.00276,628.0161,0}, LiqK = {16,-0.37218,78.8,-1.5916,0.0043895,-0.0000053291}, VapK = {102,-9539.9,0.39852,-1.7433E+09,-6.3715E+10,0}, Racketparam = 0.284, UniquacR = 3.0436, UniquacQ = 2.976, ChaoSeadAF = 0.446737, ChaoSeadSP = 31830, ChaoSeadLV = 0.0603415);
  end Monoethanolamine;
  
  model Diethanolamine
  extends General_Properties(
    SN = 368, name = "Diethanolamine", CAS = "111-42-2", Tc = 736.6, Pc = 4720000,  Vc = 0.349, Cc = 0.243, Tb = 542, Tm = 301.15, TT = 301.15, TP = 0.102031, MW = 105.136, LVB = 0.096244, AF = 0.991515, SP = 29260, DM = 2.84E-30, SH = -22600000.0, IGHF = -3.73E+08, GEF = -2.2574E+08, AS = 429000, HFMP = 2.5104E+07, HOC = -2.4439E+09, LiqDen = {105,0.5251,0.20924,736.61,0.18363,0}, VP = {10,23.735,5441.7,-95.519,0,0}, LiqCp = {4,88234.68,483.2566,0.294569,-0.000214761,0}, HOV = {106,7.90134E+07,-1.865152,6.820965,-7.963053,3.251551}, VapCp = {16,92216,-624.1,12.938,-0.00014779,6.6337E-08}, LiqVis = {101,-0.28702,6080.5,-3.8708,0.00001517,2}, VapVis = {102,4.7852E-08,0.89857,99.058,-7265.2,0}, LiqK = {16,-0.91328,16.824,-0.15997,0.0011516,-0.0000013756}, VapK = {102,-10221,0.42596,-2.5172E+09,-7.9932E+10,0}, Racketparam = 0.243, UniquacR = 5.2302, UniquacQ = 4.956, ChaoSeadAF = 0.952882, ChaoSeadSP = 29260, ChaoSeadLV = 0.096244);
  end Diethanolamine;
  
  model Triethanolamine
  extends General_Properties(
    SN = 369, name = "Triethanolamine", CAS = "102-71-6", Tc = 787, Pc = 3590000,  Vc = 0.472, Cc = 0.202, Tb = 613, Tm = 294.35, TT = 294.35, TP = 0.000287009, MW = 149.188, LVB = 0.132992, AF = 1.28411, SP = 27430, DM = 3.6E-30, SH = -22600000.0, IGHF = -5.54E+08, GEF = -2.994E+08, AS = 538000, HFMP = 2.7191E+07, HOC = -3.5025E+09, LiqDen = {105,0.028938,0.058014,787,0.099632,0}, VP = {101,283.76,-24672,-37.048,0.000015689,2}, LiqCp = {16,285560,313.35,6.351,0.016374,-0.000012842}, HOV = {106,1.354875E+08,0.343894,0.961738,-1.466285,0.442687}, VapCp = {16,114870,-616.04,13.509,-0.00048074,2.2464E-07}, LiqVis = {101,33.605,4399.7,-8.9203,0.000021038,2}, VapVis = {102,3.0013E-08,0.95199,45.139,-3355.9,0}, LiqK = {16,-0.76863,26.11,-0.3374,0.0010847,-0.0000011937}, VapK = {102,0.043843,0.38395,6681.4,1202500,0}, Racketparam = 0.202, UniquacR = 7.3317, UniquacQ = 6.932, ChaoSeadAF = 1.28411, ChaoSeadSP = 27430, ChaoSeadLV = 0.132992);
  end Triethanolamine;
  
  model Ethylenediamine
  extends General_Properties(
    SN = 370, name = "Ethylenediamine", CAS = "107-15-3", Tc = 592.95, Pc = 6290000,  Vc = 0.206, Cc = 0.337, Tb = 390.15, Tm = 281.65, TT = 284.29, TP = 677.511, MW = 60.0983, LVB = 0.0672757, AF = 0.472367, SP = 25200, DM = 6.34E-30, SH = -22600000.0, IGHF = -1.78E+07, GEF = 1.032E+08, AS = 321833, HFMP = 109700, HOC = -1.691E+09, LiqDen = {105,0.77469,0.20588,592.95,0.20098,0}, VP = {101,133.543,-9787.615,-16.57909,0.0000129717,2}, LiqCp = {16,143860,434.68,4.2425,0.021662,-0.000021123}, HOV = {106,7.5708E+07,1.0826,-0.65481,-0.27019,0.25065}, VapCp = {16,58340,-554.75,12.205,0.00022368,-7.8562E-08}, LiqVis = {101,-9.2076,2247.2,-0.93509,0.0000071501,2}, VapVis = {102,2.0005E-07,0.70929,192.67,-6383.4,0}, LiqK = {16,0.020715,-158.25,0.1953,-0.004385,0.0000010035}, VapK = {102,0.16528,0.18013,3835.1,1598900,0}, Racketparam = 0.337, UniquacR = 2.7384, UniquacQ = 2.472, ChaoSeadAF = 0, ChaoSeadSP = 0, ChaoSeadLV = 0);
  end Ethylenediamine;
  
  model Diisopropylamine
  extends General_Properties(
    SN = 371, name = "Diisopropylamine", CAS = "108-18-9", Tc = 522.15, Pc = 3200000,  Vc = 0.031, Cc = 0.308, Tb = 357.05, Tm = 176.85, TT = 176.85, TP = 0.00447237, MW = 101.19, LVB = 0.141919, AF = 0.388315, SP = 15060, DM = 0, SH = -22600000.0, IGHF = -1.5E+08, GEF = 6.42E+07, AS = 412000, HFMP = 6530000, HOC = -3.99E+09, LiqDen = {105,0.72754,0.27918,522.15,0.29458,0}, VP = {101,237.36,-12403,-33.276,0.000035165,2}, LiqCp = {16,150380,276.56,5.7411,0.021881,-0.000021998}, HOV = {106,8.537039E+07,-2.459337,14.73933,-19.70849,7.844199}, VapCp = {16,61641,-432.93,12.839,0.00037342,-1.4329E-07}, LiqVis = {101,-7.0105,766.59,-0.57101,-0.0000016173,2}, VapVis = {102,5.4462E-07,0.56686,334.62,-4787.5,0}, LiqK = {16,0.046488,-113.84,-0.63846,-0.0065631,0.0000029442}, VapK = {102,0.00048482,0.81453,349.64,151910,0}, Racketparam = 0.308, UniquacR = 5.0308, UniquacQ = 4.244, ChaoSeadAF = 0, ChaoSeadSP = 0, ChaoSeadLV = 0);
  end Diisopropylamine;
  
  model Naminoethylpiperazine
  extends General_Properties(
    SN = 372, name = "Naminoethylpiperazine", CAS = "140-31-8", Tc = 708, Pc = 3850000,  Vc = 0.475, Cc = 0.266, Tb = 495.15, Tm = 254.15, TT = 254.15, TP = 0.0694812, MW = 129.203, LVB = 0.132257, AF = 0.557243, SP = 21520, DM = 0, SH = -22600000.0, IGHF = 2.51E+07, GEF = 2.79E+08, AS = 451000, HFMP = 0, HOC = -4.135E+09, LiqDen = {105,0.66681,0.27137,708,0.27214,0}, VP = {101,127.7429,-12067.23,-15.04915,6.424073E-06,2}, LiqCp = {16,259220,331.04,3.608,0.023605,-0.000018248}, HOV = {106,9.785579E+07,0.814708,0.0237006,-0.690218,0.260899}, VapCp = {16,70888,-450.73,13.066,0.00018285,-6.5268E-08}, LiqVis = {101,-497.9054,22666.52,74.36022,-0.0000702789,2}, VapVis = {102,7.7705E-08,0.8233,132.06,-8963.7,0}, LiqK = {16,-0.089882,-7.0061,-1.0711,-0.00065668,-0.0000005629}, VapK = {102,0.00012973,0.99814,630.8,21962,0}, Racketparam = 0.266, UniquacR = 5.5591, UniquacQ = 4.424, ChaoSeadAF = 0.557243, ChaoSeadSP = 21520, ChaoSeadLV = 0.132257);
  end Naminoethylpiperazine;
  
  model Diethylenetriamine
  extends General_Properties(
    SN = 373, name = "Diethylenetriamine", CAS = "111-40-0", Tc = 676, Pc = 4220000,  Vc = 0.426, Cc = 0.257, Tb = 480, Tm = 234, TT = 234.15, TP = 0.0524649, MW = 103.166, LVB = 0.108088, AF = 0.70022, SP = 22210, DM = 0, SH = -22600000.0, IGHF = -5860000, GEF = 2.07293E+08, AS = 444000, HFMP = 1.97E+07, HOC = -3.08E+09, LiqDen = {105,0.75082,0.25686,676,0.285,0}, VP = {101,100.1854,-10608.36,-10.96201,4.74905E-06,2}, LiqCp = {16,42291,-130.86,11.696,0.0024243,-0.0000011576}, HOV = {106,6.200873E+07,-0.521717,2.922507,-3.785965,1.591946}, VapCp = {16,73737,-451.7,12.705,0.00030197,-1.0181E-07}, LiqVis = {101,-10.117,2075.7,-0.40711,6.9322E-07,2}, VapVis = {102,5.7285E-08,0.85783,72.519,-3817.5,0}, LiqK = {16,-0.078667,1.4114,-1.3167,-0.00041656,-8.7844E-07}, VapK = {102,0.00017737,0.94914,591.08,27011,0}, Racketparam = 0.257, UniquacR = 4.6198, UniquacQ = 3.948, ChaoSeadAF = 0.70022, ChaoSeadSP = 22210, ChaoSeadLV = 0.108088);
  end Diethylenetriamine;
  
  model Naminoethylethanolamine
  extends General_Properties(
    SN = 374, name = "Naminoethylethanolamine", CAS = "111-41-1", Tc = 698, Pc = 4460000,  Vc = 0.387, Cc = 0.252, Tb = 517, Tm = 0, TT = 0, TP = 0, MW = 104.151, LVB = 0.101519, AF = 1.04726, SP = 29230, DM = 0, SH = -22600000.0, IGHF = -1.91E+08, GEF = 3810000, AS = 447000, HFMP = 0, HOC = -2.74E+09, LiqDen = {105,0.76828,0.25238,698,0.28565,0}, VP = {101,214.43,-18769,-27.15,0.00001141,2}, LiqCp = {16,65604,-121.74,11.802,0.0023485,-7.9478E-07}, HOV = {106,1.2005E+08,0.3465,0.971,-1.7132,0.81091}, VapCp = {16,75533,-495.37,12.77,0.00015714,-4.9852E-08}, LiqVis = {101,-27.66295,5326.5,1.362383,-1.706454E-06,2}, VapVis = {102,1.2606E-07,0.76222,173.4,-8594.2,0}, LiqK = {16,-0.1257,-10.607,-0.88928,-0.00060102,-5.9478E-07}, VapK = {102,0.00019261,0.93731,615.43,23918,0}, Racketparam = 0.252, UniquacR = 4.925, UniquacQ = 4.452, ChaoSeadAF = 1.04726, ChaoSeadSP = 29230, ChaoSeadLV = 0.101519);
  end Naminoethylethanolamine;
  
  model Pphenylenediamine
  extends General_Properties(
    SN = 375, name = "Pphenylenediamine", CAS = "106-50-3", Tc = 796, Pc = 5180000,  Vc = 0.377, Cc = 0.248, Tb = 540, Tm = 419, TT = 413, TP = 1388.21, MW = 108.141, LVB = 0.102198, AF = 0.53864, SP = 24810, DM = 5.1E-30, SH = -22600000.0, IGHF = 9.12E+07, GEF = 2.1E+08, AS = 349000, HFMP = 2.68E+07, HOC = -3.33E+09, LiqDen = {105,0.78274,0.24798,796,0.28573,0}, VP = {101,120.7365,-13060.28,-13.71648,4.333592E-06,2}, LiqCp = {16,199750,494.23,5.1045,0.015817,-0.000010858}, HOV = {106,1.0783E+08,1.6408,-3.3392,3.5461,-1.4179}, VapCp = {16,58132,-482.33,12.882,-0.000085339,9.0492E-09}, LiqVis = {101,-8.9816,2291,-0.53494,2.8717E-07,2}, VapVis = {102,1.4679E-07,0.74191,224.79,-11478,0}, LiqK = {16,0.0030572,-268.6,0.38244,-0.0036549,8.2114E-07}, VapK = {102,0.000070276,1.0203,189.91,62690,0}, Racketparam = 0.248, UniquacR = 4.2452, UniquacQ = 3.232, ChaoSeadAF = 0.53864, ChaoSeadSP = 24810, ChaoSeadLV = 0);
  end Pphenylenediamine;
  
  model Piperazine
  extends General_Properties(
    SN = 376, name = "Piperazine", CAS = "110-85-0", Tc = 656.3, Pc = 5420000,  Vc = 0.267, Cc = 0.2652, Tb = 419.15, Tm = 379.15, TT = 379.15, TP = 26372.2, MW = 86.1356, LVB = 0.129371, AF = 0.269668, SP = 17960, DM = 4.90339E-30, SH = -22600000.0, IGHF = 2.26E+07, GEF = 1.7E+08, AS = 321000, HFMP = 1.17E+07, HOC = -2.76E+09, LiqDen = {105,1.4074,0.323,638,0.28571,0}, VP = {101,143.27,-11245,-17.657,0.0000096236,2}, LiqCp = {4,32886.27,346.6189,0.473406,-0.000434168,0}, HOV = {106,6.6945E+07,0.99602,-2.0069,2.4018,-0.97129}, VapCp = {16,68463,-744.16,13.556,-0.00073698,1.7652E-07}, LiqVis = {101,24.341,105.42,-5.6537,0.0000060109,2}, VapVis = {102,0.0000022951,0.42453,937.27,-18307,0}, LiqK = {16,0.029211,-334.85,0.86034,-0.0073343,0.0000029317}, VapK = {102,0.0014866,0.6319,-11.551,345800,0}, Racketparam = 0.323, UniquacR = 3.7628, UniquacQ = 2.952, ChaoSeadAF = 0.41376, ChaoSeadSP = 17960, ChaoSeadLV = 0.129371);
  end Piperazine;
  
  model Methylethanolamine
  extends General_Properties(
    SN = 377, name = "Methylethanolamine", CAS = "109-83-1", Tc = 630, Pc = 5300000,  Vc = 0.25901, Cc = 0.262, Tb = 432.388, Tm = 268.65, TT = 268.65, TP = 11.1091, MW = 75.112, LVB = 0.082206, AF = 0.604, SP = 25930, DM = 7.2E-30, SH = -22600000.0, IGHF = -1.98E+08, GEF = -6.11E+07, AS = 344000, HFMP = 8760000, HOC = -2.01E+09, LiqDen = {105,0.982868,0.255663,630,0.231239,0}, VP = {101,101.1268,-9896.461,-11.12231,4.333878E-06,2}, LiqCp = {4,65879.9,415.0007,0.00004583,2.109E-09,-0.0000030816}, HOV = {106,8.3715E+07,1.1304,-1.7736,1.7333,-0.66961}, VapCp = {16,50351,-464.92,12.353,0.00032078,-1.1521E-07}, LiqVis = {101,-8.8113,2947,-0.99316,4.0603E-07,2}, VapVis = {102,2.1919E-07,0.70935,211,-8775.4,0}, LiqK = {16,-0.011378,-96.849,-0.47605,-0.0029428,4.7129E-07}, VapK = {102,0.00021463,0.94857,622.07,15372,0}, Racketparam = 0.262, UniquacR = 3.7825, UniquacQ = 3.524, ChaoSeadAF = 0.604, ChaoSeadSP = 25930, ChaoSeadLV = 0.082206);
  end Methylethanolamine;
  
  model Dimethylethanolamine
  extends General_Properties(
    SN = 378, name = "Dimethylethanolamine", CAS = "108-01-0", Tc = 571.82, Pc = 4140000,  Vc = 0.331, Cc = 0.261, Tb = 404.15, Tm = 214.15, TT = 214.15, TP = 0.0376223, MW = 89.1362, LVB = 0.101094, AF = 0.710963, SP = 22790, DM = 7.37E-30, SH = -22600000.0, IGHF = -2.02E+08, GEF = -3.64E+07, AS = 384000, HFMP = 0, HOC = -2.65E+09, LiqDen = {105,0.87166,0.26133,571.82,0.28585,0}, VP = {101,121.6094,-10451.37,-14.23754,0.000006927,2}, LiqCp = {16,66692,-55.489,10.897,0.0047237,-0.0000030382}, HOV = {106,7.9011E+07,0.56455,-0.031757,-0.28621,0.17191}, VapCp = {16,71203,-582.55,12.891,-0.000082299,3.2172E-08}, LiqVis = {101,-15.376,3350.8,-0.34232,9.4723E-07,2}, VapVis = {102,1.2904E-07,0.77955,165.36,-6888.3,0}, LiqK = {16,-0.083559,-10.945,-0.99458,-0.00097463,-8.1342E-07}, VapK = {102,0.00023136,0.92757,412.5,95357,0}, Racketparam = 0.261, UniquacR = 4.4363, UniquacQ = 4.068, ChaoSeadAF = 0.710963, ChaoSeadSP = 22790, ChaoSeadLV = 0.101094);
  end Dimethylethanolamine;
  
  model Nitromethane
  extends General_Properties(
    SN = 379, name = "Nitromethane", CAS = "75-52-5", Tc = 588, Pc = 5870000,  Vc = 0.173, Cc = 0.208, Tb = 374.35, Tm = 244.6, TT = 244.6, TP = 146.529, MW = 61.04, LVB = 0.05396, AF = 0.348026, SP = 25700, DM = 1.15E-29, SH = -22600000.0, IGHF = -7.48E+07, GEF = -6940000, AS = 275000, HFMP = 9703000, HOC = -6.432E+08, LiqDen = {105,1.2195,0.22476,588.16,0.2787,0}, VP = {101,93.27,-7345.1,-10.689,0.0000086998,2}, LiqCp = {16,80588,345.48,6.7575,0.0084794,-0.0000031326}, HOV = {106,4.160998E+07,-0.662124,2.67118,-2.702805,0.931262}, VapCp = {16,38681,-615.84,11.895,0.000023118,-2.9677E-08}, LiqVis = {101,-10.411,1047.6,-0.095445,6.9198E-07,2}, VapVis = {102,4.2141E-07,0.64539,383.4,-1344.5,0}, LiqK = {16,0.050889,-150.55,-0.2952,-0.0028403,-0.0000022109}, VapK = {102,0.000031393,1.1117,-91.903,128140,0}, Racketparam = 0.208, UniquacR = 2.0086, UniquacQ = 1.868, ChaoSeadAF = 0.348026, ChaoSeadSP = 257, ChaoSeadLV = 0);
  end Nitromethane;
  
  model Nitroethane
  extends General_Properties(
    SN = 380, name = "Nitroethane", CAS = "79-24-3", Tc = 557.15, Pc = 5160000,  Vc = 0.236, Cc = 0.247, Tb = 387.22, Tm = 183.63, TT = 183.63, TP = 0.0317711, MW = 75.0666, LVB = 0.0720005, AF = 0.672348, SP = 23090, DM = 1.22E-29, SH = -22600000.0, IGHF = -1.022E+08, GEF = -4900000, AS = 315400, HFMP = 9853000, HOC = -1.25E+09, LiqDen = {105,0.90007,0.22451,593.01,0.26359,0}, VP = {101,81.03385,-7188.308,-8.680357,0.0000053196,2}, LiqCp = {16,67990,798.52,2.4874,0.02816,-0.000027001}, HOV = {106,5.428692E+07,0.314015,-0.225443,1.068645,-0.953684}, VapCp = {16,48198,-581.79,12.283,0.000023838,-2.2739E-08}, LiqVis = {101,15.403,194.75,-4.2217,0.0000078126,2}, VapVis = {102,2.4631E-07,0.70062,285.76,-1030.8,0}, LiqK = {16,-0.1486,6.324,-1.0708,0.00009663,-0.0000015981}, VapK = {102,0.0011064,0.69186,675.03,236860,0}, Racketparam = 0.247, UniquacR = 2.6829, UniquacQ = 2.408, ChaoSeadAF = 0.380324, ChaoSeadSP = 23090, ChaoSeadLV = 0.0720005);
  end Nitroethane;
  
  model Onenitropropane
  extends General_Properties(
    SN = 381, name = "Onenitropropane", CAS = "108-03-2", Tc = 605, Pc = 4350000,  Vc = 0.288, Cc = 0.249, Tb = 404.33, Tm = 169.16, TT = 169.16, TP = 0.000688982, MW = 89.0932, LVB = 0.0894679, AF = 0.412773, SP = 21290, DM = 1.22E-29, SH = -22600000.0, IGHF = -1.24E+08, GEF = 335000, AS = 355600, HFMP = 9220000, HOC = -1.859E+09, LiqDen = {105,0.85075,0.24483,605,0.27413,0}, VP = {101,38.65807,-5750.644,-2.115655,-1.225423E-06,2}, LiqCp = {16,-8835.6,176.43,9.53,0.0096176,-0.0000099253}, HOV = {106,5.6307E+07,0.47767,-0.18338,0.057255,-0.028311}, VapCp = {16,57745,-538.37,12.483,0.00011202,-5.1502E-08}, LiqVis = {101,-19.997,1653,1.2605,0.0000015194,2}, VapVis = {102,1.7108E-07,0.7401,220.03,-15.073,0}, LiqK = {16,-0.068381,13.221,-1.3628,-0.00024357,-0.0000012535}, VapK = {102,0.0022117,0.61538,875.34,312410,0}, Racketparam = 0.249, UniquacR = 3.3573, UniquacQ = 2.948, ChaoSeadAF = 0.412773, ChaoSeadSP = 21290, ChaoSeadLV = 0.0894679);
  end Onenitropropane;
  
  model Twonitropropane
  extends General_Properties(
    SN = 382, name = "Twonitropropane", CAS = "79-46-9", Tc = 595, Pc = 4450000,  Vc = 0.288, Cc = 0.26, Tb = 393.4, Tm = 181.83, TT = 181.83, TP = 0.021584, MW = 89.0932, LVB = 0.0905535, AF = 0.383568, SP = 20530, DM = 1.24E-29, SH = -22600000.0, IGHF = -1.39E+08, GEF = -1.2803E+07, AS = 347700, HFMP = 7790000, HOC = -1.846E+09, LiqDen = {105,0.27031,0.13967,595,0.17588,0}, VP = {101,57.04038,-6262.318,-4.993807,1.61213E-06,2}, LiqCp = {16,67863,138.63,8.8679,0.01051,-0.00001051}, HOV = {106,5.543435E+07,0.377393,0.18894,-0.0391329,-0.243258}, VapCp = {16,58543,-558.36,12.559,0.000040137,-3.1383E-08}, LiqVis = {101,-26.48,1441.6,2.6439,-0.0000074647,2}, VapVis = {102,0.000005644,0.32789,1291.7,6279.8,0}, LiqK = {16,0.085284,-50.915,-1.467,-0.0035856,-0.000001687}, VapK = {102,0.0042281,0.52696,790.25,431610,0}, Racketparam = 0.26, UniquacR = 3.3573, UniquacQ = 2.948, ChaoSeadAF = 0.383568, ChaoSeadSP = 20530, ChaoSeadLV = 0.0905535);
  end Twonitropropane;
  
  model Onenitrobutane
  extends General_Properties(
    SN = 383, name = "Onenitrobutane", CAS = "627-05-4", Tc = 623, Pc = 3600000,  Vc = 0.338, Cc = 0.248, Tb = 425.92, Tm = 191.82, TT = 191.82, TP = 0.00329301, MW = 103.12, LVB = 0.106476, AF = 0.454584, SP = 20780, DM = 1.13E-29, SH = -22600000.0, IGHF = -1.439E+08, GEF = 1.5E+07, AS = 379100, HFMP = 1.27E+07, HOC = -2.46965E+09, LiqDen = {105,0.709,0.24401,623,0.28339,0}, VP = {101,275.2044,-15483.84,-38.70231,0.0000386,2}, LiqCp = {16,56152,6.6387,10.762,0.003942,-0.0000013791}, HOV = {106,5.525605E+07,-1.025854,4.47262,-4.675607,1.466497}, VapCp = {16,69545,-548.77,12.729,0.0001233,-6.7656E-08}, LiqVis = {101,-8.4776,1274.9,-0.51437,0.0000019485,2}, VapVis = {102,9.0308E-08,0.82266,144.36,-9193.7,0}, LiqK = {16,-0.088752,4.014,-1.2388,-0.00043694,-0.0000009691}, VapK = {102,0.00013665,0.98745,630.3,15608,0}, Racketparam = 0.248, UniquacR = 4.0317, UniquacQ = 3.488, ChaoSeadAF = 0.454584, ChaoSeadSP = 20780, ChaoSeadLV = 0.106476);
  end Onenitrobutane;
  
  model Onitrotoluene
  extends General_Properties(
    SN = 384, name = "Onitrotoluene", CAS = "88-72-2", Tc = 720, Pc = 3800000,  Vc = 0.441, Cc = 0.28, Tb = 494.85, Tm = 269.65, TT = 269.98, TP = 1.72928, MW = 137.136, LVB = 0.118442, AF = 0.487824, SP = 21420, DM = 1.25E-29, SH = -22600000.0, IGHF = 4.71E+07, GEF = 1.715E+08, AS = 380800, HFMP = 1.148E+07, HOC = -3.5914E+09, LiqDen = {105,0.49527,0.21852,720,0.27202,0}, VP = {101,110.496,-10356.21,-12.86215,7.080827E-06,2}, LiqCp = {16,167320,675.67,2.8482,0.023742,-0.00001748}, HOV = {106,7.853006E+07,0.959622,-1.263212,1.073123,-0.436452}, VapCp = {16,126830,-1053.5,13.982,-0.0011308,3.2272E-07}, LiqVis = {101,-227.78,9560.6,33.954,-0.00004379,2}, VapVis = {102,3.9111E-08,0.92063,61.279,-2619.3,0}, LiqK = {16,-0.28005,20.455,-0.90478,0.000049377,-4.8022E-07}, VapK = {102,0.00013501,0.95252,632.43,27080,0}, Racketparam = 0.28, UniquacR = 4.2801, UniquacQ = 3.272, ChaoSeadAF = 0.487824, ChaoSeadSP = 21420, ChaoSeadLV = 0.118442);
  end Onitrotoluene;
  
  model Pnitrotoluene
  extends General_Properties(
    SN = 385, name = "Pnitrotoluene", CAS = "99-99-0", Tc = 736, Pc = 3800000,  Vc = 0.441, Cc = 0.229, Tb = 511.15, Tm = 325.05, TT = 324.75, TP = 40.4829, MW = 137.136, LVB = 0.121894, AF = 0.542405, SP = 21110, DM = 1.48E-29, SH = -22600000.0, IGHF = 3.1E+07, GEF = 1.554E+08, AS = 380800, HFMP = 1.6676E+07, HOC = -3.553E+09, LiqDen = {105,0.76802,0.27463,736,0.3126,0}, VP = {101,115.4618,-11239.6,-13.3636,5.387653E-06,2}, LiqCp = {16,90280,945.96,3.9359,0.019415,-0.000013352}, HOV = {106,1.550237E+08,1.89329,-1.014085,-0.0168324,-0.442436}, VapCp = {16,126830,-1053.5,13.982,-0.0011308,3.2272E-07}, LiqVis = {101,-164.01,7455.2,23.73,-0.000026464,2}, VapVis = {102,4.1207E-08,0.91154,64.997,-92.66,0}, LiqK = {16,-0.1404,23.385,-1.2743,-0.000067534,-5.8708E-07}, VapK = {102,0.000064675,1.0353,391.41,37904,0}, Racketparam = 0.229, UniquacR = 4.2801, UniquacQ = 3.272, ChaoSeadAF = 0.425222, ChaoSeadSP = 21110, ChaoSeadLV = 0.121894);
  end Pnitrotoluene;
  
  model Mnitrotoluene
  extends General_Properties(
    SN = 386, name = "Mnitrotoluene", CAS = "99-08-1", Tc = 734, Pc = 3800000,  Vc = 0.441, Cc = 0.275, Tb = 504, Tm = 288.65, TT = 289.2, TP = 6.84272, MW = 137.136, LVB = 0.118913, AF = 0.491987, SP = 21470, DM = 1.41E-29, SH = -22600000.0, IGHF = 2.58E+07, GEF = 1.502E+08, AS = 380800, HFMP = 1.406E+07, HOC = -3.5696E+09, LiqDen = {105,0.50673,0.22353,734,0.25642,0}, VP = {101,174.0974,-13266.49,-22.50751,0.0000146534,2}, LiqCp = {16,165480,678.6,2.6976,0.024579,-0.000018568}, HOV = {106,1.23147E+08,2.991682,-5.10633,3.432299,-0.844633}, VapCp = {16,126830,-1053.5,13.982,-0.0011308,3.2272E-07}, LiqVis = {101,-219.04,9323.8,32.506,-0.000040609,2}, VapVis = {102,3.6657E-08,0.9283,56.912,-1935.8,0}, LiqK = {16,-0.16653,2.5129,-1.0577,-0.0003596,-3.0249E-07}, VapK = {102,0.00013182,0.95336,611.68,32295,0}, Racketparam = 0.275, UniquacR = 4.2801, UniquacQ = 3.272, ChaoSeadAF = 0.491987, ChaoSeadSP = 21470, ChaoSeadLV = 0.118913);
  end Mnitrotoluene;
  
  model TwoFourdinitrotoluene
  extends General_Properties(
    SN = 387, name = "TwoFourdinitrotoluene", CAS = "121-14-2", Tc = 814, Pc = 3400000,  Vc = 0.487, Cc = 0.245, Tb = 553, Tm = 333, TT = 342.65, TP = 7.8719, MW = 182.134, LVB = 0.137448, AF = 0.712571, SP = 21470, DM = 1.44E-29, SH = -22600000.0, IGHF = 3.36E+07, GEF = 2.18E+08, AS = 414000, HFMP = 2.0126E+07, HOC = -3.416E+09, LiqDen = {105,0.5108,0.24037,814,0.26806,0}, VP = {101,128.9329,-13393.44,-15.15736,5.597038E-06,2}, LiqCp = {16,88958,1324.4,2.7528,0.019721,-0.000011079}, HOV = {106,1.2919E+08,1.3248,1.0872,-4.8737,2.858}, VapCp = {16,94512,-582.56,13.27,-0.00026587,5.3735E-08}, LiqVis = {101,-41.408,3947.7,4.2203,-0.0000035178,2}, VapVis = {102,1.9809E-08,1.0159,22.316,-3670.3,0}, LiqK = {16,-0.057001,-67.01,-0.90194,-0.0013614,-3.0209E-08}, VapK = {102,0.00011852,0.95914,734.05,13896,0}, Racketparam = 0.245, UniquacR = 5.7, UniquacQ = 4.376, ChaoSeadAF = 0.712571, ChaoSeadSP = 21470, ChaoSeadLV = 0.137448);
  end TwoFourdinitrotoluene;
  
  model Two6dinitrotoluene
  extends General_Properties(
    SN = 388, name = "Two6dinitrotoluene", CAS = "606-20-2", Tc = 780, Pc = 3400000,  Vc = 0.487, Cc = 0.242, Tb = 553, Tm = 339, TT = 337.85, TP = 24.9565, MW = 182.134, LVB = 0.136568, AF = 0.714206, SP = 20760, DM = 9.37E-30, SH = -22600000.0, IGHF = 2.86E+07, GEF = 2.32E+08, AS = 414000, HFMP = 2.12E+07, HOC = -3.429E+09, LiqDen = {105,0.27332,0.17415,780,0.22386,0}, VP = {101,115.7657,-12082.2,-13.31782,5.09858E-06,2}, LiqCp = {16,163490,785.69,5.0684,0.014589,-0.0000070833}, HOV = {106,1.041715E+08,1.247529,0.0309575,-2.851863,1.938855}, VapCp = {16,94512,-582.56,13.27,-0.00026587,5.3735E-08}, LiqVis = {101,-70.386,5310.9,8.6262,-0.0000081126,2}, VapVis = {102,5.9592E-08,0.88167,135.78,-11605,0}, LiqK = {16,-0.039901,-99.466,-0.76681,-0.0019329,1.8512E-07}, VapK = {102,0.00015932,0.92355,690.15,19720,0}, Racketparam = 0.242, UniquacR = 5.7, UniquacQ = 4.376, ChaoSeadAF = 0.714206, ChaoSeadSP = 20760, ChaoSeadLV = 0.136568);
  end Two6dinitrotoluene;
  
  model ThreeFourdinitrotoluene
  extends General_Properties(
    SN = 389, name = "ThreeFourdinitrotoluene", CAS = "610-39-9", Tc = 842, Pc = 3400000,  Vc = 0.487, Cc = 0.237, Tb = 610, Tm = 331.45, TT = 331.45, TP = 2.66366, MW = 182.134, LVB = 0.139231, AF = 0.709209, SP = 21410, DM = 2.13E-29, SH = -22600000.0, IGHF = 3.58E+07, GEF = 2.59E+08, AS = 414000, HFMP = 2.08E+07, HOC = -3.466E+09, LiqDen = {105,0.48567,0.23619,842,0.28583,0}, VP = {101,62.33838,-11025.98,-5.109566,1.997931E-07,2}, LiqCp = {16,144440,677.88,6.2554,0.011911,-0.000005235}, HOV = {106,6.888359E+07,-1.153409,5.750305,-8.495374,4.124815}, VapCp = {16,94512,-582.56,13.27,-0.00026587,5.3735E-08}, LiqVis = {101,-13.817,2734.2,0.029663,-2.4471E-08,2}, VapVis = {102,2.8655E-08,0.96106,104.06,-10189,0}, LiqK = {16,-0.082395,-25.284,-1.0996,-0.00075328,-2.6136E-07}, VapK = {102,0.0001043,0.96342,702.61,22699,0}, Racketparam = 0.237, UniquacR = 5.7, UniquacQ = 4.376, ChaoSeadAF = 0.709209, ChaoSeadSP = 21410, ChaoSeadLV = 0.139231);
  end ThreeFourdinitrotoluene;
  
  model TwoFivedinitrotoluene
  extends General_Properties(
    SN = 390, name = "TwoFivedinitrotoluene", CAS = "619-15-8", Tc = 814, Pc = 3400000,  Vc = 0.487, Cc = 0.237, Tb = 590, Tm = 325.65, TT = 323.48, TP = 3.04164, MW = 182.134, LVB = 0.135666, AF = 0.712285, SP = 21390, DM = 1.93E-30, SH = -22600000.0, IGHF = 2.71E+07, GEF = 2.36E+08, AS = 414000, HFMP = 2.03E+07, HOC = -3.446E+09, LiqDen = {105,0.50237,0.23693,814,0.28571,0}, VP = {101,90.89499,-12036.13,-9.395524,2.853055E-06,2}, LiqCp = {16,152220,711.2,5.8598,0.012789,-0.0000058246}, HOV = {106,5.5817E+07,-1.8578,6.6656,-8.4526,3.8136}, VapCp = {16,94512,-582.56,13.27,-0.00026587,5.3735E-08}, LiqVis = {101,-10.391,2604.7,-0.5024,5.1688E-07,2}, VapVis = {102,3.8924E-08,0.93015,82.835,-8099.3,0}, LiqK = {16,-0.078898,-29.065,-1.0796,-0.00084649,-2.5074E-07}, VapK = {102,0.0001568,0.92031,704.11,20197,0}, Racketparam = 0.237, UniquacR = 5.7, UniquacQ = 4.376, ChaoSeadAF = 0.712285, ChaoSeadSP = 21390, ChaoSeadLV = 0.135666);
  end TwoFivedinitrotoluene;
  
  model ThreeFivedinitrotoluene
  extends General_Properties(
    SN = 391, name = "ThreeFivedinitrotoluene", CAS = "618-85-9", Tc = 800, Pc = 2150000,  Vc = 0.487, Cc = 0.238, Tb = 588, Tm = 366.15, TT = 365.65, TP = 35.4684, MW = 182.134, LVB = 0.140577, AF = 0.702302, SP = 21440, DM = 1.44E-29, SH = -22600000.0, IGHF = 2.71E+07, GEF = 2.34E+08, AS = 414000, HFMP = 2.29E+07, HOC = -3.437E+09, LiqDen = {105,0.45727,0.227,814.01,0.27155,0}, VP = {101,63.61855,-10355.64,-5.423477,2.374318E-07,2}, LiqCp = {16,211860,-5.3058,8.1208,0.009225,-0.0000034389}, HOV = {106,5.989509E+07,-0.991558,3.414071,-4.448985,2.238465}, VapCp = {16,94512,-582.56,13.27,-0.00026587,5.3735E-08}, LiqVis = {101,-0.25652,2097.7,-2.0147,0.0000014987,2}, VapVis = {102,4.7633E-08,0.90246,116.57,-8469.6,0}, LiqK = {16,-0.029795,-134.57,-0.63203,-0.0021751,3.0388E-07}, VapK = {102,0.00014433,0.92815,684.42,24021,0}, Racketparam = 0.238, UniquacR = 5.7, UniquacQ = 4.376, ChaoSeadAF = 0.702302, ChaoSeadSP = 21440, ChaoSeadLV = 0.140577);
  end ThreeFivedinitrotoluene;
  
  model TwoFour6trinitrotoluene
  extends General_Properties(
    SN = 392, name = "TwoFour6trinitrotoluene", CAS = "118-96-7", Tc = 795, Pc = 3040000,  Vc = 0.48, Cc = 0.253, Tb = 573, Tm = 355, TT = 354, TP = 0.936248, MW = 227.131, LVB = 0.154989, AF = 0.897249, SP = 23070, DM = 3.87E-30, SH = -22600000.0, IGHF = 1.64E+07, GEF = 2.844E+08, AS = 460700, HFMP = 2.12E+07, HOC = -3.2919E+09, LiqDen = {105,0.99663,0.34261,803.06,0.50647,0}, VP = {101,245.81,-20425,-32.225,0.00001503,2}, LiqCp = {16,188750,750.94,4.5661,0.019107,-0.00001348}, HOV = {106,2.111008E+07,-12.33056,37.27643,-41.67226,16.622}, VapCp = {16,209680,-1410.9,14.902,-0.0017672,4.5403E-07}, LiqVis = {101,92.002,-1238.6,-16.127,0.000013297,2}, VapVis = {102,5.1205E-08,0.89283,134.66,-13583,0}, LiqK = {16,-0.10196,-488.31,0.35873,-0.0039133,0.0000039064}, VapK = {102,0.00015986,0.89621,647.63,36973,0}, Racketparam = 0.253, UniquacR = 6.5886, UniquacQ = 5.08, ChaoSeadAF = 0.897249, ChaoSeadSP = 23070, ChaoSeadLV = 0.154989);
  end TwoFour6trinitrotoluene;
  
  model Oxalicacid
  extends General_Properties(
    SN = 393, name = "Oxalicacid", CAS = "144-62-7", Tc = 804, Pc = 7020000,  Vc = 0.205, Cc = 0.215, Tb = 569, Tm = 462.65, TT = 462.65, TP = 2152.34, MW = 90.0349, LVB = 0.0614585, AF = 0.917597, SP = 35980, DM = 8.77E-30, SH = -22600000.0, IGHF = -7.338E+08, GEF = -6.614E+08, AS = 343300, HFMP = 0, HOC = -2.01E+08, LiqDen = {105,1.0501,0.215,804,0.28571,0}, VP = {101,216.92,-20979,-27.004,0.0000086326,2}, LiqCp = {16,81965,-1.9623,9.0826,0.0038828,2.1663E-07}, HOV = {106,1.2079E+08,0.30321,0.62049,-0.9257,0.38682}, VapCp = {16,25231,-1473.6,15.259,-0.0058042,0.0000026122}, LiqVis = {0,0,0,0,0,0}, VapVis = {102,1.3016E-07,0.7814,154.56,-3949.8,0}, LiqK = {16,-0.088775,-213.56,0.1118,-0.0022725,3.5301E-07}, VapK = {102,0.084868,0.23486,15441,507600,0}, Racketparam = 0.215, UniquacR = 2.6026, UniquacQ = 2.448, ChaoSeadAF = 0.917597, ChaoSeadSP = 35980, ChaoSeadLV = 0.0614585);
  end Oxalicacid;
  
  model Acrylicacid
  extends General_Properties(
    SN = 394, name = "Acrylicacid", CAS = "79-10-7", Tc = 654.15, Pc = 5664070,  Vc = 0.210712, Cc = 0.23, Tb = 414.15, Tm = 286.15, TT = 286.15, TP = 257.117, MW = 72.0627, LVB = 0.068927, AF = 0.220736, SP = 19230, DM = 4.87E-30, SH = -22600000.0, IGHF = -3.371E+08, GEF = -2.861E+08, AS = 315000, HFMP = 1.117E+07, HOC = -1.28022E+09, LiqDen = {105,0.11535,0.078693,654.15,0.16945,0}, VP = {101,55.86645,-7062.889,-4.564151,1.238643E-06,2}, LiqCp = {16,142250,1837.1,-38.373,0.21763,-0.00027035}, HOV = {106,6.9258E+07,1.9796,2.7587,-12.283,8.2823}, VapCp = {16,49916,-589.6,12.259,-0.00013536,3.0855E-08}, LiqVis = {101,-113.67,5526.6,15.75,-0.000015983,2}, VapVis = {102,2.4666E-07,0.69704,207.66,-6104.4,0}, LiqK = {16,-0.40695,33.472,-0.79449,0.00078306,-0.0000013868}, VapK = {102,0.00092475,0.70367,626.1,112700,0}, Racketparam = 0.23, UniquacR = 2.6467, UniquacQ = 2.4, ChaoSeadAF = 0.538324, ChaoSeadSP = 19230, ChaoSeadLV = 0.068927);
  end Acrylicacid;
  
  model Methacrylicacid
  extends General_Properties(
    SN = 395, name = "Methacrylicacid", CAS = "79-41-4", Tc = 643, Pc = 4700000,  Vc = 0.27, Cc = 0.244, Tb = 433.65, Tm = 288.15, TT = 288.15, TP = 58.5615, MW = 86.0892, LVB = 0.0852843, AF = 0.331817, SP = 21000, DM = 5.5E-30, SH = -22600000.0, IGHF = -3.68E+08, GEF = -2.88E+08, AS = 350000, HFMP = 0, HOC = -1.93E+09, LiqDen = {105,2.1083,0.37321,643,0.47743,0}, VP = {101,9.843112,-6238.161,2.965581,-0.0000105952,2}, LiqCp = {16,130480,265.42,3.971,0.026507,-0.000026858}, HOV = {106,7009500,-12.334,36.335,-42.263,18.248}, VapCp = {16,48894,-560.59,12.692,-0.00031458,1.4407E-07}, LiqVis = {101,0.054722,968.88,-1.7788,0.0000031087,2}, VapVis = {102,9.4671E-08,0.81582,92.397,383.72,0}, LiqK = {16,-0.067603,29.398,-1.512,0.00016774,-0.0000015769}, VapK = {102,0.000065218,1.0555,299.46,29315,0}, Racketparam = 0.244, UniquacR = 3.3197, UniquacQ = 3.06, ChaoSeadAF = 0.331817, ChaoSeadSP = 21000, ChaoSeadLV = 0.0852843);
  end Methacrylicacid;
  
  model Benzoicacid
  extends General_Properties(
    SN = 396, name = "Benzoicacid", CAS = "65-85-0", Tc = 751, Pc = 4470000,  Vc = 0.344, Cc = 0.246, Tb = 523.15, Tm = 395.55, TT = 395.45, TP = 795.501, MW = 122.121, LVB = 0.112442, AF = 0.602794, SP = 24590, DM = 3.34E-30, SH = -22600000.0, IGHF = -2.902E+08, GEF = -2.142E+08, AS = 369000, HFMP = 1.807E+07, HOC = -3.0951E+09, LiqDen = {105,0.7147,0.24811,751,0.28445,0}, VP = {101,444.4847,-30166.81,-61.25117,0.000029739,2}, LiqCp = {16,78008,1056.8,2.5621,0.02421,-0.000017579}, HOV = {106,6.7437E+07,0.13946,-2.3071,5.0416,-2.5138}, VapCp = {16,71253,-905.31,13.682,-0.00087786,2.5351E-07}, LiqVis = {101,-204.19,11713,28.642,-0.000020228,2}, VapVis = {102,7.426E-08,0.8289,91.171,5.6616,0}, LiqK = {16,-0.26694,24.352,-0.89204,0.00010336,-5.9141E-07}, VapK = {102,0.000021559,1.1593,126.16,64371,0}, Racketparam = 0.246, UniquacR = 4.323, UniquacQ = 3.344, ChaoSeadAF = 0.602794, ChaoSeadSP = 24590, ChaoSeadLV = 0.112442);
  end Benzoicacid;
  
  model Otoluicacid
  extends General_Properties(
    SN = 397, name = "Otoluicacid", CAS = "118-90-1", Tc = 751, Pc = 3860000,  Vc = 0.397, Cc = 0.245, Tb = 532, Tm = 376.85, TT = 376.85, TP = 237.832, MW = 136.148, LVB = 0.126888, AF = 0.657237, SP = 22920, DM = 5.67059E-30, SH = -22600000.0, IGHF = -3.22796E+08, GEF = -2.13346E+08, AS = 406141, HFMP = 2.01774E+07, HOC = -3.69902E+09, LiqDen = {105,0.61816,0.24687,751,0.2856,0}, VP = {101,133.1988,-13740.37,-15.5105,5.245068E-06,2}, LiqCp = {16,129490,18.011,10.105,0.0057419,-0.000003975}, HOV = {106,9.9956E+07,0.80217,-0.93427,0.8805,-0.3406}, VapCp = {16,85949,-929.05,14.065,-0.0013145,5.0858E-07}, LiqVis = {101,-8.7015,1473.1,-0.25079,0.0000003109,2}, VapVis = {102,1.2379E-07,0.7551,177.89,-5611.1,0}, LiqK = {16,-0.13162,29.195,-1.2663,0.000070644,-8.4448E-07}, VapK = {102,0.000027427,1.1315,204.73,55122,0}, Racketparam = 0.245, UniquacR = 5.058, UniquacQ = 3.912, ChaoSeadAF = 0.657237, ChaoSeadSP = 22920, ChaoSeadLV = 0.126888);
  end Otoluicacid;
  
  model Ptoluicacid
  extends General_Properties(
    SN = 398, name = "Ptoluicacid", CAS = "99-94-5", Tc = 773, Pc = 3860000,  Vc = 0.397, Cc = 0.238, Tb = 548.15, Tm = 452.75, TT = 452.75, TP = 5208.62, MW = 136.148, LVB = 0.129817, AF = 0.661017, SP = 22040, DM = 0, SH = -22600000.0, IGHF = -3.22796E+08, GEF = -2.13346E+08, AS = 406141, HFMP = 2.2737E+07, HOC = -3.69222E+09, LiqDen = {105,0.60059,0.238,773,0.28571,0}, VP = {101,180.79,-16901,-22.327,0.0000079041,2}, LiqCp = {16,204240,558.58,5.081,0.015699,-0.000010465}, HOV = {106,1.0299E+08,0.94653,-1.474,1.5504,-0.62044}, VapCp = {16,85949,-929.05,14.065,-0.0013145,5.0858E-07}, LiqVis = {101,-16.393,2717.5,0.51437,-3.3608E-07,2}, VapVis = {102,8.0828E-08,0.81038,114.97,-489.3,0}, LiqK = {16,-0.14095,29.118,-1.2124,0.000049104,-7.6374E-07}, VapK = {102,0.00002977,1.1214,206.56,62002,0}, Racketparam = 0.238, UniquacR = 5.058, UniquacQ = 3.912, ChaoSeadAF = 0.661017, ChaoSeadSP = 22040, ChaoSeadLV = 0.129817);
  end Ptoluicacid;
  
  model Salicylicacid
  extends General_Properties(
    SN = 399, name = "Salicylicacid", CAS = "69-72-7", Tc = 739, Pc = 5180000,  Vc = 0.364, Cc = 0.275, Tb = 529, Tm = 431.75, TT = 431.75, TP = 2802.65, MW = 138.121, LVB = 0.119591, AF = 0.851182, SP = 24210, DM = 8.84E-30, SH = -22600000.0, IGHF = -4.948E+08, GEF = -3.954E+08, AS = 399800, HFMP = 1.959E+07, HOC = -2.8901E+09, LiqDen = {105,0.8432,0.27522,739,0.28574,0}, VP = {101,252.5417,-21148.9,-32.63925,0.0000130693,2}, LiqCp = {16,129500,160.82,8.5105,0.0092921,-0.0000057493}, HOV = {106,1.3325E+08,-0.11849,3.6062,-5.1635,2.13}, VapCp = {16,83388,-879.57,13.917,-0.0013499,0.0000005122}, LiqVis = {101,-50.743,5203.6,5.2837,2.047E-08,2}, VapVis = {102,1.0029E-07,0.78423,131.87,-154.53,0}, LiqK = {16,0.0043799,-391.31,0.63544,-0.0048323,0.0000010995}, VapK = {102,0.000028337,1.1043,106.43,67783,0}, Racketparam = 0.275, UniquacR = 4.6869, UniquacQ = 3.624, ChaoSeadAF = 0.851182, ChaoSeadSP = 24210, ChaoSeadLV = 0.119591);
  end Salicylicacid;
  
  model Adipicacid
  extends General_Properties(
    SN = 400, name = "Adipicacid", CAS = "124-04-9", Tc = 809, Pc = 3530000,  Vc = 0.4, Cc = 0.21, Tb = 611, Tm = 426.15, TT = 425.5, TP = 78.0827, MW = 146.141, LVB = 0.133942, AF = 1.05065, SP = 25370, DM = 7.74E-30, SH = -22600000.0, IGHF = -8.65E+08, GEF = -6.82E+08, AS = 482000, HFMP = 1.67E+07, HOC = -2.58E+09, LiqDen = {105,0.64797,0.25918,809,0.28198,0}, VP = {101,255.2237,-23233.92,-32.83085,0.000013435,2}, LiqCp = {16,235940,-32.997,10.809,0.0032672,-0.0000019456}, HOV = {106,1.949255E+08,0.823008,2.518159,-5.646327,2.784565}, VapCp = {16,85474,-423.41,12.745,0.00026178,-1.1462E-07}, LiqVis = {101,-8.4738,3093.2,-0.68319,4.5668E-07,2}, VapVis = {102,8.6397E-08,0.79699,129.04,-83.45,0}, LiqK = {16,-0.15138,31.723,-1.1417,0.000072402,-7.2467E-07}, VapK = {102,0.00019846,0.87712,520.45,62013,0}, Racketparam = 0.21, UniquacR = 5.3002, UniquacQ = 4.608, ChaoSeadAF = 1.05065, ChaoSeadSP = 25370, ChaoSeadLV = 0.133942);
  end Adipicacid;
  
  model Phthalicacid
  extends General_Properties(
    SN = 401, name = "Phthalicacid", CAS = "88-99-3", Tc = 943.0648, Pc = 4492234,  Vc = 0.4235, Cc = 0.242627, Tb = 651.424, Tm = 483.15, TT = 0, TP = 0, MW = 166.131, LVB = 0.115821, AF = 1.16031, SP = 29038.44, DM = 8.67E-30, SH = -22600000.0, IGHF = -6.63E+08, GEF = -5.42E+08, AS = 442000, HFMP = 0, HOC = -3.0915E+09, LiqDen = {105,0.59385,0.252,800,0.28571,0}, VP = {101,214.6186,-21678.73,-26.54136,7.94063E-06,2}, LiqCp = {16,126080,73.955,9.4222,0.0070682,-0.0000039598}, HOV = {106,1.16446E+08,0.325842,-0.000233021,0.00216992,0.484323}, VapCp = {16,78972,-814.12,13.621,-0.00057909,1.2469E-07}, LiqVis = {101,-20.315,4089.4,0.87699,-5.3713E-07,2}, VapVis = {102,5.1978E-08,0.86126,68.544,-136.86,0}, LiqK = {16,-0.13007,40.261,-1.3314,0.00027982,-9.4309E-07}, VapK = {102,0.00011576,0.91053,351.24,130660,0}, Racketparam = 0.242627, UniquacR = 5.456, UniquacQ = 4.288, ChaoSeadAF = 0, ChaoSeadSP = 0, ChaoSeadLV = 0);
  end Phthalicacid;
  
  model Maleicacid
  extends General_Properties(
    SN = 402, name = "Maleicacid", CAS = "110-16-7", Tc = 773, Pc = 4990000,  Vc = 0.297, Cc = 0.231, Tb = 411, Tm = 403.45, TT = 403.8, TP = 98.6734, MW = 116.072, LVB = 0.090835, AF = 0.997587, SP = 30550, DM = 1.06E-29, SH = -22600000.0, IGHF = -6.794E+08, GEF = -5.96E+08, AS = 416000, HFMP = 3.47E+07, HOC = -1.2684E+09, LiqDen = {105,0.77641,0.231,773,0.28571,0}, VP = {101,187.4602,-19104.39,-22.78106,6.967225E-06,2}, LiqCp = {16,148240,706.52,4.046,0.018422,-0.000011933}, HOV = {106,1.16446E+08,0.325842,-0.000233021,0.00216992,0.484323}, VapCp = {16,60872,-493.34,12.58,-0.00028606,0.0000001493}, LiqVis = {101,-11.993,2508.3,0.079857,-1.8766E-08,2}, VapVis = {102,9.0189E-08,0.80995,111.91,-70.22,0}, LiqK = {16,-0.061944,-160.86,-0.25643,-0.0021458,2.3954E-07}, VapK = {102,0.0000021963,1.4191,-285.03,84199,0}, Racketparam = 0.231, UniquacR = 3.7193, UniquacQ = 3.315, ChaoSeadAF = 0.997587, ChaoSeadSP = 30550, ChaoSeadLV = 0.090835);
  end Maleicacid;
  
  model Terephthalicacid
  extends General_Properties(
    SN = 403, name = "Terephthalicacid", CAS = "100-21-0", Tc = 943.0648, Pc = 4492234,  Vc = 0.4235, Cc = 0.242627, Tb = 665.55, Tm = 573.15, TT = 0, TP = 0, MW = 166.131, LVB = 0.115821, AF = 1.16031, SP = 29038.44, DM = 0, SH = -22600000.0, IGHF = -7.179E+08, GEF = -5.99E+08, AS = 448000, HFMP = 0, HOC = -3.0576E+09, LiqDen = {105,0.42685,0.181,1113,0.28571,0}, VP = {101,215.8574,-29586.64,-25.50026,3.863371E-06,2}, LiqCp = {0,0,0,0,0,0}, HOV = {106,8.9802E+07,0.189,-0.50305,-1.1074,4.311}, VapCp = {16,83070,-852.74,13.689,-0.000643,1.4167E-07}, LiqVis = {0,0,0,0,0,0}, VapVis = {102,2.4248E-08,0.96894,40.456,-14256,0}, LiqK = {16,0,0,0,0,0}, VapK = {102,0.00016184,0.88608,624.29,90960,0}, Racketparam = 0.242627, UniquacR = 5.456, UniquacQ = 4.288, ChaoSeadAF = 0, ChaoSeadSP = 0, ChaoSeadLV = 0);
  end Terephthalicacid;
  
  model Aceticanhydride
  extends General_Properties(
    SN = 404, name = "Aceticanhydride", CAS = "108-24-7", Tc = 569.15, Pc = 4280000,  Vc = 0.29, Cc = 0.23, Tb = 413.15, Tm = 200.15, TT = 200.15, TP = 0.0219995, MW = 102.089, LVB = 0.0949602, AF = 0.809524, SP = 22010, DM = 9.3E-30, SH = -22600000.0, IGHF = -5.735E+08, GEF = -4.767E+08, AS = 389900, HFMP = 1.05E+07, HOC = -1.675E+09, LiqDen = {105,1.3543,0.3062,584.65,0.43334,0}, VP = {101,94.79499,-8627.117,-10.49847,0.0000051448,2}, LiqCp = {16,-76055,674.26,4.7415,0.026829,-0.000028167}, HOV = {106,4.787557E+07,-0.639261,1.651354,-0.778133,-0.0411955}, VapCp = {16,63862,-716.36,13.016,-0.00041944,1.1702E-07}, LiqVis = {101,-13.196,1321.3,0.29135,3.1938E-07,2}, VapVis = {102,1.3132E-07,0.7781,96.036,3593.8,0}, LiqK = {16,0.0017236,-11.978,-1.3413,-0.0012823,-6.1388E-07}, VapK = {102,0.0003967,0.81349,426.6,140300,0}, Racketparam = 0.23, UniquacR = 3.586025, UniquacQ = 3.224, ChaoSeadAF = 0.453, ChaoSeadSP = 22010, ChaoSeadLV = 0.0949602);
  end Aceticanhydride;
  
  model Maleicanhydride
  extends General_Properties(
    SN = 405, name = "Maleicanhydride", CAS = "108-31-6", Tc = 721, Pc = 7280000,  Vc = 0.219, Cc = 0.266, Tb = 473.15, Tm = 325.927, TT = 325.72, TP = 289.837, MW = 98.0569, LVB = 0.0741215, AF = 0.54629, SP = 25870, DM = 1.31E-29, SH = -22600000.0, IGHF = -4.167E+08, GEF = -3.55E+08, AS = 317000, HFMP = 1.15E+07, HOC = -1.38E+09, LiqDen = {105,1.1934,0.26153,721,0.35499,0}, VP = {101,181.7423,-13070.32,-23.83155,0.0000182982,2}, LiqCp = {16,7374.3,412.68,8.4647,0.0086559,-0.0000060424}, HOV = {106,5.7421E+07,0.064434,0.35394,-0.39596,0.19018}, VapCp = {16,-39596,-169.57,12.496,6.0181E-08,4.1214E-08}, LiqVis = {101,93.459,-2744.1,-16.078,0.000015825,2}, VapVis = {102,7.5282E-08,0.87275,168.46,-10784,0}, LiqK = {16,0.0050361,-137.05,-0.46443,-0.0029116,3.9472E-07}, VapK = {102,0.00030053,0.85542,634.55,21624,0}, Racketparam = 0.266, UniquacR = 2.903098, UniquacQ = 2.384, ChaoSeadAF = 0.54629, ChaoSeadSP = 25870, ChaoSeadLV = 0.0741215);
  end Maleicanhydride;
  
  model Ketene
  extends General_Properties(
    SN = 406, name = "Ketene", CAS = "463-51-4", Tc = 370, Pc = 5810000,  Vc = 0.144, Cc = 0.272, Tb = 217.15, Tm = 122.15, TT = 122, TP = 7.19493, MW = 42.0367, LVB = 0.06374, AF = 0.125656, SP = 13820, DM = 4.74E-30, SH = -61100000.0, IGHF = -6.11E+07, GEF = -6.02914E+07, AS = 241800, HFMP = 0, HOC = -9.67759E+08, LiqDen = {105,1.8886,0.272,370,0.28571,0}, VP = {101,58.628,-3467,-5.9337,0.000010248,2}, LiqCp = {16,41971,267.01,4.7755,0.029953,-0.000037749}, HOV = {106,4.6158E+07,4.5264,-12.408,14.257,-5.881}, VapCp = {16,33110,-414.32,10.968,0.00041237,-1.3222E-07}, LiqVis = {101,-18.659,731.69,1.5497,-0.000011288,2}, VapVis = {102,0.000001285,0.50552,367.45,-2188.3,0}, LiqK = {16,-0.007072,-11.763,-0.74777,-0.0024777,-0.0000018714}, VapK = {102,0.000028519,1.1477,-97.436,37387,0}, Racketparam = 0.272, UniquacR = 1.694792, UniquacQ = 1.610932, ChaoSeadAF = 0.125656, ChaoSeadSP = 13820, ChaoSeadLV = 0.06374);
  end Ketene;
  
  model Methylmethacrylate
  extends General_Properties(
    SN = 407, name = "Methylmethacrylate", CAS = "80-62-6", Tc = 563.15, Pc = 3670000,  Vc = 0.324, Cc = 0.253, Tb = 374.15, Tm = 225.15, TT = 225.6, TP = 19.0855, MW = 100.116, LVB = 0.106736, AF = 0.280233, SP = 18530, DM = 6.57E-30, SH = -61100000.0, IGHF = -3.6E+08, GEF = -2.54E+08, AS = 401000, HFMP = 1.44348E+07, HOC = -2.54E+09, LiqDen = {105,0.91648,0.27205,563.15,0.3201,0}, VP = {101,129.5007,-8907.818,-16.17497,0.000012098,2}, LiqCp = {16,45251,733.56,4.0201,0.024183,-0.000020347}, HOV = {106,5.397285E+07,-0.0862845,1.857786,-2.127696,0.775243}, VapCp = {16,40862.92,-408.0793,12.53452,0.000265188,-1.105927E-07}, LiqVis = {101,-8.2342,780.75,-0.30393,-0.0000019127,2}, VapVis = {102,4.0508E-07,0.64362,435.99,-25064,0}, LiqK = {16,0.093744,-51.297,-0.18289,-0.0078351,-0.0000030405}, VapK = {102,0.0023506,0.61168,848.43,252520,0}, Racketparam = 0.253, UniquacR = 3.9215, UniquacQ = 3.564, ChaoSeadAF = 0.280233, ChaoSeadSP = 18530, ChaoSeadLV = 0.106736);
  end Methylmethacrylate;
  
  model Dimethylterephthalate
  extends General_Properties(
    SN = 408, name = "Dimethylterephthalate", CAS = "120-61-6", Tc = 772, Pc = 2780000,  Vc = 0.529, Cc = 0.229, Tb = 555.15, Tm = 413.8, TT = 413.8, TP = 1257.73, MW = 194.184, LVB = 0.180564, AF = 0.637086, SP = 17710, DM = 7.3E-30, SH = -61100000.0, IGHF = -6.37E+08, GEF = -4.74E+08, AS = 550000, HFMP = 3.09E+07, HOC = -4.4115E+09, LiqDen = {105,0.50864,0.26895,772,0.26133,0}, VP = {101,87.35202,-11061.82,-8.88269,1.566691E-07,2}, LiqCp = {16,306140,1151.8,1.8179,0.019226,-0.0000087371}, HOV = {106,4.927268E+07,-0.826644,0.840569,0.547723,-0.373819}, VapCp = {16,95546,-944.26,15.059,-0.0027373,0.0000012901}, LiqVis = {101,-9.6027,1845.8,-0.28991,2.7867E-07,2}, VapVis = {102,1.5497E-10,1.62,-527.6,101960,0}, LiqK = {16,-0.015206,-275.63,0.058569,-0.0035078,7.3745E-07}, VapK = {102,-21938,0.32202,-4.3275E+09,-1.5265E+11,0}, Racketparam = 0.229, UniquacR = 6.6618, UniquacQ = 5.296, ChaoSeadAF = 0.637086, ChaoSeadSP = 17710, ChaoSeadLV = 0.180564);
  end Dimethylterephthalate;
  
  model OneTwopropyleneoxide
  extends General_Properties(
    SN = 409, name = "OneTwopropyleneoxide", CAS = "75-56-9", Tc = 482.25, Pc = 4920000,  Vc = 0.186, Cc = 0.228, Tb = 307.05, Tm = 161.22, TT = 161.22, TP = 0.965624, MW = 58.0791, LVB = 0.0705481, AF = 0.268304, SP = 19050, DM = 6.7E-30, SH = -61100000.0, IGHF = -9.372E+07, GEF = -2.58E+07, AS = 286700, HFMP = 6531000, HOC = -1.79E+09, LiqDen = {105,1.5769,0.28598,482.25,0.29139,0}, VP = {101,83.693,-5715.8,-9.522,0.00001033,2}, LiqCp = {16,78704,274.26,7.2963,0.0088641,-0.0000023407}, HOV = {106,5.241305E+07,1.339985,-1.496096,0.72766,-0.151947}, VapCp = {16,42195,-578.73,12.252,0.00010777,-4.7082E-08}, LiqVis = {101,20.905,283.5,-5.5156,0.000016261,2}, VapVis = {102,1.1059E-07,0.81831,109.91,-5863.4,0}, LiqK = {16,0.10066,294.75,-5.9561,0.019433,-0.000039547}, VapK = {102,0.00022671,0.95467,579.31,32798,0}, Racketparam = 0.228, UniquacR = 2.2663, UniquacQ = 1.856, ChaoSeadAF = 0.268304, ChaoSeadSP = 19050, ChaoSeadLV = 0.0705481);
  end OneTwopropyleneoxide;
  
  model Cumenehydroperoxide
  extends General_Properties(
    SN = 410, name = "Cumenehydroperoxide", CAS = "80-15-9", Tc = 605, Pc = 3340000,  Vc = 0.463, Cc = 0.278, Tb = 442.7, Tm = 264.26, TT = 264.26, TP = 0.00236574, MW = 152.19, LVB = 0.145892, AF = 0.995, SP = 21500, DM = 5.95412E-30, SH = -61100000.0, IGHF = -7.84E+07, GEF = 9.6E+07, AS = 455000, HFMP = 0, HOC = -4.8444E+09, LiqDen = {105,0.6643,0.27801,605,0.28637,0}, VP = {101,156.523,-16668.56,-17.98221,0.0000113017,2}, LiqCp = {16,83403,-35.074,9.3262,0.010979,-0.00001071}, HOV = {106,7.2836E+07,0.18056,-0.22381,-0.21673,0.35898}, VapCp = {16,70090,-408.89,12.927,0.00036839,-1.5886E-07}, LiqVis = {0,0,0,0,0,0}, VapVis = {102,1.9678E-07,0.71936,203.36,-7639,0}, LiqK = {16,-0.022189,-77.144,-1.2225,-0.0023354,4.0588E-08}, VapK = {102,0.00018194,0.94296,592.69,22533,0}, Racketparam = 0.278, UniquacR = 5.817402, UniquacQ = 4.648, ChaoSeadAF = 0.995, ChaoSeadSP = 21500, ChaoSeadLV = 0.145892);
  end Cumenehydroperoxide;
  
  model Propionitrile
  extends General_Properties(
    SN = 411, name = "Propionitrile", CAS = "107-12-0", Tc = 564.4, Pc = 4180000,  Vc = 0.229, Cc = 0.204, Tb = 370.5, Tm = 180.26, TT = 180.26, TP = 0.169356, MW = 55.0785, LVB = 0.0708565, AF = 0.324267, SP = 21760, DM = 1.34E-29, SH = -61100000.0, IGHF = 5.15E+07, GEF = 9.74949E+07, AS = 286600, HFMP = 5029170, HOC = -1.8007E+09, LiqDen = {105,0.90359,0.2211,564.4,0.26246,0}, VP = {101,81.601,-6646.8,-8.9882,0.0000074443,2}, LiqCp = {16,105770,154.89,4.5843,0.018329,-0.000011984}, HOV = {106,3.633259E+07,-2.107222,8.013128,-9.747514,4.114254}, VapCp = {16,47947,-544.83,11.91,0.00026005,-9.1233E-08}, LiqVis = {101,-8.0958,775.57,-0.393,-7.9624E-07,2}, VapVis = {102,9.8851E-08,0.79377,155.28,-11568,0}, LiqK = {16,0.13846,2645.2,-37.177,0.15078,-0.00022598}, VapK = {102,0.00048871,1.327,43042,-3226700,0}, Racketparam = 0.204, UniquacR = 2.5445, UniquacQ = 2.264, ChaoSeadAF = 0.324267, ChaoSeadSP = 21760, ChaoSeadLV = 0.0708565);
  end Propionitrile;
  
  model Dimethylcarbonate
  extends General_Properties(
    SN = 412, name = "Dimethylcarbonate", CAS = "616-38-6", Tc = 557, Pc = 4800000,  Vc = 0.25163, Cc = 0.261, Tb = 363.24, Tm = 276.15, TT = 273.15, TP = 1825.53, MW = 90.084, LVB = 0.084825, AF = 0.337, SP = 20240, DM = 3.0E-30, SH = -61100000.0, IGHF = -5.701E+08, GEF = -4.524E+08, AS = 321600, HFMP = 1.2E+07, HOC = -1.295E+09, LiqDen = {105,0.0073625,0.022214,557,0.083013,0}, VP = {101,127.2975,-8353.984,-16.14514,0.0000181933,2}, LiqCp = {16,170430,-2560.3,-9.9628,-0.012169,0.000014736}, HOV = {106,5.291764E+07,1.146922,-2.489366,2.898325,-1.182726}, VapCp = {16,62577,-594.2,12.53,-0.000022352,-2.2803E-08}, LiqVis = {101,-235.18,9633.9,34.904,-0.000038795,2}, VapVis = {102,3.5376E-07,0.64846,244.72,-7103.7,0}, LiqK = {16,0.011223,-183.44,0.22279,-0.0056614,0.0000021056}, VapK = {102,0.00023689,0.89541,568.87,19356,0}, Racketparam = 0.261, UniquacR = 3.3822, UniquacQ = 3.086, ChaoSeadAF = 0.337, ChaoSeadSP = 20240, ChaoSeadLV = 0.084825);
  end Dimethylcarbonate;
  
  model DiEthylCarbonate
  extends General_Properties(
    SN = 413, name = "DiEthylCarbonate", CAS = "105-58-8", Tc = 577, Pc = 3420000,  Vc = 0.35725, Cc = 0.254676, Tb = 399.95, Tm = 230.15, TT = 0, TP = 0, MW = 118.1322, LVB = 0.12721, AF = 0.3544, SP = 18727.86, DM = 0, SH = -61100000.0, IGHF = 4.443408E+07, GEF = -1.919535, AS = 1202641, HFMP = 0, HOC = -3.223334, LiqDen = {0,0,0,0,0,0}, VP = {10,20.45386,2817.834,-84.304,0,0}, LiqCp = {0,0,0,0,0,0}, HOV = {106,2.9807E+07,0.38,0,0,0}, VapCp = {4,-748.0008,383.84,-0.1938,0.0000364,0}, LiqVis = {0,0,0,0,0,0}, VapVis = {0,0,0,0,0,0}, LiqK = {16,0,0,0,0,0}, VapK = {0,0,0,0,0,0}, Racketparam = 0.254676, UniquacR = 4.731, UniquacQ = 4.166, ChaoSeadAF = 0.3544, ChaoSeadSP = 0, ChaoSeadLV = 0.12721);
  end DiEthylCarbonate;
  
  model MethylEthylCarbonate
  extends General_Properties(
    SN = 414, name = "MethylEthylCarbonate", CAS = "623-53-0", Tc = 565.93, Pc = 3828600,  Vc = 0.30149, Cc = 0.24531, Tb = 385.68, Tm = 258.65, TT = 0, TP = 0, MW = 104.1054, LVB = 0.1108, AF = 0.31086, SP = 20328.39, DM = 0, SH = -61100000.0, IGHF = 6.510304E+07, GEF = -2.776586, AS = 1164449, HFMP = 0, HOC = -2.608223, LiqDen = {0,0,0,0,0,0}, VP = {10,21.71522,3376.596,-49.461,0,0}, LiqCp = {0,0,0,0,0,0}, HOV = {106,2.0559E+07,0.38,0,0,0}, VapCp = {4,160.9996,288.84,-0.1394,0.0000245,0}, LiqVis = {0,0,0,0,0,0}, VapVis = {0,0,0,0,0,0}, LiqK = {16,0,0,0,0,0}, VapK = {0,0,0,0,0,0}, Racketparam = 0.24531, UniquacR = 4.0566, UniquacQ = 3.626, ChaoSeadAF = 0.31086, ChaoSeadSP = 0, ChaoSeadLV = 0.1108);
  end MethylEthylCarbonate;
  
  model MethylPhenylCarbonate
  extends General_Properties(
    SN = 415, name = "MethylPhenylCarbonate", CAS = "13509-27-8", Tc = 711.76, Pc = 3441000,  Vc = 0.42129, Cc = 0.244961, Tb = 491.76, Tm = 0, TT = 0, TP = 0, MW = 152.1494, LVB = 0.1385, AF = 0.41299, SP = 19646.23, DM = 0, SH = -61100000.0, IGHF = 1.345156E+08, GEF = 1.178139E+08, AS = 931814.4, HFMP = 0, HOC = -4.252756, LiqDen = {0,0,0,0,0,0}, VP = {10,23.07041,5677.005,0,0,0}, LiqCp = {0,0,0,0,0,0}, HOV = {106,4.6776E+07,0.38,0,0,0}, VapCp = {4,-37380,589.92,-0.3882,0.0000976,0}, LiqVis = {0,0,0,0,0,0}, VapVis = {0,0,0,0,0,0}, LiqK = {16,0,0,0,0,0}, VapK = {0,0,0,0,0,0}, Racketparam = 0.244961, UniquacR = 5.5028, UniquacQ = 4.358, ChaoSeadAF = 0.41299, ChaoSeadSP = 0, ChaoSeadLV = 0.1385);
  end MethylPhenylCarbonate;
  
  model EthylPhenylCarbonate
  extends General_Properties(
    SN = 416, name = "EthylPhenylCarbonate", CAS = "3878-46-4", Tc = 729.29, Pc = 2529800,  Vc = 0.55209, Cc = 0.230336, Tb = 522.67, Tm = 0, TT = 0, TP = 0, MW = 166.1762, LVB = 0.18105, AF = 0.54406, SP = 18670.52, DM = 0, SH = -61100000.0, IGHF = 1.138466E+08, GEF = 1.263844E+08, AS = 970006.4, HFMP = 0, HOC = -4.867867, LiqDen = {0,0,0,0,0,0}, VP = {10,22.88975,5939.5,0,0,0}, LiqCp = {0,0,0,0,0,0}, HOV = {106,5.2005E+07,0.38,0,0,0}, VapCp = {4,-38289,684.92,-0.4426,0.0001095,0}, LiqVis = {0,0,0,0,0,0}, VapVis = {0,0,0,0,0,0}, LiqK = {16,0,0,0,0,0}, VapK = {0,0,0,0,0,0}, Racketparam = 0.230336, UniquacR = 6.1772, UniquacQ = 4.898, ChaoSeadAF = 0.54406, ChaoSeadSP = 0, ChaoSeadLV = 0.18105);
  end EthylPhenylCarbonate;
  
  model DiPhenylCarbonate
  extends General_Properties(
    SN = 417, name = "DiPhenylCarbonate", CAS = "102-09-0", Tc = 799.32, Pc = 2796500,  Vc = 0.59685, Cc = 0.251145, Tb = 572.99, Tm = 352.15, TT = 0, TP = 0, MW = 214.2202, LVB = 0.18261, AF = 0.55805, SP = 18788.28, DM = 0, SH = -61100000.0, IGHF = 1.832592E+08, GEF = 2.719642E+08, AS = 737371.8, HFMP = 0, HOC = -6.512399E+09, LiqDen = {0,0,0,0,0,0}, VP = {10,23.41177,6810.358,0,0,0}, LiqCp = {3,-164882.8,994.6407,-0.464037,0,0}, HOV = {106,7.141145E+07,0.38,0,0,0}, VapCp = {4,-72586.55,927.9609,-0.573626,0.000147143,0}, LiqVis = {101,-49.44655,15931.93,0,0,0}, VapVis = {0,0,0,0,0,0}, LiqK = {3,0.101839,0.000518198,-1.230409E-06,0,0}, VapK = {3,-0.0506874,0.00020251,-1.156856E-07,0,0}, Racketparam = 0.251145, UniquacR = 7.6234, UniquacQ = 5.63, ChaoSeadAF = 0.55805, ChaoSeadSP = 0, ChaoSeadLV = 0.18261);
  end DiPhenylCarbonate;
  
  model Ethylenecarbonate
  extends General_Properties(
    SN = 418, name = "Ethylenecarbonate", CAS = "96-49-1", Tc = 806, Pc = 6770000,  Vc = 0.193, Cc = 0.195, Tb = 521.15, Tm = 309.15, TT = 309.55, TP = 8.01004, MW = 88.0621, LVB = 0.0664942, AF = 0.442272, SP = 29660, DM = 1.5E-29, SH = -61100000.0, IGHF = -5.069E+08, GEF = -4.1E+08, AS = 260000, HFMP = 1.0E+07, HOC = -1.083E+09, LiqDen = {105,1.5442,0.2959,806,0.28857,0}, VP = {101,132.44,-12293,-15.875,0.0000073572,2}, LiqCp = {16,-57259,-17.021,11.366,0.0033817,-0.0000020646}, HOV = {106,8.7297E+07,-0.075043,3.7018,-6.1954,2.9631}, VapCp = {16,50075,-516.61,12.288,0.000013893,-2.689E-08}, LiqVis = {101,-8.7402,1424.5,-0.45708,0.0000005934,2}, VapVis = {102,8.5517E-08,0.85448,116.16,-3914.9,0}, LiqK = {16,0.00091342,-110.82,-0.51748,-0.0023793,3.9376E-07}, VapK = {102,0.030823,0.34958,3003.2,830800,0}, Racketparam = 0.195, UniquacR = 2.9288, UniquacQ = 2.47, ChaoSeadAF = 0.442272, ChaoSeadSP = 29660, ChaoSeadLV = 0.0664942);
  end Ethylenecarbonate;
  
  model Propylenecarbonate
  extends General_Properties(
    SN = 419, name = "Propylenecarbonate", CAS = "108-32-7", Tc = 778, Pc = 5410000,  Vc = 0.246, Cc = 0.206, Tb = 514.9, Tm = 218.62, TT = 224.85, TP = 0.00116652, MW = 102.089, LVB = 0.0852768, AF = 0.449764, SP = 27300, DM = 1.65E-29, SH = -61100000.0, IGHF = -6.0116E+08, GEF = -4.555E+08, AS = 296300, HFMP = 9617000, HOC = -1.6678E+09, LiqDen = {105,1.122,0.27599,778,0.40344,0}, VP = {101,102.32,-10530,-11.489,0.0000052921,2}, LiqCp = {16,121750,105.89,6.5083,0.016964,-0.000014577}, HOV = {106,3.145898E+08,9.998207,-26.2884,28.38292,-11.49051}, VapCp = {16,51696,-502.59,12.655,-0.000076494,1.3781E-08}, LiqVis = {101,-818.33,28057,129.62,-0.00022812,2}, VapVis = {102,4.7119E-08,0.92676,86.628,-9783.8,0}, LiqK = {16,-0.096241,6.7832,-1.0385,-0.00032841,-6.9782E-07}, VapK = {102,0.00017416,0.94857,659.28,16364,0}, Racketparam = 0.206, UniquacR = 3.6024, UniquacQ = 3.006, ChaoSeadAF = 0.449764, ChaoSeadSP = 27300, ChaoSeadLV = 0.0852768);
  end Propylenecarbonate;
  
  model TwomethylOneheptene
  extends General_Properties(
    SN = 420, name = "TwomethylOneheptene", CAS = "15870-10-7", Tc = 564, Pc = 2400000,  Vc = 0.497, Cc = 0.25, Tb = 392.37, Tm = 185.78, TT = 185.77, TP = 0.113498, MW = 112.213, LVB = 0.156655, AF = 0.35513, SP = 15180, DM = 0, SH = -61100000.0, IGHF = -9.699E+07, GEF = 9.32E+07, AS = 457800, HFMP = 1.44E+07, HOC = -4.948E+09, LiqDen = {105,0.53765,0.25476,567.01,0.28376,0}, VP = {101,108.46,-8257.2,-12.941,0.0000091062,2}, LiqCp = {16,88257,855.11,3.1929,0.026245,-0.000022451}, HOV = {106,5.8021E+07,1.4711,-3.336,3.8018,-1.5579}, VapCp = {16,92500,-450.54,12.712,0.00068864,-3.0334E-07}, LiqVis = {101,-34.674,1655.3,3.8693,-0.0000085602,2}, VapVis = {102,5.7686E-07,0.51551,255.32,-429.98,0}, LiqK = {16,-0.0714,1.7767,-1.4729,-0.00055517,-0.0000010492}, VapK = {102,0.00085233,0.71803,81.386,330930,0}, Racketparam = 0.25, UniquacR = 5.6171, UniquacQ = 4.844, ChaoSeadAF = 0.35513, ChaoSeadSP = 15180, ChaoSeadLV = 0.156655);
  end TwomethylOneheptene;
  
  model TwoMethoxyTwoMethylHeptane
  extends General_Properties(
    SN = 421, name = "TwoMethoxyTwoMethylHeptane", CAS = "76589-16-7", Tc = 618.2025, Pc = 2357849,  Vc = 0.53093, Cc = 0.24355, Tb = 446.7301, Tm = 0, TT = 0, TP = 0, MW = 144.2564, LVB = 0.18511, AF = 0.433286, SP = 14871.82, DM = 0, SH = -61100000.0, IGHF = -9790565, GEF = -6.029269, AS = 1629362, HFMP = 0, HOC = -5.95423E+09, LiqDen = {0,0,0,0,0,0}, VP = {200,-8.2705,2.1937,-3.6992,-3.7256,2357800}, LiqCp = {0,0,0,0,0,0}, HOV = {106,6.6655E+07,0.38,0,0,0}, VapCp = {4,-4265.999,921.48,-0.5266,0.000113,0}, LiqVis = {0,0,0,0,0,0}, VapVis = {0,0,0,0,0,0}, LiqK = {16,0,0,0,0,0}, VapK = {0,0,0,0,0,0}, Racketparam = 0.24355, UniquacR = 6.7654, UniquacQ = 5.792, ChaoSeadAF = 0.433286, ChaoSeadSP = 14871.82, ChaoSeadLV = 0.18511);
  end TwoMethoxyTwoMethylHeptane;
  
  model TwoMethylTwoHeptanol
  extends General_Properties(
    SN = 422, name = "TwoMethylTwoHeptanol", CAS = "625-25-2", Tc = 636.6534, Pc = 2716180,  Vc = 0.48244, Cc = 0.247551, Tb = 467.6976, Tm = 0, TT = 0, TP = 0, MW = 130.2296, LVB = 0.15788, AF = 0.723562, SP = 17397.3, DM = 0, SH = -61100000.0, IGHF = -1.238045, GEF = -1.233886, AS = 1322185, HFMP = 0, HOC = -5.204435, LiqDen = {0,0,0,0,0,0}, VP = {200,-10.016,3.415,-6.8543,-4.7824,2716200}, LiqCp = {0,0,0,0,0,0}, HOV = {106,7.9114E+07,0.38,0,0,0}, VapCp = {4,-23566,923.66,-0.6136,0.0001657,0}, LiqVis = {0,0,0,0,0,0}, VapVis = {0,0,0,0,0,0}, LiqK = {16,0,0,0,0,0}, VapK = {0,0,0,0,0,0}, Racketparam = 0.247551, UniquacR = 6.6204, UniquacQ = 5.904, ChaoSeadAF = 0.723562, ChaoSeadSP = 17397.3, ChaoSeadLV = 0.15788);
  end TwoMethylTwoHeptanol;
  
  model Methylal
  extends General_Properties(
    SN = 423, name = "Methylal", CAS = "109-87-5", Tc = 480.6, Pc = 3950000,  Vc = 0.213, Cc = 0.211, Tb = 315, Tm = 168, TT = 168.35, TP = 1.13284, MW = 76.0944, LVB = 0.0891275, AF = 0.285565, SP = 17430, DM = 2.47E-30, SH = -61100000.0, IGHF = -3.482E+08, GEF = -2.263E+08, AS = 335700, HFMP = 8330000, HOC = -1.7998E+09, LiqDen = {105,1.4351,0.30572,480.6,0.31739,0}, VP = {101,62.15058,-5217.94,-5.982976,3.491239E-06,2}, LiqCp = {16,134330,575.02,0.73414,0.035906,-0.00003541}, HOV = {106,4.956236E+07,0.517705,0.708214,-1.530256,0.744705}, VapCp = {16,73387,-1249,14.774,-0.0029552,0.0000012399}, LiqVis = {101,-8.4058,722.36,-0.36572,2.4819E-07,2}, VapVis = {102,4.8512E-07,0.60235,248.43,-1208.9,0}, LiqK = {16,0.11543,-776.65,7.882,-0.041206,0.000038121}, VapK = {102,0.0014869,0.65846,470.64,206460,0}, Racketparam = 0.211, UniquacR = 2.964403, UniquacQ = 2.716, ChaoSeadAF = 0.285565, ChaoSeadSP = 17430, ChaoSeadLV = 0.0891275);
  end Methylal;
  
  model MethylDiEthanolAmine
  extends General_Properties(
    SN = 424, name = "MethylDiEthanolAmine", CAS = "105-59-9", Tc = 741.9, Pc = 4160000,  Vc = 0.365, Cc = 0.246154, Tb = 520.15, Tm = 252.15, TT = 252.15, TP = 0.00203612, MW = 119.162, LVB = 0.115302, AF = 1.1649, SP = 28140, DM = 9.53993E-30, SH = -61100000.0, IGHF = -3.8E+08, GEF = -1.69E+08, AS = 469000, HFMP = 0, HOC = -3.06E+09, LiqDen = {105,0.69135,0.25418,675,0.2857,0}, VP = {101,-0.352098,-4812.65,3.121045,6.605463E-06,2}, LiqCp = {4,181326,26.21689,0.880838,0,-0.00001581}, HOV = {106,1.40201E+08,0.632751,0.350924,-0.633597,0.0584955}, VapCp = {16,89777,-550.24,13.01,0.000045139,-3.2024E-08}, LiqVis = {101,-162.0804,9995.149,22.49076,-0.0000361184,1.932506}, VapVis = {102,7.7364E-08,0.84268,140.24,-9063.1,0}, LiqK = {16,-0.869,15,0,0,0}, VapK = {102,0.00016443,0.97072,595.54,41960,0}, Racketparam = 0.254, UniquacR = 5.8841, UniquacQ = 5.5, ChaoSeadAF = 1.1649, ChaoSeadSP = 28140, ChaoSeadLV = 0.115302);
  end MethylDiEthanolAmine;
  
  model Diethylethanolamine
  extends General_Properties(
    SN = 425, name = "Diethylethanolamine", CAS = "100-37-8", Tc = 616, Pc = 2650000,  Vc = 0.4231, Cc = 0.218914, Tb = 434.15, Tm = 235.15, TT = 253, TP = 4.85244, MW = 117.189, LVB = 0.132864, AF = 0.781757, SP = 19100, DM = 8.11E-30, SH = -61100000.0, IGHF = -2.575E+08, GEF = -3.323E+07, AS = 459800, HFMP = 1.84E+07, HOC = -4.03338E+09, LiqDen = {105,0.63795,0.25988,592,0.27186,0}, VP = {101,442.3122,-22650.03,-64.35227,0.0000641088,2}, LiqCp = {4,28933.37,738.1104,-0.669126,0.000593149,0}, HOV = {106,6.442525E+07,-0.590881,4.028331,-5.586056,2.388691}, VapCp = {16,91061,-562.7,13.172,-0.000023606,6.7111E-09}, LiqVis = {101,-83.307,6061.8,10.089,-1.4583E-07,2}, VapVis = {102,1.3335E-07,0.7599,186.08,-6648.4,0}, LiqK = {16,-0.0045149,-46.605,-1.1875,-0.0019723,-5.2781E-08}, VapK = {102,0.00013877,0.99774,582.26,23748,0}, Racketparam = 0.259, UniquacR = 5.315095, UniquacQ = 4.532, ChaoSeadAF = 0.781757, ChaoSeadSP = 19100, ChaoSeadLV = 0.132864);
  end Diethylethanolamine;
  
  model Diisopropanolamine
  extends General_Properties(
    SN = 426, name = "Diisopropanolamine", CAS = "110-97-4", Tc = 672, Pc = 3600000,  Vc = 0.454, Cc = 0.293, Tb = 521.9, Tm = 315, TT = 318.15, TP = 0.217912, MW = 133.189, LVB = 0.134763, AF = 1.38914, SP = 26610, DM = 0, SH = -61100000.0, IGHF = -4.54E+08, GEF = -2.15E+08, AS = 513000, HFMP = 2.636E+07, HOC = -3.82E+09, LiqDen = {105,0.54022,0.24621,672,0.22052,0}, VP = {101,339.329,-25910.98,-45.42461,0.0000223088,2}, LiqCp = {4,119382.9,778.3072,-0.00245385,-1.190941E-06,-0.0000013464}, HOV = {106,1.4113E+08,0.38119,1.0156,-1.8242,0.83437}, VapCp = {16,104010,-559.93,13.272,-0.00018865,9.0295E-08}, LiqVis = {101,-158.9768,13684.82,19.79212,0.0000178855,1.442815}, VapVis = {102,1.7289E-07,0.71286,205.1,-6089.6,0}, LiqK = {16,-0.070378,-101.18,-0.46641,-0.0021528,2.0992E-07}, VapK = {102,0.0002313,0.90558,651.81,18136,0}, Racketparam = 0.293, UniquacR = 6.5774, UniquacQ = 6.028, ChaoSeadAF = 1.38914, ChaoSeadSP = 26610, ChaoSeadLV = 0.134763);
  end Diisopropanolamine;
  
  model Cyclobutane
  extends General_Properties(
    SN = 427, name = "Cyclobutane", CAS = "287-23-0", Tc = 459.93, Pc = 4980000,  Vc = 0.21, Cc = 0.273, Tb = 285.66, Tm = 182.48, TT = 182.48, TP = 180.101, MW = 56.1063, LVB = 0.0814243, AF = 0.18474, SP = 16020, DM = 0, SH = 28500000.0, IGHF = 2.85E+07, GEF = 1.122E+08, AS = 265400, HFMP = 1088000, HOC = -2.5678E+09, LiqDen = {105,1.407691,0.295395,459.93,0.248729,0}, VP = {101,60.70694,-4389.85,-6.086364,7.387074E-06,2}, LiqCp = {16,-3355.973,25.71519,11.14976,-0.0000199586,4.55626E-06}, HOV = {106,3.344974E+07,0.35995,-0.0547115,0.0583309,-0.0233634}, VapCp = {16,37380.05,-673.6637,12.72112,-0.000063263,1.539025E-09}, LiqVis = {16,0.0000263799,486.4199,-9.034853,-0.00420404,4.708051E-07}, VapVis = {16,2.344771E-06,-353.1514,-11.15186,0.000996526,-0.0000002755}, LiqK = {16,0.0169674,14.7154,-1.831383,-0.000155026,-0.0000048849}, VapK = {16,0.00541541,-765.5803,-2.581507,0.00174448,-3.307726E-07}, Racketparam = 0, UniquacR = 0, UniquacQ = 0, ChaoSeadAF = 0, ChaoSeadSP = 0, ChaoSeadLV = 0);
  end Cyclobutane;
  
  model Isopropylmercaptan
  extends General_Properties(
    SN = 428, name = "Isopropylmercaptan", CAS = "75-33-2", Tc = 517.3, Pc = 4750000,  Vc = 0.254, Cc = 0.281, Tb = 325.75, Tm = 142.61, TT = 142.64, TP = 0.00973089, MW = 76.1606, LVB = 0.0941865, AF = 0.21381, SP = 16970, DM = 5.47E-30, SH = 28500000.0, IGHF = -7.59E+07, GEF = -2180000, AS = 324300, HFMP = 5736000, HOC = -2.3684E+09, LiqDen = {105,1.093001,0.27762,517,0.29781,0}, VP = {101,52.49398,-5018.813,-4.414151,1.969036E-13,2}, LiqCp = {16,-4182.09,11.57821,11.69322,0.0000133303,0.0000020152}, HOV = {106,4.07186E+07,0.189905,0.420769,-0.0231137,-0.258009}, VapCp = {16,68588.92,-673.2911,12.50044,1.486465E-06,-1.964897E-08}, LiqVis = {16,0.0000158085,630.9957,-8.670452,-0.006493,5.676279E-06}, VapVis = {16,2.562672E-06,-300.3637,-11.49051,0.00155043,-4.080467E-07}, LiqK = {16,0.019346,8.361977,-1.76982,-0.000539416,-3.287583E-06}, VapK = {102,0.00018367,0.9627,646.01,0,0}, Racketparam = 0, UniquacR = 3.225445, UniquacQ = 2.84, ChaoSeadAF = 0, ChaoSeadSP = 0, ChaoSeadLV = 0);
  end Isopropylmercaptan;
  
  model Glycerol
  extends General_Properties(
    SN = 429, name = "Glycerol", CAS = "56-81-5", Tc = 725.15, Pc = 6660000,  Vc = 0.264, Cc = 0.28, Tb = 563.15, Tm = 291.15, TT = 291.33, TP = 0.00952225, MW = 92.0938, LVB = 0.0732027, AF = 1.544133, SP = 34540, DM = 1.4E-29, SH = 28500000.0, IGHF = -5.828E+08, GEF = -4.471E+08, AS = 396000, HFMP = 1.831E+07, HOC = -1.477E+09, LiqDen = {105,0.933664,0.246209,850,0.220672,0}, VP = {101,99.57469,-13673.87,-10.09699,1.227718E-11,2}, LiqCp = {16,115.6361,-33.33621,11.80006,0.00238285,-0.0000010098}, HOV = {106,1.1E+08,1,-2.5,3.4,-1.65}, VapCp = {16,31366.31,-311.2541,12.31511,0.000195602,1.752076E-09}, LiqVis = {10,-27,-10000,70,0,0}, VapVis = {16,1.418624E-06,-375.5227,-11.1197,0.000710923,4.531819E-08}, LiqK = {16,0.00821317,-13.47096,-1.285018,0.000197192,1.226656E-07}, VapK = {16,-0.00880104,-445.7976,-2.857337,0.000677005,8.722756E-08}, Racketparam = 0, UniquacR = 3.385629, UniquacQ = 3.06, ChaoSeadAF = 0, ChaoSeadSP = 0, ChaoSeadLV = 0);
  end Glycerol;
  
  model Neicosane
  extends General_Properties(
    SN = 430, name = "Neicosane", CAS = "112-95-8", Tc = 767, Pc = 1160000,  Vc = 1.19, Cc = 0.213, Tb = 616.95, Tm = 309.58, TT = 309.58, TP = 0.00925737, MW = 282.547, LVB = 0.360385, AF = 0.9065, SP = 16000, DM = 0, SH = 28500000.0, IGHF = -4.5576E+08, GEF = 1.157E+08, AS = 934120, HFMP = 7.03E+07, HOC = -1.239199E+10, LiqDen = {105,0.18166,0.23351,768,0.28571,0}, VP = {101,164.6909,-17503.89,-19.74205,5.399206E-06,2}, LiqCp = {100,352720,807.32,0.2122,0,0}, HOV = {106,1.286E+08,0.50351,0.32986,-0.42184,0}, VapCp = {107,324810,1109000,1636,745000,726.27}, LiqVis = {101,-10.5557,1830.385,-0.148602,-7.471032E-06,-7.49069E-06}, VapVis = {102,2.9236E-07,0.62458,702.84,0,0}, LiqK = {100,0.2178,-0.0002233,0,0,0}, VapK = {102,-375.32,1.0708,-8.7836E+09,0,0}, Racketparam = 0, UniquacR = 13.9414, UniquacQ = 11.416, ChaoSeadAF = 0.9065, ChaoSeadSP = 16000, ChaoSeadLV = 0.360385);
  end Neicosane;
  
  model DiButylCarbonate
  extends General_Properties(
    SN = 431, name = "DiButylCarbonate", CAS = "542-52-9", Tc = 577.9457, Pc = 2554740,  Vc = 0.48029, Cc = 0.255346, Tb = 480.6, Tm = 0, TT = 0, TP = 0, MW = 174.2374, LVB = 0.16285, AF = 0.380499, SP = 14896.02, DM = 0, SH = 28500000.0, IGHF = -3.824176E+07, GEF = 1.508667E+07, AS = 1355409, HFMP = 0, HOC = -5.683778E+09, LiqDen = {0,0,0,0,0,0}, VP = {10,22.02883,4492.482,-50.81,0,0}, LiqCp = {0,0,0,0,0,0}, HOV = {0,0,0,0,0,0}, VapCp = {0,0,0,0,0,0}, LiqVis = {0,0,0,0,0,0}, VapVis = {0,0,0,0,0,0}, LiqK = {100,0,0,0,0,0}, VapK = {0,0,0,0,0,0}, Racketparam = 0, UniquacR = 0, UniquacQ = 0, ChaoSeadAF = 0, ChaoSeadSP = 0, ChaoSeadLV = 0);
  end DiButylCarbonate;
end Chemsep_Database;
