/*!
 * jQuery Cycle Plugin (with Transition Definitions)
 * Examples and documentation at: http://jquery.malsup.com/cycle/
 * Copyright (c) 2007-2010 M. Alsup
 * Version: 2.9999.5 (10-APR-2012)
 * Dual licensed under the MIT and GPL licenses.
 * http://jquery.malsup.com/license.html
 * Requires: jQuery v1.3.2 or later
 */
(function($,undefined){var ver="2.9999.5";if($.support===undefined)$.support={opacity:!$.browser.msie};function debug(s){if($.fn.cycle.debug)log(s)}function log(){if(window.console&&console.log)console.log("[cycle] "+Array.prototype.join.call(arguments," "))}$.expr[":"].paused=function(el){return el.cyclePause};$.fn.cycle=function(options,arg2){var o={s:this.selector,c:this.context};if(this.length===0&&options!="stop"){if(!$.isReady&&o.s){log("DOM not ready, queuing slideshow");$(function(){$(o.s,
o.c).cycle(options,arg2)});return this}log("terminating; zero elements found by selector"+($.isReady?"":" (DOM not ready)"));return this}return this.each(function(){var opts=handleArguments(this,options,arg2);if(opts===false)return;opts.updateActivePagerLink=opts.updateActivePagerLink||$.fn.cycle.updateActivePagerLink;if(this.cycleTimeout)clearTimeout(this.cycleTimeout);this.cycleTimeout=this.cyclePause=0;this.cycleStop=0;var $cont=$(this);var $slides=opts.slideExpr?$(opts.slideExpr,this):$cont.children();
var els=$slides.get();if(els.length<2){log("terminating; too few slides: "+els.length);return}var opts2=buildOptions($cont,$slides,els,opts,o);if(opts2===false)return;var startTime=opts2.continuous?10:getTimeout(els[opts2.currSlide],els[opts2.nextSlide],opts2,!opts2.backwards);if(startTime){startTime+=opts2.delay||0;if(startTime<10)startTime=10;debug("first timeout: "+startTime);this.cycleTimeout=setTimeout(function(){go(els,opts2,0,!opts.backwards)},startTime)}})};function triggerPause(cont,byHover,
onPager){var opts=$(cont).data("cycle.opts");var paused=!!cont.cyclePause;if(paused&&opts.paused)opts.paused(cont,opts,byHover,onPager);else if(!paused&&opts.resumed)opts.resumed(cont,opts,byHover,onPager)}function handleArguments(cont,options,arg2){if(cont.cycleStop===undefined)cont.cycleStop=0;if(options===undefined||options===null)options={};if(options.constructor==String){switch(options){case "destroy":case "stop":var opts=$(cont).data("cycle.opts");if(!opts)return false;cont.cycleStop++;if(cont.cycleTimeout)clearTimeout(cont.cycleTimeout);
cont.cycleTimeout=0;if(opts.elements)$(opts.elements).stop();$(cont).removeData("cycle.opts");if(options=="destroy")destroy(cont,opts);return false;case "toggle":cont.cyclePause=cont.cyclePause===1?0:1;checkInstantResume(cont.cyclePause,arg2,cont);triggerPause(cont);return false;case "pause":cont.cyclePause=1;triggerPause(cont);return false;case "resume":cont.cyclePause=0;checkInstantResume(false,arg2,cont);triggerPause(cont);return false;case "prev":case "next":opts=$(cont).data("cycle.opts");if(!opts){log('options not found, "prev/next" ignored');
return false}$.fn.cycle[options](opts);return false;default:options={fx:options}}return options}else if(options.constructor==Number){var num=options;options=$(cont).data("cycle.opts");if(!options){log("options not found, can not advance slide");return false}if(num<0||num>=options.elements.length){log("invalid slide index: "+num);return false}options.nextSlide=num;if(cont.cycleTimeout){clearTimeout(cont.cycleTimeout);cont.cycleTimeout=0}if(typeof arg2=="string")options.oneTimeFx=arg2;go(options.elements,
options,1,num>=options.currSlide);return false}return options;function checkInstantResume(isPaused,arg2,cont){if(!isPaused&&arg2===true){var options=$(cont).data("cycle.opts");if(!options){log("options not found, can not resume");return false}if(cont.cycleTimeout){clearTimeout(cont.cycleTimeout);cont.cycleTimeout=0}go(options.elements,options,1,!options.backwards)}}}function removeFilter(el,opts){if(!$.support.opacity&&opts.cleartype&&el.style.filter)try{el.style.removeAttribute("filter")}catch(smother){}}
function destroy(cont,opts){if(opts.next)$(opts.next).unbind(opts.prevNextEvent);if(opts.prev)$(opts.prev).unbind(opts.prevNextEvent);if(opts.pager||opts.pagerAnchorBuilder)$.each(opts.pagerAnchors||[],function(){this.unbind().remove()});opts.pagerAnchors=null;$(cont).unbind("mouseenter.cycle mouseleave.cycle");if(opts.destroy)opts.destroy(opts)}function buildOptions($cont,$slides,els,options,o){var startingSlideSpecified;var opts=$.extend({},$.fn.cycle.defaults,options||{},$.metadata?$cont.metadata():
$.meta?$cont.data():{});var meta=$.isFunction($cont.data)?$cont.data(opts.metaAttr):null;if(meta)opts=$.extend(opts,meta);if(opts.autostop)opts.countdown=opts.autostopCount||els.length;var cont=$cont[0];$cont.data("cycle.opts",opts);opts.$cont=$cont;opts.stopCount=cont.cycleStop;opts.elements=els;opts.before=opts.before?[opts.before]:[];opts.after=opts.after?[opts.after]:[];if(!$.support.opacity&&opts.cleartype)opts.after.push(function(){removeFilter(this,opts)});if(opts.continuous)opts.after.push(function(){go(els,
opts,0,!opts.backwards)});saveOriginalOpts(opts);if(!$.support.opacity&&opts.cleartype&&!opts.cleartypeNoBg)clearTypeFix($slides);if($cont.css("position")=="static")$cont.css("position","relative");if(opts.width)$cont.width(opts.width);if(opts.height&&opts.height!="auto")$cont.height(opts.height);if(opts.startingSlide!==undefined){opts.startingSlide=parseInt(opts.startingSlide,10);if(opts.startingSlide>=els.length||opts.startSlide<0)opts.startingSlide=0;else startingSlideSpecified=true}else if(opts.backwards)opts.startingSlide=
els.length-1;else opts.startingSlide=0;if(opts.random){opts.randomMap=[];for(var i=0;i<els.length;i++)opts.randomMap.push(i);opts.randomMap.sort(function(a,b){return Math.random()-0.5});if(startingSlideSpecified)for(var cnt=0;cnt<els.length;cnt++){if(opts.startingSlide==opts.randomMap[cnt])opts.randomIndex=cnt}else{opts.randomIndex=1;opts.startingSlide=opts.randomMap[1]}}else if(opts.startingSlide>=els.length)opts.startingSlide=0;opts.currSlide=opts.startingSlide||0;var first=opts.startingSlide;$slides.css({position:"absolute",
top:0,left:0}).hide().each(function(i){var z;if(opts.backwards)z=first?i<=first?els.length+(i-first):first-i:els.length-i;else z=first?i>=first?els.length-(i-first):first-i:els.length-i;$(this).css("z-index",z)});$(els[first]).css("opacity",1).show();removeFilter(els[first],opts);if(opts.fit)if(!opts.aspect){if(opts.width)$slides.width(opts.width);if(opts.height&&opts.height!="auto")$slides.height(opts.height)}else $slides.each(function(){var $slide=$(this);var ratio=opts.aspect===true?$slide.width()/
$slide.height():opts.aspect;if(opts.width&&$slide.width()!=opts.width){$slide.width(opts.width);$slide.height(opts.width/ratio)}if(opts.height&&$slide.height()<opts.height){$slide.height(opts.height);$slide.width(opts.height*ratio)}});if(opts.center&&(!opts.fit||opts.aspect))$slides.each(function(){var $slide=$(this);$slide.css({"margin-left":opts.width?(opts.width-$slide.width())/2+"px":0,"margin-top":opts.height?(opts.height-$slide.height())/2+"px":0})});if(opts.center&&!opts.fit&&!opts.slideResize)$slides.each(function(){var $slide=
$(this);$slide.css({"margin-left":opts.width?(opts.width-$slide.width())/2+"px":0,"margin-top":opts.height?(opts.height-$slide.height())/2+"px":0})});var reshape=opts.containerResize&&!$cont.innerHeight();if(reshape){var maxw=0,maxh=0;for(var j=0;j<els.length;j++){var $e=$(els[j]),e=$e[0],w=$e.outerWidth(),h=$e.outerHeight();if(!w)w=e.offsetWidth||e.width||$e.attr("width");if(!h)h=e.offsetHeight||e.height||$e.attr("height");maxw=w>maxw?w:maxw;maxh=h>maxh?h:maxh}if(maxw>0&&maxh>0)$cont.css({width:maxw+
"px",height:maxh+"px"})}var pauseFlag=false;if(opts.pause)$cont.bind("mouseenter.cycle",function(){pauseFlag=true;this.cyclePause++;triggerPause(cont,true)}).bind("mouseleave.cycle",function(){if(pauseFlag)this.cyclePause--;triggerPause(cont,true)});if(supportMultiTransitions(opts)===false)return false;var requeue=false;options.requeueAttempts=options.requeueAttempts||0;$slides.each(function(){var $el=$(this);this.cycleH=opts.fit&&opts.height?opts.height:$el.height()||this.offsetHeight||this.height||
$el.attr("height")||0;this.cycleW=opts.fit&&opts.width?opts.width:$el.width()||this.offsetWidth||this.width||$el.attr("width")||0;if($el.is("img")){var loadingIE=$.browser.msie&&this.cycleW==28&&this.cycleH==30&&!this.complete;var loadingFF=$.browser.mozilla&&this.cycleW==34&&this.cycleH==19&&!this.complete;var loadingOp=$.browser.opera&&(this.cycleW==42&&this.cycleH==19||this.cycleW==37&&this.cycleH==17)&&!this.complete;var loadingOther=this.cycleH===0&&this.cycleW===0&&!this.complete;if(loadingIE||
loadingFF||loadingOp||loadingOther)if(o.s&&opts.requeueOnImageNotLoaded&&++options.requeueAttempts<100){log(options.requeueAttempts," - img slide not loaded, requeuing slideshow: ",this.src,this.cycleW,this.cycleH);setTimeout(function(){$(o.s,o.c).cycle(options)},opts.requeueTimeout);requeue=true;return false}else log("could not determine size of image: "+this.src,this.cycleW,this.cycleH)}return true});if(requeue)return false;opts.cssBefore=opts.cssBefore||{};opts.cssAfter=opts.cssAfter||{};opts.cssFirst=
opts.cssFirst||{};opts.animIn=opts.animIn||{};opts.animOut=opts.animOut||{};$slides.not(":eq("+first+")").css(opts.cssBefore);$($slides[first]).css(opts.cssFirst);if(opts.timeout){opts.timeout=parseInt(opts.timeout,10);if(opts.speed.constructor==String)opts.speed=$.fx.speeds[opts.speed]||parseInt(opts.speed,10);if(!opts.sync)opts.speed=opts.speed/2;var buffer=opts.fx=="none"?0:opts.fx=="shuffle"?500:250;while(opts.timeout-opts.speed<buffer)opts.timeout+=opts.speed}if(opts.easing)opts.easeIn=opts.easeOut=
opts.easing;if(!opts.speedIn)opts.speedIn=opts.speed;if(!opts.speedOut)opts.speedOut=opts.speed;opts.slideCount=els.length;opts.currSlide=opts.lastSlide=first;if(opts.random){if(++opts.randomIndex==els.length)opts.randomIndex=0;opts.nextSlide=opts.randomMap[opts.randomIndex]}else if(opts.backwards)opts.nextSlide=opts.startingSlide===0?els.length-1:opts.startingSlide-1;else opts.nextSlide=opts.startingSlide>=els.length-1?0:opts.startingSlide+1;if(!opts.multiFx){var init=$.fn.cycle.transitions[opts.fx];
if($.isFunction(init))init($cont,$slides,opts);else if(opts.fx!="custom"&&!opts.multiFx){log("unknown transition: "+opts.fx,"; slideshow terminating");return false}}var e0=$slides[first];if(!opts.skipInitializationCallbacks){if(opts.before.length)opts.before[0].apply(e0,[e0,e0,opts,true]);if(opts.after.length)opts.after[0].apply(e0,[e0,e0,opts,true])}if(opts.next)$(opts.next).bind(opts.prevNextEvent,function(){return advance(opts,1)});if(opts.prev)$(opts.prev).bind(opts.prevNextEvent,function(){return advance(opts,
0)});if(opts.pager||opts.pagerAnchorBuilder)buildPager(els,opts);exposeAddSlide(opts,els);return opts}function saveOriginalOpts(opts){opts.original={before:[],after:[]};opts.original.cssBefore=$.extend({},opts.cssBefore);opts.original.cssAfter=$.extend({},opts.cssAfter);opts.original.animIn=$.extend({},opts.animIn);opts.original.animOut=$.extend({},opts.animOut);$.each(opts.before,function(){opts.original.before.push(this)});$.each(opts.after,function(){opts.original.after.push(this)})}function supportMultiTransitions(opts){var i,
tx,txs=$.fn.cycle.transitions;if(opts.fx.indexOf(",")>0){opts.multiFx=true;opts.fxs=opts.fx.replace(/\s*/g,"").split(",");for(i=0;i<opts.fxs.length;i++){var fx=opts.fxs[i];tx=txs[fx];if(!tx||!txs.hasOwnProperty(fx)||!$.isFunction(tx)){log("discarding unknown transition: ",fx);opts.fxs.splice(i,1);i--}}if(!opts.fxs.length){log("No valid transitions named; slideshow terminating.");return false}}else if(opts.fx=="all"){opts.multiFx=true;opts.fxs=[];for(var p in txs)if(txs.hasOwnProperty(p)){tx=txs[p];
if(txs.hasOwnProperty(p)&&$.isFunction(tx))opts.fxs.push(p)}}if(opts.multiFx&&opts.randomizeEffects){var r1=Math.floor(Math.random()*20)+30;for(i=0;i<r1;i++){var r2=Math.floor(Math.random()*opts.fxs.length);opts.fxs.push(opts.fxs.splice(r2,1)[0])}debug("randomized fx sequence: ",opts.fxs)}return true}function exposeAddSlide(opts,els){opts.addSlide=function(newSlide,prepend){var $s=$(newSlide),s=$s[0];if(!opts.autostopCount)opts.countdown++;els[prepend?"unshift":"push"](s);if(opts.els)opts.els[prepend?
"unshift":"push"](s);opts.slideCount=els.length;if(opts.random){opts.randomMap.push(opts.slideCount-1);opts.randomMap.sort(function(a,b){return Math.random()-0.5})}$s.css("position","absolute");$s[prepend?"prependTo":"appendTo"](opts.$cont);if(prepend){opts.currSlide++;opts.nextSlide++}if(!$.support.opacity&&opts.cleartype&&!opts.cleartypeNoBg)clearTypeFix($s);if(opts.fit&&opts.width)$s.width(opts.width);if(opts.fit&&opts.height&&opts.height!="auto")$s.height(opts.height);s.cycleH=opts.fit&&opts.height?
opts.height:$s.height();s.cycleW=opts.fit&&opts.width?opts.width:$s.width();$s.css(opts.cssBefore);if(opts.pager||opts.pagerAnchorBuilder)$.fn.cycle.createPagerAnchor(els.length-1,s,$(opts.pager),els,opts);if($.isFunction(opts.onAddSlide))opts.onAddSlide($s);else $s.hide()}}$.fn.cycle.resetState=function(opts,fx){fx=fx||opts.fx;opts.before=[];opts.after=[];opts.cssBefore=$.extend({},opts.original.cssBefore);opts.cssAfter=$.extend({},opts.original.cssAfter);opts.animIn=$.extend({},opts.original.animIn);
opts.animOut=$.extend({},opts.original.animOut);opts.fxFn=null;$.each(opts.original.before,function(){opts.before.push(this)});$.each(opts.original.after,function(){opts.after.push(this)});var init=$.fn.cycle.transitions[fx];if($.isFunction(init))init(opts.$cont,$(opts.elements),opts)};function go(els,opts,manual,fwd){var p=opts.$cont[0],curr=els[opts.currSlide],next=els[opts.nextSlide];if(manual&&opts.busy&&opts.manualTrump){debug("manualTrump in go(), stopping active transition");$(els).stop(true,
true);opts.busy=0;clearTimeout(p.cycleTimeout)}if(opts.busy){debug("transition active, ignoring new tx request");return}if(p.cycleStop!=opts.stopCount||p.cycleTimeout===0&&!manual)return;if(!manual&&!p.cyclePause&&!opts.bounce&&(opts.autostop&&--opts.countdown<=0||opts.nowrap&&!opts.random&&opts.nextSlide<opts.currSlide)){if(opts.end)opts.end(opts);return}var changed=false;if((manual||!p.cyclePause)&&opts.nextSlide!=opts.currSlide){changed=true;var fx=opts.fx;curr.cycleH=curr.cycleH||$(curr).height();
curr.cycleW=curr.cycleW||$(curr).width();next.cycleH=next.cycleH||$(next).height();next.cycleW=next.cycleW||$(next).width();if(opts.multiFx){if(fwd&&(opts.lastFx===undefined||++opts.lastFx>=opts.fxs.length))opts.lastFx=0;else if(!fwd&&(opts.lastFx===undefined||--opts.lastFx<0))opts.lastFx=opts.fxs.length-1;fx=opts.fxs[opts.lastFx]}if(opts.oneTimeFx){fx=opts.oneTimeFx;opts.oneTimeFx=null}$.fn.cycle.resetState(opts,fx);if(opts.before.length)$.each(opts.before,function(i,o){if(p.cycleStop!=opts.stopCount)return;
o.apply(next,[curr,next,opts,fwd])});var after=function(){opts.busy=0;$.each(opts.after,function(i,o){if(p.cycleStop!=opts.stopCount)return;o.apply(next,[curr,next,opts,fwd])});if(!p.cycleStop)queueNext()};debug("tx firing("+fx+"); currSlide: "+opts.currSlide+"; nextSlide: "+opts.nextSlide);opts.busy=1;if(opts.fxFn)opts.fxFn(curr,next,opts,after,fwd,manual&&opts.fastOnEvent);else if($.isFunction($.fn.cycle[opts.fx]))$.fn.cycle[opts.fx](curr,next,opts,after,fwd,manual&&opts.fastOnEvent);else $.fn.cycle.custom(curr,
next,opts,after,fwd,manual&&opts.fastOnEvent)}else queueNext();if(changed||opts.nextSlide==opts.currSlide){var roll;opts.lastSlide=opts.currSlide;if(opts.random){opts.currSlide=opts.nextSlide;if(++opts.randomIndex==els.length){opts.randomIndex=0;opts.randomMap.sort(function(a,b){return Math.random()-0.5})}opts.nextSlide=opts.randomMap[opts.randomIndex];if(opts.nextSlide==opts.currSlide)opts.nextSlide=opts.currSlide==opts.slideCount-1?0:opts.currSlide+1}else if(opts.backwards){roll=opts.nextSlide-
1<0;if(roll&&opts.bounce){opts.backwards=!opts.backwards;opts.nextSlide=1;opts.currSlide=0}else{opts.nextSlide=roll?els.length-1:opts.nextSlide-1;opts.currSlide=roll?0:opts.nextSlide+1}}else{roll=opts.nextSlide+1==els.length;if(roll&&opts.bounce){opts.backwards=!opts.backwards;opts.nextSlide=els.length-2;opts.currSlide=els.length-1}else{opts.nextSlide=roll?0:opts.nextSlide+1;opts.currSlide=roll?els.length-1:opts.nextSlide-1}}}if(changed&&opts.pager)opts.updateActivePagerLink(opts.pager,opts.currSlide,
opts.activePagerClass);function queueNext(){var ms=0,timeout=opts.timeout;if(opts.timeout&&!opts.continuous){ms=getTimeout(els[opts.currSlide],els[opts.nextSlide],opts,fwd);if(opts.fx=="shuffle")ms-=opts.speedOut}else if(opts.continuous&&p.cyclePause)ms=10;if(ms>0)p.cycleTimeout=setTimeout(function(){go(els,opts,0,!opts.backwards)},ms)}}$.fn.cycle.updateActivePagerLink=function(pager,currSlide,clsName){$(pager).each(function(){$(this).children().removeClass(clsName).eq(currSlide).addClass(clsName)})};
function getTimeout(curr,next,opts,fwd){if(opts.timeoutFn){var t=opts.timeoutFn.call(curr,curr,next,opts,fwd);while(opts.fx!="none"&&t-opts.speed<250)t+=opts.speed;debug("calculated timeout: "+t+"; speed: "+opts.speed);if(t!==false)return t}return opts.timeout}$.fn.cycle.next=function(opts){advance(opts,1)};$.fn.cycle.prev=function(opts){advance(opts,0)};function advance(opts,moveForward){var val=moveForward?1:-1;var els=opts.elements;var p=opts.$cont[0],timeout=p.cycleTimeout;if(timeout){clearTimeout(timeout);
p.cycleTimeout=0}if(opts.random&&val<0){opts.randomIndex--;if(--opts.randomIndex==-2)opts.randomIndex=els.length-2;else if(opts.randomIndex==-1)opts.randomIndex=els.length-1;opts.nextSlide=opts.randomMap[opts.randomIndex]}else if(opts.random)opts.nextSlide=opts.randomMap[opts.randomIndex];else{opts.nextSlide=opts.currSlide+val;if(opts.nextSlide<0){if(opts.nowrap)return false;opts.nextSlide=els.length-1}else if(opts.nextSlide>=els.length){if(opts.nowrap)return false;opts.nextSlide=0}}var cb=opts.onPrevNextEvent||
opts.prevNextClick;if($.isFunction(cb))cb(val>0,opts.nextSlide,els[opts.nextSlide]);go(els,opts,1,moveForward);return false}function buildPager(els,opts){var $p=$(opts.pager);$.each(els,function(i,o){$.fn.cycle.createPagerAnchor(i,o,$p,els,opts)});opts.updateActivePagerLink(opts.pager,opts.startingSlide,opts.activePagerClass)}$.fn.cycle.createPagerAnchor=function(i,el,$p,els,opts){var a;if($.isFunction(opts.pagerAnchorBuilder)){a=opts.pagerAnchorBuilder(i,el);debug("pagerAnchorBuilder("+i+", el) returned: "+
a)}else a='<a href="#">'+(i+1)+"</a>";if(!a)return;var $a=$(a);if($a.parents("body").length===0){var arr=[];if($p.length>1){$p.each(function(){var $clone=$a.clone(true);$(this).append($clone);arr.push($clone[0])});$a=$(arr)}else $a.appendTo($p)}opts.pagerAnchors=opts.pagerAnchors||[];opts.pagerAnchors.push($a);var pagerFn=function(e){e.preventDefault();opts.nextSlide=i;var p=opts.$cont[0],timeout=p.cycleTimeout;if(timeout){clearTimeout(timeout);p.cycleTimeout=0}var cb=opts.onPagerEvent||opts.pagerClick;
if($.isFunction(cb))cb(opts.nextSlide,els[opts.nextSlide]);go(els,opts,1,opts.currSlide<i)};if(/mouseenter|mouseover/i.test(opts.pagerEvent))$a.hover(pagerFn,function(){});else $a.bind(opts.pagerEvent,pagerFn);if(!/^click/.test(opts.pagerEvent)&&!opts.allowPagerClickBubble)$a.bind("click.cycle",function(){return false});var cont=opts.$cont[0];var pauseFlag=false;if(opts.pauseOnPagerHover)$a.hover(function(){pauseFlag=true;cont.cyclePause++;triggerPause(cont,true,true)},function(){if(pauseFlag)cont.cyclePause--;
triggerPause(cont,true,true)})};$.fn.cycle.hopsFromLast=function(opts,fwd){var hops,l=opts.lastSlide,c=opts.currSlide;if(fwd)hops=c>l?c-l:opts.slideCount-l;else hops=c<l?l-c:l+opts.slideCount-c;return hops};function clearTypeFix($slides){debug("applying clearType background-color hack");function hex(s){s=parseInt(s,10).toString(16);return s.length<2?"0"+s:s}function getBg(e){for(;e&&e.nodeName.toLowerCase()!="html";e=e.parentNode){var v=$.css(e,"background-color");if(v&&v.indexOf("rgb")>=0){var rgb=
v.match(/\d+/g);return"#"+hex(rgb[0])+hex(rgb[1])+hex(rgb[2])}if(v&&v!="transparent")return v}return"#ffffff"}$slides.each(function(){$(this).css("background-color",getBg(this))})}$.fn.cycle.commonReset=function(curr,next,opts,w,h,rev){$(opts.elements).not(curr).hide();if(typeof opts.cssBefore.opacity=="undefined")opts.cssBefore.opacity=1;opts.cssBefore.display="block";if(opts.slideResize&&w!==false&&next.cycleW>0)opts.cssBefore.width=next.cycleW;if(opts.slideResize&&h!==false&&next.cycleH>0)opts.cssBefore.height=
next.cycleH;opts.cssAfter=opts.cssAfter||{};opts.cssAfter.display="none";$(curr).css("zIndex",opts.slideCount+(rev===true?1:0));$(next).css("zIndex",opts.slideCount+(rev===true?0:1))};$.fn.cycle.custom=function(curr,next,opts,cb,fwd,speedOverride){var $l=$(curr),$n=$(next);var speedIn=opts.speedIn,speedOut=opts.speedOut,easeIn=opts.easeIn,easeOut=opts.easeOut;$n.css(opts.cssBefore);if(speedOverride){if(typeof speedOverride=="number")speedIn=speedOut=speedOverride;else speedIn=speedOut=1;easeIn=easeOut=
null}var fn=function(){$n.animate(opts.animIn,speedIn,easeIn,function(){cb()})};$l.animate(opts.animOut,speedOut,easeOut,function(){$l.css(opts.cssAfter);if(!opts.sync)fn()});if(opts.sync)fn()};$.fn.cycle.transitions={fade:function($cont,$slides,opts){$slides.not(":eq("+opts.currSlide+")").css("opacity",0);opts.before.push(function(curr,next,opts){$.fn.cycle.commonReset(curr,next,opts);opts.cssBefore.opacity=0});opts.animIn={opacity:1};opts.animOut={opacity:0};opts.cssBefore={top:0,left:0}}};$.fn.cycle.ver=
function(){return ver};$.fn.cycle.defaults={activePagerClass:"activeSlide",after:null,allowPagerClickBubble:false,animIn:null,animOut:null,aspect:false,autostop:0,autostopCount:0,backwards:false,before:null,center:null,cleartype:!$.support.opacity,cleartypeNoBg:false,containerResize:1,continuous:0,cssAfter:null,cssBefore:null,delay:0,easeIn:null,easeOut:null,easing:null,end:null,fastOnEvent:0,fit:0,fx:"fade",fxFn:null,height:"auto",manualTrump:true,metaAttr:"cycle",next:null,nowrap:0,onPagerEvent:null,
onPrevNextEvent:null,pager:null,pagerAnchorBuilder:null,pagerEvent:"click.cycle",pause:0,pauseOnPagerHover:0,prev:null,prevNextEvent:"click.cycle",random:0,randomizeEffects:1,requeueOnImageNotLoaded:true,requeueTimeout:250,rev:0,shuffle:null,skipInitializationCallbacks:false,slideExpr:null,slideResize:1,speed:1E3,speedIn:null,speedOut:null,startingSlide:undefined,sync:1,timeout:4E3,timeoutFn:null,updateActivePagerLink:null,width:null}})(jQuery);
(function($){$.fn.cycle.transitions.none=function($cont,$slides,opts){opts.fxFn=function(curr,next,opts,after){$(next).show();$(curr).hide();after()}};$.fn.cycle.transitions.fadeout=function($cont,$slides,opts){$slides.not(":eq("+opts.currSlide+")").css({display:"block","opacity":1});opts.before.push(function(curr,next,opts,w,h,rev){$(curr).css("zIndex",opts.slideCount+(rev!==true?1:0));$(next).css("zIndex",opts.slideCount+(rev!==true?0:1))});opts.animIn.opacity=1;opts.animOut.opacity=0;opts.cssBefore.opacity=
1;opts.cssBefore.display="block";opts.cssAfter.zIndex=0};$.fn.cycle.transitions.scrollUp=function($cont,$slides,opts){$cont.css("overflow","hidden");opts.before.push($.fn.cycle.commonReset);var h=$cont.height();opts.cssBefore.top=h;opts.cssBefore.left=0;opts.cssFirst.top=0;opts.animIn.top=0;opts.animOut.top=-h};$.fn.cycle.transitions.scrollDown=function($cont,$slides,opts){$cont.css("overflow","hidden");opts.before.push($.fn.cycle.commonReset);var h=$cont.height();opts.cssFirst.top=0;opts.cssBefore.top=
-h;opts.cssBefore.left=0;opts.animIn.top=0;opts.animOut.top=h};$.fn.cycle.transitions.scrollLeft=function($cont,$slides,opts){$cont.css("overflow","hidden");opts.before.push($.fn.cycle.commonReset);var w=$cont.width();opts.cssFirst.left=0;opts.cssBefore.left=w;opts.cssBefore.top=0;opts.animIn.left=0;opts.animOut.left=0-w};$.fn.cycle.transitions.scrollRight=function($cont,$slides,opts){$cont.css("overflow","hidden");opts.before.push($.fn.cycle.commonReset);var w=$cont.width();opts.cssFirst.left=0;
opts.cssBefore.left=-w;opts.cssBefore.top=0;opts.animIn.left=0;opts.animOut.left=w};$.fn.cycle.transitions.scrollHorz=function($cont,$slides,opts){$cont.css("overflow","hidden").width();opts.before.push(function(curr,next,opts,fwd){if(opts.rev)fwd=!fwd;$.fn.cycle.commonReset(curr,next,opts);opts.cssBefore.left=fwd?next.cycleW-1:1-next.cycleW;opts.animOut.left=fwd?-curr.cycleW:curr.cycleW});opts.cssFirst.left=0;opts.cssBefore.top=0;opts.animIn.left=0;opts.animOut.top=0};$.fn.cycle.transitions.scrollVert=
function($cont,$slides,opts){$cont.css("overflow","hidden");opts.before.push(function(curr,next,opts,fwd){if(opts.rev)fwd=!fwd;$.fn.cycle.commonReset(curr,next,opts);opts.cssBefore.top=fwd?1-next.cycleH:next.cycleH-1;opts.animOut.top=fwd?curr.cycleH:-curr.cycleH});opts.cssFirst.top=0;opts.cssBefore.left=0;opts.animIn.top=0;opts.animOut.left=0};$.fn.cycle.transitions.slideX=function($cont,$slides,opts){opts.before.push(function(curr,next,opts){$(opts.elements).not(curr).hide();$.fn.cycle.commonReset(curr,
next,opts,false,true);opts.animIn.width=next.cycleW});opts.cssBefore.left=0;opts.cssBefore.top=0;opts.cssBefore.width=0;opts.animIn.width="show";opts.animOut.width=0};$.fn.cycle.transitions.slideY=function($cont,$slides,opts){opts.before.push(function(curr,next,opts){$(opts.elements).not(curr).hide();$.fn.cycle.commonReset(curr,next,opts,true,false);opts.animIn.height=next.cycleH});opts.cssBefore.left=0;opts.cssBefore.top=0;opts.cssBefore.height=0;opts.animIn.height="show";opts.animOut.height=0};
$.fn.cycle.transitions.shuffle=function($cont,$slides,opts){var i,w=$cont.css("overflow","visible").width();$slides.css({left:0,top:0});opts.before.push(function(curr,next,opts){$.fn.cycle.commonReset(curr,next,opts,true,true,true)});if(!opts.speedAdjusted){opts.speed=opts.speed/2;opts.speedAdjusted=true}opts.random=0;opts.shuffle=opts.shuffle||{left:-w,top:15};opts.els=[];for(i=0;i<$slides.length;i++)opts.els.push($slides[i]);for(i=0;i<opts.currSlide;i++)opts.els.push(opts.els.shift());opts.fxFn=
function(curr,next,opts,cb,fwd){if(opts.rev)fwd=!fwd;var $el=fwd?$(curr):$(next);$(next).css(opts.cssBefore);var count=opts.slideCount;$el.animate(opts.shuffle,opts.speedIn,opts.easeIn,function(){var hops=$.fn.cycle.hopsFromLast(opts,fwd);for(var k=0;k<hops;k++)if(fwd)opts.els.push(opts.els.shift());else opts.els.unshift(opts.els.pop());if(fwd)for(var i=0,len=opts.els.length;i<len;i++)$(opts.els[i]).css("z-index",len-i+count);else{var z=$(curr).css("z-index");$el.css("z-index",parseInt(z,10)+1+count)}$el.animate({left:0,
top:0},opts.speedOut,opts.easeOut,function(){$(fwd?this:curr).hide();if(cb)cb()})})};$.extend(opts.cssBefore,{display:"block",opacity:1,top:0,left:0})};$.fn.cycle.transitions.turnUp=function($cont,$slides,opts){opts.before.push(function(curr,next,opts){$.fn.cycle.commonReset(curr,next,opts,true,false);opts.cssBefore.top=next.cycleH;opts.animIn.height=next.cycleH;opts.animOut.width=next.cycleW});opts.cssFirst.top=0;opts.cssBefore.left=0;opts.cssBefore.height=0;opts.animIn.top=0;opts.animOut.height=
0};$.fn.cycle.transitions.turnDown=function($cont,$slides,opts){opts.before.push(function(curr,next,opts){$.fn.cycle.commonReset(curr,next,opts,true,false);opts.animIn.height=next.cycleH;opts.animOut.top=curr.cycleH});opts.cssFirst.top=0;opts.cssBefore.left=0;opts.cssBefore.top=0;opts.cssBefore.height=0;opts.animOut.height=0};$.fn.cycle.transitions.turnLeft=function($cont,$slides,opts){opts.before.push(function(curr,next,opts){$.fn.cycle.commonReset(curr,next,opts,false,true);opts.cssBefore.left=
next.cycleW;opts.animIn.width=next.cycleW});opts.cssBefore.top=0;opts.cssBefore.width=0;opts.animIn.left=0;opts.animOut.width=0};$.fn.cycle.transitions.turnRight=function($cont,$slides,opts){opts.before.push(function(curr,next,opts){$.fn.cycle.commonReset(curr,next,opts,false,true);opts.animIn.width=next.cycleW;opts.animOut.left=curr.cycleW});$.extend(opts.cssBefore,{top:0,left:0,width:0});opts.animIn.left=0;opts.animOut.width=0};$.fn.cycle.transitions.zoom=function($cont,$slides,opts){opts.before.push(function(curr,
next,opts){$.fn.cycle.commonReset(curr,next,opts,false,false,true);opts.cssBefore.top=next.cycleH/2;opts.cssBefore.left=next.cycleW/2;$.extend(opts.animIn,{top:0,left:0,width:next.cycleW,height:next.cycleH});$.extend(opts.animOut,{width:0,height:0,top:curr.cycleH/2,left:curr.cycleW/2})});opts.cssFirst.top=0;opts.cssFirst.left=0;opts.cssBefore.width=0;opts.cssBefore.height=0};$.fn.cycle.transitions.fadeZoom=function($cont,$slides,opts){opts.before.push(function(curr,next,opts){$.fn.cycle.commonReset(curr,
next,opts,false,false);opts.cssBefore.left=next.cycleW/2;opts.cssBefore.top=next.cycleH/2;$.extend(opts.animIn,{top:0,left:0,width:next.cycleW,height:next.cycleH})});opts.cssBefore.width=0;opts.cssBefore.height=0;opts.animOut.opacity=0};$.fn.cycle.transitions.blindX=function($cont,$slides,opts){var w=$cont.css("overflow","hidden").width();opts.before.push(function(curr,next,opts){$.fn.cycle.commonReset(curr,next,opts);opts.animIn.width=next.cycleW;opts.animOut.left=curr.cycleW});opts.cssBefore.left=
w;opts.cssBefore.top=0;opts.animIn.left=0;opts.animOut.left=w};$.fn.cycle.transitions.blindY=function($cont,$slides,opts){var h=$cont.css("overflow","hidden").height();opts.before.push(function(curr,next,opts){$.fn.cycle.commonReset(curr,next,opts);opts.animIn.height=next.cycleH;opts.animOut.top=curr.cycleH});opts.cssBefore.top=h;opts.cssBefore.left=0;opts.animIn.top=0;opts.animOut.top=h};$.fn.cycle.transitions.blindZ=function($cont,$slides,opts){var h=$cont.css("overflow","hidden").height();var w=
$cont.width();opts.before.push(function(curr,next,opts){$.fn.cycle.commonReset(curr,next,opts);opts.animIn.height=next.cycleH;opts.animOut.top=curr.cycleH});opts.cssBefore.top=h;opts.cssBefore.left=w;opts.animIn.top=0;opts.animIn.left=0;opts.animOut.top=h;opts.animOut.left=w};$.fn.cycle.transitions.growX=function($cont,$slides,opts){opts.before.push(function(curr,next,opts){$.fn.cycle.commonReset(curr,next,opts,false,true);opts.cssBefore.left=this.cycleW/2;opts.animIn.left=0;opts.animIn.width=this.cycleW;
opts.animOut.left=0});opts.cssBefore.top=0;opts.cssBefore.width=0};$.fn.cycle.transitions.growY=function($cont,$slides,opts){opts.before.push(function(curr,next,opts){$.fn.cycle.commonReset(curr,next,opts,true,false);opts.cssBefore.top=this.cycleH/2;opts.animIn.top=0;opts.animIn.height=this.cycleH;opts.animOut.top=0});opts.cssBefore.height=0;opts.cssBefore.left=0};$.fn.cycle.transitions.curtainX=function($cont,$slides,opts){opts.before.push(function(curr,next,opts){$.fn.cycle.commonReset(curr,next,
opts,false,true,true);opts.cssBefore.left=next.cycleW/2;opts.animIn.left=0;opts.animIn.width=this.cycleW;opts.animOut.left=curr.cycleW/2;opts.animOut.width=0});opts.cssBefore.top=0;opts.cssBefore.width=0};$.fn.cycle.transitions.curtainY=function($cont,$slides,opts){opts.before.push(function(curr,next,opts){$.fn.cycle.commonReset(curr,next,opts,true,false,true);opts.cssBefore.top=next.cycleH/2;opts.animIn.top=0;opts.animIn.height=next.cycleH;opts.animOut.top=curr.cycleH/2;opts.animOut.height=0});opts.cssBefore.height=
0;opts.cssBefore.left=0};$.fn.cycle.transitions.cover=function($cont,$slides,opts){var d=opts.direction||"left";var w=$cont.css("overflow","hidden").width();var h=$cont.height();opts.before.push(function(curr,next,opts){$.fn.cycle.commonReset(curr,next,opts);if(d=="right")opts.cssBefore.left=-w;else if(d=="up")opts.cssBefore.top=h;else if(d=="down")opts.cssBefore.top=-h;else opts.cssBefore.left=w});opts.animIn.left=0;opts.animIn.top=0;opts.cssBefore.top=0;opts.cssBefore.left=0};$.fn.cycle.transitions.uncover=
function($cont,$slides,opts){var d=opts.direction||"left";var w=$cont.css("overflow","hidden").width();var h=$cont.height();opts.before.push(function(curr,next,opts){$.fn.cycle.commonReset(curr,next,opts,true,true,true);if(d=="right")opts.animOut.left=w;else if(d=="up")opts.animOut.top=-h;else if(d=="down")opts.animOut.top=h;else opts.animOut.left=-w});opts.animIn.left=0;opts.animIn.top=0;opts.cssBefore.top=0;opts.cssBefore.left=0};$.fn.cycle.transitions.toss=function($cont,$slides,opts){var w=$cont.css("overflow",
"visible").width();var h=$cont.height();opts.before.push(function(curr,next,opts){$.fn.cycle.commonReset(curr,next,opts,true,true,true);if(!opts.animOut.left&&!opts.animOut.top)$.extend(opts.animOut,{left:w*2,top:-h/2,opacity:0});else opts.animOut.opacity=0});opts.cssBefore.left=0;opts.cssBefore.top=0;opts.animIn.left=0};$.fn.cycle.transitions.wipe=function($cont,$slides,opts){var w=$cont.css("overflow","hidden").width();var h=$cont.height();opts.cssBefore=opts.cssBefore||{};var clip;if(opts.clip)if(/l2r/.test(opts.clip))clip=
"rect(0px 0px "+h+"px 0px)";else if(/r2l/.test(opts.clip))clip="rect(0px "+w+"px "+h+"px "+w+"px)";else if(/t2b/.test(opts.clip))clip="rect(0px "+w+"px 0px 0px)";else if(/b2t/.test(opts.clip))clip="rect("+h+"px "+w+"px "+h+"px 0px)";else if(/zoom/.test(opts.clip)){var top=parseInt(h/2,10);var left=parseInt(w/2,10);clip="rect("+top+"px "+left+"px "+top+"px "+left+"px)"}opts.cssBefore.clip=opts.cssBefore.clip||clip||"rect(0px 0px 0px 0px)";var d=opts.cssBefore.clip.match(/(\d+)/g);var t=parseInt(d[0],
10),r=parseInt(d[1],10),b=parseInt(d[2],10),l=parseInt(d[3],10);opts.before.push(function(curr,next,opts){if(curr==next)return;var $curr=$(curr),$next=$(next);$.fn.cycle.commonReset(curr,next,opts,true,true,false);opts.cssAfter.display="block";var step=1,count=parseInt(opts.speedIn/13,10)-1;(function f(){var tt=t?t-parseInt(step*(t/count),10):0;var ll=l?l-parseInt(step*(l/count),10):0;var bb=b<h?b+parseInt(step*((h-b)/count||1),10):h;var rr=r<w?r+parseInt(step*((w-r)/count||1),10):w;$next.css({clip:"rect("+
tt+"px "+rr+"px "+bb+"px "+ll+"px)"});step++<=count?setTimeout(f,13):$curr.css("display","none")})()});$.extend(opts.cssBefore,{display:"block",opacity:1,top:0,left:0});opts.animIn={left:0};opts.animOut={left:0}}})(jQuery);
;/*})'"*/;/*})'"*/
/*!
 * jQuery Cycle set up
 * Version: 1.0
 * Description: Featured slider to display in header.php
 */

jQuery(window).load(function() {
 
  var transition_effect = "fade";
  var transition_delay = "5000";
  var transition_duration = "1000";

  jQuery('#slider-wrap').cycle({ 
    fx: transition_effect, // name of transition effect (or comma separated names, ex: 'fade,scrollUp,shuffle') 
    next: '#nav-slider .nav-next',    // advances slideshow to next slide 
    prev: '#nav-slider .nav-previous',    // advances slideshow to previous slide
    timeout: transition_delay,  // milliseconds between slide transitions (0 to disable auto advance) 
    speed: transition_duration,  // speed of the transition (any valid fx speed value) 
    pause: 1,     // true to enable "pause on hover" 
    pauseOnPagerHover: 1, // true to pause when hovering over pager link 
    width: '100%',
    containerResize: 0,   // resize container to fit largest slide 
    fit: 1,
    after: function (){
        jQuery(this).parent().css("height", jQuery(this).height());
      }
  });

});
;/*})'"*/;/*})'"*/
/*!
	Colorbox 1.6.4
	license: MIT
	http://www.jacklmoore.com/colorbox
*/
(function(t,e,i){function n(i,n,o){var r=e.createElement(i);return n&&(r.id=Z+n),o&&(r.style.cssText=o),t(r)}function o(){return i.innerHeight?i.innerHeight:t(i).height()}function r(e,i){i!==Object(i)&&(i={}),this.cache={},this.el=e,this.value=function(e){var n;return void 0===this.cache[e]&&(n=t(this.el).attr("data-cbox-"+e),void 0!==n?this.cache[e]=n:void 0!==i[e]?this.cache[e]=i[e]:void 0!==X[e]&&(this.cache[e]=X[e])),this.cache[e]},this.get=function(e){var i=this.value(e);return t.isFunction(i)?i.call(this.el,this):i}}function h(t){var e=W.length,i=(A+t)%e;return 0>i?e+i:i}function a(t,e){return Math.round((/%/.test(t)?("x"===e?E.width():o())/100:1)*parseInt(t,10))}function s(t,e){return t.get("photo")||t.get("photoRegex").test(e)}function l(t,e){return t.get("retinaUrl")&&i.devicePixelRatio>1?e.replace(t.get("photoRegex"),t.get("retinaSuffix")):e}function d(t){"contains"in x[0]&&!x[0].contains(t.target)&&t.target!==v[0]&&(t.stopPropagation(),x.focus())}function c(t){c.str!==t&&(x.add(v).removeClass(c.str).addClass(t),c.str=t)}function g(e){A=0,e&&e!==!1&&"nofollow"!==e?(W=t("."+te).filter(function(){var i=t.data(this,Y),n=new r(this,i);return n.get("rel")===e}),A=W.index(_.el),-1===A&&(W=W.add(_.el),A=W.length-1)):W=t(_.el)}function u(i){t(e).trigger(i),ae.triggerHandler(i)}function f(i){var o;if(!G){if(o=t(i).data(Y),_=new r(i,o),g(_.get("rel")),!U){U=$=!0,c(_.get("className")),x.css({visibility:"hidden",display:"block",opacity:""}),I=n(se,"LoadedContent","width:0; height:0; overflow:hidden; visibility:hidden"),b.css({width:"",height:""}).append(I),j=T.height()+k.height()+b.outerHeight(!0)-b.height(),D=C.width()+H.width()+b.outerWidth(!0)-b.width(),N=I.outerHeight(!0),z=I.outerWidth(!0);var h=a(_.get("initialWidth"),"x"),s=a(_.get("initialHeight"),"y"),l=_.get("maxWidth"),f=_.get("maxHeight");_.w=Math.max((l!==!1?Math.min(h,a(l,"x")):h)-z-D,0),_.h=Math.max((f!==!1?Math.min(s,a(f,"y")):s)-N-j,0),I.css({width:"",height:_.h}),J.position(),u(ee),_.get("onOpen"),O.add(F).hide(),x.focus(),_.get("trapFocus")&&e.addEventListener&&(e.addEventListener("focus",d,!0),ae.one(re,function(){e.removeEventListener("focus",d,!0)})),_.get("returnFocus")&&ae.one(re,function(){t(_.el).focus()})}var p=parseFloat(_.get("opacity"));v.css({opacity:p===p?p:"",cursor:_.get("overlayClose")?"pointer":"",visibility:"visible"}).show(),_.get("closeButton")?B.html(_.get("close")).appendTo(b):B.appendTo("<div/>"),w()}}function p(){x||(V=!1,E=t(i),x=n(se).attr({id:Y,"class":t.support.opacity===!1?Z+"IE":"",role:"dialog",tabindex:"-1"}).hide(),v=n(se,"Overlay").hide(),L=t([n(se,"LoadingOverlay")[0],n(se,"LoadingGraphic")[0]]),y=n(se,"Wrapper"),b=n(se,"Content").append(F=n(se,"Title"),R=n(se,"Current"),P=t('<button type="button"/>').attr({id:Z+"Previous"}),K=t('<button type="button"/>').attr({id:Z+"Next"}),S=t('<button type="button"/>').attr({id:Z+"Slideshow"}),L),B=t('<button type="button"/>').attr({id:Z+"Close"}),y.append(n(se).append(n(se,"TopLeft"),T=n(se,"TopCenter"),n(se,"TopRight")),n(se,!1,"clear:left").append(C=n(se,"MiddleLeft"),b,H=n(se,"MiddleRight")),n(se,!1,"clear:left").append(n(se,"BottomLeft"),k=n(se,"BottomCenter"),n(se,"BottomRight"))).find("div div").css({"float":"left"}),M=n(se,!1,"position:absolute; width:9999px; visibility:hidden; display:none; max-width:none;"),O=K.add(P).add(R).add(S)),e.body&&!x.parent().length&&t(e.body).append(v,x.append(y,M))}function m(){function i(t){t.which>1||t.shiftKey||t.altKey||t.metaKey||t.ctrlKey||(t.preventDefault(),f(this))}return x?(V||(V=!0,K.click(function(){J.next()}),P.click(function(){J.prev()}),B.click(function(){J.close()}),v.click(function(){_.get("overlayClose")&&J.close()}),t(e).bind("keydown."+Z,function(t){var e=t.keyCode;U&&_.get("escKey")&&27===e&&(t.preventDefault(),J.close()),U&&_.get("arrowKey")&&W[1]&&!t.altKey&&(37===e?(t.preventDefault(),P.click()):39===e&&(t.preventDefault(),K.click()))}),t.isFunction(t.fn.on)?t(e).on("click."+Z,"."+te,i):t("."+te).live("click."+Z,i)),!0):!1}function w(){var e,o,r,h=J.prep,d=++le;if($=!0,q=!1,u(he),u(ie),_.get("onLoad"),_.h=_.get("height")?a(_.get("height"),"y")-N-j:_.get("innerHeight")&&a(_.get("innerHeight"),"y"),_.w=_.get("width")?a(_.get("width"),"x")-z-D:_.get("innerWidth")&&a(_.get("innerWidth"),"x"),_.mw=_.w,_.mh=_.h,_.get("maxWidth")&&(_.mw=a(_.get("maxWidth"),"x")-z-D,_.mw=_.w&&_.w<_.mw?_.w:_.mw),_.get("maxHeight")&&(_.mh=a(_.get("maxHeight"),"y")-N-j,_.mh=_.h&&_.h<_.mh?_.h:_.mh),e=_.get("href"),Q=setTimeout(function(){L.show()},100),_.get("inline")){var c=t(e).eq(0);r=t("<div>").hide().insertBefore(c),ae.one(he,function(){r.replaceWith(c)}),h(c)}else _.get("iframe")?h(" "):_.get("html")?h(_.get("html")):s(_,e)?(e=l(_,e),q=_.get("createImg"),t(q).addClass(Z+"Photo").bind("error."+Z,function(){h(n(se,"Error").html(_.get("imgError")))}).one("load",function(){d===le&&setTimeout(function(){var e;_.get("retinaImage")&&i.devicePixelRatio>1&&(q.height=q.height/i.devicePixelRatio,q.width=q.width/i.devicePixelRatio),_.get("scalePhotos")&&(o=function(){q.height-=q.height*e,q.width-=q.width*e},_.mw&&q.width>_.mw&&(e=(q.width-_.mw)/q.width,o()),_.mh&&q.height>_.mh&&(e=(q.height-_.mh)/q.height,o())),_.h&&(q.style.marginTop=Math.max(_.mh-q.height,0)/2+"px"),W[1]&&(_.get("loop")||W[A+1])&&(q.style.cursor="pointer",t(q).bind("click."+Z,function(){J.next()})),q.style.width=q.width+"px",q.style.height=q.height+"px",h(q)},1)}),q.src=e):e&&M.load(e,_.get("data"),function(e,i){d===le&&h("error"===i?n(se,"Error").html(_.get("xhrError")):t(this).contents())})}var v,x,y,b,T,C,H,k,W,E,I,M,L,F,R,S,K,P,B,O,_,j,D,N,z,A,q,U,$,G,Q,J,V,X={html:!1,photo:!1,iframe:!1,inline:!1,transition:"elastic",speed:300,fadeOut:300,width:!1,initialWidth:"600",innerWidth:!1,maxWidth:!1,height:!1,initialHeight:"450",innerHeight:!1,maxHeight:!1,scalePhotos:!0,scrolling:!0,opacity:.9,preloading:!0,className:!1,overlayClose:!0,escKey:!0,arrowKey:!0,top:!1,bottom:!1,left:!1,right:!1,fixed:!1,data:void 0,closeButton:!0,fastIframe:!0,open:!1,reposition:!0,loop:!0,slideshow:!1,slideshowAuto:!0,slideshowSpeed:2500,slideshowStart:"start slideshow",slideshowStop:"stop slideshow",photoRegex:/\.(gif|png|jp(e|g|eg)|bmp|ico|webp|jxr|svg)((#|\?).*)?$/i,retinaImage:!1,retinaUrl:!1,retinaSuffix:"@2x.$1",current:"image {current} of {total}",previous:"previous",next:"next",close:"close",xhrError:"This content failed to load.",imgError:"This image failed to load.",returnFocus:!0,trapFocus:!0,onOpen:!1,onLoad:!1,onComplete:!1,onCleanup:!1,onClosed:!1,rel:function(){return this.rel},href:function(){return t(this).attr("href")},title:function(){return this.title},createImg:function(){var e=new Image,i=t(this).data("cbox-img-attrs");return"object"==typeof i&&t.each(i,function(t,i){e[t]=i}),e},createIframe:function(){var i=e.createElement("iframe"),n=t(this).data("cbox-iframe-attrs");return"object"==typeof n&&t.each(n,function(t,e){i[t]=e}),"frameBorder"in i&&(i.frameBorder=0),"allowTransparency"in i&&(i.allowTransparency="true"),i.name=(new Date).getTime(),i.allowFullscreen=!0,i}},Y="colorbox",Z="cbox",te=Z+"Element",ee=Z+"_open",ie=Z+"_load",ne=Z+"_complete",oe=Z+"_cleanup",re=Z+"_closed",he=Z+"_purge",ae=t("<a/>"),se="div",le=0,de={},ce=function(){function t(){clearTimeout(h)}function e(){(_.get("loop")||W[A+1])&&(t(),h=setTimeout(J.next,_.get("slideshowSpeed")))}function i(){S.html(_.get("slideshowStop")).unbind(s).one(s,n),ae.bind(ne,e).bind(ie,t),x.removeClass(a+"off").addClass(a+"on")}function n(){t(),ae.unbind(ne,e).unbind(ie,t),S.html(_.get("slideshowStart")).unbind(s).one(s,function(){J.next(),i()}),x.removeClass(a+"on").addClass(a+"off")}function o(){r=!1,S.hide(),t(),ae.unbind(ne,e).unbind(ie,t),x.removeClass(a+"off "+a+"on")}var r,h,a=Z+"Slideshow_",s="click."+Z;return function(){r?_.get("slideshow")||(ae.unbind(oe,o),o()):_.get("slideshow")&&W[1]&&(r=!0,ae.one(oe,o),_.get("slideshowAuto")?i():n(),S.show())}}();t[Y]||(t(p),J=t.fn[Y]=t[Y]=function(e,i){var n,o=this;return e=e||{},t.isFunction(o)&&(o=t("<a/>"),e.open=!0),o[0]?(p(),m()&&(i&&(e.onComplete=i),o.each(function(){var i=t.data(this,Y)||{};t.data(this,Y,t.extend(i,e))}).addClass(te),n=new r(o[0],e),n.get("open")&&f(o[0])),o):o},J.position=function(e,i){function n(){T[0].style.width=k[0].style.width=b[0].style.width=parseInt(x[0].style.width,10)-D+"px",b[0].style.height=C[0].style.height=H[0].style.height=parseInt(x[0].style.height,10)-j+"px"}var r,h,s,l=0,d=0,c=x.offset();if(E.unbind("resize."+Z),x.css({top:-9e4,left:-9e4}),h=E.scrollTop(),s=E.scrollLeft(),_.get("fixed")?(c.top-=h,c.left-=s,x.css({position:"fixed"})):(l=h,d=s,x.css({position:"absolute"})),d+=_.get("right")!==!1?Math.max(E.width()-_.w-z-D-a(_.get("right"),"x"),0):_.get("left")!==!1?a(_.get("left"),"x"):Math.round(Math.max(E.width()-_.w-z-D,0)/2),l+=_.get("bottom")!==!1?Math.max(o()-_.h-N-j-a(_.get("bottom"),"y"),0):_.get("top")!==!1?a(_.get("top"),"y"):Math.round(Math.max(o()-_.h-N-j,0)/2),x.css({top:c.top,left:c.left,visibility:"visible"}),y[0].style.width=y[0].style.height="9999px",r={width:_.w+z+D,height:_.h+N+j,top:l,left:d},e){var g=0;t.each(r,function(t){return r[t]!==de[t]?(g=e,void 0):void 0}),e=g}de=r,e||x.css(r),x.dequeue().animate(r,{duration:e||0,complete:function(){n(),$=!1,y[0].style.width=_.w+z+D+"px",y[0].style.height=_.h+N+j+"px",_.get("reposition")&&setTimeout(function(){E.bind("resize."+Z,J.position)},1),t.isFunction(i)&&i()},step:n})},J.resize=function(t){var e;U&&(t=t||{},t.width&&(_.w=a(t.width,"x")-z-D),t.innerWidth&&(_.w=a(t.innerWidth,"x")),I.css({width:_.w}),t.height&&(_.h=a(t.height,"y")-N-j),t.innerHeight&&(_.h=a(t.innerHeight,"y")),t.innerHeight||t.height||(e=I.scrollTop(),I.css({height:"auto"}),_.h=I.height()),I.css({height:_.h}),e&&I.scrollTop(e),J.position("none"===_.get("transition")?0:_.get("speed")))},J.prep=function(i){function o(){return _.w=_.w||I.width(),_.w=_.mw&&_.mw<_.w?_.mw:_.w,_.w}function a(){return _.h=_.h||I.height(),_.h=_.mh&&_.mh<_.h?_.mh:_.h,_.h}if(U){var d,g="none"===_.get("transition")?0:_.get("speed");I.remove(),I=n(se,"LoadedContent").append(i),I.hide().appendTo(M.show()).css({width:o(),overflow:_.get("scrolling")?"auto":"hidden"}).css({height:a()}).prependTo(b),M.hide(),t(q).css({"float":"none"}),c(_.get("className")),d=function(){function i(){t.support.opacity===!1&&x[0].style.removeAttribute("filter")}var n,o,a=W.length;U&&(o=function(){clearTimeout(Q),L.hide(),u(ne),_.get("onComplete")},F.html(_.get("title")).show(),I.show(),a>1?("string"==typeof _.get("current")&&R.html(_.get("current").replace("{current}",A+1).replace("{total}",a)).show(),K[_.get("loop")||a-1>A?"show":"hide"]().html(_.get("next")),P[_.get("loop")||A?"show":"hide"]().html(_.get("previous")),ce(),_.get("preloading")&&t.each([h(-1),h(1)],function(){var i,n=W[this],o=new r(n,t.data(n,Y)),h=o.get("href");h&&s(o,h)&&(h=l(o,h),i=e.createElement("img"),i.src=h)})):O.hide(),_.get("iframe")?(n=_.get("createIframe"),_.get("scrolling")||(n.scrolling="no"),t(n).attr({src:_.get("href"),"class":Z+"Iframe"}).one("load",o).appendTo(I),ae.one(he,function(){n.src="//about:blank"}),_.get("fastIframe")&&t(n).trigger("load")):o(),"fade"===_.get("transition")?x.fadeTo(g,1,i):i())},"fade"===_.get("transition")?x.fadeTo(g,0,function(){J.position(0,d)}):J.position(g,d)}},J.next=function(){!$&&W[1]&&(_.get("loop")||W[A+1])&&(A=h(1),f(W[A]))},J.prev=function(){!$&&W[1]&&(_.get("loop")||A)&&(A=h(-1),f(W[A]))},J.close=function(){U&&!G&&(G=!0,U=!1,u(oe),_.get("onCleanup"),E.unbind("."+Z),v.fadeTo(_.get("fadeOut")||0,0),x.stop().fadeTo(_.get("fadeOut")||0,0,function(){x.hide(),v.hide(),u(he),I.remove(),setTimeout(function(){G=!1,u(re),_.get("onClosed")},1)}))},J.remove=function(){x&&(x.stop(),t[Y].close(),x.stop(!1,!0).remove(),v.remove(),G=!1,x=null,t("."+te).removeData(Y).removeClass(te),t(e).unbind("click."+Z).unbind("keydown."+Z))},J.element=function(){return t(_.el)},J.settings=X)})(jQuery,document,window);
;/*})'"*/;/*})'"*/
/**
 * @file
 * Colorbox module init js.
 */

(function ($) {

Drupal.behaviors.initColorbox = {
  attach: function (context, settings) {
    if (!$.isFunction($('a, area, input', context).colorbox) || typeof settings.colorbox === 'undefined') {
      return;
    }

    if (settings.colorbox.mobiledetect && window.matchMedia) {
      // Disable Colorbox for small screens.
      var mq = window.matchMedia("(max-device-width: " + settings.colorbox.mobiledevicewidth + ")");
      if (mq.matches) {
        return;
      }
    }

    // Use "data-colorbox-gallery" if set otherwise use "rel".
    settings.colorbox.rel = function () {
      if ($(this).data('colorbox-gallery')) {
        return $(this).data('colorbox-gallery');
      }
      else {
        return $(this).attr('rel');
      }
    };

    $('.colorbox', context)
      .once('init-colorbox').each(function(){
        // Only images are supported for the "colorbox" class.
        // The "photo" setting forces the href attribute to be treated as an image.
        var extendParams = {
          photo: true
        };
        // If a title attribute is supplied, sanitize it.
        var title = $(this).attr('title');
        if (title) {
          extendParams.title = Drupal.colorbox.sanitizeMarkup(title);
        }
        $(this).colorbox($.extend({}, settings.colorbox, extendParams));
      });

    $(context).bind('cbox_complete', function () {
      Drupal.attachBehaviors($('#cboxLoadedContent'));
    });
  }
};

// Create colorbox namespace if it doesn't exist.
if (!Drupal.hasOwnProperty('colorbox')) {
  Drupal.colorbox = {};
}

/**
 * Global function to allow sanitizing captions and control strings.
 *
 * @param markup
 *   String containing potential markup.
 * @return @string
 *  Sanitized string with potentially dangerous markup removed.
 */
Drupal.colorbox.sanitizeMarkup = function(markup) {
  // If DOMPurify installed, allow some HTML. Otherwise, treat as plain text.
  if (typeof DOMPurify !== 'undefined') {
    var purifyConfig = {
      ALLOWED_TAGS: [
        'a',
        'b',
        'strong',
        'i',
        'em',
        'u',
        'cite',
        'code',
        'br'
      ],
      ALLOWED_ATTR: [
        'href',
        'hreflang',
        'title',
        'target'
      ]
    }
    if (Drupal.settings.hasOwnProperty('dompurify_custom_config')) {
      purifyConfig = Drupal.settings.dompurify_custom_config;
    }
    return DOMPurify.sanitize(markup, purifyConfig);
  }
  else {
    return Drupal.checkPlain(markup);
  }
}

})(jQuery);
;/*})'"*/;/*})'"*/
/**
 * @file
 * Colorbox module style js.
 */

(function ($) {

Drupal.behaviors.initColorboxDefaultStyle = {
  attach: function (context, settings) {
    $(context).bind('cbox_complete', function () {
      // Only run if there is a title.
      if ($('#cboxTitle:empty', context).length == false) {
        $('#cboxLoadedContent img', context).bind('mouseover', function () {
          $('#cboxTitle', context).slideDown();
        });
        $('#cboxOverlay', context).bind('mouseover', function () {
          $('#cboxTitle', context).slideUp();
        });
      }
      else {
        $('#cboxTitle', context).hide();
      }
    });
  }
};

})(jQuery);
;/*})'"*/;/*})'"*/
(function($) {
	$(document).ready(function() {
		var basePath = Drupal.settings.basePath;
		var modPath = basePath + "r_tbc_fixer/";
		$book = $("#fix-tbc-form #edit-book");
		$chapter = $("#fix-tbc-form #edit-chapter");
		$example = $("#fix-tbc-form #edit-example");
		$caption = $("#fix-tbc-form #edit-caption");
		$code = $("#fix-tbc-form #edit-code");
		$caption_form = $("#r-fixer-caption-form");
		$code_form = $("#r-fixer-code-form");
		$updating = $("#fix-tbc-page #updating");
		$done = $("#fix-tbc-page #done");
		$example.attr("multiple", "enabled");


		function reset() {
			for (var i = 0, l = arguments.length; i < l; i++) {
				switch (arguments[i]) {
					case "book":
						$book.html("<option value='0'>Please select a book</option>");
						break;
					case "chapter":
						$chapter.html("<option value='0'>Please select a chapter</option>");
						break;
					case "example":
						$example.html("<option value='0'>Please select a example</option>");
						break;
					case "caption":
						$caption.val("");
						break;
				}
			}
		}
		$(".select-book").hide();
		$(".select-chapter").hide();
		$(".enter-chapter-name").hide();
		$(".chapter-example-chk").hide();
		$(".select-example").hide();
		$(".enter-caption").hide();
		$(".example-code-edit").hide();
		$(".well").hide();
		$(".update-button").hide();
		$book.change(function() {
			reset("chapter", "example", "caption");
			var book_id = $(this).val();
			if (book_id < 1) {
				$(".select-chapter").hide();
				$(".select-example").hide();
				$(".enter-caption").hide();
				$(".enter-chapter-name").hide();
				$(".chapter-example-chk").hide();
				$(".example-code-edit").hide();
				$(".well").hide();
				$(".update-button").hide();
			} else {
				$(".select-chapter").show();
				$(".select-example").hide();
				$(".enter-chapter-name").hide();
				$(".chapter-example-chk").hide();
				$(".enter-caption").hide();
				$(".example-code-edit").hide();
				$(".well").hide();
				$(".update-button").hide();
			}
			$.ajax({
				url: modPath + "ajax/book/" + book_id,
				type: "POST",
				dataType: "html",
				success: function(data) {
					$chapter.html(data);
				}
			});
		});
		$chapter.change(function() {
			reset("example", "caption");
			var chapter_name = $('option:selected', this).attr("data-chaptername");
			var chapter_id = $(this).val();
			if (chapter_id < 1) {
				$(".select-example").hide();
				$(".enter-caption").hide();
				$(".enter-chapter-name").hide();
				$(".chapter-example-chk").hide();
				$(".example-code-edit").hide();
				$(".well").hide();
				$(".update-button").hide();
			} else {
				$(".select-example").show();
				$(".enter-chapter-name").show();
				$(".chapter-example-chk").show();
				$("#edit-chapter-name").val(chapter_name);
				$(".enter-caption").hide();
				$(".example-code-edit").hide();
				$(".update-button").show();
			}
			$.ajax({
				url: modPath + "ajax/chapter/" + chapter_id,
				type: "POST",
				dataType: "html",
				success: function(data) {
					$example.html(data);
					$example.attr("size", $("#fix-tbc-form #edit-example option").length);
				}
			});
		});
		$example.change(function() {
			reset("caption");
			var example_id = $(this).val();
			var example_name = $('option:selected', this).attr("data-exampleid");
			var example_caption = $(this).text();
			if (example_id < 1) {
				$(".enter-caption").hide();
				// $("#edit-caption").val("");
				$(".example-code-edit").hide();
				$(".well").hide();
				$(".update-button").hide();
			} else {

				$(".enter-caption").show();
				$("#edit-caption").val(example_name);
				$(".example-code-edit").show();
				$(".well").show();
				$(".update-button").show();
			}
			$.ajax({
				url: modPath + "ajax/example/" + example_id,
				type: "POST",
				dataType: "html",
				success: function(data) {
					var code = $(data).filter("#code").text();
					/* checking whether it is for .well or textarea */
					if ($code.hasClass("fix-caption-code")) {
						$code.text(code);
					} else {
						$code.val(code);
					}
					var caption = $(data).filter("#caption").html();
					try {
						$caption.val(caption);
					} catch (e) {
						return;
					}
				}
			});
		});
		//edit caption form submit
		$caption_form.submit(function(e) {
			var example_id = $example.val();
			var chapter_id = $('option:selected', $chapter).attr("data-chapterid");
			if ($('.chapter-caption-chk').prop('checked') == true && $(
					'.example-caption-chk').prop('checked') == true) {
				if (example_id != "0" && chapter_id != "0") {
					var caption = $caption.val();
					caption = caption.trim();
					caption = caption.replace(/\s\s+/g, ' ');
					if(validateCaption(caption) == true) {
						alert('Enter valid text for example caption');
						return false;
					}
					var chapter_caption = $("#edit-chapter-name").val();
					chapter_caption = chapter_caption.trim();
					chapter_caption = chapter_caption.replace(/\s\s+/g, ' ');
					if(validateCaption(chapter_caption) == true) {
						alert('Enter valid text for chapter caption');
						return false;
					}
					if (caption == '' || chapter_caption =='') {
						alert('Please enter new caption ');
						return false;
					}
					$updating.show();
					$.ajax({
						url: modPath + "ajax/update-both/" + example_id,
						type: "POST",
						data: {
							example_id: example_id,
							caption: caption,
							chapter_id: chapter_id,
							chapter_caption: chapter_caption
						},
						dataType: "html",
						success: function(data) {
							$chapter.trigger("change");
							$book.trigger("change");
							$updating.hide();
							$done.show();
							$done.fadeOut("slow");
						}
					});
				} else {
					alert("No entry is selected.")
				}
			} else if ($('.example-caption-chk').prop('checked') == true) {
				if (example_id != "0") {
					var caption = $caption.val();
					caption = caption.trim();
					caption = caption.replace(/\s\s+/g, ' ');
					if(validateCaption(caption) == true) {
						alert('Enter valid text');
						return false;
					}
					if (caption == '') {
						alert('Please enter new caption ');
						return false;
					}
					$updating.show();
					$.ajax({
						url: modPath + "ajax/update-example/" + example_id,
						type: "POST",
						data: {
							example_id: example_id,
							caption: caption,
						},
						dataType: "html",
						success: function(data) {
							$chapter.trigger("change");
							$updating.hide();
							$done.show();
							$done.fadeOut("slow");
						}
					});
				} else {
					alert("No example selected.")
				}
			} else if ($('.chapter-caption-chk').prop('checked') == true) {
					if (chapter_id != "0") {
					var chapter_caption = $("#edit-chapter-name").val();
					alert(chapter_caption);
					chapter_caption = chapter_caption.trim();
					chapter_caption = chapter_caption.replace(/\s\s+/g, ' ');
					if(validateCaption(chapter_caption) == true) {
						alert('Enter valid text for chapter caption');
						return false;
					}
					if (chapter_caption == '') {
						alert('Please enter new caption ');
						return false;
					}
					$updating.show();
					$.ajax({
						url: modPath + "ajax/update-chapter/" + example_id,
						type: "POST",
						data: {
							chapter_id: chapter_id,
							chapter_caption: chapter_caption
						},
						dataType: "html",
						success: function(data) {
							$chapter.trigger("change");
							$book.trigger("change");
							$updating.hide();
							$done.show();
							$done.fadeOut("slow");
						}
					});
				} else {
					alert("No example selected.")
				}
			} else {
				alert("Please select the checkbox option")
			}
			e.preventDefault();
		});
		$code_form.submit(function(e) {
			var example_id = $example.val();
			if (example_id != "0") {
				var code = $code.val();
				code = code.trim();
				if (code == '') {
					alert('Please enter new code');
					return false;
				}
				$.ajax({
					url: modPath + "ajax/code/" + example_id,
					type: "POST",
					data: {
						code: code
					},
					dataType: "html",
					success: function(data) {
						$chapter.trigger("change");
						$updating.hide();
						$done.show();
						$done.fadeOut("slow");
						$(".example-code-edit").show();
					}
				});
			} else {
				alert("No example selected.")
			}
			e.preventDefault();
		});

		function validateCaption(text){
			var re = /([a-zA-Z|*|_|.|+|-|\\|?|/|!|~|!|@|#|$|%|^|&|(|)|<|>|{|}|;|:|\"|\'|,])\1{2,}/;
			return re.test(text);
		}
		/* toggle in edition */
		$ind_ed = $(".ind-ed");
		$ind_ed.click(function(e) {
			var aicte_id = $(this).attr("data-aicte");
			$t = $(this);
			$.ajax({
				url: modPath + "ajax/ind-ed/" + aicte_id,
				type: "GET",
				dataType: "html",
				success: function(data) {
					$tr = $t.parents("tr:first");
					if ($tr.hasClass("orange")) {
						$t.parents("tr:first").removeClass("orange");
						$t.html("Mark");
					} else {
						$t.parents("tr:first").addClass("orange");
						$t.html("Unmark");
					}
				},
			});
			e.preventDefault();
		});
	});
})(jQuery);
;/*})'"*/;/*})'"*/
(function($) {
	$(document).ready(function() {
		var basePath = Drupal.settings.basePath;
		//var modPath = basePath + "textbook_companion_fixer/";
		var modPath = basePath +
			"r_tbc_fixer/ajax/edit-book-category/";
		$category_form = $("#fix-tbc-category-form");
		$(".main-subcategory-table-div").hide();

		/*********************************************/
		//$('#main-subcategory-table-'+ 1).show();
		//var main_cat_chk_value = [];
		$("input[name='ids[]']:checked").each(function() {
			main_cat_chk_value = $(this).val();
			console.log('ooo' + main_cat_chk_value);
			if (main_cat_chk_value) {
				$('#main-subcategory-table-div-id-' + main_cat_chk_value).show();
			} else {
				$('#main-subcategory-table-div-id-' + main_cat_chk_value).hide();
			}
		});

		$('.main-category-checkbox').change(function() {
			main_cat_chk_value = $(this).val();
			if (!this.checked)
				$('#main-subcategory-table-div-id-' + main_cat_chk_value).hide();
			else
				$('#main-subcategory-table-div-id-' + main_cat_chk_value).show();
		});

		$("#fix-tbc-category-form").on('click', '#btn-add', function() {
			//$('#btn-add').click(function(){
			var selectID = $(this).attr("data-cid");
			console.log(selectID);
			$('#subcats-' + selectID + ' option:selected').each(function() {
				$('#selected-subcats-' + selectID).append("<option value='" + $(this)
					.val() + "'>" + $(this).text() + "</option>");

				/**********************/
				var pref_id = $('.prefrence_id').val();
				var main_cat_chk_value = selectID;
				var sub_cat_select_value = $(this).val();
				$.ajax({
					url: modPath,
					type: "POST",
					data: {
						pref_id: pref_id,
						main_category: main_cat_chk_value,
						sub_category: sub_cat_select_value,
						action: "add"
					},
					dataType: "html",
					success: function(data) {
						//alert("Updated");
						console.log("My data:" + data);
						$updating.hide();
						$done.show();
						console.log("data1: " + main_cat_chk_value + " data2: " +
							sub_cat_select_value + " data3: " + pref_id);
						$done.fadeOut("slow");
						//alert("ok");
					}
				});
				/**********************/

				$(this).remove();
			});
		});
		$("#fix-tbc-category-form").on('click', '#btn-remove', function() {
			//$('#btn-remove').click(function(){
			var selectID = $(this).attr("data-cid");
			$('#selected-subcats-' + selectID + ' option:selected').each(function() {
				$('#subcats-' + selectID).append("<option value='" + $(this).val() +
					"'>" + $(this).text() + "</option>");
				var action = "delete";
				/**********************/
				var pref_id = $('.prefrence_id').val();
				var main_cat_chk_value = selectID;
				var sub_cat_select_value = $(this).val();
				$.ajax({
					url: modPath,
					type: "POST",
					data: {
						pref_id: pref_id,
						main_category: main_cat_chk_value,
						sub_category: sub_cat_select_value,
						action: action
					},
					dataType: "html",
					success: function(data) {
						//alert("Updated");
						console.log("My data:" + data);
						$updating.hide();
						$done.show();
						console.log(action + "data1: " + main_cat_chk_value +
							" data2: " + sub_cat_select_value + " data3: " + pref_id);
						$done.fadeOut("slow");
						//alert("ok");
					}
				});
				/**********************/
				$(this).remove();
			});
		});

		//$("#main_cat_checkbox").change(function() {
		$("#fix-tbc-category-form").on('change', '.main-category-checkbox',
			function() {
				var selectID = $(this).val();
				prop = $(this).prop('checked');
				if (prop) {
					$('main-subcategory-table-' + selectID).show();
				} else {
					if (confirm('Are you sure?')) {
						alert('Thanks for confirming');
						var action = "delete-main-with-ub-category";
						var pref_id = $('.prefrence_id').val();
						var main_cat_chk_value = selectID;
						console.log(action + "data1: " + main_cat_chk_value + " data2: " +
							action + " data3: " + pref_id);
						//ConfirmFunction();
						$.ajax({
							url: modPath,
							type: "POST",
							data: {
								pref_id: pref_id,
								main_category: main_cat_chk_value,
								sub_category: '',
								action: action
							},
							dataType: "html",
							success: function(data) {
								//alert("Updated");
								location.reload();
								$('main-subcategory-table-' + selectID).hide();
								console.log("My data:" + data);
								$updating.hide();
								$done.show();
								console.log(action + "data1: " + main_cat_chk_value + " data2: " +
									action + " data3: " + pref_id);
								$done.fadeOut("slow");
								//alert("ok");
							}
						});
					} else {
						alert('You have not confirmed the action');
						location.reload();
					}
				}
			});
		/**********************************************************************/
	});
})(jQuery);

function ConfirmFunction() {
	confirm("Are you sure?");
}
;/*})'"*/;/*})'"*/
function getSelectionText(divID) {
	var selectedText = "";
	if (window.getSelection) {
		var sel = window.getSelection();
		var div = document.getElementById(divID);
		if (sel.rangeCount) {
			// Get the selected range
			var range = sel.getRangeAt(0);
			// Check that the selection is wholly contained within the div text
			// if (range.commonAncestorContainer == div.firstChild) {
			var selectedText = range.toString();
			// }
		}
	}
	return selectedText;
}


(function($) {
	$(document).ready(function() {
		$(".fix-caption-code").mousedown(function() {
			$("#edit-caption").val("");
		});
		$(".fix-caption-code").mouseup(function() {
			quotedText = getSelectionText("#fix-caption-code");
			$("#edit-caption").val(quotedText);
		});
		$("#edit-example").mousedown(function() {
			$("#edit-caption").val("");
		});
		$("#edit-example").mouseup(function() {
			quotedText =  $('option:selected', this).attr("data-exampleid");
			$("#edit-caption").val(quotedText);
		});
	});
})(jQuery);
;/*})'"*/;/*})'"*/
(function ($) {

Drupal.googleanalytics = {};

$(document).ready(function() {

  // Attach mousedown, keyup, touchstart events to document only and catch
  // clicks on all elements.
  $(document.body).bind("mousedown keyup touchstart", function(event) {

    // Catch the closest surrounding link of a clicked element.
    $(event.target).closest("a,area").each(function() {

      // Is the clicked URL internal?
      if (Drupal.googleanalytics.isInternal(this.href)) {
        // Skip 'click' tracking, if custom tracking events are bound.
        if ($(this).is('.colorbox') && (Drupal.settings.googleanalytics.trackColorbox)) {
          // Do nothing here. The custom event will handle all tracking.
          //console.info("Click on .colorbox item has been detected.");
        }
        // Is download tracking activated and the file extension configured for download tracking?
        else if (Drupal.settings.googleanalytics.trackDownload && Drupal.googleanalytics.isDownload(this.href)) {
          // Download link clicked.
          gtag('event', Drupal.googleanalytics.getDownloadExtension(this.href).toUpperCase(), {
            event_category: 'Downloads',
            event_label: Drupal.googleanalytics.getPageUrl(this.href),
            transport_type: 'beacon'
          });
        }
        else if (Drupal.googleanalytics.isInternalSpecial(this.href)) {
          // Keep the internal URL for Google Analytics website overlay intact.
          // @todo: May require tracking ID
          var target = this;
          $.each(Drupal.settings.googleanalytics.account, function () {
            gtag('config', this, {
              page_path: Drupal.googleanalytics.getPageUrl(target.href),
              transport_type: 'beacon'
            });
          });
        }
      }
      else {
        if (Drupal.settings.googleanalytics.trackMailto && $(this).is("a[href^='mailto:'],area[href^='mailto:']")) {
          // Mailto link clicked.
          gtag('event', 'Click', {
            event_category: 'Mails',
            event_label: this.href.substring(7),
            transport_type: 'beacon'
          });
        }
        else if (Drupal.settings.googleanalytics.trackOutbound && this.href.match(/^\w+:\/\//i)) {
          if (Drupal.settings.googleanalytics.trackDomainMode !== 2 || (Drupal.settings.googleanalytics.trackDomainMode === 2 && !Drupal.googleanalytics.isCrossDomain(this.hostname, Drupal.settings.googleanalytics.trackCrossDomains))) {
            // External link clicked / No top-level cross domain clicked.
            gtag('event', 'Click', {
              event_category: 'Outbound links',
              event_label: this.href,
              transport_type: 'beacon'
            });
          }
        }
      }
    });
  });

  // Track hash changes as unique pageviews, if this option has been enabled.
  if (Drupal.settings.googleanalytics.trackUrlFragments) {
    window.onhashchange = function() {
      $.each(Drupal.settings.googleanalytics.account, function () {
        gtag('config', this, {
          page_path: location.pathname + location.search + location.hash
        });
      });
    };
  }

  // Colorbox: This event triggers when the transition has completed and the
  // newly loaded content has been revealed.
  if (Drupal.settings.googleanalytics.trackColorbox) {
    $(document).bind("cbox_complete", function () {
      var href = $.colorbox.element().attr("href");
      if (href) {
        $.each(Drupal.settings.googleanalytics.account, function () {
          gtag('config', this, {
            page_path: Drupal.googleanalytics.getPageUrl(href)
          });
        });
      }
    });
  }

});

/**
 * Check whether the hostname is part of the cross domains or not.
 *
 * @param string hostname
 *   The hostname of the clicked URL.
 * @param array crossDomains
 *   All cross domain hostnames as JS array.
 *
 * @return boolean
 */
Drupal.googleanalytics.isCrossDomain = function (hostname, crossDomains) {
  /**
   * jQuery < 1.6.3 bug: $.inArray crushes IE6 and Chrome if second argument is
   * `null` or `undefined`, https://bugs.jquery.com/ticket/10076,
   * https://github.com/jquery/jquery/commit/a839af034db2bd934e4d4fa6758a3fed8de74174
   *
   * @todo: Remove/Refactor in D8
   */
  if (!crossDomains) {
    return false;
  }
  else {
    return $.inArray(hostname, crossDomains) > -1 ? true : false;
  }
};

/**
 * Check whether this is a download URL or not.
 *
 * @param string url
 *   The web url to check.
 *
 * @return boolean
 */
Drupal.googleanalytics.isDownload = function (url) {
  var isDownload = new RegExp("\\.(" + Drupal.settings.googleanalytics.trackDownloadExtensions + ")([\?#].*)?$", "i");
  return isDownload.test(url);
};

/**
 * Check whether this is an absolute internal URL or not.
 *
 * @param string url
 *   The web url to check.
 *
 * @return boolean
 */
Drupal.googleanalytics.isInternal = function (url) {
  var isInternal = new RegExp("^(https?):\/\/" + window.location.host, "i");
  return isInternal.test(url);
};

/**
 * Check whether this is a special URL or not.
 *
 * URL types:
 *  - gotwo.module /go/* links.
 *
 * @param string url
 *   The web url to check.
 *
 * @return boolean
 */
Drupal.googleanalytics.isInternalSpecial = function (url) {
  var isInternalSpecial = new RegExp("(\/go\/.*)$", "i");
  return isInternalSpecial.test(url);
};

/**
 * Extract the relative internal URL from an absolute internal URL.
 *
 * Examples:
 * - https://mydomain.com/node/1 -> /node/1
 * - https://example.com/foo/bar -> https://example.com/foo/bar
 *
 * @param string url
 *   The web url to check.
 *
 * @return string
 *   Internal website URL
 */
Drupal.googleanalytics.getPageUrl = function (url) {
  var extractInternalUrl = new RegExp("^(https?):\/\/" + window.location.host, "i");
  return url.replace(extractInternalUrl, '');
};

/**
 * Extract the download file extension from the URL.
 *
 * @param string url
 *   The web url to check.
 *
 * @return string
 *   The file extension of the passed url. e.g. "zip", "txt"
 */
Drupal.googleanalytics.getDownloadExtension = function (url) {
  var extractDownloadextension = new RegExp("\\.(" + Drupal.settings.googleanalytics.trackDownloadExtensions + ")([\?#].*)?$", "i");
  var extension = extractDownloadextension.exec(url);
  return (extension === null) ? '' : extension[1];
};

})(jQuery);
;/*})'"*/;/*})'"*/
