	(function($) {
	$(document).ready(function() {
		var basePath = Drupal.settings.basePath;
		var modPath = basePath + "r_tbc_fixer/";
		$book = $("#fix-tbc-form #edit-book");
		$chapter = $("#fix-tbc-form #edit-chapter");
		$example = $("#fix-tbc-form #edit-example");
		$caption = $("#fix-tbc-form #edit-caption");
		$code = $("#fix-tbc-form #edit-code");
		$caption_form = $("#r-fixer-caption-form");
		$code_form = $("#r-fixer-code-form");
		$updating = $("#fix-tbc-page #updating");
		$done = $("#fix-tbc-page #done");
		$example.attr("multiple", "enabled");


		function reset() {
			for (var i = 0, l = arguments.length; i < l; i++) {
				switch (arguments[i]) {
					case "book":
						$book.html("<option value='0'>Please select a book</option>");
						break;
					case "chapter":
						$chapter.html("<option value='0'>Please select a chapter</option>");
						break;
					case "example":
						$example.html("<option value='0'>Please select a example</option>");
						break;
					case "caption":
						$caption.val("");
						break;
				}
			}
		}
		$(".select-book").hide();
		$(".select-chapter").hide();
		$(".enter-chapter-name").hide();
		$(".chapter-example-chk").hide();
		$(".select-example").hide();
		$(".enter-caption").hide();
		$(".example-code-edit").hide();
		$(".well").hide();
		$(".update-button").hide();
		$book.change(function() {
			reset("chapter", "example", "caption");
			var book_id = $(this).val();
			if (book_id < 1) {
				$(".select-chapter").hide();
				$(".select-example").hide();
				$(".enter-caption").hide();
				$(".enter-chapter-name").hide();
				$(".chapter-example-chk").hide();
				$(".example-code-edit").hide();
				$(".well").hide();
				$(".update-button").hide();
			} else {
				$(".select-chapter").show();
				$(".select-example").hide();
				$(".enter-chapter-name").hide();
				$(".chapter-example-chk").hide();
				$(".enter-caption").hide();
				$(".example-code-edit").hide();
				$(".well").hide();
				$(".update-button").hide();
			}
			$.ajax({
				url: modPath + "ajax/book/" + book_id,
				type: "POST",
				dataType: "html",
				success: function(data) {
					$chapter.html(data);
				}
			});
		});
		$chapter.change(function() {
			reset("example", "caption");
			var chapter_name = $('option:selected', this).attr("data-chaptername");
			var chapter_id = $(this).val();
			if (chapter_id < 1) {
				$(".select-example").hide();
				$(".enter-caption").hide();
				$(".enter-chapter-name").hide();
				$(".chapter-example-chk").hide();
				$(".example-code-edit").hide();
				$(".well").hide();
				$(".update-button").hide();
			} else {
				$(".select-example").show();
				$(".enter-chapter-name").show();
				$(".chapter-example-chk").show();
				$("#edit-chapter-name").val(chapter_name);
				$(".enter-caption").hide();
				$(".example-code-edit").hide();
				$(".update-button").show();
			}
			$.ajax({
				url: modPath + "ajax/chapter/" + chapter_id,
				type: "POST",
				dataType: "html",
				success: function(data) {
					$example.html(data);
					$example.attr("size", $("#fix-tbc-form #edit-example option").length);
				}
			});
		});
		$example.change(function() {
			reset("caption");
			var example_id = $(this).val();
			var example_name = $('option:selected', this).attr("data-exampleid");
			var example_caption = $(this).text();
			if (example_id < 1) {
				$(".enter-caption").hide();
				// $("#edit-caption").val("");
				$(".example-code-edit").hide();
				$(".well").hide();
				$(".update-button").hide();
			} else {

				$(".enter-caption").show();
				$("#edit-caption").val(example_name);
				$(".example-code-edit").show();
				$(".well").show();
				$(".update-button").show();
			}
			$.ajax({
				url: modPath + "ajax/example/" + example_id,
				type: "POST",
				dataType: "html",
				success: function(data) {
					var code = $(data).filter("#code").text();
					/* checking whether it is for .well or textarea */
					if ($code.hasClass("fix-caption-code")) {
						$code.text(code);
					} else {
						$code.val(code);
					}
					var caption = $(data).filter("#caption").html();
					try {
						$caption.val(caption);
					} catch (e) {
						return;
					}
				}
			});
		});
		//edit caption form submit
		$caption_form.submit(function(e) {
			var example_id = $example.val();
			var chapter_id = $('option:selected', $chapter).attr("data-chapterid");
			if ($('.chapter-caption-chk').prop('checked') == true && $(
					'.example-caption-chk').prop('checked') == true) {
				if (example_id != "0" && chapter_id != "0") {
					var caption = $caption.val();
					caption = caption.trim();
					caption = caption.replace(/\s\s+/g, ' ');
					if(validateCaption(caption) == true) {
						alert('Enter valid text for example caption');
						return false;
					}
					var chapter_caption = $("#edit-chapter-name").val();
					chapter_caption = chapter_caption.trim();
					chapter_caption = chapter_caption.replace(/\s\s+/g, ' ');
					if(validateCaption(chapter_caption) == true) {
						alert('Enter valid text for chapter caption');
						return false;
					}
					if (caption == '' || chapter_caption =='') {
						alert('Please enter new caption ');
						return false;
					}
					$updating.show();
					$.ajax({
						url: modPath + "ajax/update-both/" + example_id,
						type: "POST",
						data: {
							example_id: example_id,
							caption: caption,
							chapter_id: chapter_id,
							chapter_caption: chapter_caption
						},
						dataType: "html",
						success: function(data) {
							$chapter.trigger("change");
							$book.trigger("change");
							$updating.hide();
							$done.show();
							$done.fadeOut("slow");
						}
					});
				} else {
					alert("No entry is selected.")
				}
			} else if ($('.example-caption-chk').prop('checked') == true) {
				if (example_id != "0") {
					var caption = $caption.val();
					caption = caption.trim();
					caption = caption.replace(/\s\s+/g, ' ');
					if(validateCaption(caption) == true) {
						alert('Enter valid text');
						return false;
					}
					if (caption == '') {
						alert('Please enter new caption ');
						return false;
					}
					$updating.show();
					$.ajax({
						url: modPath + "ajax/update-example/" + example_id,
						type: "POST",
						data: {
							example_id: example_id,
							caption: caption,
						},
						dataType: "html",
						success: function(data) {
							$chapter.trigger("change");
							$updating.hide();
							$done.show();
							$done.fadeOut("slow");
						}
					});
				} else {
					alert("No example selected.")
				}
			} else if ($('.chapter-caption-chk').prop('checked') == true) {
					if (chapter_id != "0") {
					var chapter_caption = $("#edit-chapter-name").val();
					alert(chapter_caption);
					chapter_caption = chapter_caption.trim();
					chapter_caption = chapter_caption.replace(/\s\s+/g, ' ');
					if(validateCaption(chapter_caption) == true) {
						alert('Enter valid text for chapter caption');
						return false;
					}
					if (chapter_caption == '') {
						alert('Please enter new caption ');
						return false;
					}
					$updating.show();
					$.ajax({
						url: modPath + "ajax/update-chapter/" + example_id,
						type: "POST",
						data: {
							chapter_id: chapter_id,
							chapter_caption: chapter_caption
						},
						dataType: "html",
						success: function(data) {
							$chapter.trigger("change");
							$book.trigger("change");
							$updating.hide();
							$done.show();
							$done.fadeOut("slow");
						}
					});
				} else {
					alert("No example selected.")
				}
			} else {
				alert("Please select the checkbox option")
			}
			e.preventDefault();
		});
		$code_form.submit(function(e) {
			var example_id = $example.val();
			if (example_id != "0") {
				var code = $code.val();
				code = code.trim();
				if (code == '') {
					alert('Please enter new code');
					return false;
				}
				$.ajax({
					url: modPath + "ajax/code/" + example_id,
					type: "POST",
					data: {
						code: code
					},
					dataType: "html",
					success: function(data) {
						$chapter.trigger("change");
						$updating.hide();
						$done.show();
						$done.fadeOut("slow");
						$(".example-code-edit").show();
					}
				});
			} else {
				alert("No example selected.")
			}
			e.preventDefault();
		});

		function validateCaption(text){
			var re = /([a-zA-Z|*|_|.|+|-|\\|?|/|!|~|!|@|#|$|%|^|&|(|)|<|>|{|}|;|:|\"|\'|,])\1{2,}/;
			return re.test(text);
		}
		/* toggle in edition */
		$ind_ed = $(".ind-ed");
		$ind_ed.click(function(e) {
			var aicte_id = $(this).attr("data-aicte");
			$t = $(this);
			$.ajax({
				url: modPath + "ajax/ind-ed/" + aicte_id,
				type: "GET",
				dataType: "html",
				success: function(data) {
					$tr = $t.parents("tr:first");
					if ($tr.hasClass("orange")) {
						$t.parents("tr:first").removeClass("orange");
						$t.html("Mark");
					} else {
						$t.parents("tr:first").addClass("orange");
						$t.html("Unmark");
					}
				},
			});
			e.preventDefault();
		});
	});
})(jQuery);

;/*})'"*/
;/*})'"*/
(function($) {
	$(document).ready(function() {
		var basePath = Drupal.settings.basePath;
		//var modPath = basePath + "textbook_companion_fixer/";
		var modPath = basePath +
			"r_tbc_fixer/ajax/edit-book-category/";
		$category_form = $("#fix-tbc-category-form");
		$(".main-subcategory-table-div").hide();

		/*********************************************/
		//$('#main-subcategory-table-'+ 1).show();
		//var main_cat_chk_value = [];
		$("input[name='ids[]']:checked").each(function() {
			main_cat_chk_value = $(this).val();
			console.log('ooo' + main_cat_chk_value);
			if (main_cat_chk_value) {
				$('#main-subcategory-table-div-id-' + main_cat_chk_value).show();
			} else {
				$('#main-subcategory-table-div-id-' + main_cat_chk_value).hide();
			}
		});

		$('.main-category-checkbox').change(function() {
			main_cat_chk_value = $(this).val();
			if (!this.checked)
				$('#main-subcategory-table-div-id-' + main_cat_chk_value).hide();
			else
				$('#main-subcategory-table-div-id-' + main_cat_chk_value).show();
		});

		$("#fix-tbc-category-form").on('click', '#btn-add', function() {
			//$('#btn-add').click(function(){
			var selectID = $(this).attr("data-cid");
			console.log(selectID);
			$('#subcats-' + selectID + ' option:selected').each(function() {
				$('#selected-subcats-' + selectID).append("<option value='" + $(this)
					.val() + "'>" + $(this).text() + "</option>");

				/**********************/
				var pref_id = $('.prefrence_id').val();
				var main_cat_chk_value = selectID;
				var sub_cat_select_value = $(this).val();
				$.ajax({
					url: modPath,
					type: "POST",
					data: {
						pref_id: pref_id,
						main_category: main_cat_chk_value,
						sub_category: sub_cat_select_value,
						action: "add"
					},
					dataType: "html",
					success: function(data) {
						//alert("Updated");
						console.log("My data:" + data);
						$updating.hide();
						$done.show();
						console.log("data1: " + main_cat_chk_value + " data2: " +
							sub_cat_select_value + " data3: " + pref_id);
						$done.fadeOut("slow");
						//alert("ok");
					}
				});
				/**********************/

				$(this).remove();
			});
		});
		$("#fix-tbc-category-form").on('click', '#btn-remove', function() {
			//$('#btn-remove').click(function(){
			var selectID = $(this).attr("data-cid");
			$('#selected-subcats-' + selectID + ' option:selected').each(function() {
				$('#subcats-' + selectID).append("<option value='" + $(this).val() +
					"'>" + $(this).text() + "</option>");
				var action = "delete";
				/**********************/
				var pref_id = $('.prefrence_id').val();
				var main_cat_chk_value = selectID;
				var sub_cat_select_value = $(this).val();
				$.ajax({
					url: modPath,
					type: "POST",
					data: {
						pref_id: pref_id,
						main_category: main_cat_chk_value,
						sub_category: sub_cat_select_value,
						action: action
					},
					dataType: "html",
					success: function(data) {
						//alert("Updated");
						console.log("My data:" + data);
						$updating.hide();
						$done.show();
						console.log(action + "data1: " + main_cat_chk_value +
							" data2: " + sub_cat_select_value + " data3: " + pref_id);
						$done.fadeOut("slow");
						//alert("ok");
					}
				});
				/**********************/
				$(this).remove();
			});
		});

		//$("#main_cat_checkbox").change(function() {
		$("#fix-tbc-category-form").on('change', '.main-category-checkbox',
			function() {
				var selectID = $(this).val();
				prop = $(this).prop('checked');
				if (prop) {
					$('main-subcategory-table-' + selectID).show();
				} else {
					if (confirm('Are you sure?')) {
						alert('Thanks for confirming');
						var action = "delete-main-with-ub-category";
						var pref_id = $('.prefrence_id').val();
						var main_cat_chk_value = selectID;
						console.log(action + "data1: " + main_cat_chk_value + " data2: " +
							action + " data3: " + pref_id);
						//ConfirmFunction();
						$.ajax({
							url: modPath,
							type: "POST",
							data: {
								pref_id: pref_id,
								main_category: main_cat_chk_value,
								sub_category: '',
								action: action
							},
							dataType: "html",
							success: function(data) {
								//alert("Updated");
								location.reload();
								$('main-subcategory-table-' + selectID).hide();
								console.log("My data:" + data);
								$updating.hide();
								$done.show();
								console.log(action + "data1: " + main_cat_chk_value + " data2: " +
									action + " data3: " + pref_id);
								$done.fadeOut("slow");
								//alert("ok");
							}
						});
					} else {
						alert('You have not confirmed the action');
						location.reload();
					}
				}
			});
		/**********************************************************************/
	});
})(jQuery);

function ConfirmFunction() {
	confirm("Are you sure?");
}

;/*})'"*/
;/*})'"*/
function getSelectionText(divID) {
	var selectedText = "";
	if (window.getSelection) {
		var sel = window.getSelection();
		var div = document.getElementById(divID);
		if (sel.rangeCount) {
			// Get the selected range
			var range = sel.getRangeAt(0);
			// Check that the selection is wholly contained within the div text
			// if (range.commonAncestorContainer == div.firstChild) {
			var selectedText = range.toString();
			// }
		}
	}
	return selectedText;
}


(function($) {
	$(document).ready(function() {
		$(".fix-caption-code").mousedown(function() {
			$("#edit-caption").val("");
		});
		$(".fix-caption-code").mouseup(function() {
			quotedText = getSelectionText("#fix-caption-code");
			$("#edit-caption").val(quotedText);
		});
		$("#edit-example").mousedown(function() {
			$("#edit-caption").val("");
		});
		$("#edit-example").mouseup(function() {
			quotedText =  $('option:selected', this).attr("data-exampleid");
			$("#edit-caption").val(quotedText);
		});
	});
})(jQuery);

;/*})'"*/
;/*})'"*/
(function ($) {

Drupal.googleanalytics = {};

$(document).ready(function() {

  // Attach mousedown, keyup, touchstart events to document only and catch
  // clicks on all elements.
  $(document.body).bind("mousedown keyup touchstart", function(event) {

    // Catch the closest surrounding link of a clicked element.
    $(event.target).closest("a,area").each(function() {

      // Is the clicked URL internal?
      if (Drupal.googleanalytics.isInternal(this.href)) {
        // Skip 'click' tracking, if custom tracking events are bound.
        if ($(this).is('.colorbox') && (Drupal.settings.googleanalytics.trackColorbox)) {
          // Do nothing here. The custom event will handle all tracking.
          //console.info("Click on .colorbox item has been detected.");
        }
        // Is download tracking activated and the file extension configured for download tracking?
        else if (Drupal.settings.googleanalytics.trackDownload && Drupal.googleanalytics.isDownload(this.href)) {
          // Download link clicked.
          gtag('event', Drupal.googleanalytics.getDownloadExtension(this.href).toUpperCase(), {
            event_category: 'Downloads',
            event_label: Drupal.googleanalytics.getPageUrl(this.href),
            transport_type: 'beacon'
          });
        }
        else if (Drupal.googleanalytics.isInternalSpecial(this.href)) {
          // Keep the internal URL for Google Analytics website overlay intact.
          // @todo: May require tracking ID
          var target = this;
          $.each(Drupal.settings.googleanalytics.account, function () {
            gtag('config', this, {
              page_path: Drupal.googleanalytics.getPageUrl(target.href),
              transport_type: 'beacon'
            });
          });
        }
      }
      else {
        if (Drupal.settings.googleanalytics.trackMailto && $(this).is("a[href^='mailto:'],area[href^='mailto:']")) {
          // Mailto link clicked.
          gtag('event', 'Click', {
            event_category: 'Mails',
            event_label: this.href.substring(7),
            transport_type: 'beacon'
          });
        }
        else if (Drupal.settings.googleanalytics.trackOutbound && this.href.match(/^\w+:\/\//i)) {
          if (Drupal.settings.googleanalytics.trackDomainMode !== 2 || (Drupal.settings.googleanalytics.trackDomainMode === 2 && !Drupal.googleanalytics.isCrossDomain(this.hostname, Drupal.settings.googleanalytics.trackCrossDomains))) {
            // External link clicked / No top-level cross domain clicked.
            gtag('event', 'Click', {
              event_category: 'Outbound links',
              event_label: this.href,
              transport_type: 'beacon'
            });
          }
        }
      }
    });
  });

  // Track hash changes as unique pageviews, if this option has been enabled.
  if (Drupal.settings.googleanalytics.trackUrlFragments) {
    window.onhashchange = function() {
      $.each(Drupal.settings.googleanalytics.account, function () {
        gtag('config', this, {
          page_path: location.pathname + location.search + location.hash
        });
      });
    };
  }

  // Colorbox: This event triggers when the transition has completed and the
  // newly loaded content has been revealed.
  if (Drupal.settings.googleanalytics.trackColorbox) {
    $(document).bind("cbox_complete", function () {
      var href = $.colorbox.element().attr("href");
      if (href) {
        $.each(Drupal.settings.googleanalytics.account, function () {
          gtag('config', this, {
            page_path: Drupal.googleanalytics.getPageUrl(href)
          });
        });
      }
    });
  }

});

/**
 * Check whether the hostname is part of the cross domains or not.
 *
 * @param string hostname
 *   The hostname of the clicked URL.
 * @param array crossDomains
 *   All cross domain hostnames as JS array.
 *
 * @return boolean
 */
Drupal.googleanalytics.isCrossDomain = function (hostname, crossDomains) {
  /**
   * jQuery < 1.6.3 bug: $.inArray crushes IE6 and Chrome if second argument is
   * `null` or `undefined`, https://bugs.jquery.com/ticket/10076,
   * https://github.com/jquery/jquery/commit/a839af034db2bd934e4d4fa6758a3fed8de74174
   *
   * @todo: Remove/Refactor in D8
   */
  if (!crossDomains) {
    return false;
  }
  else {
    return $.inArray(hostname, crossDomains) > -1 ? true : false;
  }
};

/**
 * Check whether this is a download URL or not.
 *
 * @param string url
 *   The web url to check.
 *
 * @return boolean
 */
Drupal.googleanalytics.isDownload = function (url) {
  var isDownload = new RegExp("\\.(" + Drupal.settings.googleanalytics.trackDownloadExtensions + ")([\?#].*)?$", "i");
  return isDownload.test(url);
};

/**
 * Check whether this is an absolute internal URL or not.
 *
 * @param string url
 *   The web url to check.
 *
 * @return boolean
 */
Drupal.googleanalytics.isInternal = function (url) {
  var isInternal = new RegExp("^(https?):\/\/" + window.location.host, "i");
  return isInternal.test(url);
};

/**
 * Check whether this is a special URL or not.
 *
 * URL types:
 *  - gotwo.module /go/* links.
 *
 * @param string url
 *   The web url to check.
 *
 * @return boolean
 */
Drupal.googleanalytics.isInternalSpecial = function (url) {
  var isInternalSpecial = new RegExp("(\/go\/.*)$", "i");
  return isInternalSpecial.test(url);
};

/**
 * Extract the relative internal URL from an absolute internal URL.
 *
 * Examples:
 * - https://mydomain.com/node/1 -> /node/1
 * - https://example.com/foo/bar -> https://example.com/foo/bar
 *
 * @param string url
 *   The web url to check.
 *
 * @return string
 *   Internal website URL
 */
Drupal.googleanalytics.getPageUrl = function (url) {
  var extractInternalUrl = new RegExp("^(https?):\/\/" + window.location.host, "i");
  return url.replace(extractInternalUrl, '');
};

/**
 * Extract the download file extension from the URL.
 *
 * @param string url
 *   The web url to check.
 *
 * @return string
 *   The file extension of the passed url. e.g. "zip", "txt"
 */
Drupal.googleanalytics.getDownloadExtension = function (url) {
  var extractDownloadextension = new RegExp("\\.(" + Drupal.settings.googleanalytics.trackDownloadExtensions + ")([\?#].*)?$", "i");
  var extension = extractDownloadextension.exec(url);
  return (extension === null) ? '' : extension[1];
};

})(jQuery);

;/*})'"*/
;/*})'"*/
