// This GUI file is generated by guibuilder version 3.0
//////////
function cmd_arduino_d_control(h,pin_no)
// GUI to control digital signal to be sent to a connected Arduino board
//
// Calling Sequence
//     cmd_arduino_d_control(h,pin_no)
//
// Parameters
//     h : Board number, reserved for future use. For this version, any number would do
//     pin_no : Digital pin to sent the signal
//
// Description
//     This GUI provides a convenient way to control the value (0-255) to sent to the given pin number on Arduino. 
//  
// Examples
//    ok = open_serial(1,9,115200) 
//    cmd_arduino_d_control(1,9)
//    close_serial(1)
// 
// See also
//    cmd_digital_out_volt
//    cmd_digital_out
//
// Authors
//     Bruno JOFRET, Tan C.L. 
//    
    //    str = string(val);
    //
    handles.h = h;
    handles.pin_no = pin_no;
    f=figure('figure_position',[128,41],'figure_size',[300,300],'auto_resize','on','background',[33],'figure_name','Arduino Digital Control',"visible", "off",...
    "dockable", "off", ...
    "infobar_visible", "off", ...
    "toolbar_visible", "off", ...
    "menubar_visible", "off", ...
    "default_axes", "off");

    handles.pbStop=uicontrol(f,'unit','normalized','BackgroundColor',[-1,-1,-1],'Enable','on','FontAngle','normal','FontName','Tahoma','FontSize',[12],'FontUnits','points','FontWeight','normal','ForegroundColor',[-1,-1,-1],'HorizontalAlignment','center','ListboxTop',[],'Max',[1],'Min',[0],'Position',[0.3159509,0.16,0.3619632,0.2],'Relief','default','SliderStep',[0.01,0.1],'String','Stop','Style','pushbutton','Value',[0],'VerticalAlignment','middle','Visible','on','Tag','pbStop','Callback','pbStop_callback()')
    handles.pbResult=uicontrol(f,'unit','normalized','BackgroundColor',[-1,-1,-1],'Enable','on','FontAngle','normal','FontName','Tahoma','FontSize',[24],'FontUnits','points','FontWeight','bold','ForegroundColor',[-1,-1,-1],'HorizontalAlignment','center','ListboxTop',[],'Max',[1],'Min',[0],'Position',[0.3190184,0.565,0.3527607,0.19],'Relief','default','SliderStep',[0.01,0.1],'String',"LOW",'Style','pushbutton','Value',[0],'VerticalAlignment','middle','Visible','on','Tag','pbResult','Callback','pbResult_callback(handles)')


   f.visible = "on";

    handles = resume(handles);
    //set(txtResult,'string',str);
 
endfunction
//////////
// Callbacks are defined as below. Please do not delete the comments as it will be used in coming version
function pbResult_callback(handles)
//    pbResult = findobj("tag', "pbResult");
    
    if handles.pbResult.string == "LOW"  then
        set(handles.pbResult,"string", "HIGH")
        set(handles.pbResult,"relief", "sunken")
        cmd_digital_out(handles.h,handles.pin_no,1)
    elseif  handles.pbResult.string == "HIGH"
        set(handles.pbResult,"string", "LOW")
        set(handles.pbResult,"relief", "raised")
        cmd_digital_out(handles.h,handles.pin_no,0)
    end

endfunction    //////////

function pbStop_callback()
    //Write your callback for  pbStop  here
    close();
    //    abort;


endfunction



