function value=sine(param,t)
   pi=3.14;
   value=param(2)*sin(2*pi*param(3)*t);
endfunction

function value=pulse(param,t)
   v1=param(2);  // Initial value
   v2=param(3);  // Pulsed value
   td=param(4);  // Delay time
   tr=param(5);  // Rise time
   tf=param(6);  // Fall time
   pw=param(7);  // Pulse width
   per=param(8); // Pulse period
   while(t>per)
     t=t-per;
   end
   if(v1>v2)
     tr_back=tr;
     tr=tf;
     tf=tr_back;
   end
   if(t<td)
     value=v1;
   elseif(t<td+tr)
     va=v1;   ta=td;   
     vb=v2;   tb=td+tr;
     value=(vb-va)/(tb-ta)*(t-ta)+va;
   elseif(t<td+tr+pw)
     value=v2;      
   elseif(t<td+tr+pw+tf)
     va=v2;   ta=td+tr+pw;   
     vb=v1;   tb=td+tr+pw+tf;
     value=(vb-va)/(tb-ta)*(t-ta)+va;
   else 
     value=v1;
   end
endfunction
