// Get circuit analysis option from circuit file
function [transParameter,sweep,Analysis,Nodes]=getAnalysisOption(filename)
global vPrintList;
global vPlotList;
global iPrintList;
global iPlotList;
global initialVoltage;

transParameter=list(0.0,0.0,0.0,0);
sweep=list(0.0,0.0,0.0);
vPrintList=list(0);
vPlotList=list(0);
iPrintList=list(0);
iPlotList=list(0);
vPrintIndex=1;
vPlotIndex=1;
iPrintIndex=1;
iPlotIndex=1;
icIndex=1;
Analysis=0;

try
// Open the circuit file
fid = mopen(filename, 'r');
if (fid == -1)
  error("cannot open file for reading");
end
Nodes=0;

while (1)
   tempStr=mgetl(fid,1);
   tempStr=stripblanks(tempStr);
   if (part(tempStr,1)=='*')
     continue;
   end
   tempStr=convstr(tempStr,'l');
   [dev] = sscanf(tempStr, "%s");
   if (dev=='.end')
     break;
   elseif (dev=='.op')   // Operation Point Analysis
     Analysis=0;
   elseif (dev=='.tran')  // Transient Analysis
     Analysis=1; UIC=0;
     [UICstr] = msscanf(tempStr, "%*s %*f %*f %*f %s");
     if(UICstr=='uic') UIC=1; end
     [startTime,stopTime,stepSize] = sscanf(tempStr, "%*s %f %f %f");
     transParameter=list(startTime,stopTime,stepSize,UIC);
   elseif (dev=='.dc')  // DC Analysis
     Analysis=2;
     [start,stop,step] = sscanf(tempStr, "%*s %f %f %f");
     sweep=list(start,stop,step);
   elseif (dev=='.ac')  // AC Analysis
     Analysis=3;
     [axisType,NP,start,stop] = sscanf(tempStr, "%*s %s %d %f %f");
     sweep=list(start,stop,NP,axisType);
   elseif (dev=='.ic')  // intial condition
     if(icIndex==1)
       initialVoltage=list(0);
     end
     token = strtok(tempStr," ");
     while( token <> '' )
       token = strtok(" ");
       if(length(token)) 
        [NodeNumber,potential]=sscanf(token,"v(%d)=%f");
        initialVoltage(icIndex)=[NodeNumber,potential];
        icIndex=icIndex+1; 
       end
     end
// Get Output variable for printing
   elseif (dev=='.print') 
     token = strtok(tempStr," ");
     while( token <> '' )
       token = strtok(" ");
       if(length(token))
         if(msscanf(token,"%c")=='v')
           if(length(strchr(token,'-')))
             if(length(strchr(token,'-'))==length(token))
               printNode=sscanf(token,"-v(%d)"); 
               vPrintList(vPrintIndex)=-printNode;
             else
               [printNode,printNode1]=sscanf(token,"v(%d)-v(%d)");
               vPrintList(vPrintIndex)=[printNode,printNode1];
             end
           else                
             printNode=sscanf(token,"v(%d)"); 
             vPrintList(vPrintIndex)=printNode;
           end
           vPrintIndex=vPrintIndex+1;
         elseif(msscanf(token,"%c")=='i')
           if(length(strchr(token,'-')))
             printNode=msscanf(token,"-i(%*c%d)"); 
             iPrintList(iPrintIndex)=-printNode;
           else                
             printNode=msscanf(token,"i(%*c%d)"); 
             iPrintList(iPrintIndex)=printNode;
           end
           iPrintIndex=iPrintIndex+1;
         end
       end
     end
// Get Output variable for plotting
   elseif (dev=='.plot')
     token = strtok(tempStr," ");
     while( token <> '' )
       token = strtok(" ");
       if(length(token))
         if(msscanf(token,"%c")=='v')
           if(length(strchr(token,'-')))
             if(length(strchr(token,'-'))==length(token))
               printNode=sscanf(token,"-v(%d)"); 
               vPlotList(vPlotIndex)=-printNode;
             else
               [printNode,printNode1]=sscanf(token,"v(%d)-v(%d)");
               vPlotList(vPlotIndex)=[printNode,printNode1];
             end
           else                
             printNode=sscanf(token,"v(%d)"); 
             vPlotList(vPlotIndex)=printNode;
           end
           vPlotIndex=vPlotIndex+1;
         elseif(msscanf(token,"%c")=='i')
           if(length(strchr(token,'-')))
             printNode=msscanf(token,"-i(%*c%d)"); 
             iPlotList(iPlotIndex)=-printNode;
           else                
             printNode=msscanf(token,"i(%*c%d)"); 
             iPlotList(iPlotIndex)=printNode;
           end
           iPlotIndex=iPlotIndex+1;
         end
       end
     end
// Find number of nodes in the circuit
   else
     devtype=sscanf(tempStr, "%c");
     if(devtype=='m')
        [source,sink,gate] = sscanf(tempStr, "%*s %d %d %d");
        if(gate>Nodes)
           Nodes=gate;
        end
     else
        [source,sink] = sscanf(tempStr, "%*s %d %d");
     end
     if(source>Nodes)
	Nodes=source;
     end
     if(sink>Nodes)
	Nodes=sink;
     end
   end
end
err=mclose(fid)

Nodes=Nodes+1
catch
   disp("Error in circuit file. Error code:110. Exiting.......");
   abort;
end
endfunction

function T=convertCircuitIntoGraph(filename,Nodes)
global g;
global model;
global wave;
global iPrintList;
global iPlotList;
global cValue;
global cInitial;

model=list(0);
wave=list(0);
Edges=0;
T=0;
X=0;

//try
// Open the circuit file
fid=mopen(filename,'r');
firstEdge=%t
X=1;
C=1;
waveIndex=1;

// Scan each line of the circuit file
while (1)
   tempStr=mgetl(fid,1);
   tempStr=stripblanks(tempStr);
   if (part(tempStr,1)=='*')
     continue;
   end
   tempStr=convstr(tempStr,'l')
   [dev] = sscanf(tempStr, "%s");
   if (dev=='.end')
     break;
   elseif (dev=='.op'|dev=='.tran'|dev=='.dc'|dev=='.ic'|dev=='.plot'|dev=='.print'|dev=='.ac')
     continue;
   else
      [source, sink] = sscanf(tempStr, "%*s %d %d");
      Edges=Edges+1;
      source=source+1;
      sink=sink+1;
      if(firstEdge) // initializing graph with first edge
        g = make_graph('my_graph',1,Nodes,source,sink);
        g = add_edge_data(g,'type');
        g = add_edge_data(g,'value');
        g = add_edge_data(g,'devName');
        firstEdge=%f; 
      else
        g=add_edge(source,sink,g);
      end
      [device_type] = sscanf(dev, "%c");
      device_type=convstr(device_type,'u');
      g.edges.data.devName(Edges) = dev;
      select (device_type)
        case 'R' then    // Resistance
          g.edges.data.type(Edges) = device_type;
          [value] = sscanf(tempStr, "%*s %*d %*d %f"); 
          g.edges.data.value(Edges) = 1/value;
        
        case 'I' then    // Current Source
          tempWave=list(0);
          g.edges.data.type(Edges) = device_type;
          wavtype = sscanf(tempStr, "%*s %*d %*d %s");
          [wave(waveIndex),g.edges.data.value(Edges)] = getSourceParam(tempStr,wavtype);
          waveIndex=waveIndex+1;
          
        case 'V' then   // Voltage Source
          tempWave=list(0);
          g.edges.data.type(Edges) = device_type;
          Index=msscanf(tempStr, "%*c%d"); 
          wavtype = sscanf(tempStr, "%*s %*d %*d %s");
          [wave(waveIndex),g.edges.data.value(Edges)] = getSourceParam(tempStr,wavtype);
          waveIndex=waveIndex+1;
          T=T+1;
       // For printing and plotting current variables    
          if(~(iPlotList(1)==0))
            Index=findIndex(Index,iPlotList);
            if(~(Index==0)) 
              iPlotList(Index)=T;
            end 
          end
          if(~(iPrintList(1)==0))
            Index=findIndex(Index,iPrintList);
            if(~(Index==0)) 
              iPrintList(Index)=T;
            end 
          end
        
        case 'G' then   // Voltage Controlled Current Source
          g.edges.data.type(Edges) = device_type;
          [sourceC sinkC value] = sscanf(tempStr, "%*s %*d %*d %d %d %f");
          g.edges.data.value(Edges) = value;
          Edges=Edges+1;
       // Add Current Source for voltage sensing
          g=add_edge(sourceC+1,sinkC+1,g); 
          g.edges.data.type(Edges) = 'I';
          g.edges.data.value(Edges) = 0;
          tempWave=list(0);
          tempWave(1)='dc';
          wave(waveIndex)=tempWave;            
          waveIndex=waveIndex+1;
          clear tempWave;
          
        case 'E' then   // Voltage Controlled Voltage Source
          g.edges.data.type(Edges) = device_type;
          [sourceC sinkC value] = sscanf(tempStr, "%*s %*d %*d %d %d %f");
          g.edges.data.value(Edges) = value;
          Edges=Edges+1;
       // Add Current Source for voltage sensing
          g=add_edge(sourceC+1,sinkC+1,g);
          g.edges.data.type(Edges) = 'I';
          g.edges.data.value(Edges) = 0;
          T=T+1;
          tempWave=list(0);
          tempWave(1)='dc';
          wave(waveIndex)=tempWave;            
          waveIndex=waveIndex+1;
          clear tempWave;

        case 'F' then   // Current Controlled Current Source
          g.edges.data.type(Edges) = device_type;
          [value] = sscanf(tempStr, "%*s %*d %*d %*s %f");
          g.edges.data.value(Edges) = value;
          Edges=Edges+1;
          T=T+1;

        case 'H' then  // Current Controlled Voltage Source
          g.edges.data.type(Edges) = device_type;
          [value] = sscanf(tempStr, "%*s %*d %*d %*s %f");
          g.edges.data.value(Edges) = value;
          Edges=Edges+1;
          T=T+1;
          
        case 'D' then  // Diode
          tempModel=list(0);
          g.edges.data.type(Edges) = 'D';
          tempModel(1) = sscanf(tempStr, "%*s %*d %*d %s");
          token = strtok(tempStr,"(");
          i=2;
          while( token <> '' )
            token = strtok(" )");
            if(length(token))
               tempModel(i)=atof(token);
               i=i+1; 
            end
          end
          model(X)=tempModel;            
          Is=tempModel(2);
          Vt=tempModel(3);
          g.edges.data.value(Edges) = Is/Vt;
          Edges=Edges+1;
       // Add Current Source parallel with resistance(linearization)
          g=add_edge(source,sink,g);
          g.edges.data.type(Edges) = 'I';
          g.edges.data.value(Edges) = 0;
          tempWave=list(0);
          tempWave(1)='dc';
          wave(waveIndex)=tempWave;            
          waveIndex=waveIndex+1;
          clear tempWave;
          X=X+1;
          clear tempModel;

        case 'M' then  // MOSFET 
          tempModel=list(0);
          g.edges.data.type(Edges) = device_type;
          g.edges.data.value(Edges) = 1e-12;
          Edges=Edges+1;
          [gateNode,tempModel(1)] = sscanf(tempStr, "%*s %*d %*d %d %s");
          tempModel(1)=convstr(tempModel(1),'u');
          token = strtok(tempStr,"(");
          i=2;
          while( token <> '' )
            token = strtok(" )");
            if(length(token))
              tempModel(i)=atof(token);
              i=i+1; 
            end
          end
          model(X)=tempModel;            
     
     // Add current source drain to source
          g=add_edge(source,sink,g);
          g.edges.data.type(Edges) = 'I';
          g.edges.data.value(Edges) = 0;
          tempWave=list(0);
          tempWave(1)='dc';
          wave(waveIndex)=tempWave;            
          waveIndex=waveIndex+1;
          clear tempWave;
          Edges=Edges+1;
       
       // Add current source gate to source   
          g=add_edge(gateNode+1,sink,g);
          g.edges.data.type(Edges) = 'I';
          g.edges.data.value(Edges) = 0;
          tempWave=list(0);
          tempWave(1)='dc';
          wave(waveIndex)=tempWave;            
          waveIndex=waveIndex+1;
          clear tempWave;
          X=X+1;
          Edges=Edges+1;
        
       // Add capactior gate to drain  
          g=add_edge(gateNode+1,source,g);
          g.edges.data.type(Edges) = 'C';
          cValue(C)=0.5*tempModel(4)*tempModel(2)*tempModel(3);
          g.edges.data.value(Edges) = 1e-12;
          Edges=Edges+1;
          
          g=add_edge(source,gateNode+1,g);
          g.edges.data.type(Edges) = 'I';
          g.edges.data.value(Edges) = 0;
          tempWave=list(0);
          tempWave(1)='dc';
          wave(waveIndex)=tempWave;            
          waveIndex=waveIndex+1;
          clear tempWave;
          C=C+1;
          Edges=Edges+1;
        
        // Add capacitor gate to source
          g=add_edge(gateNode+1,sink,g);
          g.edges.data.type(Edges) = 'C';
          cValue(C)=0.5*tempModel(4)*tempModel(2)*tempModel(3);
          g.edges.data.value(Edges) = 1e-12;
          Edges=Edges+1;
     
          g=add_edge(sink,gateNode+1,g);
          g.edges.data.type(Edges) = 'I';
          g.edges.data.value(Edges) = 0;
          tempWave=list(0);
          tempWave(1)='dc';
          wave(waveIndex)=tempWave;            
          waveIndex=waveIndex+1;
          clear tempWave;
          C=C+1;
          clear tempModel;
          
        case 'C' then  // Capacitor 
          g.edges.data.type(Edges) = 'C';
          [value] = sscanf(tempStr, "%*s %*d %*d %f");
          token=strtok(tempStr,"=");
          token = strtok(" ");
          if(token <> '')
            cInitial(C)=atof(token);  
          else
            cInitial(C)=0.0;  
          end
          cValue(C)=value;
          g.edges.data.value(Edges) = 0.0;
          Edges=Edges+1;
          g=add_edge(sink,source,g);
          g.edges.data.type(Edges) = 'I';
          g.edges.data.value(Edges) = 0;
          tempWave=list(0);
          tempWave(1)='dc';
          wave(waveIndex)=tempWave;            
          waveIndex=waveIndex+1;
          clear tempWave;
          C=C+1;

        case 'X' then  // UserDefined Component
          tempModel=list(0);
          g.edges.data.type(Edges) = 'X';
          tempModel(1) = sscanf(tempStr, "%*s %*d %*d %s");
          i=2;
          token = strtok(tempStr,"(");
          while( token <> '' )
            token = strtok(" )");
            if(length(token))
              tempModel(i)=atof(token);
              i=i+1; 
            end
          end
          model(X)=tempModel;            
          generateCallingLibF(tempModel(1));
          exec('getlib.sci',-1); 
          value=jacobian(0.0,model(X));
          if(value>1d-6)      
            g.edges.data.value(Edges) = value;
          else
            g.edges.data.value(Edges) = 1d-6;
          end
          Edges=Edges+1;
          g=add_edge(source,sink,g);
          g.edges.data.type(Edges) = 'I';
          g.edges.data.value(Edges) = 0;
          tempWave=list(0);
          tempWave(1)='dc';
          wave(waveIndex)=tempWave;            
          waveIndex=waveIndex+1;
          clear tempWave;
          X=X+1;
          clear tempModel;
        else
          printf("Incorrect input file\n");
          exit(0);
        end
   end
end //while
mclose(fid);

//catch
//   disp("Error in circuit file. Error code: 120 Exiting.......");
//   abort;
//end
endfunction
          
function [tempWave,value]=getSourceParam(tempStr,wavtype)
  tempWave=list(0);
  tempWave(1)=wavtype;
  if(wavtype=='dc') 
    value = sscanf(tempStr, "%*s %*d %*d %*s %f");
  elseif(wavtype=='sweep') 
    value = sscanf(tempStr, "%*s %*d %*d %*s %f");
  elseif(wavtype=='ac') 
    value = sscanf(tempStr, "%*s %*d %*d %*s %f");
  else
    token = strtok(tempStr,"(");
    i=2;
    while( token <> '' )
      token = strtok(" )");
      if(length(token))
         tempWave(i)=atof(token);
         i=i+1; 
      end
    end            
    value = 0;
  end
endfunction
