// MNA based Circuit Simulator
// Yogesh Dilip Save
// Research Scholor
// Electrical Engg. Dept.
// IIT Bombay, Mumbai-400076
// Guide:Prof. H. Narayanan
//       Prof. S. Patkar

clear
//%format('e',10);
MaxNRitr=100;
displayMatrix=%T;

// Metanet Graph library
  // exec('metanet-0.4/loader.sce',-1);

// Supporting function library
exec('support/atof.sci',-1);
exec('support/findIndex.sci',-1);

exec('lib/mos.sci',-1);
exec('readfile.sci',-1);
exec('buildMatrices.sci',-1);
exec('buildMatricesSymbolic.sci',-1);
exec('OpAnalysis.sci',-1);
exec('NR.sci',-1);
exec('genrateCallingLibF.sci',-1);
exec('printSolution.sci',-1);
exec('tranAnalysis.sci',-1);
exec('DCAnalysis.sci',-1);
exec('ACAnalysis.sci',-1);
//getf('LUT/ids.sce');
//fileName = 'ckt/nodalExample.ckt';
//fileName = 'ckt/ModifiednodalExample.ckt';
//fileName = 'ckt/linear.ckt';
fileName = 'ckt/bridge.ckt';
//fileName='ckt/Vsweep.ckt';
//fileName='ckt/myCompSweep.ckt';
//fileName='ckt/rc1.ckt'
//fileName='ckt/rc_ac.ckt'
//fileName = readc_();
//args=sciargs();
//disp(args(4));

global('g');
global('model')
global('wave')
global('cValue','cInitial')
global('vPrintList','vPlotList')
global('iPrintList','iPlotList')
global('initialVoltage')

// Get circuit analysis option from circuit file 
[transParameter,sweep,Analysis,_Nodes]=getAnalysisOption(fileName);

// Read circuit form file and convert it into graph
_T=convertCircuitIntoGraph(fileName,_Nodes); 
_X=length(model);   

// Build Modified Nodal Matrix for linear devices
[A,B]=buildMatrices(_T);

if displayMatrix then
  mprintf("-----------------------------------------------------\n");
  mprintf("The system of equations Ax+C(dx/dt)=b (Symbolically):\n");
  mprintf("-----------------------------------------------------\n");
  [Asymb,Bsymb,Csymb,xsymb]=buildMatricesSymbolic(_T);
  disp(xsymb,"x=",Csymb,"C=",Bsymb,"B=",Asymb,"A=");
  mprintf("The number of equations are %d\n",_Nodes+_T-1);
  mprintf("Unknowns:\n");
  mprintf("  Node potentials: %d Current Variables: %d\n",_Nodes-1,_T);
  mprintf("Note that the matrix contains r entries (corresponding to resistors) whose values are equal to 1/r\n");
  pause;

  mprintf("-----------------------------------------------------\n");
  mprintf("Operating Point (DC) Analysis: \n");
  mprintf("All capacitors are open circuited and inductors are short circuited \n");
  mprintf("The system of equations Ax=b (Numerically):\n");
  mprintf("-----------------------------------------------------\n");
  format('e',10);
  disp(B,"B=",A,"A=");
  pause;
end

// Perform Operating Point Analysis on static circuit
[A,B,x]=OPAnalysis(A,B);

if displayMatrix then
  mprintf("-----------------------------------------------------\n");
  mprintf("The solution of the circuit x:\n");
  mprintf("-----------------------------------------------------\n");
  format('e',10);
  disp(x,"x=");
  pause;
end

// Find branch voltage from node potential
voltage=findBranchVoltage(x);

// Find branch current from branch voltage using device characteristic
current=findBranchCurrent(x,voltage);

// Print the Operating Point Solution
fileName=fileName+".sol";
Wmode="w"; 
printOPSolution(fileName,voltage,current,Wmode);
mprintf("-----------------------------------------------------\n");
mprintf("The complete solution (Operating Point) of the circuit\n\t is written in %s\n",fileName);
mprintf("-----------------------------------------------------\n");

if(Analysis==1)      // Transient Analysis  
  mprintf("-----------------------------------------------------\n");
  mprintf("Transient Analysis: \n");
  mprintf("-----------------------------------------------------\n");
  global('sweepArray','vPrintArray','vPlotArray','iPrintArray','iPlotArray');
  t_start=transParameter(1);
  t_end=transParameter(2);
  t_step=transParameter(3);
  UIC=transParameter(4);
  t_itr=(t_end-t_start)/t_step+2;
  initArrays(t_itr);
  sweepArray = zeros(t_itr,1);
  i=1;
 // Find Initial condition at t=0
  [x]=setIntialCondition(A,B,x,_T,UIC);
 // Store Output Variable for plotting/printing 
  buildOutput(x,0,i);
  i=i+1;
  for t=t_start:t_step:t_end
     if(i==2) t=t+t_step/100; end;
     [A,B,x]=transientAnalysis(A,B,x,_X,t,i);
     i=i+1;
  end
  xaxis='time(sec)';
  printSolution(sweepArray,xaxis,'lin');
end

if(Analysis==2)    // DC Analysis
  global('sweepArray','vPrintArray','vPlotArray','iPrintArray','iPlotArray');
  s_start=sweep(1);
  s_end=sweep(2);
  s_step=sweep(3);
  s_itr=(s_end-s_start)/s_step+1;
  initArrays(s_itr);
  sweepArray = zeros(s_itr,1);
  i=1;
  for s=s_start:s_step:s_end
     [A,B,x]=DCAnalysis(A,B,_X,s);
     buildOutput(x,s,i);
     i=i+1;
  end
  xaxis='Voltage(V)';
  printSolution(sweepArray,xaxis,'lin');
end

if(Analysis==3)    // AC Analysis
  global('sweepArray','vPrintArray','vPlotArray','iPrintArray','iPlotArray');
  f_start=sweep(1);
  f_end=sweep(2);
  f_itr=sweep(3)+1;
  axisType=sweep(4);
  f_step=(f_end-f_start)/(f_itr-1);
  initArrays(f_itr);
  sweepArray = zeros(f_itr,1);
  i=1;
  buildOutput(x,0,i);
  i=i+1;
  for f=f_start:f_step:f_end
     [A,B,x]=ACAnalysis(A,B,_X,f);
     buildDCOutput(x,f,i);
     i=i+1;
  end
  xaxis='frequency(Hz)';
  printSolution(sweepArray,xaxis,axisType);
end
clearglobal();
quit
///////////////////////////////////////////////////////////////////////////////   
