clc

//c is a vector containing coefficients of the variables in the objective
c = [2, -1, -2, -1]';

//In our case there are 2 inequality constraints
//A is the matrix of the LHS of the inequality constraints
A = [0,2,-8,0; -1,-1,2,0];
//b is the vector of the RHS of the inequality constraints 
b = [0,-1];

//In our case there is 1 equality constraint
//Aeq is the matrix of the LHS of the equality constraints
Aeq = [1,1,1,1];
//beq is the vector of the RHS of the equality constraints
beq = [10];

intcon = [1,4]; //This vector indicates which decision variables are to be integers. In our case, this includes the first and the 4th variable

//The 1st and 4th variables are integers ranging from 0 to 10.
//lb is the row vector of the lower bounds of the decision variables.
lb = [0,-%inf,-%inf,0];
//ub is the row vector of the upper bounds of the decision variables.
ub = [10,%inf,%inf,10];

//The options allow the user to set various parameters of the Optimization problem.
options= list("MaxNodes", [500]);
//The output parameters
//xopt is the optimal value of x.
//fopt is the optimal objective function value.
//exitflag denotes the status of execution
//output is a structure containing detailed information about the optimization.
[xopt, fopt, exitflag, output] = fot_intlinprog(c,intcon,A,b,Aeq,beq,lb,ub, options)

//print the results:
//Uncomment the below lines to print the results 
//Or execute the file with echo
/*
printf("\nxopt: ");
disp(xopt);
printf("\nfopt: ");
disp(fopt);
printf("\nexitflag: ");
disp(exitflag);
printf("\noutput: ");
disp(output);
*/
