clc; 

function f = ObjectiveFunction (X) 							//ObjectiveFunction is the function that will be minimized
    f = 0.6224*X(1)*X(3)*X(4) + 1.7781*X(2)*X(3)^2 + 3.1661*X(1)^2*X(4) + 19.84*X(1)^2*X(3);
endfunction

x0 = [20 10 58.291 43.69]; 									// x0 is the row vector of the initial guess given to the solver

// Linear inequality constraints
A = [-0.0625 0 0.0193 0;0 -0.0625 0.00954 0;0 0 0 1];		//A is the matrix of the LHS of the inequality constraints
b = [0 0 240]';												//b is the vector of the RHS of the inequality constraints 
// Bounds of the variables
lb = [1 1 10 10];											//lb is the row vector of the lower bounds of the decision variables
ub = [99 99 200 200];										//ub is the row vector of the upper bounds of the decision variables
nVar = length(lb);

function [C,Ceq] = Nonlinearcon(X) 						//Nonlinearcon is the function with  the nonlinear equality and inequality constraints
    C = -%pi*X(3)^2*X(4) - (4/3)*%pi*X(3)^3 + 1296000;
    Ceq = []; 												//As you can see, there are no equality constraints	
endfunction

intcon = [1 2];												//This vector indicates which decision variables are to be integers

//The output parameters
//xopt is the optimal value of x
//fopt is the optimal objective function value
//exitflag denotes the status of execution
//gradient is a vector, containing the objective's gradient of the solution.
//hessian is a matrix of doubles, containing the lagrangian's hessian of the solution.
[xopt,fopt,exitflag,gradient,hessian] = fot_intfmincon(ObjectiveFunction,x0,intcon,A,b,[],[],lb,ub,Nonlinearcon) //This is how we call intfmincon
