clc
c=[-1,-1/3]';               //c is the column vector of the objective function
A=[1,1;-1/4,-1;-1,-1;-1,1]; //A is the matrix of the LHS of the inequality constraints
b=[2,1,-1,2];               //b is the vector of the RHS of the inequality constraints 
Aeq=[1,1/4];                //Aeq is the matrix of the LHS of the equality constraints
beq=[1/2];                  //beq is the vector of the RHS of the equality constraints
lb=[-1,-0.5];                //lb is the row vector of the lower bounds of the decision variables.
ub=[1.5,1.25];              //ub is the row vector of the upper bounds of the decision variables.
//The output parameters
//xopt is the optimal value of x.
//fopt is the optimal objective function value.
//exitflag denotes the status of execution
//Output is a structure containing detailed information about the optimization.
// Lambda is structure containing the Lagrange multipliers at the optimal solution.
[xopt,fopt,exitflag,output,lambda]=fot_linprog(c, A, b, Aeq, beq, lb, ub) //This is how we call linprog.

//Uncomment to print the results or execute the file with echo
/*
printf("\nxopt: ");
disp(xopt);
printf("\nfopt: ");
disp(fopt);
printf("\nexitflag: ");
disp(exitflag);
printf("\noutput: ");
disp(output);
printf("\nlambda: ");
disp(lambda);
*/
