
function y=f(x) //f is the Objective function to be minimised
	y= 100*(x(2) - x(1)^2)^2 + (1-x(1))^2;
endfunction

x0=[-1,2]; //x0 is the starting point
intcon = [2] //This vector indicates which decision variables are constrained to be integers.

//The output parameters
//xopt is the optimal value of x.
//fopt is the optimal objective function value.
//exitflag denotes the status of execution.
//Output is a structure containing detailed information about the optimization.
// gradient is a vector, containing the objective's gradient of the solution.
//hessian is a matrix of doubles, containing the lagrangian's hessian of the solution.

[xopt,fopt,exitflag,gradient,hessian]= fot_intfminunc(f,x0,intcon) //This is how we call intfminunc.

