
function y=f(x) //f is the Objective function to be minimised
	y= 100*(x(2) - x(1)^2)^2 + (1-x(1))^2;
endfunction


x0=[-1,2]; //x0 is the starting point

//The output parameters
//xopt is the optimal value of x.
//fopt is the optimal objective function value.
//exitflag denotes the status of execution.
//Output is a structure containing detailed information about the optimization.
// gradient is a vector, containing the objective's gradient of the solution.
//hessian is a matrix of doubles, containing the lagrangian's hessian of the solution.

[xopt,fopt,exitflag,output,gradient,hessian]= fot_fminunc(f,x0) //This is how we call fminunc.

